(ns leiningen.new.o2w
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files raw-resourcer]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]
            [clojure.string :as str]
            [clj-jgit.porcelain :refer :all]))

(require '[clj-jgit.porcelain :refer :all])

(defn get-files [resource-path f]
  (let [path (str/join "/" ["src" "leiningen" "new" resource-path])]
    (->> (io/file path)
      file-seq
      (map bean)
      (filter :file)
      (map :path)
      (map #(subs % (+ 1 (count path))))
      (map #(vector
              (str/replace % "o2w" "{{sanitized}}")
              (f %))))))


(def render (renderer "o2w"))
;;(def resource (raw-resourcer "o2w"))

(defn o2w
  "FIXME: write documentation"
  [name & params]
  (println params)
  (let [data {:name      name
              :sanitized (name-to-path name)}]

    (main/info "Generating fresh 'lein new' o2w project.")

    (apply ->files data
      (get-files "o2w" #(render % data)))

    (main/info "Git Init " name)
    (let [repo (load-repo name)]
      (git-add repo ".")
      (git-commit repo (str "lein new " name)))))

(comment
  (get-files "o2w" identity)
  (git-init "test")
  )
