(ns state-flow.internal-utils)

(def ^:private abbr-size 15)
(defn ellipsify [expr-str]
  (let [short-expr (subs expr-str 0 (- abbr-size 3))]
    (case (first expr-str)
      \( (str short-expr "...)")
      \[ (str short-expr "...]")
      (str short-expr "..."))))

(defn abbr-sexpr [expr]
  (let [expr-str   (str expr)
        short-expr (if (< abbr-size (count expr-str))
                     (ellipsify expr-str)
                     expr-str)]
    (str "`" short-expr "`")))

(defn push-abbr-meta [flow]
  `(push-meta ~(abbr-sexpr flow)
              ~(meta flow)))

(defn annote-with-line-meta [flows]
  (when-let [subflow-lines (->> flows
                                (map push-abbr-meta)
                                seq)]
    (interleave subflow-lines
                flows
                (repeat `pop-meta))))
