(ns state-flow.utils
  (:require [state-flow.state :as state]
            [cats.core :as m]))

(defn with-resource
  "Returns a step that fetches resource by calling <resource-fetcher> with the state
   and applies <user-fn> to the resource.

  Return value is the return of <user-fn>"
  [resource-fetcher user-fn]
  (assert (ifn? resource-fetcher) "First argument must be callable")
  (assert (ifn? user-fn) "Second argument must be callable")
  (m/mlet [resource (state/gets resource-fetcher)]
    (m/return (user-fn resource))))
