(ns kubernetes.api.my-scratch)


(comment
  (-> (str "openapiv2/" "networking.k8s.io-v1" ".json")
      io/resource
      slurp
      (json/read-str :key-fn keyword)
      openapiv2->swagger)

  (render-full-api "networking.k8s.io-v1")

  (render-api-group "v1.21.14" "networking.k8s.io" "v1")

  (keys (ns-publics 'kubernetes.api.openapiv2))


  (keys (ns-publics 'kubernetes.api.networking-k8s-io-v1))

  (slurp "resources/swagger/v1.json")

  (require '[clojure.data.json :as json])


  (def example-swagger
    (-> "resources/swagger/v1.json" slurp
        (json/read-str :key-fn keyword)))

  (def example-openapiv2
    (-> "resources/openapiv2/networking.k8s.io-v1.json"
        slurp
        (json/read-str :key-fn keyword)))

  (keys example-swagger)



  (:swaggerVersion example-swagger)

  (:apiVersion example-swagger)

  (first (:apis example-swagger))

{:path "/api/v1/namespaces/{namespace}/bindings",
 :description "API at /api/v1",
 :operations
 [{:type "v1.Binding",
   :method "POST",
   :summary "create a Binding",
   :nickname "createNamespacedBinding",
   :parameters
   [{:type "string",
     :paramType "query",
     :name "pretty",
     :description "If 'true', then the output is pretty printed.",
     :required false,
     :allowMultiple false}
    {:type "v1.Binding",
     :paramType "body",
     :name "body",
     :description "",
     :required true,
     :allowMultiple false}
    {:type "string",
     :paramType "path",
     :name "namespace",
     :description "object name and auth scope, such as for teams and projects",
     :required true,
     :allowMultiple false}],
   :responseMessages
   [{:code 200, :message "OK", :responseModel "v1.Binding"}
    {:code 201, :message "Created", :responseModel "v1.Binding"}
    {:code 202, :message "Accepted", :responseModel "v1.Binding"}],
   :produces
   ["application/json"
    "application/yaml"
    "application/vnd.kubernetes.protobuf"],
   :consumes ["*/*"]}]}


  (paths->apis (:paths example-openapiv2))

  (->> (paths->apis (:paths example-openapiv2))
       (mapcat :operations)
       (map :nickname)
       (map swagger/camel->dashed))

  (-> (paths->apis (:paths example-openapiv2))
      first
      keys)

  (map :nickname
       (paths->apis (:paths example-openapiv2))

       )


  (keys example-openapiv2)

  (->>
    (-> (openapiv2->swagger example-openapiv2)
        (filter-api-group "networking.k8s.io" "v1")
        :apis)
    (mapcat :operations)
    (map :nickname)
    (map swagger/camel->dashed)
    )


  (:swagger example-openapiv2)

  (nth (vec (:paths example-openapiv2)) 20)

  "")
