(ns kubernetes.api.v1
  (:require [kubernetes.api.swagger :as swagger]
            [kubernetes.api.util :as util]))

(def make-context util/make-context)

(swagger/render-full-api "v1")

; expose dynamically generated vars for static analysis
(declare
  create-namespace
  create-namespaced-binding
  create-namespaced-config-map
  create-namespaced-endpoints
  create-namespaced-event
  create-namespaced-limit-range
  create-namespaced-persistent-volume-claim
  create-namespaced-pod
  create-namespaced-pod-binding
  create-namespaced-pod-eviction
  create-namespaced-pod-template
  create-namespaced-replication-controller
  create-namespaced-resource-quota
  create-namespaced-secret
  create-namespaced-service
  create-namespaced-service-account
  create-node
  create-persistent-volume
  delete-namespace
  delete-namespaced-config-map
  delete-namespaced-endpoints
  delete-namespaced-event
  delete-namespaced-limit-range
  delete-namespaced-persistent-volume-claim
  delete-namespaced-pod
  delete-namespaced-pod-template
  delete-namespaced-replication-controller
  delete-namespaced-resource-quota
  delete-namespaced-secret
  delete-namespaced-service
  delete-namespaced-service-account
  delete-node
  delete-persistent-volume
  deletecollection-namespaced-config-map
  deletecollection-namespaced-endpoints
  deletecollection-namespaced-event
  deletecollection-namespaced-limit-range
  deletecollection-namespaced-persistent-volume-claim
  deletecollection-namespaced-pod
  deletecollection-namespaced-pod-template
  deletecollection-namespaced-replication-controller
  deletecollection-namespaced-resource-quota
  deletecollection-namespaced-secret
  deletecollection-namespaced-service-account
  deletecollection-node
  deletecollection-persistent-volume
  get-api-resources
  list-component-status
  list-config-map-for-all-namespaces
  list-endpoints-for-all-namespaces
  list-event-for-all-namespaces
  list-limit-range-for-all-namespaces
  list-namespace
  list-namespaced-config-map
  list-namespaced-endpoints
  list-namespaced-event
  list-namespaced-limit-range
  list-namespaced-persistent-volume-claim
  list-namespaced-pod
  list-namespaced-pod-template
  list-namespaced-replication-controller
  list-namespaced-resource-quota
  list-namespaced-secret
  list-namespaced-service
  list-namespaced-service-account
  list-node
  list-persistent-volume
  list-persistent-volume-claim-for-all-namespaces
  list-pod-for-all-namespaces
  list-pod-template-for-all-namespaces
  list-replication-controller-for-all-namespaces
  list-resource-quota-for-all-namespaces
  list-secret-for-all-namespaces
  list-service-account-for-all-namespaces
  list-service-for-all-namespaces
  patch-namespace
  patch-namespace-status
  patch-namespaced-config-map
  patch-namespaced-endpoints
  patch-namespaced-event
  patch-namespaced-limit-range
  patch-namespaced-persistent-volume-claim
  patch-namespaced-persistent-volume-claim-status
  patch-namespaced-pod
  patch-namespaced-pod-status
  patch-namespaced-pod-template
  patch-namespaced-replication-controller
  patch-namespaced-replication-controller-scale
  patch-namespaced-replication-controller-status
  patch-namespaced-resource-quota
  patch-namespaced-resource-quota-status
  patch-namespaced-secret
  patch-namespaced-service
  patch-namespaced-service-account
  patch-namespaced-service-status
  patch-node
  patch-node-status
  patch-persistent-volume
  patch-persistent-volume-status
  read-component-status
  read-namespace
  read-namespace-status
  read-namespaced-config-map
  read-namespaced-endpoints
  read-namespaced-event
  read-namespaced-limit-range
  read-namespaced-persistent-volume-claim
  read-namespaced-persistent-volume-claim-status
  read-namespaced-pod
  read-namespaced-pod-log
  read-namespaced-pod-status
  read-namespaced-pod-template
  read-namespaced-replication-controller
  read-namespaced-replication-controller-scale
  read-namespaced-replication-controller-status
  read-namespaced-resource-quota
  read-namespaced-resource-quota-status
  read-namespaced-secret
  read-namespaced-service
  read-namespaced-service-account
  read-namespaced-service-status
  read-node
  read-node-status
  read-persistent-volume
  read-persistent-volume-status
  replace-namespace
  replace-namespace-finalize
  replace-namespace-status
  replace-namespaced-config-map
  replace-namespaced-endpoints
  replace-namespaced-event
  replace-namespaced-limit-range
  replace-namespaced-persistent-volume-claim
  replace-namespaced-persistent-volume-claim-status
  replace-namespaced-pod
  replace-namespaced-pod-status
  replace-namespaced-pod-template
  replace-namespaced-replication-controller
  replace-namespaced-replication-controller-scale
  replace-namespaced-replication-controller-status
  replace-namespaced-resource-quota
  replace-namespaced-resource-quota-status
  replace-namespaced-secret
  replace-namespaced-service
  replace-namespaced-service-account
  replace-namespaced-service-status
  replace-node
  replace-node-status
  replace-persistent-volume
  replace-persistent-volume-status)
