(ns my-scratch
  (:require [kubernetes-api.extensions.custom-resource-definition :as crd]
            [kubernetes-api.interceptors.auth :as interceptors.auth]
            [kubernetes-api.interceptors.encoders :as interceptors.encoders]
            [kubernetes-api.interceptors.raise :as interceptors.raise]
            [kubernetes-api.internals.client :as internals.client]
            [kubernetes-api.internals.martian :as internals.martian]
            [kubernetes-api.misc :as misc]
            [kubernetes-api.swagger :as swagger]
            [martian.core :as martian]
            [martian.interceptors :as interceptors]
            [martian.httpkit :as martian-httpkit]
            [kubernetes-api.core :as k8s]
            martian.swagger))


(comment

  (def br-staging-global
    (k8s/client "https://staging-global-green-kubernetes-api.nustg.com.br"
                {:token     (clojure.string/trim (slurp "/tmp/global-staging-br-token"))
                 :insecure? true}))

  (k8s/info br-staging-global {:kind :Deployment
                               :action :update})


  (k8s/client "https://staging-s0-green-kubernetes-api.nustg.com.br"
              {:token     (slurp "/tmp/s0-staging-br-token")
               :insecure? true})

  (System/getenv "HOME")

  (k8s/client "https://staging-s0-green-kubernetes-api.nustg.com.br"
              {:ca-file (str (System/getenv "HOME") "/.kube/ca-br-staging-staging-global-green.crt")})

  (def host  "https://staging-global-green-kubernetes-api.nustg.com.br")
  (def opts {:token     (clojure.string/trim (slurp "/tmp/global-staging-br-token"))

             :insecure? true})


  (def k8s-client
    (internals.client/transform
      (martian/bootstrap-swagger host
                                 (or (swagger/from-api host opts)
                                     (swagger/read))
                                 {:interceptors (concat [(interceptors.raise/new opts)
                                                         (interceptors.auth/new opts)]
                                                        (:interceptors opts)
                                                        martian/default-interceptors
                                                        [(interceptors.encoders/new)
                                                         interceptors/default-coerce-response
                                                         martian-httpkit/perform-request])})))




  (martian/request-for k8s-client :GetCoreApiVersions)

  (internals.martian/response-for k8s-client :GetCoreApiVersions)


  @(org.httpkit.client/request (merge {:url (str host "/openapi/v3/api/v1")
                                       :method :get}
                                      (interceptors.auth/request-auth-params opts)))

  (def x

    (org.httpkit.client/request
      (assoc-in  (martian/request-for k8s-client :GetCoreApiVersions) [:headers "Host"] "staging-global-green-kubernetes-api.nustg.com.br")))

  @x


  (let [client (martian-httpkit/bootstrap-openapi "/tmp/openapiv3-example.yaml")]
    (martian/explore client :get-users))
  {:summary "Gets a list of users.", :parameters {#schema.core.OptionalKey{:k :offset} Int, #schema.core.OptionalKey{:k :limit} (default Int 20)}, :returns {200 nil}}
  (let [client (martian-httpkit/bootstrap-openapi "/tmp/swagger-example.yaml")]
    (martian/explore client :get-users))

  (let [client (martian-httpkit/bootstrap-openapi "/tmp/swagger-example2.yaml")]
    (martian/explore client :get-users))

  (let [client (martian-httpkit/bootstrap-openapi "/tmp/swagger-example3.yaml")]
    (martian/explore client :get-users))

  (let [client (martian-httpkit/bootstrap-openapi "/tmp/swagger-example4.yaml")]
    (martian/explore client :get-users))

  (def x2
    (#'martian-httpkit/load-definition "/tmp/openapiv3-example.yaml" nil))

  (:parameters ((keyword "/users") (:paths x2)))

  (clojure.pprint/pprint
    (let [client (martian-httpkit/bootstrap-openapi "/tmp/openapiv3-example.yaml")]
      (:handlers client)))


  (martian.openapi/openapi->handlers x2)



  (->> x2
       :paths
       (map (fn [[url methods]] (keys methods))))

  (:components x2)


  (for [[url methods] (:paths x2)
        :let [common-parameters (map (partial #'martian.openapi/resolve-ref (:components x2)) (:parameters methods))]
        [method definition] (dissoc methods :parameters)
        :let [parameters (group-by (comp keyword :in) (concat common-parameters
                                               (map (partial #'martian.openapi/resolve-ref (:components x2))
                                                    (:parameters definition))))]]
    (#'martian.openapi/process-parameters (:query parameters) (:components x2)))


  martian-httpkit/bootstrap-openapi

  (martian.openapi/openapi->handlers
    x2
    (martian.interceptors/supported-content-types
      martian.core/default-interceptors))

  )
