// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__25970 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__25971 = null;
var count__25972 = (0);
var i__25973 = (0);
while(true){
if((i__25973 < count__25972)){
var vec__25974 = cljs.core._nth.call(null,chunk__25971,i__25973);
var effect_key = cljs.core.nth.call(null,vec__25974,(0),null);
var effect_value = cljs.core.nth.call(null,vec__25974,(1),null);
var temp__5455__auto___25980 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___25980)){
var effect_fn_25981 = temp__5455__auto___25980;
effect_fn_25981.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__25982 = seq__25970;
var G__25983 = chunk__25971;
var G__25984 = count__25972;
var G__25985 = (i__25973 + (1));
seq__25970 = G__25982;
chunk__25971 = G__25983;
count__25972 = G__25984;
i__25973 = G__25985;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__25970);
if(temp__5457__auto__){
var seq__25970__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25970__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__25970__$1);
var G__25986 = cljs.core.chunk_rest.call(null,seq__25970__$1);
var G__25987 = c__9319__auto__;
var G__25988 = cljs.core.count.call(null,c__9319__auto__);
var G__25989 = (0);
seq__25970 = G__25986;
chunk__25971 = G__25987;
count__25972 = G__25988;
i__25973 = G__25989;
continue;
} else {
var vec__25977 = cljs.core.first.call(null,seq__25970__$1);
var effect_key = cljs.core.nth.call(null,vec__25977,(0),null);
var effect_value = cljs.core.nth.call(null,vec__25977,(1),null);
var temp__5455__auto___25990 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___25990)){
var effect_fn_25991 = temp__5455__auto___25990;
effect_fn_25991.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__25992 = cljs.core.next.call(null,seq__25970__$1);
var G__25993 = null;
var G__25994 = (0);
var G__25995 = (0);
seq__25970 = G__25992;
chunk__25971 = G__25993;
count__25972 = G__25994;
i__25973 = G__25995;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__25996 = cljs.core.seq.call(null,value);
var chunk__25997 = null;
var count__25998 = (0);
var i__25999 = (0);
while(true){
if((i__25999 < count__25998)){
var map__26000 = cljs.core._nth.call(null,chunk__25997,i__25999);
var map__26000__$1 = ((((!((map__26000 == null)))?((((map__26000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26000.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26000):map__26000);
var effect = map__26000__$1;
var ms = cljs.core.get.call(null,map__26000__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__26000__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__25996,chunk__25997,count__25998,i__25999,map__26000,map__26000__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__25996,chunk__25997,count__25998,i__25999,map__26000,map__26000__$1,effect,ms,dispatch))
,ms);
}

var G__26004 = seq__25996;
var G__26005 = chunk__25997;
var G__26006 = count__25998;
var G__26007 = (i__25999 + (1));
seq__25996 = G__26004;
chunk__25997 = G__26005;
count__25998 = G__26006;
i__25999 = G__26007;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__25996);
if(temp__5457__auto__){
var seq__25996__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25996__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__25996__$1);
var G__26008 = cljs.core.chunk_rest.call(null,seq__25996__$1);
var G__26009 = c__9319__auto__;
var G__26010 = cljs.core.count.call(null,c__9319__auto__);
var G__26011 = (0);
seq__25996 = G__26008;
chunk__25997 = G__26009;
count__25998 = G__26010;
i__25999 = G__26011;
continue;
} else {
var map__26002 = cljs.core.first.call(null,seq__25996__$1);
var map__26002__$1 = ((((!((map__26002 == null)))?((((map__26002.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26002.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26002):map__26002);
var effect = map__26002__$1;
var ms = cljs.core.get.call(null,map__26002__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__26002__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__25996,chunk__25997,count__25998,i__25999,map__26002,map__26002__$1,effect,ms,dispatch,seq__25996__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__25996,chunk__25997,count__25998,i__25999,map__26002,map__26002__$1,effect,ms,dispatch,seq__25996__$1,temp__5457__auto__))
,ms);
}

var G__26012 = cljs.core.next.call(null,seq__25996__$1);
var G__26013 = null;
var G__26014 = (0);
var G__26015 = (0);
seq__25996 = G__26012;
chunk__25997 = G__26013;
count__25998 = G__26014;
i__25999 = G__26015;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__26016 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__26017 = null;
var count__26018 = (0);
var i__26019 = (0);
while(true){
if((i__26019 < count__26018)){
var event = cljs.core._nth.call(null,chunk__26017,i__26019);
re_frame.router.dispatch.call(null,event);

var G__26020 = seq__26016;
var G__26021 = chunk__26017;
var G__26022 = count__26018;
var G__26023 = (i__26019 + (1));
seq__26016 = G__26020;
chunk__26017 = G__26021;
count__26018 = G__26022;
i__26019 = G__26023;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__26016);
if(temp__5457__auto__){
var seq__26016__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26016__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__26016__$1);
var G__26024 = cljs.core.chunk_rest.call(null,seq__26016__$1);
var G__26025 = c__9319__auto__;
var G__26026 = cljs.core.count.call(null,c__9319__auto__);
var G__26027 = (0);
seq__26016 = G__26024;
chunk__26017 = G__26025;
count__26018 = G__26026;
i__26019 = G__26027;
continue;
} else {
var event = cljs.core.first.call(null,seq__26016__$1);
re_frame.router.dispatch.call(null,event);

var G__26028 = cljs.core.next.call(null,seq__26016__$1);
var G__26029 = null;
var G__26030 = (0);
var G__26031 = (0);
seq__26016 = G__26028;
chunk__26017 = G__26029;
count__26018 = G__26030;
i__26019 = G__26031;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__26032 = cljs.core.seq.call(null,value);
var chunk__26033 = null;
var count__26034 = (0);
var i__26035 = (0);
while(true){
if((i__26035 < count__26034)){
var event = cljs.core._nth.call(null,chunk__26033,i__26035);
clear_event.call(null,event);

var G__26036 = seq__26032;
var G__26037 = chunk__26033;
var G__26038 = count__26034;
var G__26039 = (i__26035 + (1));
seq__26032 = G__26036;
chunk__26033 = G__26037;
count__26034 = G__26038;
i__26035 = G__26039;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__26032);
if(temp__5457__auto__){
var seq__26032__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26032__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__26032__$1);
var G__26040 = cljs.core.chunk_rest.call(null,seq__26032__$1);
var G__26041 = c__9319__auto__;
var G__26042 = cljs.core.count.call(null,c__9319__auto__);
var G__26043 = (0);
seq__26032 = G__26040;
chunk__26033 = G__26041;
count__26034 = G__26042;
i__26035 = G__26043;
continue;
} else {
var event = cljs.core.first.call(null,seq__26032__$1);
clear_event.call(null,event);

var G__26044 = cljs.core.next.call(null,seq__26032__$1);
var G__26045 = null;
var G__26046 = (0);
var G__26047 = (0);
seq__26032 = G__26044;
chunk__26033 = G__26045;
count__26034 = G__26046;
i__26035 = G__26047;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));
