// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__25850_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__25850_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___25851 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___25851)){
var not_i_25852 = temp__5457__auto___25851;
if(cljs.core.fn_QMARK_.call(null,not_i_25852)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_25852);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_25852);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_25853 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_25854 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__19291__auto___25867 = re_frame.interop.now.call(null);
var duration__19292__auto___25868 = (end__19291__auto___25867 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__25855_25869 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__25856_25870 = null;
var count__25857_25871 = (0);
var i__25858_25872 = (0);
while(true){
if((i__25858_25872 < count__25857_25871)){
var vec__25859_25873 = cljs.core._nth.call(null,chunk__25856_25870,i__25858_25872);
var k__19293__auto___25874 = cljs.core.nth.call(null,vec__25859_25873,(0),null);
var cb__19294__auto___25875 = cljs.core.nth.call(null,vec__25859_25873,(1),null);
try{cb__19294__auto___25875.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___25868,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e25862){if((e25862 instanceof java.lang.Exception)){
var e__19295__auto___25876 = e25862;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___25874,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___25876);
} else {
throw e25862;

}
}
var G__25877 = seq__25855_25869;
var G__25878 = chunk__25856_25870;
var G__25879 = count__25857_25871;
var G__25880 = (i__25858_25872 + (1));
seq__25855_25869 = G__25877;
chunk__25856_25870 = G__25878;
count__25857_25871 = G__25879;
i__25858_25872 = G__25880;
continue;
} else {
var temp__5457__auto___25881 = cljs.core.seq.call(null,seq__25855_25869);
if(temp__5457__auto___25881){
var seq__25855_25882__$1 = temp__5457__auto___25881;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25855_25882__$1)){
var c__9319__auto___25883 = cljs.core.chunk_first.call(null,seq__25855_25882__$1);
var G__25884 = cljs.core.chunk_rest.call(null,seq__25855_25882__$1);
var G__25885 = c__9319__auto___25883;
var G__25886 = cljs.core.count.call(null,c__9319__auto___25883);
var G__25887 = (0);
seq__25855_25869 = G__25884;
chunk__25856_25870 = G__25885;
count__25857_25871 = G__25886;
i__25858_25872 = G__25887;
continue;
} else {
var vec__25863_25888 = cljs.core.first.call(null,seq__25855_25882__$1);
var k__19293__auto___25889 = cljs.core.nth.call(null,vec__25863_25888,(0),null);
var cb__19294__auto___25890 = cljs.core.nth.call(null,vec__25863_25888,(1),null);
try{cb__19294__auto___25890.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___25868,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e25866){if((e25866 instanceof java.lang.Exception)){
var e__19295__auto___25891 = e25866;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___25889,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___25891);
} else {
throw e25866;

}
}
var G__25892 = cljs.core.next.call(null,seq__25855_25882__$1);
var G__25893 = null;
var G__25894 = (0);
var G__25895 = (0);
seq__25855_25869 = G__25892;
chunk__25856_25870 = G__25893;
count__25857_25871 = G__25894;
i__25858_25872 = G__25895;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_25854;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_25853;
}}
} else {
return null;
}
});
