// Compiled by ClojureScript 1.9.946 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__26742 = arguments.length;
switch (G__26742) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async26743 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26743 = (function (f,blockable,meta26744){
this.f = f;
this.blockable = blockable;
this.meta26744 = meta26744;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26745,meta26744__$1){
var self__ = this;
var _26745__$1 = this;
return (new cljs.core.async.t_cljs$core$async26743(self__.f,self__.blockable,meta26744__$1));
});

cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26745){
var self__ = this;
var _26745__$1 = this;
return self__.meta26744;
});

cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async26743.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async26743.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta26744","meta26744",1461216746,null)], null);
});

cljs.core.async.t_cljs$core$async26743.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26743.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26743";

cljs.core.async.t_cljs$core$async26743.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async26743");
});

cljs.core.async.__GT_t_cljs$core$async26743 = (function cljs$core$async$__GT_t_cljs$core$async26743(f__$1,blockable__$1,meta26744){
return (new cljs.core.async.t_cljs$core$async26743(f__$1,blockable__$1,meta26744));
});

}

return (new cljs.core.async.t_cljs$core$async26743(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__26749 = arguments.length;
switch (G__26749) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__26752 = arguments.length;
switch (G__26752) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__26755 = arguments.length;
switch (G__26755) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_26757 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_26757);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_26757,ret){
return (function (){
return fn1.call(null,val_26757);
});})(val_26757,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__26759 = arguments.length;
switch (G__26759) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9433__auto___26761 = n;
var x_26762 = (0);
while(true){
if((x_26762 < n__9433__auto___26761)){
(a[x_26762] = (0));

var G__26763 = (x_26762 + (1));
x_26762 = G__26763;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__26764 = (i + (1));
i = G__26764;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async26765 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26765 = (function (flag,meta26766){
this.flag = flag;
this.meta26766 = meta26766;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_26767,meta26766__$1){
var self__ = this;
var _26767__$1 = this;
return (new cljs.core.async.t_cljs$core$async26765(self__.flag,meta26766__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_26767){
var self__ = this;
var _26767__$1 = this;
return self__.meta26766;
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta26766","meta26766",2133586506,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async26765.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26765.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26765";

cljs.core.async.t_cljs$core$async26765.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async26765");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async26765 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async26765(flag__$1,meta26766){
return (new cljs.core.async.t_cljs$core$async26765(flag__$1,meta26766));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async26765(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async26768 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26768 = (function (flag,cb,meta26769){
this.flag = flag;
this.cb = cb;
this.meta26769 = meta26769;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26770,meta26769__$1){
var self__ = this;
var _26770__$1 = this;
return (new cljs.core.async.t_cljs$core$async26768(self__.flag,self__.cb,meta26769__$1));
});

cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26770){
var self__ = this;
var _26770__$1 = this;
return self__.meta26769;
});

cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async26768.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async26768.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta26769","meta26769",-1501282898,null)], null);
});

cljs.core.async.t_cljs$core$async26768.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26768.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26768";

cljs.core.async.t_cljs$core$async26768.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async26768");
});

cljs.core.async.__GT_t_cljs$core$async26768 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async26768(flag__$1,cb__$1,meta26769){
return (new cljs.core.async.t_cljs$core$async26768(flag__$1,cb__$1,meta26769));
});

}

return (new cljs.core.async.t_cljs$core$async26768(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26771_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26771_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26772_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26772_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8388__auto__ = wport;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return port;
}
})()], null));
} else {
var G__26773 = (i + (1));
i = G__26773;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8388__auto__ = ret;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__8376__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___26779 = arguments.length;
var i__9668__auto___26780 = (0);
while(true){
if((i__9668__auto___26780 < len__9667__auto___26779)){
args__9674__auto__.push((arguments[i__9668__auto___26780]));

var G__26781 = (i__9668__auto___26780 + (1));
i__9668__auto___26780 = G__26781;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__26776){
var map__26777 = p__26776;
var map__26777__$1 = ((((!((map__26777 == null)))?((((map__26777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26777):map__26777);
var opts = map__26777__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq26774){
var G__26775 = cljs.core.first.call(null,seq26774);
var seq26774__$1 = cljs.core.next.call(null,seq26774);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26775,seq26774__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__26783 = arguments.length;
switch (G__26783) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16273__auto___26829 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___26829){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___26829){
return (function (state_26807){
var state_val_26808 = (state_26807[(1)]);
if((state_val_26808 === (7))){
var inst_26803 = (state_26807[(2)]);
var state_26807__$1 = state_26807;
var statearr_26809_26830 = state_26807__$1;
(statearr_26809_26830[(2)] = inst_26803);

(statearr_26809_26830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (1))){
var state_26807__$1 = state_26807;
var statearr_26810_26831 = state_26807__$1;
(statearr_26810_26831[(2)] = null);

(statearr_26810_26831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (4))){
var inst_26786 = (state_26807[(7)]);
var inst_26786__$1 = (state_26807[(2)]);
var inst_26787 = (inst_26786__$1 == null);
var state_26807__$1 = (function (){var statearr_26811 = state_26807;
(statearr_26811[(7)] = inst_26786__$1);

return statearr_26811;
})();
if(cljs.core.truth_(inst_26787)){
var statearr_26812_26832 = state_26807__$1;
(statearr_26812_26832[(1)] = (5));

} else {
var statearr_26813_26833 = state_26807__$1;
(statearr_26813_26833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (13))){
var state_26807__$1 = state_26807;
var statearr_26814_26834 = state_26807__$1;
(statearr_26814_26834[(2)] = null);

(statearr_26814_26834[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (6))){
var inst_26786 = (state_26807[(7)]);
var state_26807__$1 = state_26807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26807__$1,(11),to,inst_26786);
} else {
if((state_val_26808 === (3))){
var inst_26805 = (state_26807[(2)]);
var state_26807__$1 = state_26807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26807__$1,inst_26805);
} else {
if((state_val_26808 === (12))){
var state_26807__$1 = state_26807;
var statearr_26815_26835 = state_26807__$1;
(statearr_26815_26835[(2)] = null);

(statearr_26815_26835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (2))){
var state_26807__$1 = state_26807;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26807__$1,(4),from);
} else {
if((state_val_26808 === (11))){
var inst_26796 = (state_26807[(2)]);
var state_26807__$1 = state_26807;
if(cljs.core.truth_(inst_26796)){
var statearr_26816_26836 = state_26807__$1;
(statearr_26816_26836[(1)] = (12));

} else {
var statearr_26817_26837 = state_26807__$1;
(statearr_26817_26837[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (9))){
var state_26807__$1 = state_26807;
var statearr_26818_26838 = state_26807__$1;
(statearr_26818_26838[(2)] = null);

(statearr_26818_26838[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (5))){
var state_26807__$1 = state_26807;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26819_26839 = state_26807__$1;
(statearr_26819_26839[(1)] = (8));

} else {
var statearr_26820_26840 = state_26807__$1;
(statearr_26820_26840[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (14))){
var inst_26801 = (state_26807[(2)]);
var state_26807__$1 = state_26807;
var statearr_26821_26841 = state_26807__$1;
(statearr_26821_26841[(2)] = inst_26801);

(statearr_26821_26841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (10))){
var inst_26793 = (state_26807[(2)]);
var state_26807__$1 = state_26807;
var statearr_26822_26842 = state_26807__$1;
(statearr_26822_26842[(2)] = inst_26793);

(statearr_26822_26842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26808 === (8))){
var inst_26790 = cljs.core.async.close_BANG_.call(null,to);
var state_26807__$1 = state_26807;
var statearr_26823_26843 = state_26807__$1;
(statearr_26823_26843[(2)] = inst_26790);

(statearr_26823_26843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___26829))
;
return ((function (switch__16183__auto__,c__16273__auto___26829){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_26824 = [null,null,null,null,null,null,null,null];
(statearr_26824[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_26824[(1)] = (1));

return statearr_26824;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_26807){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e26825){if((e26825 instanceof Object)){
var ex__16187__auto__ = e26825;
var statearr_26826_26844 = state_26807;
(statearr_26826_26844[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26825;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26845 = state_26807;
state_26807 = G__26845;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_26807){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_26807);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___26829))
})();
var state__16275__auto__ = (function (){var statearr_26827 = f__16274__auto__.call(null);
(statearr_26827[(6)] = c__16273__auto___26829);

return statearr_26827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___26829))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__26846){
var vec__26847 = p__26846;
var v = cljs.core.nth.call(null,vec__26847,(0),null);
var p = cljs.core.nth.call(null,vec__26847,(1),null);
var job = vec__26847;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16273__auto___27018 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results){
return (function (state_26854){
var state_val_26855 = (state_26854[(1)]);
if((state_val_26855 === (1))){
var state_26854__$1 = state_26854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26854__$1,(2),res,v);
} else {
if((state_val_26855 === (2))){
var inst_26851 = (state_26854[(2)]);
var inst_26852 = cljs.core.async.close_BANG_.call(null,res);
var state_26854__$1 = (function (){var statearr_26856 = state_26854;
(statearr_26856[(7)] = inst_26851);

return statearr_26856;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26854__$1,inst_26852);
} else {
return null;
}
}
});})(c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results))
;
return ((function (switch__16183__auto__,c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_26857 = [null,null,null,null,null,null,null,null];
(statearr_26857[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_26857[(1)] = (1));

return statearr_26857;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_26854){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e26858){if((e26858 instanceof Object)){
var ex__16187__auto__ = e26858;
var statearr_26859_27019 = state_26854;
(statearr_26859_27019[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26858;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27020 = state_26854;
state_26854 = G__27020;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_26854){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_26854);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results))
})();
var state__16275__auto__ = (function (){var statearr_26860 = f__16274__auto__.call(null);
(statearr_26860[(6)] = c__16273__auto___27018);

return statearr_26860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27018,res,vec__26847,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__26861){
var vec__26862 = p__26861;
var v = cljs.core.nth.call(null,vec__26862,(0),null);
var p = cljs.core.nth.call(null,vec__26862,(1),null);
var job = vec__26862;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9433__auto___27021 = n;
var __27022 = (0);
while(true){
if((__27022 < n__9433__auto___27021)){
var G__26865_27023 = type;
var G__26865_27024__$1 = (((G__26865_27023 instanceof cljs.core.Keyword))?G__26865_27023.fqn:null);
switch (G__26865_27024__$1) {
case "compute":
var c__16273__auto___27026 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27022,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__27022,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function (state_26878){
var state_val_26879 = (state_26878[(1)]);
if((state_val_26879 === (1))){
var state_26878__$1 = state_26878;
var statearr_26880_27027 = state_26878__$1;
(statearr_26880_27027[(2)] = null);

(statearr_26880_27027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26879 === (2))){
var state_26878__$1 = state_26878;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26878__$1,(4),jobs);
} else {
if((state_val_26879 === (3))){
var inst_26876 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26878__$1,inst_26876);
} else {
if((state_val_26879 === (4))){
var inst_26868 = (state_26878[(2)]);
var inst_26869 = process.call(null,inst_26868);
var state_26878__$1 = state_26878;
if(cljs.core.truth_(inst_26869)){
var statearr_26881_27028 = state_26878__$1;
(statearr_26881_27028[(1)] = (5));

} else {
var statearr_26882_27029 = state_26878__$1;
(statearr_26882_27029[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26879 === (5))){
var state_26878__$1 = state_26878;
var statearr_26883_27030 = state_26878__$1;
(statearr_26883_27030[(2)] = null);

(statearr_26883_27030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26879 === (6))){
var state_26878__$1 = state_26878;
var statearr_26884_27031 = state_26878__$1;
(statearr_26884_27031[(2)] = null);

(statearr_26884_27031[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26879 === (7))){
var inst_26874 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
var statearr_26885_27032 = state_26878__$1;
(statearr_26885_27032[(2)] = inst_26874);

(statearr_26885_27032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27022,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
;
return ((function (__27022,switch__16183__auto__,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_26886 = [null,null,null,null,null,null,null];
(statearr_26886[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_26886[(1)] = (1));

return statearr_26886;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_26878){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26878);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e26887){if((e26887 instanceof Object)){
var ex__16187__auto__ = e26887;
var statearr_26888_27033 = state_26878;
(statearr_26888_27033[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26878);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27034 = state_26878;
state_26878 = G__27034;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_26878){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_26878);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__27022,switch__16183__auto__,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_26889 = f__16274__auto__.call(null);
(statearr_26889[(6)] = c__16273__auto___27026);

return statearr_26889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__27022,c__16273__auto___27026,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
);


break;
case "async":
var c__16273__auto___27035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__27022,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__27022,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function (state_26902){
var state_val_26903 = (state_26902[(1)]);
if((state_val_26903 === (1))){
var state_26902__$1 = state_26902;
var statearr_26904_27036 = state_26902__$1;
(statearr_26904_27036[(2)] = null);

(statearr_26904_27036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26903 === (2))){
var state_26902__$1 = state_26902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26902__$1,(4),jobs);
} else {
if((state_val_26903 === (3))){
var inst_26900 = (state_26902[(2)]);
var state_26902__$1 = state_26902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26902__$1,inst_26900);
} else {
if((state_val_26903 === (4))){
var inst_26892 = (state_26902[(2)]);
var inst_26893 = async.call(null,inst_26892);
var state_26902__$1 = state_26902;
if(cljs.core.truth_(inst_26893)){
var statearr_26905_27037 = state_26902__$1;
(statearr_26905_27037[(1)] = (5));

} else {
var statearr_26906_27038 = state_26902__$1;
(statearr_26906_27038[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26903 === (5))){
var state_26902__$1 = state_26902;
var statearr_26907_27039 = state_26902__$1;
(statearr_26907_27039[(2)] = null);

(statearr_26907_27039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26903 === (6))){
var state_26902__$1 = state_26902;
var statearr_26908_27040 = state_26902__$1;
(statearr_26908_27040[(2)] = null);

(statearr_26908_27040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26903 === (7))){
var inst_26898 = (state_26902[(2)]);
var state_26902__$1 = state_26902;
var statearr_26909_27041 = state_26902__$1;
(statearr_26909_27041[(2)] = inst_26898);

(statearr_26909_27041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__27022,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
;
return ((function (__27022,switch__16183__auto__,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_26910 = [null,null,null,null,null,null,null];
(statearr_26910[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_26910[(1)] = (1));

return statearr_26910;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_26902){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e26911){if((e26911 instanceof Object)){
var ex__16187__auto__ = e26911;
var statearr_26912_27042 = state_26902;
(statearr_26912_27042[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26902);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26911;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27043 = state_26902;
state_26902 = G__27043;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_26902){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_26902);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__27022,switch__16183__auto__,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_26913 = f__16274__auto__.call(null);
(statearr_26913[(6)] = c__16273__auto___27035);

return statearr_26913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__27022,c__16273__auto___27035,G__26865_27023,G__26865_27024__$1,n__9433__auto___27021,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26865_27024__$1)].join('')));

}

var G__27044 = (__27022 + (1));
__27022 = G__27044;
continue;
} else {
}
break;
}

var c__16273__auto___27045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27045,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27045,jobs,results,process,async){
return (function (state_26935){
var state_val_26936 = (state_26935[(1)]);
if((state_val_26936 === (1))){
var state_26935__$1 = state_26935;
var statearr_26937_27046 = state_26935__$1;
(statearr_26937_27046[(2)] = null);

(statearr_26937_27046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26936 === (2))){
var state_26935__$1 = state_26935;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26935__$1,(4),from);
} else {
if((state_val_26936 === (3))){
var inst_26933 = (state_26935[(2)]);
var state_26935__$1 = state_26935;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26935__$1,inst_26933);
} else {
if((state_val_26936 === (4))){
var inst_26916 = (state_26935[(7)]);
var inst_26916__$1 = (state_26935[(2)]);
var inst_26917 = (inst_26916__$1 == null);
var state_26935__$1 = (function (){var statearr_26938 = state_26935;
(statearr_26938[(7)] = inst_26916__$1);

return statearr_26938;
})();
if(cljs.core.truth_(inst_26917)){
var statearr_26939_27047 = state_26935__$1;
(statearr_26939_27047[(1)] = (5));

} else {
var statearr_26940_27048 = state_26935__$1;
(statearr_26940_27048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26936 === (5))){
var inst_26919 = cljs.core.async.close_BANG_.call(null,jobs);
var state_26935__$1 = state_26935;
var statearr_26941_27049 = state_26935__$1;
(statearr_26941_27049[(2)] = inst_26919);

(statearr_26941_27049[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26936 === (6))){
var inst_26916 = (state_26935[(7)]);
var inst_26921 = (state_26935[(8)]);
var inst_26921__$1 = cljs.core.async.chan.call(null,(1));
var inst_26922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26923 = [inst_26916,inst_26921__$1];
var inst_26924 = (new cljs.core.PersistentVector(null,2,(5),inst_26922,inst_26923,null));
var state_26935__$1 = (function (){var statearr_26942 = state_26935;
(statearr_26942[(8)] = inst_26921__$1);

return statearr_26942;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26935__$1,(8),jobs,inst_26924);
} else {
if((state_val_26936 === (7))){
var inst_26931 = (state_26935[(2)]);
var state_26935__$1 = state_26935;
var statearr_26943_27050 = state_26935__$1;
(statearr_26943_27050[(2)] = inst_26931);

(statearr_26943_27050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26936 === (8))){
var inst_26921 = (state_26935[(8)]);
var inst_26926 = (state_26935[(2)]);
var state_26935__$1 = (function (){var statearr_26944 = state_26935;
(statearr_26944[(9)] = inst_26926);

return statearr_26944;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26935__$1,(9),results,inst_26921);
} else {
if((state_val_26936 === (9))){
var inst_26928 = (state_26935[(2)]);
var state_26935__$1 = (function (){var statearr_26945 = state_26935;
(statearr_26945[(10)] = inst_26928);

return statearr_26945;
})();
var statearr_26946_27051 = state_26935__$1;
(statearr_26946_27051[(2)] = null);

(statearr_26946_27051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___27045,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto___27045,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_26947 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26947[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_26947[(1)] = (1));

return statearr_26947;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_26935){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26935);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e26948){if((e26948 instanceof Object)){
var ex__16187__auto__ = e26948;
var statearr_26949_27052 = state_26935;
(statearr_26949_27052[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26935);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26948;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27053 = state_26935;
state_26935 = G__27053;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_26935){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_26935);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27045,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_26950 = f__16274__auto__.call(null);
(statearr_26950[(6)] = c__16273__auto___27045);

return statearr_26950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27045,jobs,results,process,async))
);


var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,jobs,results,process,async){
return (function (state_26988){
var state_val_26989 = (state_26988[(1)]);
if((state_val_26989 === (7))){
var inst_26984 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
var statearr_26990_27054 = state_26988__$1;
(statearr_26990_27054[(2)] = inst_26984);

(statearr_26990_27054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (20))){
var state_26988__$1 = state_26988;
var statearr_26991_27055 = state_26988__$1;
(statearr_26991_27055[(2)] = null);

(statearr_26991_27055[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (1))){
var state_26988__$1 = state_26988;
var statearr_26992_27056 = state_26988__$1;
(statearr_26992_27056[(2)] = null);

(statearr_26992_27056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (4))){
var inst_26953 = (state_26988[(7)]);
var inst_26953__$1 = (state_26988[(2)]);
var inst_26954 = (inst_26953__$1 == null);
var state_26988__$1 = (function (){var statearr_26993 = state_26988;
(statearr_26993[(7)] = inst_26953__$1);

return statearr_26993;
})();
if(cljs.core.truth_(inst_26954)){
var statearr_26994_27057 = state_26988__$1;
(statearr_26994_27057[(1)] = (5));

} else {
var statearr_26995_27058 = state_26988__$1;
(statearr_26995_27058[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (15))){
var inst_26966 = (state_26988[(8)]);
var state_26988__$1 = state_26988;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26988__$1,(18),to,inst_26966);
} else {
if((state_val_26989 === (21))){
var inst_26979 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
var statearr_26996_27059 = state_26988__$1;
(statearr_26996_27059[(2)] = inst_26979);

(statearr_26996_27059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (13))){
var inst_26981 = (state_26988[(2)]);
var state_26988__$1 = (function (){var statearr_26997 = state_26988;
(statearr_26997[(9)] = inst_26981);

return statearr_26997;
})();
var statearr_26998_27060 = state_26988__$1;
(statearr_26998_27060[(2)] = null);

(statearr_26998_27060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (6))){
var inst_26953 = (state_26988[(7)]);
var state_26988__$1 = state_26988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26988__$1,(11),inst_26953);
} else {
if((state_val_26989 === (17))){
var inst_26974 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
if(cljs.core.truth_(inst_26974)){
var statearr_26999_27061 = state_26988__$1;
(statearr_26999_27061[(1)] = (19));

} else {
var statearr_27000_27062 = state_26988__$1;
(statearr_27000_27062[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (3))){
var inst_26986 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26988__$1,inst_26986);
} else {
if((state_val_26989 === (12))){
var inst_26963 = (state_26988[(10)]);
var state_26988__$1 = state_26988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26988__$1,(14),inst_26963);
} else {
if((state_val_26989 === (2))){
var state_26988__$1 = state_26988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26988__$1,(4),results);
} else {
if((state_val_26989 === (19))){
var state_26988__$1 = state_26988;
var statearr_27001_27063 = state_26988__$1;
(statearr_27001_27063[(2)] = null);

(statearr_27001_27063[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (11))){
var inst_26963 = (state_26988[(2)]);
var state_26988__$1 = (function (){var statearr_27002 = state_26988;
(statearr_27002[(10)] = inst_26963);

return statearr_27002;
})();
var statearr_27003_27064 = state_26988__$1;
(statearr_27003_27064[(2)] = null);

(statearr_27003_27064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (9))){
var state_26988__$1 = state_26988;
var statearr_27004_27065 = state_26988__$1;
(statearr_27004_27065[(2)] = null);

(statearr_27004_27065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (5))){
var state_26988__$1 = state_26988;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27005_27066 = state_26988__$1;
(statearr_27005_27066[(1)] = (8));

} else {
var statearr_27006_27067 = state_26988__$1;
(statearr_27006_27067[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (14))){
var inst_26968 = (state_26988[(11)]);
var inst_26966 = (state_26988[(8)]);
var inst_26966__$1 = (state_26988[(2)]);
var inst_26967 = (inst_26966__$1 == null);
var inst_26968__$1 = cljs.core.not.call(null,inst_26967);
var state_26988__$1 = (function (){var statearr_27007 = state_26988;
(statearr_27007[(11)] = inst_26968__$1);

(statearr_27007[(8)] = inst_26966__$1);

return statearr_27007;
})();
if(inst_26968__$1){
var statearr_27008_27068 = state_26988__$1;
(statearr_27008_27068[(1)] = (15));

} else {
var statearr_27009_27069 = state_26988__$1;
(statearr_27009_27069[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (16))){
var inst_26968 = (state_26988[(11)]);
var state_26988__$1 = state_26988;
var statearr_27010_27070 = state_26988__$1;
(statearr_27010_27070[(2)] = inst_26968);

(statearr_27010_27070[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (10))){
var inst_26960 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
var statearr_27011_27071 = state_26988__$1;
(statearr_27011_27071[(2)] = inst_26960);

(statearr_27011_27071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (18))){
var inst_26971 = (state_26988[(2)]);
var state_26988__$1 = state_26988;
var statearr_27012_27072 = state_26988__$1;
(statearr_27012_27072[(2)] = inst_26971);

(statearr_27012_27072[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26989 === (8))){
var inst_26957 = cljs.core.async.close_BANG_.call(null,to);
var state_26988__$1 = state_26988;
var statearr_27013_27073 = state_26988__$1;
(statearr_27013_27073[(2)] = inst_26957);

(statearr_27013_27073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_27014 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27014[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_27014[(1)] = (1));

return statearr_27014;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_26988){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_26988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27015){if((e27015 instanceof Object)){
var ex__16187__auto__ = e27015;
var statearr_27016_27074 = state_26988;
(statearr_27016_27074[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26988);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27015;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27075 = state_26988;
state_26988 = G__27075;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_26988){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_26988);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_27017 = f__16274__auto__.call(null);
(statearr_27017[(6)] = c__16273__auto__);

return statearr_27017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,jobs,results,process,async))
);

return c__16273__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__27077 = arguments.length;
switch (G__27077) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__27080 = arguments.length;
switch (G__27080) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__27083 = arguments.length;
switch (G__27083) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16273__auto___27132 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27132,tc,fc){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27132,tc,fc){
return (function (state_27109){
var state_val_27110 = (state_27109[(1)]);
if((state_val_27110 === (7))){
var inst_27105 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27111_27133 = state_27109__$1;
(statearr_27111_27133[(2)] = inst_27105);

(statearr_27111_27133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (1))){
var state_27109__$1 = state_27109;
var statearr_27112_27134 = state_27109__$1;
(statearr_27112_27134[(2)] = null);

(statearr_27112_27134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (4))){
var inst_27086 = (state_27109[(7)]);
var inst_27086__$1 = (state_27109[(2)]);
var inst_27087 = (inst_27086__$1 == null);
var state_27109__$1 = (function (){var statearr_27113 = state_27109;
(statearr_27113[(7)] = inst_27086__$1);

return statearr_27113;
})();
if(cljs.core.truth_(inst_27087)){
var statearr_27114_27135 = state_27109__$1;
(statearr_27114_27135[(1)] = (5));

} else {
var statearr_27115_27136 = state_27109__$1;
(statearr_27115_27136[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (13))){
var state_27109__$1 = state_27109;
var statearr_27116_27137 = state_27109__$1;
(statearr_27116_27137[(2)] = null);

(statearr_27116_27137[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (6))){
var inst_27086 = (state_27109[(7)]);
var inst_27092 = p.call(null,inst_27086);
var state_27109__$1 = state_27109;
if(cljs.core.truth_(inst_27092)){
var statearr_27117_27138 = state_27109__$1;
(statearr_27117_27138[(1)] = (9));

} else {
var statearr_27118_27139 = state_27109__$1;
(statearr_27118_27139[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (3))){
var inst_27107 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27109__$1,inst_27107);
} else {
if((state_val_27110 === (12))){
var state_27109__$1 = state_27109;
var statearr_27119_27140 = state_27109__$1;
(statearr_27119_27140[(2)] = null);

(statearr_27119_27140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (2))){
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27109__$1,(4),ch);
} else {
if((state_val_27110 === (11))){
var inst_27086 = (state_27109[(7)]);
var inst_27096 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27109__$1,(8),inst_27096,inst_27086);
} else {
if((state_val_27110 === (9))){
var state_27109__$1 = state_27109;
var statearr_27120_27141 = state_27109__$1;
(statearr_27120_27141[(2)] = tc);

(statearr_27120_27141[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (5))){
var inst_27089 = cljs.core.async.close_BANG_.call(null,tc);
var inst_27090 = cljs.core.async.close_BANG_.call(null,fc);
var state_27109__$1 = (function (){var statearr_27121 = state_27109;
(statearr_27121[(8)] = inst_27089);

return statearr_27121;
})();
var statearr_27122_27142 = state_27109__$1;
(statearr_27122_27142[(2)] = inst_27090);

(statearr_27122_27142[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (14))){
var inst_27103 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
var statearr_27123_27143 = state_27109__$1;
(statearr_27123_27143[(2)] = inst_27103);

(statearr_27123_27143[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (10))){
var state_27109__$1 = state_27109;
var statearr_27124_27144 = state_27109__$1;
(statearr_27124_27144[(2)] = fc);

(statearr_27124_27144[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27110 === (8))){
var inst_27098 = (state_27109[(2)]);
var state_27109__$1 = state_27109;
if(cljs.core.truth_(inst_27098)){
var statearr_27125_27145 = state_27109__$1;
(statearr_27125_27145[(1)] = (12));

} else {
var statearr_27126_27146 = state_27109__$1;
(statearr_27126_27146[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___27132,tc,fc))
;
return ((function (switch__16183__auto__,c__16273__auto___27132,tc,fc){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_27127 = [null,null,null,null,null,null,null,null,null];
(statearr_27127[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_27127[(1)] = (1));

return statearr_27127;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_27109){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27109);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27128){if((e27128 instanceof Object)){
var ex__16187__auto__ = e27128;
var statearr_27129_27147 = state_27109;
(statearr_27129_27147[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27109);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27128;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27148 = state_27109;
state_27109 = G__27148;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_27109){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_27109);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27132,tc,fc))
})();
var state__16275__auto__ = (function (){var statearr_27130 = f__16274__auto__.call(null);
(statearr_27130[(6)] = c__16273__auto___27132);

return statearr_27130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27132,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_27169){
var state_val_27170 = (state_27169[(1)]);
if((state_val_27170 === (7))){
var inst_27165 = (state_27169[(2)]);
var state_27169__$1 = state_27169;
var statearr_27171_27189 = state_27169__$1;
(statearr_27171_27189[(2)] = inst_27165);

(statearr_27171_27189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (1))){
var inst_27149 = init;
var state_27169__$1 = (function (){var statearr_27172 = state_27169;
(statearr_27172[(7)] = inst_27149);

return statearr_27172;
})();
var statearr_27173_27190 = state_27169__$1;
(statearr_27173_27190[(2)] = null);

(statearr_27173_27190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (4))){
var inst_27152 = (state_27169[(8)]);
var inst_27152__$1 = (state_27169[(2)]);
var inst_27153 = (inst_27152__$1 == null);
var state_27169__$1 = (function (){var statearr_27174 = state_27169;
(statearr_27174[(8)] = inst_27152__$1);

return statearr_27174;
})();
if(cljs.core.truth_(inst_27153)){
var statearr_27175_27191 = state_27169__$1;
(statearr_27175_27191[(1)] = (5));

} else {
var statearr_27176_27192 = state_27169__$1;
(statearr_27176_27192[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (6))){
var inst_27149 = (state_27169[(7)]);
var inst_27152 = (state_27169[(8)]);
var inst_27156 = (state_27169[(9)]);
var inst_27156__$1 = f.call(null,inst_27149,inst_27152);
var inst_27157 = cljs.core.reduced_QMARK_.call(null,inst_27156__$1);
var state_27169__$1 = (function (){var statearr_27177 = state_27169;
(statearr_27177[(9)] = inst_27156__$1);

return statearr_27177;
})();
if(inst_27157){
var statearr_27178_27193 = state_27169__$1;
(statearr_27178_27193[(1)] = (8));

} else {
var statearr_27179_27194 = state_27169__$1;
(statearr_27179_27194[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (3))){
var inst_27167 = (state_27169[(2)]);
var state_27169__$1 = state_27169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27169__$1,inst_27167);
} else {
if((state_val_27170 === (2))){
var state_27169__$1 = state_27169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27169__$1,(4),ch);
} else {
if((state_val_27170 === (9))){
var inst_27156 = (state_27169[(9)]);
var inst_27149 = inst_27156;
var state_27169__$1 = (function (){var statearr_27180 = state_27169;
(statearr_27180[(7)] = inst_27149);

return statearr_27180;
})();
var statearr_27181_27195 = state_27169__$1;
(statearr_27181_27195[(2)] = null);

(statearr_27181_27195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (5))){
var inst_27149 = (state_27169[(7)]);
var state_27169__$1 = state_27169;
var statearr_27182_27196 = state_27169__$1;
(statearr_27182_27196[(2)] = inst_27149);

(statearr_27182_27196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (10))){
var inst_27163 = (state_27169[(2)]);
var state_27169__$1 = state_27169;
var statearr_27183_27197 = state_27169__$1;
(statearr_27183_27197[(2)] = inst_27163);

(statearr_27183_27197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27170 === (8))){
var inst_27156 = (state_27169[(9)]);
var inst_27159 = cljs.core.deref.call(null,inst_27156);
var state_27169__$1 = state_27169;
var statearr_27184_27198 = state_27169__$1;
(statearr_27184_27198[(2)] = inst_27159);

(statearr_27184_27198[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16184__auto____0 = (function (){
var statearr_27185 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27185[(0)] = cljs$core$async$reduce_$_state_machine__16184__auto__);

(statearr_27185[(1)] = (1));

return statearr_27185;
});
var cljs$core$async$reduce_$_state_machine__16184__auto____1 = (function (state_27169){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27186){if((e27186 instanceof Object)){
var ex__16187__auto__ = e27186;
var statearr_27187_27199 = state_27169;
(statearr_27187_27199[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27169);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27186;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27200 = state_27169;
state_27169 = G__27200;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16184__auto__ = function(state_27169){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16184__auto____1.call(this,state_27169);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16184__auto____0;
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16184__auto____1;
return cljs$core$async$reduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_27188 = f__16274__auto__.call(null);
(statearr_27188[(6)] = c__16273__auto__);

return statearr_27188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,f__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,f__$1){
return (function (state_27206){
var state_val_27207 = (state_27206[(1)]);
if((state_val_27207 === (1))){
var inst_27201 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_27206__$1 = state_27206;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27206__$1,(2),inst_27201);
} else {
if((state_val_27207 === (2))){
var inst_27203 = (state_27206[(2)]);
var inst_27204 = f__$1.call(null,inst_27203);
var state_27206__$1 = state_27206;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27206__$1,inst_27204);
} else {
return null;
}
}
});})(c__16273__auto__,f__$1))
;
return ((function (switch__16183__auto__,c__16273__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16184__auto____0 = (function (){
var statearr_27208 = [null,null,null,null,null,null,null];
(statearr_27208[(0)] = cljs$core$async$transduce_$_state_machine__16184__auto__);

(statearr_27208[(1)] = (1));

return statearr_27208;
});
var cljs$core$async$transduce_$_state_machine__16184__auto____1 = (function (state_27206){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27206);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27209){if((e27209 instanceof Object)){
var ex__16187__auto__ = e27209;
var statearr_27210_27212 = state_27206;
(statearr_27210_27212[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27206);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27213 = state_27206;
state_27206 = G__27213;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16184__auto__ = function(state_27206){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16184__auto____1.call(this,state_27206);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16184__auto____0;
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16184__auto____1;
return cljs$core$async$transduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,f__$1))
})();
var state__16275__auto__ = (function (){var statearr_27211 = f__16274__auto__.call(null);
(statearr_27211[(6)] = c__16273__auto__);

return statearr_27211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,f__$1))
);

return c__16273__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__27215 = arguments.length;
switch (G__27215) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_27240){
var state_val_27241 = (state_27240[(1)]);
if((state_val_27241 === (7))){
var inst_27222 = (state_27240[(2)]);
var state_27240__$1 = state_27240;
var statearr_27242_27263 = state_27240__$1;
(statearr_27242_27263[(2)] = inst_27222);

(statearr_27242_27263[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (1))){
var inst_27216 = cljs.core.seq.call(null,coll);
var inst_27217 = inst_27216;
var state_27240__$1 = (function (){var statearr_27243 = state_27240;
(statearr_27243[(7)] = inst_27217);

return statearr_27243;
})();
var statearr_27244_27264 = state_27240__$1;
(statearr_27244_27264[(2)] = null);

(statearr_27244_27264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (4))){
var inst_27217 = (state_27240[(7)]);
var inst_27220 = cljs.core.first.call(null,inst_27217);
var state_27240__$1 = state_27240;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27240__$1,(7),ch,inst_27220);
} else {
if((state_val_27241 === (13))){
var inst_27234 = (state_27240[(2)]);
var state_27240__$1 = state_27240;
var statearr_27245_27265 = state_27240__$1;
(statearr_27245_27265[(2)] = inst_27234);

(statearr_27245_27265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (6))){
var inst_27225 = (state_27240[(2)]);
var state_27240__$1 = state_27240;
if(cljs.core.truth_(inst_27225)){
var statearr_27246_27266 = state_27240__$1;
(statearr_27246_27266[(1)] = (8));

} else {
var statearr_27247_27267 = state_27240__$1;
(statearr_27247_27267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (3))){
var inst_27238 = (state_27240[(2)]);
var state_27240__$1 = state_27240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27240__$1,inst_27238);
} else {
if((state_val_27241 === (12))){
var state_27240__$1 = state_27240;
var statearr_27248_27268 = state_27240__$1;
(statearr_27248_27268[(2)] = null);

(statearr_27248_27268[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (2))){
var inst_27217 = (state_27240[(7)]);
var state_27240__$1 = state_27240;
if(cljs.core.truth_(inst_27217)){
var statearr_27249_27269 = state_27240__$1;
(statearr_27249_27269[(1)] = (4));

} else {
var statearr_27250_27270 = state_27240__$1;
(statearr_27250_27270[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (11))){
var inst_27231 = cljs.core.async.close_BANG_.call(null,ch);
var state_27240__$1 = state_27240;
var statearr_27251_27271 = state_27240__$1;
(statearr_27251_27271[(2)] = inst_27231);

(statearr_27251_27271[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (9))){
var state_27240__$1 = state_27240;
if(cljs.core.truth_(close_QMARK_)){
var statearr_27252_27272 = state_27240__$1;
(statearr_27252_27272[(1)] = (11));

} else {
var statearr_27253_27273 = state_27240__$1;
(statearr_27253_27273[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (5))){
var inst_27217 = (state_27240[(7)]);
var state_27240__$1 = state_27240;
var statearr_27254_27274 = state_27240__$1;
(statearr_27254_27274[(2)] = inst_27217);

(statearr_27254_27274[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (10))){
var inst_27236 = (state_27240[(2)]);
var state_27240__$1 = state_27240;
var statearr_27255_27275 = state_27240__$1;
(statearr_27255_27275[(2)] = inst_27236);

(statearr_27255_27275[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27241 === (8))){
var inst_27217 = (state_27240[(7)]);
var inst_27227 = cljs.core.next.call(null,inst_27217);
var inst_27217__$1 = inst_27227;
var state_27240__$1 = (function (){var statearr_27256 = state_27240;
(statearr_27256[(7)] = inst_27217__$1);

return statearr_27256;
})();
var statearr_27257_27276 = state_27240__$1;
(statearr_27257_27276[(2)] = null);

(statearr_27257_27276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_27258 = [null,null,null,null,null,null,null,null];
(statearr_27258[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_27258[(1)] = (1));

return statearr_27258;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_27240){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27259){if((e27259 instanceof Object)){
var ex__16187__auto__ = e27259;
var statearr_27260_27277 = state_27240;
(statearr_27260_27277[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27240);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27259;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27278 = state_27240;
state_27240 = G__27278;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_27240){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_27240);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_27261 = f__16274__auto__.call(null);
(statearr_27261[(6)] = c__16273__auto__);

return statearr_27261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9121__auto__ = (((_ == null))?null:_);
var m__9122__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,_);
} else {
var m__9122__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m__$1,ch,close_QMARK_){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m__$1.cljs$core$async$Mult$tap_STAR_$arity$3(m__$1,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m__$1);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m__$1);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m__$1);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async27279 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27279 = (function (ch,cs,meta27280){
this.ch = ch;
this.cs = cs;
this.meta27280 = meta27280;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_27281,meta27280__$1){
var self__ = this;
var _27281__$1 = this;
return (new cljs.core.async.t_cljs$core$async27279(self__.ch,self__.cs,meta27280__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_27281){
var self__ = this;
var _27281__$1 = this;
return self__.meta27280;
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta27280","meta27280",-576532153,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async27279.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27279.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27279";

cljs.core.async.t_cljs$core$async27279.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async27279");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async27279 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async27279(ch__$1,cs__$1,meta27280){
return (new cljs.core.async.t_cljs$core$async27279(ch__$1,cs__$1,meta27280));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async27279(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m__$1,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m__$1,dchan,dctr))
;
var c__16273__auto___27501 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27501,cs,m__$1,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27501,cs,m__$1,dchan,dctr,done){
return (function (state_27416){
var state_val_27417 = (state_27416[(1)]);
if((state_val_27417 === (7))){
var inst_27412 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27418_27502 = state_27416__$1;
(statearr_27418_27502[(2)] = inst_27412);

(statearr_27418_27502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (20))){
var inst_27315 = (state_27416[(7)]);
var inst_27327 = cljs.core.first.call(null,inst_27315);
var inst_27328 = cljs.core.nth.call(null,inst_27327,(0),null);
var inst_27329 = cljs.core.nth.call(null,inst_27327,(1),null);
var state_27416__$1 = (function (){var statearr_27419 = state_27416;
(statearr_27419[(8)] = inst_27328);

return statearr_27419;
})();
if(cljs.core.truth_(inst_27329)){
var statearr_27420_27503 = state_27416__$1;
(statearr_27420_27503[(1)] = (22));

} else {
var statearr_27421_27504 = state_27416__$1;
(statearr_27421_27504[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (27))){
var inst_27359 = (state_27416[(9)]);
var inst_27284 = (state_27416[(10)]);
var inst_27364 = (state_27416[(11)]);
var inst_27357 = (state_27416[(12)]);
var inst_27364__$1 = cljs.core._nth.call(null,inst_27357,inst_27359);
var inst_27365 = cljs.core.async.put_BANG_.call(null,inst_27364__$1,inst_27284,done);
var state_27416__$1 = (function (){var statearr_27422 = state_27416;
(statearr_27422[(11)] = inst_27364__$1);

return statearr_27422;
})();
if(cljs.core.truth_(inst_27365)){
var statearr_27423_27505 = state_27416__$1;
(statearr_27423_27505[(1)] = (30));

} else {
var statearr_27424_27506 = state_27416__$1;
(statearr_27424_27506[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (1))){
var state_27416__$1 = state_27416;
var statearr_27425_27507 = state_27416__$1;
(statearr_27425_27507[(2)] = null);

(statearr_27425_27507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (24))){
var inst_27315 = (state_27416[(7)]);
var inst_27334 = (state_27416[(2)]);
var inst_27335 = cljs.core.next.call(null,inst_27315);
var inst_27293 = inst_27335;
var inst_27294 = null;
var inst_27295 = (0);
var inst_27296 = (0);
var state_27416__$1 = (function (){var statearr_27426 = state_27416;
(statearr_27426[(13)] = inst_27295);

(statearr_27426[(14)] = inst_27293);

(statearr_27426[(15)] = inst_27294);

(statearr_27426[(16)] = inst_27334);

(statearr_27426[(17)] = inst_27296);

return statearr_27426;
})();
var statearr_27427_27508 = state_27416__$1;
(statearr_27427_27508[(2)] = null);

(statearr_27427_27508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (39))){
var state_27416__$1 = state_27416;
var statearr_27431_27509 = state_27416__$1;
(statearr_27431_27509[(2)] = null);

(statearr_27431_27509[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (4))){
var inst_27284 = (state_27416[(10)]);
var inst_27284__$1 = (state_27416[(2)]);
var inst_27285 = (inst_27284__$1 == null);
var state_27416__$1 = (function (){var statearr_27432 = state_27416;
(statearr_27432[(10)] = inst_27284__$1);

return statearr_27432;
})();
if(cljs.core.truth_(inst_27285)){
var statearr_27433_27510 = state_27416__$1;
(statearr_27433_27510[(1)] = (5));

} else {
var statearr_27434_27511 = state_27416__$1;
(statearr_27434_27511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (15))){
var inst_27295 = (state_27416[(13)]);
var inst_27293 = (state_27416[(14)]);
var inst_27294 = (state_27416[(15)]);
var inst_27296 = (state_27416[(17)]);
var inst_27311 = (state_27416[(2)]);
var inst_27312 = (inst_27296 + (1));
var tmp27428 = inst_27295;
var tmp27429 = inst_27293;
var tmp27430 = inst_27294;
var inst_27293__$1 = tmp27429;
var inst_27294__$1 = tmp27430;
var inst_27295__$1 = tmp27428;
var inst_27296__$1 = inst_27312;
var state_27416__$1 = (function (){var statearr_27435 = state_27416;
(statearr_27435[(18)] = inst_27311);

(statearr_27435[(13)] = inst_27295__$1);

(statearr_27435[(14)] = inst_27293__$1);

(statearr_27435[(15)] = inst_27294__$1);

(statearr_27435[(17)] = inst_27296__$1);

return statearr_27435;
})();
var statearr_27436_27512 = state_27416__$1;
(statearr_27436_27512[(2)] = null);

(statearr_27436_27512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (21))){
var inst_27338 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27440_27513 = state_27416__$1;
(statearr_27440_27513[(2)] = inst_27338);

(statearr_27440_27513[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (31))){
var inst_27364 = (state_27416[(11)]);
var inst_27368 = done.call(null,null);
var inst_27369 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_27364);
var state_27416__$1 = (function (){var statearr_27441 = state_27416;
(statearr_27441[(19)] = inst_27368);

return statearr_27441;
})();
var statearr_27442_27514 = state_27416__$1;
(statearr_27442_27514[(2)] = inst_27369);

(statearr_27442_27514[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (32))){
var inst_27356 = (state_27416[(20)]);
var inst_27358 = (state_27416[(21)]);
var inst_27359 = (state_27416[(9)]);
var inst_27357 = (state_27416[(12)]);
var inst_27371 = (state_27416[(2)]);
var inst_27372 = (inst_27359 + (1));
var tmp27437 = inst_27356;
var tmp27438 = inst_27358;
var tmp27439 = inst_27357;
var inst_27356__$1 = tmp27437;
var inst_27357__$1 = tmp27439;
var inst_27358__$1 = tmp27438;
var inst_27359__$1 = inst_27372;
var state_27416__$1 = (function (){var statearr_27443 = state_27416;
(statearr_27443[(20)] = inst_27356__$1);

(statearr_27443[(21)] = inst_27358__$1);

(statearr_27443[(22)] = inst_27371);

(statearr_27443[(9)] = inst_27359__$1);

(statearr_27443[(12)] = inst_27357__$1);

return statearr_27443;
})();
var statearr_27444_27515 = state_27416__$1;
(statearr_27444_27515[(2)] = null);

(statearr_27444_27515[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (40))){
var inst_27384 = (state_27416[(23)]);
var inst_27388 = done.call(null,null);
var inst_27389 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_27384);
var state_27416__$1 = (function (){var statearr_27445 = state_27416;
(statearr_27445[(24)] = inst_27388);

return statearr_27445;
})();
var statearr_27446_27516 = state_27416__$1;
(statearr_27446_27516[(2)] = inst_27389);

(statearr_27446_27516[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (33))){
var inst_27375 = (state_27416[(25)]);
var inst_27377 = cljs.core.chunked_seq_QMARK_.call(null,inst_27375);
var state_27416__$1 = state_27416;
if(inst_27377){
var statearr_27447_27517 = state_27416__$1;
(statearr_27447_27517[(1)] = (36));

} else {
var statearr_27448_27518 = state_27416__$1;
(statearr_27448_27518[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (13))){
var inst_27305 = (state_27416[(26)]);
var inst_27308 = cljs.core.async.close_BANG_.call(null,inst_27305);
var state_27416__$1 = state_27416;
var statearr_27449_27519 = state_27416__$1;
(statearr_27449_27519[(2)] = inst_27308);

(statearr_27449_27519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (22))){
var inst_27328 = (state_27416[(8)]);
var inst_27331 = cljs.core.async.close_BANG_.call(null,inst_27328);
var state_27416__$1 = state_27416;
var statearr_27450_27520 = state_27416__$1;
(statearr_27450_27520[(2)] = inst_27331);

(statearr_27450_27520[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (36))){
var inst_27375 = (state_27416[(25)]);
var inst_27379 = cljs.core.chunk_first.call(null,inst_27375);
var inst_27380 = cljs.core.chunk_rest.call(null,inst_27375);
var inst_27381 = cljs.core.count.call(null,inst_27379);
var inst_27356 = inst_27380;
var inst_27357 = inst_27379;
var inst_27358 = inst_27381;
var inst_27359 = (0);
var state_27416__$1 = (function (){var statearr_27451 = state_27416;
(statearr_27451[(20)] = inst_27356);

(statearr_27451[(21)] = inst_27358);

(statearr_27451[(9)] = inst_27359);

(statearr_27451[(12)] = inst_27357);

return statearr_27451;
})();
var statearr_27452_27521 = state_27416__$1;
(statearr_27452_27521[(2)] = null);

(statearr_27452_27521[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (41))){
var inst_27375 = (state_27416[(25)]);
var inst_27391 = (state_27416[(2)]);
var inst_27392 = cljs.core.next.call(null,inst_27375);
var inst_27356 = inst_27392;
var inst_27357 = null;
var inst_27358 = (0);
var inst_27359 = (0);
var state_27416__$1 = (function (){var statearr_27453 = state_27416;
(statearr_27453[(20)] = inst_27356);

(statearr_27453[(27)] = inst_27391);

(statearr_27453[(21)] = inst_27358);

(statearr_27453[(9)] = inst_27359);

(statearr_27453[(12)] = inst_27357);

return statearr_27453;
})();
var statearr_27454_27522 = state_27416__$1;
(statearr_27454_27522[(2)] = null);

(statearr_27454_27522[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (43))){
var state_27416__$1 = state_27416;
var statearr_27455_27523 = state_27416__$1;
(statearr_27455_27523[(2)] = null);

(statearr_27455_27523[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (29))){
var inst_27400 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27456_27524 = state_27416__$1;
(statearr_27456_27524[(2)] = inst_27400);

(statearr_27456_27524[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (44))){
var inst_27409 = (state_27416[(2)]);
var state_27416__$1 = (function (){var statearr_27457 = state_27416;
(statearr_27457[(28)] = inst_27409);

return statearr_27457;
})();
var statearr_27458_27525 = state_27416__$1;
(statearr_27458_27525[(2)] = null);

(statearr_27458_27525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (6))){
var inst_27348 = (state_27416[(29)]);
var inst_27347 = cljs.core.deref.call(null,cs);
var inst_27348__$1 = cljs.core.keys.call(null,inst_27347);
var inst_27349 = cljs.core.count.call(null,inst_27348__$1);
var inst_27350 = cljs.core.reset_BANG_.call(null,dctr,inst_27349);
var inst_27355 = cljs.core.seq.call(null,inst_27348__$1);
var inst_27356 = inst_27355;
var inst_27357 = null;
var inst_27358 = (0);
var inst_27359 = (0);
var state_27416__$1 = (function (){var statearr_27459 = state_27416;
(statearr_27459[(20)] = inst_27356);

(statearr_27459[(21)] = inst_27358);

(statearr_27459[(30)] = inst_27350);

(statearr_27459[(29)] = inst_27348__$1);

(statearr_27459[(9)] = inst_27359);

(statearr_27459[(12)] = inst_27357);

return statearr_27459;
})();
var statearr_27460_27526 = state_27416__$1;
(statearr_27460_27526[(2)] = null);

(statearr_27460_27526[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (28))){
var inst_27356 = (state_27416[(20)]);
var inst_27375 = (state_27416[(25)]);
var inst_27375__$1 = cljs.core.seq.call(null,inst_27356);
var state_27416__$1 = (function (){var statearr_27461 = state_27416;
(statearr_27461[(25)] = inst_27375__$1);

return statearr_27461;
})();
if(inst_27375__$1){
var statearr_27462_27527 = state_27416__$1;
(statearr_27462_27527[(1)] = (33));

} else {
var statearr_27463_27528 = state_27416__$1;
(statearr_27463_27528[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (25))){
var inst_27358 = (state_27416[(21)]);
var inst_27359 = (state_27416[(9)]);
var inst_27361 = (inst_27359 < inst_27358);
var inst_27362 = inst_27361;
var state_27416__$1 = state_27416;
if(cljs.core.truth_(inst_27362)){
var statearr_27464_27529 = state_27416__$1;
(statearr_27464_27529[(1)] = (27));

} else {
var statearr_27465_27530 = state_27416__$1;
(statearr_27465_27530[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (34))){
var state_27416__$1 = state_27416;
var statearr_27466_27531 = state_27416__$1;
(statearr_27466_27531[(2)] = null);

(statearr_27466_27531[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (17))){
var state_27416__$1 = state_27416;
var statearr_27467_27532 = state_27416__$1;
(statearr_27467_27532[(2)] = null);

(statearr_27467_27532[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (3))){
var inst_27414 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27416__$1,inst_27414);
} else {
if((state_val_27417 === (12))){
var inst_27343 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27468_27533 = state_27416__$1;
(statearr_27468_27533[(2)] = inst_27343);

(statearr_27468_27533[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (2))){
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27416__$1,(4),ch);
} else {
if((state_val_27417 === (23))){
var state_27416__$1 = state_27416;
var statearr_27469_27534 = state_27416__$1;
(statearr_27469_27534[(2)] = null);

(statearr_27469_27534[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (35))){
var inst_27398 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27470_27535 = state_27416__$1;
(statearr_27470_27535[(2)] = inst_27398);

(statearr_27470_27535[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (19))){
var inst_27315 = (state_27416[(7)]);
var inst_27319 = cljs.core.chunk_first.call(null,inst_27315);
var inst_27320 = cljs.core.chunk_rest.call(null,inst_27315);
var inst_27321 = cljs.core.count.call(null,inst_27319);
var inst_27293 = inst_27320;
var inst_27294 = inst_27319;
var inst_27295 = inst_27321;
var inst_27296 = (0);
var state_27416__$1 = (function (){var statearr_27471 = state_27416;
(statearr_27471[(13)] = inst_27295);

(statearr_27471[(14)] = inst_27293);

(statearr_27471[(15)] = inst_27294);

(statearr_27471[(17)] = inst_27296);

return statearr_27471;
})();
var statearr_27472_27536 = state_27416__$1;
(statearr_27472_27536[(2)] = null);

(statearr_27472_27536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (11))){
var inst_27293 = (state_27416[(14)]);
var inst_27315 = (state_27416[(7)]);
var inst_27315__$1 = cljs.core.seq.call(null,inst_27293);
var state_27416__$1 = (function (){var statearr_27473 = state_27416;
(statearr_27473[(7)] = inst_27315__$1);

return statearr_27473;
})();
if(inst_27315__$1){
var statearr_27474_27537 = state_27416__$1;
(statearr_27474_27537[(1)] = (16));

} else {
var statearr_27475_27538 = state_27416__$1;
(statearr_27475_27538[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (9))){
var inst_27345 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27476_27539 = state_27416__$1;
(statearr_27476_27539[(2)] = inst_27345);

(statearr_27476_27539[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (5))){
var inst_27291 = cljs.core.deref.call(null,cs);
var inst_27292 = cljs.core.seq.call(null,inst_27291);
var inst_27293 = inst_27292;
var inst_27294 = null;
var inst_27295 = (0);
var inst_27296 = (0);
var state_27416__$1 = (function (){var statearr_27477 = state_27416;
(statearr_27477[(13)] = inst_27295);

(statearr_27477[(14)] = inst_27293);

(statearr_27477[(15)] = inst_27294);

(statearr_27477[(17)] = inst_27296);

return statearr_27477;
})();
var statearr_27478_27540 = state_27416__$1;
(statearr_27478_27540[(2)] = null);

(statearr_27478_27540[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (14))){
var state_27416__$1 = state_27416;
var statearr_27479_27541 = state_27416__$1;
(statearr_27479_27541[(2)] = null);

(statearr_27479_27541[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (45))){
var inst_27406 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27480_27542 = state_27416__$1;
(statearr_27480_27542[(2)] = inst_27406);

(statearr_27480_27542[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (26))){
var inst_27348 = (state_27416[(29)]);
var inst_27402 = (state_27416[(2)]);
var inst_27403 = cljs.core.seq.call(null,inst_27348);
var state_27416__$1 = (function (){var statearr_27481 = state_27416;
(statearr_27481[(31)] = inst_27402);

return statearr_27481;
})();
if(inst_27403){
var statearr_27482_27543 = state_27416__$1;
(statearr_27482_27543[(1)] = (42));

} else {
var statearr_27483_27544 = state_27416__$1;
(statearr_27483_27544[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (16))){
var inst_27315 = (state_27416[(7)]);
var inst_27317 = cljs.core.chunked_seq_QMARK_.call(null,inst_27315);
var state_27416__$1 = state_27416;
if(inst_27317){
var statearr_27484_27545 = state_27416__$1;
(statearr_27484_27545[(1)] = (19));

} else {
var statearr_27485_27546 = state_27416__$1;
(statearr_27485_27546[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (38))){
var inst_27395 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27486_27547 = state_27416__$1;
(statearr_27486_27547[(2)] = inst_27395);

(statearr_27486_27547[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (30))){
var state_27416__$1 = state_27416;
var statearr_27487_27548 = state_27416__$1;
(statearr_27487_27548[(2)] = null);

(statearr_27487_27548[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (10))){
var inst_27294 = (state_27416[(15)]);
var inst_27296 = (state_27416[(17)]);
var inst_27304 = cljs.core._nth.call(null,inst_27294,inst_27296);
var inst_27305 = cljs.core.nth.call(null,inst_27304,(0),null);
var inst_27306 = cljs.core.nth.call(null,inst_27304,(1),null);
var state_27416__$1 = (function (){var statearr_27488 = state_27416;
(statearr_27488[(26)] = inst_27305);

return statearr_27488;
})();
if(cljs.core.truth_(inst_27306)){
var statearr_27489_27549 = state_27416__$1;
(statearr_27489_27549[(1)] = (13));

} else {
var statearr_27490_27550 = state_27416__$1;
(statearr_27490_27550[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (18))){
var inst_27341 = (state_27416[(2)]);
var state_27416__$1 = state_27416;
var statearr_27491_27551 = state_27416__$1;
(statearr_27491_27551[(2)] = inst_27341);

(statearr_27491_27551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (42))){
var state_27416__$1 = state_27416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27416__$1,(45),dchan);
} else {
if((state_val_27417 === (37))){
var inst_27384 = (state_27416[(23)]);
var inst_27375 = (state_27416[(25)]);
var inst_27284 = (state_27416[(10)]);
var inst_27384__$1 = cljs.core.first.call(null,inst_27375);
var inst_27385 = cljs.core.async.put_BANG_.call(null,inst_27384__$1,inst_27284,done);
var state_27416__$1 = (function (){var statearr_27492 = state_27416;
(statearr_27492[(23)] = inst_27384__$1);

return statearr_27492;
})();
if(cljs.core.truth_(inst_27385)){
var statearr_27493_27552 = state_27416__$1;
(statearr_27493_27552[(1)] = (39));

} else {
var statearr_27494_27553 = state_27416__$1;
(statearr_27494_27553[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27417 === (8))){
var inst_27295 = (state_27416[(13)]);
var inst_27296 = (state_27416[(17)]);
var inst_27298 = (inst_27296 < inst_27295);
var inst_27299 = inst_27298;
var state_27416__$1 = state_27416;
if(cljs.core.truth_(inst_27299)){
var statearr_27495_27554 = state_27416__$1;
(statearr_27495_27554[(1)] = (10));

} else {
var statearr_27496_27555 = state_27416__$1;
(statearr_27496_27555[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___27501,cs,m__$1,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___27501,cs,m__$1,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16184__auto__ = null;
var cljs$core$async$mult_$_state_machine__16184__auto____0 = (function (){
var statearr_27497 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27497[(0)] = cljs$core$async$mult_$_state_machine__16184__auto__);

(statearr_27497[(1)] = (1));

return statearr_27497;
});
var cljs$core$async$mult_$_state_machine__16184__auto____1 = (function (state_27416){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27498){if((e27498 instanceof Object)){
var ex__16187__auto__ = e27498;
var statearr_27499_27556 = state_27416;
(statearr_27499_27556[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27498;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27557 = state_27416;
state_27416 = G__27557;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16184__auto__ = function(state_27416){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16184__auto____1.call(this,state_27416);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16184__auto____0;
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16184__auto____1;
return cljs$core$async$mult_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27501,cs,m__$1,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_27500 = f__16274__auto__.call(null);
(statearr_27500[(6)] = c__16273__auto___27501);

return statearr_27500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27501,cs,m__$1,dchan,dctr,done))
);


return m__$1;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__27559 = arguments.length;
switch (G__27559) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$admix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m__$1);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m__$1);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m__$1);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m__$1,state_map){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2(m__$1,state_map);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,state_map);
} else {
var m__9122__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m__$1);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m__$1,mode){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m__$1,mode);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,mode);
} else {
var m__9122__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m__$1);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___27571 = arguments.length;
var i__9668__auto___27572 = (0);
while(true){
if((i__9668__auto___27572 < len__9667__auto___27571)){
args__9674__auto__.push((arguments[i__9668__auto___27572]));

var G__27573 = (i__9668__auto___27572 + (1));
i__9668__auto___27572 = G__27573;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((3) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9675__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__27565){
var map__27566 = p__27565;
var map__27566__$1 = ((((!((map__27566 == null)))?((((map__27566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27566):map__27566);
var opts = map__27566__$1;
var statearr_27568_27574 = state;
(statearr_27568_27574[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__27566,map__27566__$1,opts){
return (function (val){
var statearr_27569_27575 = state;
(statearr_27569_27575[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__27566,map__27566__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_27570_27576 = state;
(statearr_27570_27576[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq27561){
var G__27562 = cljs.core.first.call(null,seq27561);
var seq27561__$1 = cljs.core.next.call(null,seq27561);
var G__27563 = cljs.core.first.call(null,seq27561__$1);
var seq27561__$2 = cljs.core.next.call(null,seq27561__$1);
var G__27564 = cljs.core.first.call(null,seq27561__$2);
var seq27561__$3 = cljs.core.next.call(null,seq27561__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27562,G__27563,G__27564,seq27561__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async27577 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27577 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta27578){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta27578 = meta27578;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_27579,meta27578__$1){
var self__ = this;
var _27579__$1 = this;
return (new cljs.core.async.t_cljs$core$async27577(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta27578__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_27579){
var self__ = this;
var _27579__$1 = this;
return self__.meta27578;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta27578","meta27578",92363305,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async27577.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27577.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27577";

cljs.core.async.t_cljs$core$async27577.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async27577");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async27577 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async27577(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta27578){
return (new cljs.core.async.t_cljs$core$async27577(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta27578));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async27577(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___27741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (state_27681){
var state_val_27682 = (state_27681[(1)]);
if((state_val_27682 === (7))){
var inst_27596 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
var statearr_27683_27742 = state_27681__$1;
(statearr_27683_27742[(2)] = inst_27596);

(statearr_27683_27742[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (20))){
var inst_27608 = (state_27681[(7)]);
var state_27681__$1 = state_27681;
var statearr_27684_27743 = state_27681__$1;
(statearr_27684_27743[(2)] = inst_27608);

(statearr_27684_27743[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (27))){
var state_27681__$1 = state_27681;
var statearr_27685_27744 = state_27681__$1;
(statearr_27685_27744[(2)] = null);

(statearr_27685_27744[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (1))){
var inst_27583 = (state_27681[(8)]);
var inst_27583__$1 = calc_state.call(null);
var inst_27585 = (inst_27583__$1 == null);
var inst_27586 = cljs.core.not.call(null,inst_27585);
var state_27681__$1 = (function (){var statearr_27686 = state_27681;
(statearr_27686[(8)] = inst_27583__$1);

return statearr_27686;
})();
if(inst_27586){
var statearr_27687_27745 = state_27681__$1;
(statearr_27687_27745[(1)] = (2));

} else {
var statearr_27688_27746 = state_27681__$1;
(statearr_27688_27746[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (24))){
var inst_27632 = (state_27681[(9)]);
var inst_27655 = (state_27681[(10)]);
var inst_27641 = (state_27681[(11)]);
var inst_27655__$1 = inst_27632.call(null,inst_27641);
var state_27681__$1 = (function (){var statearr_27689 = state_27681;
(statearr_27689[(10)] = inst_27655__$1);

return statearr_27689;
})();
if(cljs.core.truth_(inst_27655__$1)){
var statearr_27690_27747 = state_27681__$1;
(statearr_27690_27747[(1)] = (29));

} else {
var statearr_27691_27748 = state_27681__$1;
(statearr_27691_27748[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (4))){
var inst_27599 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27599)){
var statearr_27692_27749 = state_27681__$1;
(statearr_27692_27749[(1)] = (8));

} else {
var statearr_27693_27750 = state_27681__$1;
(statearr_27693_27750[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (15))){
var inst_27626 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27626)){
var statearr_27694_27751 = state_27681__$1;
(statearr_27694_27751[(1)] = (19));

} else {
var statearr_27695_27752 = state_27681__$1;
(statearr_27695_27752[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (21))){
var inst_27631 = (state_27681[(12)]);
var inst_27631__$1 = (state_27681[(2)]);
var inst_27632 = cljs.core.get.call(null,inst_27631__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_27633 = cljs.core.get.call(null,inst_27631__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_27634 = cljs.core.get.call(null,inst_27631__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_27681__$1 = (function (){var statearr_27696 = state_27681;
(statearr_27696[(13)] = inst_27633);

(statearr_27696[(9)] = inst_27632);

(statearr_27696[(12)] = inst_27631__$1);

return statearr_27696;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_27681__$1,(22),inst_27634);
} else {
if((state_val_27682 === (31))){
var inst_27663 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27663)){
var statearr_27697_27753 = state_27681__$1;
(statearr_27697_27753[(1)] = (32));

} else {
var statearr_27698_27754 = state_27681__$1;
(statearr_27698_27754[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (32))){
var inst_27640 = (state_27681[(14)]);
var state_27681__$1 = state_27681;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27681__$1,(35),out,inst_27640);
} else {
if((state_val_27682 === (33))){
var inst_27631 = (state_27681[(12)]);
var inst_27608 = inst_27631;
var state_27681__$1 = (function (){var statearr_27699 = state_27681;
(statearr_27699[(7)] = inst_27608);

return statearr_27699;
})();
var statearr_27700_27755 = state_27681__$1;
(statearr_27700_27755[(2)] = null);

(statearr_27700_27755[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (13))){
var inst_27608 = (state_27681[(7)]);
var inst_27615 = inst_27608.cljs$lang$protocol_mask$partition0$;
var inst_27616 = (inst_27615 & (64));
var inst_27617 = inst_27608.cljs$core$ISeq$;
var inst_27618 = (cljs.core.PROTOCOL_SENTINEL === inst_27617);
var inst_27619 = (inst_27616) || (inst_27618);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27619)){
var statearr_27701_27756 = state_27681__$1;
(statearr_27701_27756[(1)] = (16));

} else {
var statearr_27702_27757 = state_27681__$1;
(statearr_27702_27757[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (22))){
var inst_27640 = (state_27681[(14)]);
var inst_27641 = (state_27681[(11)]);
var inst_27639 = (state_27681[(2)]);
var inst_27640__$1 = cljs.core.nth.call(null,inst_27639,(0),null);
var inst_27641__$1 = cljs.core.nth.call(null,inst_27639,(1),null);
var inst_27642 = (inst_27640__$1 == null);
var inst_27643 = cljs.core._EQ_.call(null,inst_27641__$1,change);
var inst_27644 = (inst_27642) || (inst_27643);
var state_27681__$1 = (function (){var statearr_27703 = state_27681;
(statearr_27703[(14)] = inst_27640__$1);

(statearr_27703[(11)] = inst_27641__$1);

return statearr_27703;
})();
if(cljs.core.truth_(inst_27644)){
var statearr_27704_27758 = state_27681__$1;
(statearr_27704_27758[(1)] = (23));

} else {
var statearr_27705_27759 = state_27681__$1;
(statearr_27705_27759[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (36))){
var inst_27631 = (state_27681[(12)]);
var inst_27608 = inst_27631;
var state_27681__$1 = (function (){var statearr_27706 = state_27681;
(statearr_27706[(7)] = inst_27608);

return statearr_27706;
})();
var statearr_27707_27760 = state_27681__$1;
(statearr_27707_27760[(2)] = null);

(statearr_27707_27760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (29))){
var inst_27655 = (state_27681[(10)]);
var state_27681__$1 = state_27681;
var statearr_27708_27761 = state_27681__$1;
(statearr_27708_27761[(2)] = inst_27655);

(statearr_27708_27761[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (6))){
var state_27681__$1 = state_27681;
var statearr_27709_27762 = state_27681__$1;
(statearr_27709_27762[(2)] = false);

(statearr_27709_27762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (28))){
var inst_27651 = (state_27681[(2)]);
var inst_27652 = calc_state.call(null);
var inst_27608 = inst_27652;
var state_27681__$1 = (function (){var statearr_27710 = state_27681;
(statearr_27710[(7)] = inst_27608);

(statearr_27710[(15)] = inst_27651);

return statearr_27710;
})();
var statearr_27711_27763 = state_27681__$1;
(statearr_27711_27763[(2)] = null);

(statearr_27711_27763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (25))){
var inst_27677 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
var statearr_27712_27764 = state_27681__$1;
(statearr_27712_27764[(2)] = inst_27677);

(statearr_27712_27764[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (34))){
var inst_27675 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
var statearr_27713_27765 = state_27681__$1;
(statearr_27713_27765[(2)] = inst_27675);

(statearr_27713_27765[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (17))){
var state_27681__$1 = state_27681;
var statearr_27714_27766 = state_27681__$1;
(statearr_27714_27766[(2)] = false);

(statearr_27714_27766[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (3))){
var state_27681__$1 = state_27681;
var statearr_27715_27767 = state_27681__$1;
(statearr_27715_27767[(2)] = false);

(statearr_27715_27767[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (12))){
var inst_27679 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27681__$1,inst_27679);
} else {
if((state_val_27682 === (2))){
var inst_27583 = (state_27681[(8)]);
var inst_27588 = inst_27583.cljs$lang$protocol_mask$partition0$;
var inst_27589 = (inst_27588 & (64));
var inst_27590 = inst_27583.cljs$core$ISeq$;
var inst_27591 = (cljs.core.PROTOCOL_SENTINEL === inst_27590);
var inst_27592 = (inst_27589) || (inst_27591);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27592)){
var statearr_27716_27768 = state_27681__$1;
(statearr_27716_27768[(1)] = (5));

} else {
var statearr_27717_27769 = state_27681__$1;
(statearr_27717_27769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (23))){
var inst_27640 = (state_27681[(14)]);
var inst_27646 = (inst_27640 == null);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27646)){
var statearr_27718_27770 = state_27681__$1;
(statearr_27718_27770[(1)] = (26));

} else {
var statearr_27719_27771 = state_27681__$1;
(statearr_27719_27771[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (35))){
var inst_27666 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
if(cljs.core.truth_(inst_27666)){
var statearr_27720_27772 = state_27681__$1;
(statearr_27720_27772[(1)] = (36));

} else {
var statearr_27721_27773 = state_27681__$1;
(statearr_27721_27773[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (19))){
var inst_27608 = (state_27681[(7)]);
var inst_27628 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27608);
var state_27681__$1 = state_27681;
var statearr_27722_27774 = state_27681__$1;
(statearr_27722_27774[(2)] = inst_27628);

(statearr_27722_27774[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (11))){
var inst_27608 = (state_27681[(7)]);
var inst_27612 = (inst_27608 == null);
var inst_27613 = cljs.core.not.call(null,inst_27612);
var state_27681__$1 = state_27681;
if(inst_27613){
var statearr_27723_27775 = state_27681__$1;
(statearr_27723_27775[(1)] = (13));

} else {
var statearr_27724_27776 = state_27681__$1;
(statearr_27724_27776[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (9))){
var inst_27583 = (state_27681[(8)]);
var state_27681__$1 = state_27681;
var statearr_27725_27777 = state_27681__$1;
(statearr_27725_27777[(2)] = inst_27583);

(statearr_27725_27777[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (5))){
var state_27681__$1 = state_27681;
var statearr_27726_27778 = state_27681__$1;
(statearr_27726_27778[(2)] = true);

(statearr_27726_27778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (14))){
var state_27681__$1 = state_27681;
var statearr_27727_27779 = state_27681__$1;
(statearr_27727_27779[(2)] = false);

(statearr_27727_27779[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (26))){
var inst_27641 = (state_27681[(11)]);
var inst_27648 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_27641);
var state_27681__$1 = state_27681;
var statearr_27728_27780 = state_27681__$1;
(statearr_27728_27780[(2)] = inst_27648);

(statearr_27728_27780[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (16))){
var state_27681__$1 = state_27681;
var statearr_27729_27781 = state_27681__$1;
(statearr_27729_27781[(2)] = true);

(statearr_27729_27781[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (38))){
var inst_27671 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
var statearr_27730_27782 = state_27681__$1;
(statearr_27730_27782[(2)] = inst_27671);

(statearr_27730_27782[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (30))){
var inst_27633 = (state_27681[(13)]);
var inst_27632 = (state_27681[(9)]);
var inst_27641 = (state_27681[(11)]);
var inst_27658 = cljs.core.empty_QMARK_.call(null,inst_27632);
var inst_27659 = inst_27633.call(null,inst_27641);
var inst_27660 = cljs.core.not.call(null,inst_27659);
var inst_27661 = (inst_27658) && (inst_27660);
var state_27681__$1 = state_27681;
var statearr_27731_27783 = state_27681__$1;
(statearr_27731_27783[(2)] = inst_27661);

(statearr_27731_27783[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (10))){
var inst_27583 = (state_27681[(8)]);
var inst_27604 = (state_27681[(2)]);
var inst_27605 = cljs.core.get.call(null,inst_27604,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_27606 = cljs.core.get.call(null,inst_27604,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_27607 = cljs.core.get.call(null,inst_27604,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_27608 = inst_27583;
var state_27681__$1 = (function (){var statearr_27732 = state_27681;
(statearr_27732[(7)] = inst_27608);

(statearr_27732[(16)] = inst_27607);

(statearr_27732[(17)] = inst_27605);

(statearr_27732[(18)] = inst_27606);

return statearr_27732;
})();
var statearr_27733_27784 = state_27681__$1;
(statearr_27733_27784[(2)] = null);

(statearr_27733_27784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (18))){
var inst_27623 = (state_27681[(2)]);
var state_27681__$1 = state_27681;
var statearr_27734_27785 = state_27681__$1;
(statearr_27734_27785[(2)] = inst_27623);

(statearr_27734_27785[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (37))){
var state_27681__$1 = state_27681;
var statearr_27735_27786 = state_27681__$1;
(statearr_27735_27786[(2)] = null);

(statearr_27735_27786[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27682 === (8))){
var inst_27583 = (state_27681[(8)]);
var inst_27601 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27583);
var state_27681__$1 = state_27681;
var statearr_27736_27787 = state_27681__$1;
(statearr_27736_27787[(2)] = inst_27601);

(statearr_27736_27787[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
;
return ((function (switch__16183__auto__,c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function() {
var cljs$core$async$mix_$_state_machine__16184__auto__ = null;
var cljs$core$async$mix_$_state_machine__16184__auto____0 = (function (){
var statearr_27737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27737[(0)] = cljs$core$async$mix_$_state_machine__16184__auto__);

(statearr_27737[(1)] = (1));

return statearr_27737;
});
var cljs$core$async$mix_$_state_machine__16184__auto____1 = (function (state_27681){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27738){if((e27738 instanceof Object)){
var ex__16187__auto__ = e27738;
var statearr_27739_27788 = state_27681;
(statearr_27739_27788[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27681);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27738;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27789 = state_27681;
state_27681 = G__27789;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16184__auto__ = function(state_27681){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16184__auto____1.call(this,state_27681);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16184__auto____0;
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16184__auto____1;
return cljs$core$async$mix_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
})();
var state__16275__auto__ = (function (){var statearr_27740 = f__16274__auto__.call(null);
(statearr_27740[(6)] = c__16273__auto___27741);

return statearr_27740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27741,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
);


return m__$1;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__27791 = arguments.length;
switch (G__27791) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__27795 = arguments.length;
switch (G__27795) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8388__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8388__auto__,mults){
return (function (p1__27793_SHARP_){
if(cljs.core.truth_(p1__27793_SHARP_.call(null,topic))){
return p1__27793_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__27793_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8388__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async27796 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27796 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta27797){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta27797 = meta27797;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_27798,meta27797__$1){
var self__ = this;
var _27798__$1 = this;
return (new cljs.core.async.t_cljs$core$async27796(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta27797__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_27798){
var self__ = this;
var _27798__$1 = this;
return self__.meta27797;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m__$1 = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m__$1,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m__$1 = temp__5457__auto__;
return cljs.core.async.untap.call(null,m__$1,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta27797","meta27797",1434973511,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async27796.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async27796.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27796";

cljs.core.async.t_cljs$core$async27796.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async27796");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async27796 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async27796(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27797){
return (new cljs.core.async.t_cljs$core$async27796(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27797));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async27796(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___27916 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___27916,mults,ensure_mult,p){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___27916,mults,ensure_mult,p){
return (function (state_27870){
var state_val_27871 = (state_27870[(1)]);
if((state_val_27871 === (7))){
var inst_27866 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27872_27917 = state_27870__$1;
(statearr_27872_27917[(2)] = inst_27866);

(statearr_27872_27917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (20))){
var state_27870__$1 = state_27870;
var statearr_27873_27918 = state_27870__$1;
(statearr_27873_27918[(2)] = null);

(statearr_27873_27918[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (1))){
var state_27870__$1 = state_27870;
var statearr_27874_27919 = state_27870__$1;
(statearr_27874_27919[(2)] = null);

(statearr_27874_27919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (24))){
var inst_27849 = (state_27870[(7)]);
var inst_27858 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_27849);
var state_27870__$1 = state_27870;
var statearr_27875_27920 = state_27870__$1;
(statearr_27875_27920[(2)] = inst_27858);

(statearr_27875_27920[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (4))){
var inst_27801 = (state_27870[(8)]);
var inst_27801__$1 = (state_27870[(2)]);
var inst_27802 = (inst_27801__$1 == null);
var state_27870__$1 = (function (){var statearr_27876 = state_27870;
(statearr_27876[(8)] = inst_27801__$1);

return statearr_27876;
})();
if(cljs.core.truth_(inst_27802)){
var statearr_27877_27921 = state_27870__$1;
(statearr_27877_27921[(1)] = (5));

} else {
var statearr_27878_27922 = state_27870__$1;
(statearr_27878_27922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (15))){
var inst_27843 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27879_27923 = state_27870__$1;
(statearr_27879_27923[(2)] = inst_27843);

(statearr_27879_27923[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (21))){
var inst_27863 = (state_27870[(2)]);
var state_27870__$1 = (function (){var statearr_27880 = state_27870;
(statearr_27880[(9)] = inst_27863);

return statearr_27880;
})();
var statearr_27881_27924 = state_27870__$1;
(statearr_27881_27924[(2)] = null);

(statearr_27881_27924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (13))){
var inst_27825 = (state_27870[(10)]);
var inst_27827 = cljs.core.chunked_seq_QMARK_.call(null,inst_27825);
var state_27870__$1 = state_27870;
if(inst_27827){
var statearr_27882_27925 = state_27870__$1;
(statearr_27882_27925[(1)] = (16));

} else {
var statearr_27883_27926 = state_27870__$1;
(statearr_27883_27926[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (22))){
var inst_27855 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
if(cljs.core.truth_(inst_27855)){
var statearr_27884_27927 = state_27870__$1;
(statearr_27884_27927[(1)] = (23));

} else {
var statearr_27885_27928 = state_27870__$1;
(statearr_27885_27928[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (6))){
var inst_27849 = (state_27870[(7)]);
var inst_27851 = (state_27870[(11)]);
var inst_27801 = (state_27870[(8)]);
var inst_27849__$1 = topic_fn.call(null,inst_27801);
var inst_27850 = cljs.core.deref.call(null,mults);
var inst_27851__$1 = cljs.core.get.call(null,inst_27850,inst_27849__$1);
var state_27870__$1 = (function (){var statearr_27886 = state_27870;
(statearr_27886[(7)] = inst_27849__$1);

(statearr_27886[(11)] = inst_27851__$1);

return statearr_27886;
})();
if(cljs.core.truth_(inst_27851__$1)){
var statearr_27887_27929 = state_27870__$1;
(statearr_27887_27929[(1)] = (19));

} else {
var statearr_27888_27930 = state_27870__$1;
(statearr_27888_27930[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (25))){
var inst_27860 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27889_27931 = state_27870__$1;
(statearr_27889_27931[(2)] = inst_27860);

(statearr_27889_27931[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (17))){
var inst_27825 = (state_27870[(10)]);
var inst_27834 = cljs.core.first.call(null,inst_27825);
var inst_27835 = cljs.core.async.muxch_STAR_.call(null,inst_27834);
var inst_27836 = cljs.core.async.close_BANG_.call(null,inst_27835);
var inst_27837 = cljs.core.next.call(null,inst_27825);
var inst_27811 = inst_27837;
var inst_27812 = null;
var inst_27813 = (0);
var inst_27814 = (0);
var state_27870__$1 = (function (){var statearr_27890 = state_27870;
(statearr_27890[(12)] = inst_27811);

(statearr_27890[(13)] = inst_27836);

(statearr_27890[(14)] = inst_27813);

(statearr_27890[(15)] = inst_27812);

(statearr_27890[(16)] = inst_27814);

return statearr_27890;
})();
var statearr_27891_27932 = state_27870__$1;
(statearr_27891_27932[(2)] = null);

(statearr_27891_27932[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (3))){
var inst_27868 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27870__$1,inst_27868);
} else {
if((state_val_27871 === (12))){
var inst_27845 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27892_27933 = state_27870__$1;
(statearr_27892_27933[(2)] = inst_27845);

(statearr_27892_27933[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (2))){
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27870__$1,(4),ch);
} else {
if((state_val_27871 === (23))){
var state_27870__$1 = state_27870;
var statearr_27893_27934 = state_27870__$1;
(statearr_27893_27934[(2)] = null);

(statearr_27893_27934[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (19))){
var inst_27851 = (state_27870[(11)]);
var inst_27801 = (state_27870[(8)]);
var inst_27853 = cljs.core.async.muxch_STAR_.call(null,inst_27851);
var state_27870__$1 = state_27870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27870__$1,(22),inst_27853,inst_27801);
} else {
if((state_val_27871 === (11))){
var inst_27811 = (state_27870[(12)]);
var inst_27825 = (state_27870[(10)]);
var inst_27825__$1 = cljs.core.seq.call(null,inst_27811);
var state_27870__$1 = (function (){var statearr_27894 = state_27870;
(statearr_27894[(10)] = inst_27825__$1);

return statearr_27894;
})();
if(inst_27825__$1){
var statearr_27895_27935 = state_27870__$1;
(statearr_27895_27935[(1)] = (13));

} else {
var statearr_27896_27936 = state_27870__$1;
(statearr_27896_27936[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (9))){
var inst_27847 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27897_27937 = state_27870__$1;
(statearr_27897_27937[(2)] = inst_27847);

(statearr_27897_27937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (5))){
var inst_27808 = cljs.core.deref.call(null,mults);
var inst_27809 = cljs.core.vals.call(null,inst_27808);
var inst_27810 = cljs.core.seq.call(null,inst_27809);
var inst_27811 = inst_27810;
var inst_27812 = null;
var inst_27813 = (0);
var inst_27814 = (0);
var state_27870__$1 = (function (){var statearr_27898 = state_27870;
(statearr_27898[(12)] = inst_27811);

(statearr_27898[(14)] = inst_27813);

(statearr_27898[(15)] = inst_27812);

(statearr_27898[(16)] = inst_27814);

return statearr_27898;
})();
var statearr_27899_27938 = state_27870__$1;
(statearr_27899_27938[(2)] = null);

(statearr_27899_27938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (14))){
var state_27870__$1 = state_27870;
var statearr_27903_27939 = state_27870__$1;
(statearr_27903_27939[(2)] = null);

(statearr_27903_27939[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (16))){
var inst_27825 = (state_27870[(10)]);
var inst_27829 = cljs.core.chunk_first.call(null,inst_27825);
var inst_27830 = cljs.core.chunk_rest.call(null,inst_27825);
var inst_27831 = cljs.core.count.call(null,inst_27829);
var inst_27811 = inst_27830;
var inst_27812 = inst_27829;
var inst_27813 = inst_27831;
var inst_27814 = (0);
var state_27870__$1 = (function (){var statearr_27904 = state_27870;
(statearr_27904[(12)] = inst_27811);

(statearr_27904[(14)] = inst_27813);

(statearr_27904[(15)] = inst_27812);

(statearr_27904[(16)] = inst_27814);

return statearr_27904;
})();
var statearr_27905_27940 = state_27870__$1;
(statearr_27905_27940[(2)] = null);

(statearr_27905_27940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (10))){
var inst_27811 = (state_27870[(12)]);
var inst_27813 = (state_27870[(14)]);
var inst_27812 = (state_27870[(15)]);
var inst_27814 = (state_27870[(16)]);
var inst_27819 = cljs.core._nth.call(null,inst_27812,inst_27814);
var inst_27820 = cljs.core.async.muxch_STAR_.call(null,inst_27819);
var inst_27821 = cljs.core.async.close_BANG_.call(null,inst_27820);
var inst_27822 = (inst_27814 + (1));
var tmp27900 = inst_27811;
var tmp27901 = inst_27813;
var tmp27902 = inst_27812;
var inst_27811__$1 = tmp27900;
var inst_27812__$1 = tmp27902;
var inst_27813__$1 = tmp27901;
var inst_27814__$1 = inst_27822;
var state_27870__$1 = (function (){var statearr_27906 = state_27870;
(statearr_27906[(12)] = inst_27811__$1);

(statearr_27906[(14)] = inst_27813__$1);

(statearr_27906[(17)] = inst_27821);

(statearr_27906[(15)] = inst_27812__$1);

(statearr_27906[(16)] = inst_27814__$1);

return statearr_27906;
})();
var statearr_27907_27941 = state_27870__$1;
(statearr_27907_27941[(2)] = null);

(statearr_27907_27941[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (18))){
var inst_27840 = (state_27870[(2)]);
var state_27870__$1 = state_27870;
var statearr_27908_27942 = state_27870__$1;
(statearr_27908_27942[(2)] = inst_27840);

(statearr_27908_27942[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27871 === (8))){
var inst_27813 = (state_27870[(14)]);
var inst_27814 = (state_27870[(16)]);
var inst_27816 = (inst_27814 < inst_27813);
var inst_27817 = inst_27816;
var state_27870__$1 = state_27870;
if(cljs.core.truth_(inst_27817)){
var statearr_27909_27943 = state_27870__$1;
(statearr_27909_27943[(1)] = (10));

} else {
var statearr_27910_27944 = state_27870__$1;
(statearr_27910_27944[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___27916,mults,ensure_mult,p))
;
return ((function (switch__16183__auto__,c__16273__auto___27916,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_27911 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27911[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_27911[(1)] = (1));

return statearr_27911;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_27870){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e27912){if((e27912 instanceof Object)){
var ex__16187__auto__ = e27912;
var statearr_27913_27945 = state_27870;
(statearr_27913_27945[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27912;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27946 = state_27870;
state_27870 = G__27946;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_27870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_27870);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___27916,mults,ensure_mult,p))
})();
var state__16275__auto__ = (function (){var statearr_27914 = f__16274__auto__.call(null);
(statearr_27914[(6)] = c__16273__auto___27916);

return statearr_27914;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___27916,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__27948 = arguments.length;
switch (G__27948) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__27951 = arguments.length;
switch (G__27951) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__27954 = arguments.length;
switch (G__27954) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16273__auto___28021 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_27993){
var state_val_27994 = (state_27993[(1)]);
if((state_val_27994 === (7))){
var state_27993__$1 = state_27993;
var statearr_27995_28022 = state_27993__$1;
(statearr_27995_28022[(2)] = null);

(statearr_27995_28022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (1))){
var state_27993__$1 = state_27993;
var statearr_27996_28023 = state_27993__$1;
(statearr_27996_28023[(2)] = null);

(statearr_27996_28023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (4))){
var inst_27957 = (state_27993[(7)]);
var inst_27959 = (inst_27957 < cnt);
var state_27993__$1 = state_27993;
if(cljs.core.truth_(inst_27959)){
var statearr_27997_28024 = state_27993__$1;
(statearr_27997_28024[(1)] = (6));

} else {
var statearr_27998_28025 = state_27993__$1;
(statearr_27998_28025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (15))){
var inst_27989 = (state_27993[(2)]);
var state_27993__$1 = state_27993;
var statearr_27999_28026 = state_27993__$1;
(statearr_27999_28026[(2)] = inst_27989);

(statearr_27999_28026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (13))){
var inst_27982 = cljs.core.async.close_BANG_.call(null,out);
var state_27993__$1 = state_27993;
var statearr_28000_28027 = state_27993__$1;
(statearr_28000_28027[(2)] = inst_27982);

(statearr_28000_28027[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (6))){
var state_27993__$1 = state_27993;
var statearr_28001_28028 = state_27993__$1;
(statearr_28001_28028[(2)] = null);

(statearr_28001_28028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (3))){
var inst_27991 = (state_27993[(2)]);
var state_27993__$1 = state_27993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27993__$1,inst_27991);
} else {
if((state_val_27994 === (12))){
var inst_27979 = (state_27993[(8)]);
var inst_27979__$1 = (state_27993[(2)]);
var inst_27980 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_27979__$1);
var state_27993__$1 = (function (){var statearr_28002 = state_27993;
(statearr_28002[(8)] = inst_27979__$1);

return statearr_28002;
})();
if(cljs.core.truth_(inst_27980)){
var statearr_28003_28029 = state_27993__$1;
(statearr_28003_28029[(1)] = (13));

} else {
var statearr_28004_28030 = state_27993__$1;
(statearr_28004_28030[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (2))){
var inst_27956 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_27957 = (0);
var state_27993__$1 = (function (){var statearr_28005 = state_27993;
(statearr_28005[(9)] = inst_27956);

(statearr_28005[(7)] = inst_27957);

return statearr_28005;
})();
var statearr_28006_28031 = state_27993__$1;
(statearr_28006_28031[(2)] = null);

(statearr_28006_28031[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (11))){
var inst_27957 = (state_27993[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_27993,(10),Object,null,(9));
var inst_27966 = chs__$1.call(null,inst_27957);
var inst_27967 = done.call(null,inst_27957);
var inst_27968 = cljs.core.async.take_BANG_.call(null,inst_27966,inst_27967);
var state_27993__$1 = state_27993;
var statearr_28007_28032 = state_27993__$1;
(statearr_28007_28032[(2)] = inst_27968);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27993__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (9))){
var inst_27957 = (state_27993[(7)]);
var inst_27970 = (state_27993[(2)]);
var inst_27971 = (inst_27957 + (1));
var inst_27957__$1 = inst_27971;
var state_27993__$1 = (function (){var statearr_28008 = state_27993;
(statearr_28008[(7)] = inst_27957__$1);

(statearr_28008[(10)] = inst_27970);

return statearr_28008;
})();
var statearr_28009_28033 = state_27993__$1;
(statearr_28009_28033[(2)] = null);

(statearr_28009_28033[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (5))){
var inst_27977 = (state_27993[(2)]);
var state_27993__$1 = (function (){var statearr_28010 = state_27993;
(statearr_28010[(11)] = inst_27977);

return statearr_28010;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27993__$1,(12),dchan);
} else {
if((state_val_27994 === (14))){
var inst_27979 = (state_27993[(8)]);
var inst_27984 = cljs.core.apply.call(null,f,inst_27979);
var state_27993__$1 = state_27993;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27993__$1,(16),out,inst_27984);
} else {
if((state_val_27994 === (16))){
var inst_27986 = (state_27993[(2)]);
var state_27993__$1 = (function (){var statearr_28011 = state_27993;
(statearr_28011[(12)] = inst_27986);

return statearr_28011;
})();
var statearr_28012_28034 = state_27993__$1;
(statearr_28012_28034[(2)] = null);

(statearr_28012_28034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (10))){
var inst_27961 = (state_27993[(2)]);
var inst_27962 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_27993__$1 = (function (){var statearr_28013 = state_27993;
(statearr_28013[(13)] = inst_27961);

return statearr_28013;
})();
var statearr_28014_28035 = state_27993__$1;
(statearr_28014_28035[(2)] = inst_27962);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27993__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27994 === (8))){
var inst_27975 = (state_27993[(2)]);
var state_27993__$1 = state_27993;
var statearr_28015_28036 = state_27993__$1;
(statearr_28015_28036[(2)] = inst_27975);

(statearr_28015_28036[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28016 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28016[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28016[(1)] = (1));

return statearr_28016;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_27993){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_27993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28017){if((e28017 instanceof Object)){
var ex__16187__auto__ = e28017;
var statearr_28018_28037 = state_27993;
(statearr_28018_28037[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27993);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28017;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28038 = state_27993;
state_27993 = G__28038;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_27993){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_27993);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_28019 = f__16274__auto__.call(null);
(statearr_28019[(6)] = c__16273__auto___28021);

return statearr_28019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28021,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__28041 = arguments.length;
switch (G__28041) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28095 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28095,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28095,out){
return (function (state_28073){
var state_val_28074 = (state_28073[(1)]);
if((state_val_28074 === (7))){
var inst_28053 = (state_28073[(7)]);
var inst_28052 = (state_28073[(8)]);
var inst_28052__$1 = (state_28073[(2)]);
var inst_28053__$1 = cljs.core.nth.call(null,inst_28052__$1,(0),null);
var inst_28054 = cljs.core.nth.call(null,inst_28052__$1,(1),null);
var inst_28055 = (inst_28053__$1 == null);
var state_28073__$1 = (function (){var statearr_28075 = state_28073;
(statearr_28075[(7)] = inst_28053__$1);

(statearr_28075[(9)] = inst_28054);

(statearr_28075[(8)] = inst_28052__$1);

return statearr_28075;
})();
if(cljs.core.truth_(inst_28055)){
var statearr_28076_28096 = state_28073__$1;
(statearr_28076_28096[(1)] = (8));

} else {
var statearr_28077_28097 = state_28073__$1;
(statearr_28077_28097[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (1))){
var inst_28042 = cljs.core.vec.call(null,chs);
var inst_28043 = inst_28042;
var state_28073__$1 = (function (){var statearr_28078 = state_28073;
(statearr_28078[(10)] = inst_28043);

return statearr_28078;
})();
var statearr_28079_28098 = state_28073__$1;
(statearr_28079_28098[(2)] = null);

(statearr_28079_28098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (4))){
var inst_28043 = (state_28073[(10)]);
var state_28073__$1 = state_28073;
return cljs.core.async.ioc_alts_BANG_.call(null,state_28073__$1,(7),inst_28043);
} else {
if((state_val_28074 === (6))){
var inst_28069 = (state_28073[(2)]);
var state_28073__$1 = state_28073;
var statearr_28080_28099 = state_28073__$1;
(statearr_28080_28099[(2)] = inst_28069);

(statearr_28080_28099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (3))){
var inst_28071 = (state_28073[(2)]);
var state_28073__$1 = state_28073;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28073__$1,inst_28071);
} else {
if((state_val_28074 === (2))){
var inst_28043 = (state_28073[(10)]);
var inst_28045 = cljs.core.count.call(null,inst_28043);
var inst_28046 = (inst_28045 > (0));
var state_28073__$1 = state_28073;
if(cljs.core.truth_(inst_28046)){
var statearr_28082_28100 = state_28073__$1;
(statearr_28082_28100[(1)] = (4));

} else {
var statearr_28083_28101 = state_28073__$1;
(statearr_28083_28101[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (11))){
var inst_28043 = (state_28073[(10)]);
var inst_28062 = (state_28073[(2)]);
var tmp28081 = inst_28043;
var inst_28043__$1 = tmp28081;
var state_28073__$1 = (function (){var statearr_28084 = state_28073;
(statearr_28084[(10)] = inst_28043__$1);

(statearr_28084[(11)] = inst_28062);

return statearr_28084;
})();
var statearr_28085_28102 = state_28073__$1;
(statearr_28085_28102[(2)] = null);

(statearr_28085_28102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (9))){
var inst_28053 = (state_28073[(7)]);
var state_28073__$1 = state_28073;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28073__$1,(11),out,inst_28053);
} else {
if((state_val_28074 === (5))){
var inst_28067 = cljs.core.async.close_BANG_.call(null,out);
var state_28073__$1 = state_28073;
var statearr_28086_28103 = state_28073__$1;
(statearr_28086_28103[(2)] = inst_28067);

(statearr_28086_28103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (10))){
var inst_28065 = (state_28073[(2)]);
var state_28073__$1 = state_28073;
var statearr_28087_28104 = state_28073__$1;
(statearr_28087_28104[(2)] = inst_28065);

(statearr_28087_28104[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28074 === (8))){
var inst_28053 = (state_28073[(7)]);
var inst_28054 = (state_28073[(9)]);
var inst_28052 = (state_28073[(8)]);
var inst_28043 = (state_28073[(10)]);
var inst_28057 = (function (){var cs = inst_28043;
var vec__28048 = inst_28052;
var v = inst_28053;
var c = inst_28054;
return ((function (cs,vec__28048,v,c,inst_28053,inst_28054,inst_28052,inst_28043,state_val_28074,c__16273__auto___28095,out){
return (function (p1__28039_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__28039_SHARP_);
});
;})(cs,vec__28048,v,c,inst_28053,inst_28054,inst_28052,inst_28043,state_val_28074,c__16273__auto___28095,out))
})();
var inst_28058 = cljs.core.filterv.call(null,inst_28057,inst_28043);
var inst_28043__$1 = inst_28058;
var state_28073__$1 = (function (){var statearr_28088 = state_28073;
(statearr_28088[(10)] = inst_28043__$1);

return statearr_28088;
})();
var statearr_28089_28105 = state_28073__$1;
(statearr_28089_28105[(2)] = null);

(statearr_28089_28105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28095,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28095,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28090 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28090[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28090[(1)] = (1));

return statearr_28090;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28073){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28091){if((e28091 instanceof Object)){
var ex__16187__auto__ = e28091;
var statearr_28092_28106 = state_28073;
(statearr_28092_28106[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28091;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28107 = state_28073;
state_28073 = G__28107;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28073){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28073);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28095,out))
})();
var state__16275__auto__ = (function (){var statearr_28093 = f__16274__auto__.call(null);
(statearr_28093[(6)] = c__16273__auto___28095);

return statearr_28093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28095,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__28109 = arguments.length;
switch (G__28109) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28154 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28154,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28154,out){
return (function (state_28133){
var state_val_28134 = (state_28133[(1)]);
if((state_val_28134 === (7))){
var inst_28115 = (state_28133[(7)]);
var inst_28115__$1 = (state_28133[(2)]);
var inst_28116 = (inst_28115__$1 == null);
var inst_28117 = cljs.core.not.call(null,inst_28116);
var state_28133__$1 = (function (){var statearr_28135 = state_28133;
(statearr_28135[(7)] = inst_28115__$1);

return statearr_28135;
})();
if(inst_28117){
var statearr_28136_28155 = state_28133__$1;
(statearr_28136_28155[(1)] = (8));

} else {
var statearr_28137_28156 = state_28133__$1;
(statearr_28137_28156[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (1))){
var inst_28110 = (0);
var state_28133__$1 = (function (){var statearr_28138 = state_28133;
(statearr_28138[(8)] = inst_28110);

return statearr_28138;
})();
var statearr_28139_28157 = state_28133__$1;
(statearr_28139_28157[(2)] = null);

(statearr_28139_28157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (4))){
var state_28133__$1 = state_28133;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28133__$1,(7),ch);
} else {
if((state_val_28134 === (6))){
var inst_28128 = (state_28133[(2)]);
var state_28133__$1 = state_28133;
var statearr_28140_28158 = state_28133__$1;
(statearr_28140_28158[(2)] = inst_28128);

(statearr_28140_28158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (3))){
var inst_28130 = (state_28133[(2)]);
var inst_28131 = cljs.core.async.close_BANG_.call(null,out);
var state_28133__$1 = (function (){var statearr_28141 = state_28133;
(statearr_28141[(9)] = inst_28130);

return statearr_28141;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28133__$1,inst_28131);
} else {
if((state_val_28134 === (2))){
var inst_28110 = (state_28133[(8)]);
var inst_28112 = (inst_28110 < n);
var state_28133__$1 = state_28133;
if(cljs.core.truth_(inst_28112)){
var statearr_28142_28159 = state_28133__$1;
(statearr_28142_28159[(1)] = (4));

} else {
var statearr_28143_28160 = state_28133__$1;
(statearr_28143_28160[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (11))){
var inst_28110 = (state_28133[(8)]);
var inst_28120 = (state_28133[(2)]);
var inst_28121 = (inst_28110 + (1));
var inst_28110__$1 = inst_28121;
var state_28133__$1 = (function (){var statearr_28144 = state_28133;
(statearr_28144[(10)] = inst_28120);

(statearr_28144[(8)] = inst_28110__$1);

return statearr_28144;
})();
var statearr_28145_28161 = state_28133__$1;
(statearr_28145_28161[(2)] = null);

(statearr_28145_28161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (9))){
var state_28133__$1 = state_28133;
var statearr_28146_28162 = state_28133__$1;
(statearr_28146_28162[(2)] = null);

(statearr_28146_28162[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (5))){
var state_28133__$1 = state_28133;
var statearr_28147_28163 = state_28133__$1;
(statearr_28147_28163[(2)] = null);

(statearr_28147_28163[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (10))){
var inst_28125 = (state_28133[(2)]);
var state_28133__$1 = state_28133;
var statearr_28148_28164 = state_28133__$1;
(statearr_28148_28164[(2)] = inst_28125);

(statearr_28148_28164[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28134 === (8))){
var inst_28115 = (state_28133[(7)]);
var state_28133__$1 = state_28133;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28133__$1,(11),out,inst_28115);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28154,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28154,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28149 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28149[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28149[(1)] = (1));

return statearr_28149;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28133){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28133);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28150){if((e28150 instanceof Object)){
var ex__16187__auto__ = e28150;
var statearr_28151_28165 = state_28133;
(statearr_28151_28165[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28133);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28150;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28166 = state_28133;
state_28133 = G__28166;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28133){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28133);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28154,out))
})();
var state__16275__auto__ = (function (){var statearr_28152 = f__16274__auto__.call(null);
(statearr_28152[(6)] = c__16273__auto___28154);

return statearr_28152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28154,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28168 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28168 = (function (f,ch,meta28169){
this.f = f;
this.ch = ch;
this.meta28169 = meta28169;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28170,meta28169__$1){
var self__ = this;
var _28170__$1 = this;
return (new cljs.core.async.t_cljs$core$async28168(self__.f,self__.ch,meta28169__$1));
});

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28170){
var self__ = this;
var _28170__$1 = this;
return self__.meta28169;
});

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async28171 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28171 = (function (f,ch,meta28169,_,fn1,meta28172){
this.f = f;
this.ch = ch;
this.meta28169 = meta28169;
this._ = _;
this.fn1 = fn1;
this.meta28172 = meta28172;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_28173,meta28172__$1){
var self__ = this;
var _28173__$1 = this;
return (new cljs.core.async.t_cljs$core$async28171(self__.f,self__.ch,self__.meta28169,self__._,self__.fn1,meta28172__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_28173){
var self__ = this;
var _28173__$1 = this;
return self__.meta28172;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__28167_SHARP_){
return f1.call(null,(((p1__28167_SHARP_ == null))?null:self__.f.call(null,p1__28167_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28169","meta28169",1129344915,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async28168","cljs.core.async/t_cljs$core$async28168",-133128973,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta28172","meta28172",1309181987,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async28171.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28171.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28171";

cljs.core.async.t_cljs$core$async28171.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async28171");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async28171 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28171(f__$1,ch__$1,meta28169__$1,___$2,fn1__$1,meta28172){
return (new cljs.core.async.t_cljs$core$async28171(f__$1,ch__$1,meta28169__$1,___$2,fn1__$1,meta28172));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async28171(self__.f,self__.ch,self__.meta28169,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8376__auto__ = ret;
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8376__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28168.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async28168.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28169","meta28169",1129344915,null)], null);
});

cljs.core.async.t_cljs$core$async28168.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28168.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28168";

cljs.core.async.t_cljs$core$async28168.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async28168");
});

cljs.core.async.__GT_t_cljs$core$async28168 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async28168(f__$1,ch__$1,meta28169){
return (new cljs.core.async.t_cljs$core$async28168(f__$1,ch__$1,meta28169));
});

}

return (new cljs.core.async.t_cljs$core$async28168(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async28174 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28174 = (function (f,ch,meta28175){
this.f = f;
this.ch = ch;
this.meta28175 = meta28175;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28176,meta28175__$1){
var self__ = this;
var _28176__$1 = this;
return (new cljs.core.async.t_cljs$core$async28174(self__.f,self__.ch,meta28175__$1));
});

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28176){
var self__ = this;
var _28176__$1 = this;
return self__.meta28175;
});

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28174.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async28174.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28175","meta28175",-540835849,null)], null);
});

cljs.core.async.t_cljs$core$async28174.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28174.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28174";

cljs.core.async.t_cljs$core$async28174.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async28174");
});

cljs.core.async.__GT_t_cljs$core$async28174 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async28174(f__$1,ch__$1,meta28175){
return (new cljs.core.async.t_cljs$core$async28174(f__$1,ch__$1,meta28175));
});

}

return (new cljs.core.async.t_cljs$core$async28174(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async28177 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28177 = (function (p,ch,meta28178){
this.p = p;
this.ch = ch;
this.meta28178 = meta28178;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28179,meta28178__$1){
var self__ = this;
var _28179__$1 = this;
return (new cljs.core.async.t_cljs$core$async28177(self__.p,self__.ch,meta28178__$1));
});

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28179){
var self__ = this;
var _28179__$1 = this;
return self__.meta28178;
});

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28177.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async28177.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta28178","meta28178",-465607914,null)], null);
});

cljs.core.async.t_cljs$core$async28177.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28177.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28177";

cljs.core.async.t_cljs$core$async28177.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async28177");
});

cljs.core.async.__GT_t_cljs$core$async28177 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async28177(p__$1,ch__$1,meta28178){
return (new cljs.core.async.t_cljs$core$async28177(p__$1,ch__$1,meta28178));
});

}

return (new cljs.core.async.t_cljs$core$async28177(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__28181 = arguments.length;
switch (G__28181) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28221 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28221,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28221,out){
return (function (state_28202){
var state_val_28203 = (state_28202[(1)]);
if((state_val_28203 === (7))){
var inst_28198 = (state_28202[(2)]);
var state_28202__$1 = state_28202;
var statearr_28204_28222 = state_28202__$1;
(statearr_28204_28222[(2)] = inst_28198);

(statearr_28204_28222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (1))){
var state_28202__$1 = state_28202;
var statearr_28205_28223 = state_28202__$1;
(statearr_28205_28223[(2)] = null);

(statearr_28205_28223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (4))){
var inst_28184 = (state_28202[(7)]);
var inst_28184__$1 = (state_28202[(2)]);
var inst_28185 = (inst_28184__$1 == null);
var state_28202__$1 = (function (){var statearr_28206 = state_28202;
(statearr_28206[(7)] = inst_28184__$1);

return statearr_28206;
})();
if(cljs.core.truth_(inst_28185)){
var statearr_28207_28224 = state_28202__$1;
(statearr_28207_28224[(1)] = (5));

} else {
var statearr_28208_28225 = state_28202__$1;
(statearr_28208_28225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (6))){
var inst_28184 = (state_28202[(7)]);
var inst_28189 = p.call(null,inst_28184);
var state_28202__$1 = state_28202;
if(cljs.core.truth_(inst_28189)){
var statearr_28209_28226 = state_28202__$1;
(statearr_28209_28226[(1)] = (8));

} else {
var statearr_28210_28227 = state_28202__$1;
(statearr_28210_28227[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (3))){
var inst_28200 = (state_28202[(2)]);
var state_28202__$1 = state_28202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28202__$1,inst_28200);
} else {
if((state_val_28203 === (2))){
var state_28202__$1 = state_28202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28202__$1,(4),ch);
} else {
if((state_val_28203 === (11))){
var inst_28192 = (state_28202[(2)]);
var state_28202__$1 = state_28202;
var statearr_28211_28228 = state_28202__$1;
(statearr_28211_28228[(2)] = inst_28192);

(statearr_28211_28228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (9))){
var state_28202__$1 = state_28202;
var statearr_28212_28229 = state_28202__$1;
(statearr_28212_28229[(2)] = null);

(statearr_28212_28229[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (5))){
var inst_28187 = cljs.core.async.close_BANG_.call(null,out);
var state_28202__$1 = state_28202;
var statearr_28213_28230 = state_28202__$1;
(statearr_28213_28230[(2)] = inst_28187);

(statearr_28213_28230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (10))){
var inst_28195 = (state_28202[(2)]);
var state_28202__$1 = (function (){var statearr_28214 = state_28202;
(statearr_28214[(8)] = inst_28195);

return statearr_28214;
})();
var statearr_28215_28231 = state_28202__$1;
(statearr_28215_28231[(2)] = null);

(statearr_28215_28231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28203 === (8))){
var inst_28184 = (state_28202[(7)]);
var state_28202__$1 = state_28202;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28202__$1,(11),out,inst_28184);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28221,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28221,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28216 = [null,null,null,null,null,null,null,null,null];
(statearr_28216[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28216[(1)] = (1));

return statearr_28216;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28202){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28217){if((e28217 instanceof Object)){
var ex__16187__auto__ = e28217;
var statearr_28218_28232 = state_28202;
(statearr_28218_28232[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28202);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28233 = state_28202;
state_28202 = G__28233;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28202);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28221,out))
})();
var state__16275__auto__ = (function (){var statearr_28219 = f__16274__auto__.call(null);
(statearr_28219[(6)] = c__16273__auto___28221);

return statearr_28219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28221,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__28235 = arguments.length;
switch (G__28235) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_28298){
var state_val_28299 = (state_28298[(1)]);
if((state_val_28299 === (7))){
var inst_28294 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
var statearr_28300_28338 = state_28298__$1;
(statearr_28300_28338[(2)] = inst_28294);

(statearr_28300_28338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (20))){
var inst_28264 = (state_28298[(7)]);
var inst_28275 = (state_28298[(2)]);
var inst_28276 = cljs.core.next.call(null,inst_28264);
var inst_28250 = inst_28276;
var inst_28251 = null;
var inst_28252 = (0);
var inst_28253 = (0);
var state_28298__$1 = (function (){var statearr_28301 = state_28298;
(statearr_28301[(8)] = inst_28253);

(statearr_28301[(9)] = inst_28252);

(statearr_28301[(10)] = inst_28250);

(statearr_28301[(11)] = inst_28275);

(statearr_28301[(12)] = inst_28251);

return statearr_28301;
})();
var statearr_28302_28339 = state_28298__$1;
(statearr_28302_28339[(2)] = null);

(statearr_28302_28339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (1))){
var state_28298__$1 = state_28298;
var statearr_28303_28340 = state_28298__$1;
(statearr_28303_28340[(2)] = null);

(statearr_28303_28340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (4))){
var inst_28239 = (state_28298[(13)]);
var inst_28239__$1 = (state_28298[(2)]);
var inst_28240 = (inst_28239__$1 == null);
var state_28298__$1 = (function (){var statearr_28304 = state_28298;
(statearr_28304[(13)] = inst_28239__$1);

return statearr_28304;
})();
if(cljs.core.truth_(inst_28240)){
var statearr_28305_28341 = state_28298__$1;
(statearr_28305_28341[(1)] = (5));

} else {
var statearr_28306_28342 = state_28298__$1;
(statearr_28306_28342[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (15))){
var state_28298__$1 = state_28298;
var statearr_28310_28343 = state_28298__$1;
(statearr_28310_28343[(2)] = null);

(statearr_28310_28343[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (21))){
var state_28298__$1 = state_28298;
var statearr_28311_28344 = state_28298__$1;
(statearr_28311_28344[(2)] = null);

(statearr_28311_28344[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (13))){
var inst_28253 = (state_28298[(8)]);
var inst_28252 = (state_28298[(9)]);
var inst_28250 = (state_28298[(10)]);
var inst_28251 = (state_28298[(12)]);
var inst_28260 = (state_28298[(2)]);
var inst_28261 = (inst_28253 + (1));
var tmp28307 = inst_28252;
var tmp28308 = inst_28250;
var tmp28309 = inst_28251;
var inst_28250__$1 = tmp28308;
var inst_28251__$1 = tmp28309;
var inst_28252__$1 = tmp28307;
var inst_28253__$1 = inst_28261;
var state_28298__$1 = (function (){var statearr_28312 = state_28298;
(statearr_28312[(8)] = inst_28253__$1);

(statearr_28312[(14)] = inst_28260);

(statearr_28312[(9)] = inst_28252__$1);

(statearr_28312[(10)] = inst_28250__$1);

(statearr_28312[(12)] = inst_28251__$1);

return statearr_28312;
})();
var statearr_28313_28345 = state_28298__$1;
(statearr_28313_28345[(2)] = null);

(statearr_28313_28345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (22))){
var state_28298__$1 = state_28298;
var statearr_28314_28346 = state_28298__$1;
(statearr_28314_28346[(2)] = null);

(statearr_28314_28346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (6))){
var inst_28239 = (state_28298[(13)]);
var inst_28248 = f.call(null,inst_28239);
var inst_28249 = cljs.core.seq.call(null,inst_28248);
var inst_28250 = inst_28249;
var inst_28251 = null;
var inst_28252 = (0);
var inst_28253 = (0);
var state_28298__$1 = (function (){var statearr_28315 = state_28298;
(statearr_28315[(8)] = inst_28253);

(statearr_28315[(9)] = inst_28252);

(statearr_28315[(10)] = inst_28250);

(statearr_28315[(12)] = inst_28251);

return statearr_28315;
})();
var statearr_28316_28347 = state_28298__$1;
(statearr_28316_28347[(2)] = null);

(statearr_28316_28347[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (17))){
var inst_28264 = (state_28298[(7)]);
var inst_28268 = cljs.core.chunk_first.call(null,inst_28264);
var inst_28269 = cljs.core.chunk_rest.call(null,inst_28264);
var inst_28270 = cljs.core.count.call(null,inst_28268);
var inst_28250 = inst_28269;
var inst_28251 = inst_28268;
var inst_28252 = inst_28270;
var inst_28253 = (0);
var state_28298__$1 = (function (){var statearr_28317 = state_28298;
(statearr_28317[(8)] = inst_28253);

(statearr_28317[(9)] = inst_28252);

(statearr_28317[(10)] = inst_28250);

(statearr_28317[(12)] = inst_28251);

return statearr_28317;
})();
var statearr_28318_28348 = state_28298__$1;
(statearr_28318_28348[(2)] = null);

(statearr_28318_28348[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (3))){
var inst_28296 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28298__$1,inst_28296);
} else {
if((state_val_28299 === (12))){
var inst_28284 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
var statearr_28319_28349 = state_28298__$1;
(statearr_28319_28349[(2)] = inst_28284);

(statearr_28319_28349[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (2))){
var state_28298__$1 = state_28298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28298__$1,(4),in$);
} else {
if((state_val_28299 === (23))){
var inst_28292 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
var statearr_28320_28350 = state_28298__$1;
(statearr_28320_28350[(2)] = inst_28292);

(statearr_28320_28350[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (19))){
var inst_28279 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
var statearr_28321_28351 = state_28298__$1;
(statearr_28321_28351[(2)] = inst_28279);

(statearr_28321_28351[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (11))){
var inst_28250 = (state_28298[(10)]);
var inst_28264 = (state_28298[(7)]);
var inst_28264__$1 = cljs.core.seq.call(null,inst_28250);
var state_28298__$1 = (function (){var statearr_28322 = state_28298;
(statearr_28322[(7)] = inst_28264__$1);

return statearr_28322;
})();
if(inst_28264__$1){
var statearr_28323_28352 = state_28298__$1;
(statearr_28323_28352[(1)] = (14));

} else {
var statearr_28324_28353 = state_28298__$1;
(statearr_28324_28353[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (9))){
var inst_28286 = (state_28298[(2)]);
var inst_28287 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_28298__$1 = (function (){var statearr_28325 = state_28298;
(statearr_28325[(15)] = inst_28286);

return statearr_28325;
})();
if(cljs.core.truth_(inst_28287)){
var statearr_28326_28354 = state_28298__$1;
(statearr_28326_28354[(1)] = (21));

} else {
var statearr_28327_28355 = state_28298__$1;
(statearr_28327_28355[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (5))){
var inst_28242 = cljs.core.async.close_BANG_.call(null,out);
var state_28298__$1 = state_28298;
var statearr_28328_28356 = state_28298__$1;
(statearr_28328_28356[(2)] = inst_28242);

(statearr_28328_28356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (14))){
var inst_28264 = (state_28298[(7)]);
var inst_28266 = cljs.core.chunked_seq_QMARK_.call(null,inst_28264);
var state_28298__$1 = state_28298;
if(inst_28266){
var statearr_28329_28357 = state_28298__$1;
(statearr_28329_28357[(1)] = (17));

} else {
var statearr_28330_28358 = state_28298__$1;
(statearr_28330_28358[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (16))){
var inst_28282 = (state_28298[(2)]);
var state_28298__$1 = state_28298;
var statearr_28331_28359 = state_28298__$1;
(statearr_28331_28359[(2)] = inst_28282);

(statearr_28331_28359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28299 === (10))){
var inst_28253 = (state_28298[(8)]);
var inst_28251 = (state_28298[(12)]);
var inst_28258 = cljs.core._nth.call(null,inst_28251,inst_28253);
var state_28298__$1 = state_28298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28298__$1,(13),out,inst_28258);
} else {
if((state_val_28299 === (18))){
var inst_28264 = (state_28298[(7)]);
var inst_28273 = cljs.core.first.call(null,inst_28264);
var state_28298__$1 = state_28298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28298__$1,(20),out,inst_28273);
} else {
if((state_val_28299 === (8))){
var inst_28253 = (state_28298[(8)]);
var inst_28252 = (state_28298[(9)]);
var inst_28255 = (inst_28253 < inst_28252);
var inst_28256 = inst_28255;
var state_28298__$1 = state_28298;
if(cljs.core.truth_(inst_28256)){
var statearr_28332_28360 = state_28298__$1;
(statearr_28332_28360[(1)] = (10));

} else {
var statearr_28333_28361 = state_28298__$1;
(statearr_28333_28361[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_28334 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28334[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__);

(statearr_28334[(1)] = (1));

return statearr_28334;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1 = (function (state_28298){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28335){if((e28335 instanceof Object)){
var ex__16187__auto__ = e28335;
var statearr_28336_28362 = state_28298;
(statearr_28336_28362[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28363 = state_28298;
state_28298 = G__28363;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = function(state_28298){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1.call(this,state_28298);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_28337 = f__16274__auto__.call(null);
(statearr_28337[(6)] = c__16273__auto__);

return statearr_28337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__28365 = arguments.length;
switch (G__28365) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__28368 = arguments.length;
switch (G__28368) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__28371 = arguments.length;
switch (G__28371) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28418 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28418,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28418,out){
return (function (state_28395){
var state_val_28396 = (state_28395[(1)]);
if((state_val_28396 === (7))){
var inst_28390 = (state_28395[(2)]);
var state_28395__$1 = state_28395;
var statearr_28397_28419 = state_28395__$1;
(statearr_28397_28419[(2)] = inst_28390);

(statearr_28397_28419[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (1))){
var inst_28372 = null;
var state_28395__$1 = (function (){var statearr_28398 = state_28395;
(statearr_28398[(7)] = inst_28372);

return statearr_28398;
})();
var statearr_28399_28420 = state_28395__$1;
(statearr_28399_28420[(2)] = null);

(statearr_28399_28420[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (4))){
var inst_28375 = (state_28395[(8)]);
var inst_28375__$1 = (state_28395[(2)]);
var inst_28376 = (inst_28375__$1 == null);
var inst_28377 = cljs.core.not.call(null,inst_28376);
var state_28395__$1 = (function (){var statearr_28400 = state_28395;
(statearr_28400[(8)] = inst_28375__$1);

return statearr_28400;
})();
if(inst_28377){
var statearr_28401_28421 = state_28395__$1;
(statearr_28401_28421[(1)] = (5));

} else {
var statearr_28402_28422 = state_28395__$1;
(statearr_28402_28422[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (6))){
var state_28395__$1 = state_28395;
var statearr_28403_28423 = state_28395__$1;
(statearr_28403_28423[(2)] = null);

(statearr_28403_28423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (3))){
var inst_28392 = (state_28395[(2)]);
var inst_28393 = cljs.core.async.close_BANG_.call(null,out);
var state_28395__$1 = (function (){var statearr_28404 = state_28395;
(statearr_28404[(9)] = inst_28392);

return statearr_28404;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28395__$1,inst_28393);
} else {
if((state_val_28396 === (2))){
var state_28395__$1 = state_28395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28395__$1,(4),ch);
} else {
if((state_val_28396 === (11))){
var inst_28375 = (state_28395[(8)]);
var inst_28384 = (state_28395[(2)]);
var inst_28372 = inst_28375;
var state_28395__$1 = (function (){var statearr_28405 = state_28395;
(statearr_28405[(7)] = inst_28372);

(statearr_28405[(10)] = inst_28384);

return statearr_28405;
})();
var statearr_28406_28424 = state_28395__$1;
(statearr_28406_28424[(2)] = null);

(statearr_28406_28424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (9))){
var inst_28375 = (state_28395[(8)]);
var state_28395__$1 = state_28395;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28395__$1,(11),out,inst_28375);
} else {
if((state_val_28396 === (5))){
var inst_28372 = (state_28395[(7)]);
var inst_28375 = (state_28395[(8)]);
var inst_28379 = cljs.core._EQ_.call(null,inst_28375,inst_28372);
var state_28395__$1 = state_28395;
if(inst_28379){
var statearr_28408_28425 = state_28395__$1;
(statearr_28408_28425[(1)] = (8));

} else {
var statearr_28409_28426 = state_28395__$1;
(statearr_28409_28426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (10))){
var inst_28387 = (state_28395[(2)]);
var state_28395__$1 = state_28395;
var statearr_28410_28427 = state_28395__$1;
(statearr_28410_28427[(2)] = inst_28387);

(statearr_28410_28427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28396 === (8))){
var inst_28372 = (state_28395[(7)]);
var tmp28407 = inst_28372;
var inst_28372__$1 = tmp28407;
var state_28395__$1 = (function (){var statearr_28411 = state_28395;
(statearr_28411[(7)] = inst_28372__$1);

return statearr_28411;
})();
var statearr_28412_28428 = state_28395__$1;
(statearr_28412_28428[(2)] = null);

(statearr_28412_28428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28418,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28418,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28413 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28413[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28413[(1)] = (1));

return statearr_28413;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28395){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28414){if((e28414 instanceof Object)){
var ex__16187__auto__ = e28414;
var statearr_28415_28429 = state_28395;
(statearr_28415_28429[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28395);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28414;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28430 = state_28395;
state_28395 = G__28430;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28395){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28395);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28418,out))
})();
var state__16275__auto__ = (function (){var statearr_28416 = f__16274__auto__.call(null);
(statearr_28416[(6)] = c__16273__auto___28418);

return statearr_28416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28418,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__28432 = arguments.length;
switch (G__28432) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28498 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28498,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28498,out){
return (function (state_28470){
var state_val_28471 = (state_28470[(1)]);
if((state_val_28471 === (7))){
var inst_28466 = (state_28470[(2)]);
var state_28470__$1 = state_28470;
var statearr_28472_28499 = state_28470__$1;
(statearr_28472_28499[(2)] = inst_28466);

(statearr_28472_28499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (1))){
var inst_28433 = (new Array(n));
var inst_28434 = inst_28433;
var inst_28435 = (0);
var state_28470__$1 = (function (){var statearr_28473 = state_28470;
(statearr_28473[(7)] = inst_28435);

(statearr_28473[(8)] = inst_28434);

return statearr_28473;
})();
var statearr_28474_28500 = state_28470__$1;
(statearr_28474_28500[(2)] = null);

(statearr_28474_28500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (4))){
var inst_28438 = (state_28470[(9)]);
var inst_28438__$1 = (state_28470[(2)]);
var inst_28439 = (inst_28438__$1 == null);
var inst_28440 = cljs.core.not.call(null,inst_28439);
var state_28470__$1 = (function (){var statearr_28475 = state_28470;
(statearr_28475[(9)] = inst_28438__$1);

return statearr_28475;
})();
if(inst_28440){
var statearr_28476_28501 = state_28470__$1;
(statearr_28476_28501[(1)] = (5));

} else {
var statearr_28477_28502 = state_28470__$1;
(statearr_28477_28502[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (15))){
var inst_28460 = (state_28470[(2)]);
var state_28470__$1 = state_28470;
var statearr_28478_28503 = state_28470__$1;
(statearr_28478_28503[(2)] = inst_28460);

(statearr_28478_28503[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (13))){
var state_28470__$1 = state_28470;
var statearr_28479_28504 = state_28470__$1;
(statearr_28479_28504[(2)] = null);

(statearr_28479_28504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (6))){
var inst_28435 = (state_28470[(7)]);
var inst_28456 = (inst_28435 > (0));
var state_28470__$1 = state_28470;
if(cljs.core.truth_(inst_28456)){
var statearr_28480_28505 = state_28470__$1;
(statearr_28480_28505[(1)] = (12));

} else {
var statearr_28481_28506 = state_28470__$1;
(statearr_28481_28506[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (3))){
var inst_28468 = (state_28470[(2)]);
var state_28470__$1 = state_28470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28470__$1,inst_28468);
} else {
if((state_val_28471 === (12))){
var inst_28434 = (state_28470[(8)]);
var inst_28458 = cljs.core.vec.call(null,inst_28434);
var state_28470__$1 = state_28470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28470__$1,(15),out,inst_28458);
} else {
if((state_val_28471 === (2))){
var state_28470__$1 = state_28470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28470__$1,(4),ch);
} else {
if((state_val_28471 === (11))){
var inst_28450 = (state_28470[(2)]);
var inst_28451 = (new Array(n));
var inst_28434 = inst_28451;
var inst_28435 = (0);
var state_28470__$1 = (function (){var statearr_28482 = state_28470;
(statearr_28482[(10)] = inst_28450);

(statearr_28482[(7)] = inst_28435);

(statearr_28482[(8)] = inst_28434);

return statearr_28482;
})();
var statearr_28483_28507 = state_28470__$1;
(statearr_28483_28507[(2)] = null);

(statearr_28483_28507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (9))){
var inst_28434 = (state_28470[(8)]);
var inst_28448 = cljs.core.vec.call(null,inst_28434);
var state_28470__$1 = state_28470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28470__$1,(11),out,inst_28448);
} else {
if((state_val_28471 === (5))){
var inst_28435 = (state_28470[(7)]);
var inst_28434 = (state_28470[(8)]);
var inst_28443 = (state_28470[(11)]);
var inst_28438 = (state_28470[(9)]);
var inst_28442 = (inst_28434[inst_28435] = inst_28438);
var inst_28443__$1 = (inst_28435 + (1));
var inst_28444 = (inst_28443__$1 < n);
var state_28470__$1 = (function (){var statearr_28484 = state_28470;
(statearr_28484[(11)] = inst_28443__$1);

(statearr_28484[(12)] = inst_28442);

return statearr_28484;
})();
if(cljs.core.truth_(inst_28444)){
var statearr_28485_28508 = state_28470__$1;
(statearr_28485_28508[(1)] = (8));

} else {
var statearr_28486_28509 = state_28470__$1;
(statearr_28486_28509[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (14))){
var inst_28463 = (state_28470[(2)]);
var inst_28464 = cljs.core.async.close_BANG_.call(null,out);
var state_28470__$1 = (function (){var statearr_28488 = state_28470;
(statearr_28488[(13)] = inst_28463);

return statearr_28488;
})();
var statearr_28489_28510 = state_28470__$1;
(statearr_28489_28510[(2)] = inst_28464);

(statearr_28489_28510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (10))){
var inst_28454 = (state_28470[(2)]);
var state_28470__$1 = state_28470;
var statearr_28490_28511 = state_28470__$1;
(statearr_28490_28511[(2)] = inst_28454);

(statearr_28490_28511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28471 === (8))){
var inst_28434 = (state_28470[(8)]);
var inst_28443 = (state_28470[(11)]);
var tmp28487 = inst_28434;
var inst_28434__$1 = tmp28487;
var inst_28435 = inst_28443;
var state_28470__$1 = (function (){var statearr_28491 = state_28470;
(statearr_28491[(7)] = inst_28435);

(statearr_28491[(8)] = inst_28434__$1);

return statearr_28491;
})();
var statearr_28492_28512 = state_28470__$1;
(statearr_28492_28512[(2)] = null);

(statearr_28492_28512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28498,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28498,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28493 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28493[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28493[(1)] = (1));

return statearr_28493;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28470){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28494){if((e28494 instanceof Object)){
var ex__16187__auto__ = e28494;
var statearr_28495_28513 = state_28470;
(statearr_28495_28513[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28514 = state_28470;
state_28470 = G__28514;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28498,out))
})();
var state__16275__auto__ = (function (){var statearr_28496 = f__16274__auto__.call(null);
(statearr_28496[(6)] = c__16273__auto___28498);

return statearr_28496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28498,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__28516 = arguments.length;
switch (G__28516) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___28586 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___28586,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___28586,out){
return (function (state_28558){
var state_val_28559 = (state_28558[(1)]);
if((state_val_28559 === (7))){
var inst_28554 = (state_28558[(2)]);
var state_28558__$1 = state_28558;
var statearr_28560_28587 = state_28558__$1;
(statearr_28560_28587[(2)] = inst_28554);

(statearr_28560_28587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (1))){
var inst_28517 = [];
var inst_28518 = inst_28517;
var inst_28519 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_28558__$1 = (function (){var statearr_28561 = state_28558;
(statearr_28561[(7)] = inst_28518);

(statearr_28561[(8)] = inst_28519);

return statearr_28561;
})();
var statearr_28562_28588 = state_28558__$1;
(statearr_28562_28588[(2)] = null);

(statearr_28562_28588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (4))){
var inst_28522 = (state_28558[(9)]);
var inst_28522__$1 = (state_28558[(2)]);
var inst_28523 = (inst_28522__$1 == null);
var inst_28524 = cljs.core.not.call(null,inst_28523);
var state_28558__$1 = (function (){var statearr_28563 = state_28558;
(statearr_28563[(9)] = inst_28522__$1);

return statearr_28563;
})();
if(inst_28524){
var statearr_28564_28589 = state_28558__$1;
(statearr_28564_28589[(1)] = (5));

} else {
var statearr_28565_28590 = state_28558__$1;
(statearr_28565_28590[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (15))){
var inst_28548 = (state_28558[(2)]);
var state_28558__$1 = state_28558;
var statearr_28566_28591 = state_28558__$1;
(statearr_28566_28591[(2)] = inst_28548);

(statearr_28566_28591[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (13))){
var state_28558__$1 = state_28558;
var statearr_28567_28592 = state_28558__$1;
(statearr_28567_28592[(2)] = null);

(statearr_28567_28592[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (6))){
var inst_28518 = (state_28558[(7)]);
var inst_28543 = inst_28518.length;
var inst_28544 = (inst_28543 > (0));
var state_28558__$1 = state_28558;
if(cljs.core.truth_(inst_28544)){
var statearr_28568_28593 = state_28558__$1;
(statearr_28568_28593[(1)] = (12));

} else {
var statearr_28569_28594 = state_28558__$1;
(statearr_28569_28594[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (3))){
var inst_28556 = (state_28558[(2)]);
var state_28558__$1 = state_28558;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28558__$1,inst_28556);
} else {
if((state_val_28559 === (12))){
var inst_28518 = (state_28558[(7)]);
var inst_28546 = cljs.core.vec.call(null,inst_28518);
var state_28558__$1 = state_28558;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28558__$1,(15),out,inst_28546);
} else {
if((state_val_28559 === (2))){
var state_28558__$1 = state_28558;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28558__$1,(4),ch);
} else {
if((state_val_28559 === (11))){
var inst_28522 = (state_28558[(9)]);
var inst_28526 = (state_28558[(10)]);
var inst_28536 = (state_28558[(2)]);
var inst_28537 = [];
var inst_28538 = inst_28537.push(inst_28522);
var inst_28518 = inst_28537;
var inst_28519 = inst_28526;
var state_28558__$1 = (function (){var statearr_28570 = state_28558;
(statearr_28570[(11)] = inst_28538);

(statearr_28570[(7)] = inst_28518);

(statearr_28570[(8)] = inst_28519);

(statearr_28570[(12)] = inst_28536);

return statearr_28570;
})();
var statearr_28571_28595 = state_28558__$1;
(statearr_28571_28595[(2)] = null);

(statearr_28571_28595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (9))){
var inst_28518 = (state_28558[(7)]);
var inst_28534 = cljs.core.vec.call(null,inst_28518);
var state_28558__$1 = state_28558;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28558__$1,(11),out,inst_28534);
} else {
if((state_val_28559 === (5))){
var inst_28522 = (state_28558[(9)]);
var inst_28519 = (state_28558[(8)]);
var inst_28526 = (state_28558[(10)]);
var inst_28526__$1 = f.call(null,inst_28522);
var inst_28527 = cljs.core._EQ_.call(null,inst_28526__$1,inst_28519);
var inst_28528 = cljs.core.keyword_identical_QMARK_.call(null,inst_28519,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_28529 = (inst_28527) || (inst_28528);
var state_28558__$1 = (function (){var statearr_28572 = state_28558;
(statearr_28572[(10)] = inst_28526__$1);

return statearr_28572;
})();
if(cljs.core.truth_(inst_28529)){
var statearr_28573_28596 = state_28558__$1;
(statearr_28573_28596[(1)] = (8));

} else {
var statearr_28574_28597 = state_28558__$1;
(statearr_28574_28597[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (14))){
var inst_28551 = (state_28558[(2)]);
var inst_28552 = cljs.core.async.close_BANG_.call(null,out);
var state_28558__$1 = (function (){var statearr_28576 = state_28558;
(statearr_28576[(13)] = inst_28551);

return statearr_28576;
})();
var statearr_28577_28598 = state_28558__$1;
(statearr_28577_28598[(2)] = inst_28552);

(statearr_28577_28598[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (10))){
var inst_28541 = (state_28558[(2)]);
var state_28558__$1 = state_28558;
var statearr_28578_28599 = state_28558__$1;
(statearr_28578_28599[(2)] = inst_28541);

(statearr_28578_28599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28559 === (8))){
var inst_28522 = (state_28558[(9)]);
var inst_28518 = (state_28558[(7)]);
var inst_28526 = (state_28558[(10)]);
var inst_28531 = inst_28518.push(inst_28522);
var tmp28575 = inst_28518;
var inst_28518__$1 = tmp28575;
var inst_28519 = inst_28526;
var state_28558__$1 = (function (){var statearr_28579 = state_28558;
(statearr_28579[(14)] = inst_28531);

(statearr_28579[(7)] = inst_28518__$1);

(statearr_28579[(8)] = inst_28519);

return statearr_28579;
})();
var statearr_28580_28600 = state_28558__$1;
(statearr_28580_28600[(2)] = null);

(statearr_28580_28600[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___28586,out))
;
return ((function (switch__16183__auto__,c__16273__auto___28586,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_28581 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28581[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_28581[(1)] = (1));

return statearr_28581;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_28558){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_28558);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e28582){if((e28582 instanceof Object)){
var ex__16187__auto__ = e28582;
var statearr_28583_28601 = state_28558;
(statearr_28583_28601[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28558);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28582;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28602 = state_28558;
state_28558 = G__28602;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_28558){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_28558);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___28586,out))
})();
var state__16275__auto__ = (function (){var statearr_28584 = f__16274__auto__.call(null);
(statearr_28584[(6)] = c__16273__auto___28586);

return statearr_28584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___28586,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

