// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.subs');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.db');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('re_frame.utils');
goog.require('re_frame.registrar');
goog.require('re_frame.trace');
re_frame.subs.kind = cljs.core.cst$kw$sub;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.subs.kind) : re_frame.registrar.kinds.call(null,re_frame.subs.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.subs.query__GT_reaction = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Causes all subscriptions to be removed from the cache.
 *   Does this by:
 *   1. running on-dispose on all cached subscriptions
 *   2. These on-dispose will then do the removal of themselves.
 * 
 *   This is a development time tool. Useful when reloading Figwheel code
 *   after a React exception, because React components won't have been
 *   cleaned up properly. And this, in turn, means the subscriptions within those
 *   components won't have been cleaned up correctly. So this forces the issue.
 */
re_frame.subs.clear_subscription_cache_BANG_ = (function re_frame$subs$clear_subscription_cache_BANG_(){
var seq__40845_40855 = cljs.core.seq(cljs.core.deref(re_frame.subs.query__GT_reaction));
var chunk__40846_40856 = null;
var count__40847_40857 = (0);
var i__40848_40858 = (0);
while(true){
if((i__40848_40858 < count__40847_40857)){
var vec__40849_40859 = chunk__40846_40856.cljs$core$IIndexed$_nth$arity$2(null,i__40848_40858);
var k_40860 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40849_40859,(0),null);
var rxn_40861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40849_40859,(1),null);
re_frame.interop.dispose_BANG_(rxn_40861);

var G__40862 = seq__40845_40855;
var G__40863 = chunk__40846_40856;
var G__40864 = count__40847_40857;
var G__40865 = (i__40848_40858 + (1));
seq__40845_40855 = G__40862;
chunk__40846_40856 = G__40863;
count__40847_40857 = G__40864;
i__40848_40858 = G__40865;
continue;
} else {
var temp__5457__auto___40866 = cljs.core.seq(seq__40845_40855);
if(temp__5457__auto___40866){
var seq__40845_40867__$1 = temp__5457__auto___40866;
if(cljs.core.chunked_seq_QMARK_(seq__40845_40867__$1)){
var c__9319__auto___40868 = cljs.core.chunk_first(seq__40845_40867__$1);
var G__40869 = cljs.core.chunk_rest(seq__40845_40867__$1);
var G__40870 = c__9319__auto___40868;
var G__40871 = cljs.core.count(c__9319__auto___40868);
var G__40872 = (0);
seq__40845_40855 = G__40869;
chunk__40846_40856 = G__40870;
count__40847_40857 = G__40871;
i__40848_40858 = G__40872;
continue;
} else {
var vec__40852_40873 = cljs.core.first(seq__40845_40867__$1);
var k_40874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40852_40873,(0),null);
var rxn_40875 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40852_40873,(1),null);
re_frame.interop.dispose_BANG_(rxn_40875);

var G__40876 = cljs.core.next(seq__40845_40867__$1);
var G__40877 = null;
var G__40878 = (0);
var G__40879 = (0);
seq__40845_40855 = G__40876;
chunk__40846_40856 = G__40877;
count__40847_40857 = G__40878;
i__40848_40858 = G__40879;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.not_empty(cljs.core.deref(re_frame.subs.query__GT_reaction)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscription cache should be empty after clearing it."], 0));
} else {
return null;
}
});
/**
 * Unregisters all existing subscription handlers
 */
re_frame.subs.clear_all_handlers_BANG_ = (function re_frame$subs$clear_all_handlers_BANG_(){
re_frame.registrar.clear_handlers.cljs$core$IFn$_invoke$arity$1(re_frame.subs.kind);

return re_frame.subs.clear_subscription_cache_BANG_();
});
/**
 * cache the reaction r
 */
re_frame.subs.cache_and_return = (function re_frame$subs$cache_and_return(query_v,dynv,r){
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_v,dynv], null);
re_frame.interop.add_on_dispose_BANG_(r,((function (cache_key){
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.subs.query__GT_reaction,cljs.core.dissoc,cache_key);

if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_40880 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,re_frame.utils.first_in_vector(query_v),cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$sub_SLASH_dispose,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$query_DASH_v,query_v,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(r)], null)], null));

try{try{return null;
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___40895 = re_frame.interop.now();
var duration__19292__auto___40896 = (end__19291__auto___40895 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__40881_40897 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__40882_40898 = null;
var count__40883_40899 = (0);
var i__40884_40900 = (0);
while(true){
if((i__40884_40900 < count__40883_40899)){
var vec__40885_40901 = chunk__40882_40898.cljs$core$IIndexed$_nth$arity$2(null,i__40884_40900);
var k__19293__auto___40902 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40885_40901,(0),null);
var cb__19294__auto___40903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40885_40901,(1),null);
try{var G__40889_40904 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40896,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40903.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40903.cljs$core$IFn$_invoke$arity$1(G__40889_40904) : cb__19294__auto___40903.call(null,G__40889_40904));
}catch (e40888){if((e40888 instanceof java.lang.Exception)){
var e__19295__auto___40905 = e40888;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40902,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40905], 0));
} else {
throw e40888;

}
}
var G__40906 = seq__40881_40897;
var G__40907 = chunk__40882_40898;
var G__40908 = count__40883_40899;
var G__40909 = (i__40884_40900 + (1));
seq__40881_40897 = G__40906;
chunk__40882_40898 = G__40907;
count__40883_40899 = G__40908;
i__40884_40900 = G__40909;
continue;
} else {
var temp__5457__auto___40910 = cljs.core.seq(seq__40881_40897);
if(temp__5457__auto___40910){
var seq__40881_40911__$1 = temp__5457__auto___40910;
if(cljs.core.chunked_seq_QMARK_(seq__40881_40911__$1)){
var c__9319__auto___40912 = cljs.core.chunk_first(seq__40881_40911__$1);
var G__40913 = cljs.core.chunk_rest(seq__40881_40911__$1);
var G__40914 = c__9319__auto___40912;
var G__40915 = cljs.core.count(c__9319__auto___40912);
var G__40916 = (0);
seq__40881_40897 = G__40913;
chunk__40882_40898 = G__40914;
count__40883_40899 = G__40915;
i__40884_40900 = G__40916;
continue;
} else {
var vec__40890_40917 = cljs.core.first(seq__40881_40911__$1);
var k__19293__auto___40918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40890_40917,(0),null);
var cb__19294__auto___40919 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40890_40917,(1),null);
try{var G__40894_40920 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40896,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40919.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40919.cljs$core$IFn$_invoke$arity$1(G__40894_40920) : cb__19294__auto___40919.call(null,G__40894_40920));
}catch (e40893){if((e40893 instanceof java.lang.Exception)){
var e__19295__auto___40921 = e40893;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40918,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40921], 0));
} else {
throw e40893;

}
}
var G__40922 = cljs.core.next(seq__40881_40911__$1);
var G__40923 = null;
var G__40924 = (0);
var G__40925 = (0);
seq__40881_40897 = G__40922;
chunk__40882_40898 = G__40923;
count__40883_40899 = G__40924;
i__40884_40900 = G__40925;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_40880;
}} else {
return null;
}
});})(cache_key))
);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.subs.query__GT_reaction,cljs.core.assoc,cache_key,r);

if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___40926 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(r)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(r)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___40926;

} else {
}

return r;
});
re_frame.subs.cache_lookup = (function re_frame$subs$cache_lookup(var_args){
var G__40928 = arguments.length;
switch (G__40928) {
case 1:
return re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$1 = (function (query_v){
return re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$2(query_v,cljs.core.PersistentVector.EMPTY);
});

re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$2 = (function (query_v,dyn_v){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(re_frame.subs.query__GT_reaction),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_v,dyn_v], null));
});

re_frame.subs.cache_lookup.cljs$lang$maxFixedArity = 2;

/**
 * Given a `query`, returns a Reagent `reaction` which, over
 *   time, reactively delivers a stream of values. So in FRP-ish terms,
 *   it returns a Signal.
 * 
 *   To obtain the returned Signal/Stream's current value, it must be `deref`ed.
 * 
 *   `query` is a vector of at least one element. The first element is the
 *   `query-id`, typically a namespaced keyword. The rest of the vector's
 *   elements are optional, additional values which parameterise the query
 *   performed.
 * 
 *   `dynv` is an optional 3rd argument, `which is a vector of further input
 *   signals (atoms, reactions, etc), NOT values. This argument exists for
 *   historical reasons and is borderline deprecated these days.
 * 
 *   Example Usage:
 *   --------------
 * 
 *  (subscribe [:items])
 *  (subscribe [:items "blue" :small])
 *  (subscribe [:items {:colour "blue"  :size :small}])
 * 
 *   Note: for any given call to `subscribe` there must have been a previous call
 *   to `reg-sub`, registering the query handler (function) for the `query-id` given.
 * 
 *   Hint
 *   ----
 * 
 *   When used in a view function BE SURE to `deref` the returned value.
 *   In fact, to avoid any mistakes, some prefer to define:
 * 
 *   (def <sub  (comp deref re-frame.core/subscribe))
 * 
 *   And then, within their views, they call  `(<sub [:items :small])` rather
 *   than using `subscribe` directly.
 * 
 *   De-duplication
 *   --------------
 * 
 *   XXX
 *   
 */
re_frame.subs.subscribe = (function re_frame$subs$subscribe(var_args){
var G__40931 = arguments.length;
switch (G__40931) {
case 1:
return re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (query){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_40932 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,re_frame.utils.first_in_vector(query),cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$sub_SLASH_create,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_v,query], null)], null));

try{try{var temp__5455__auto__ = re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(temp__5455__auto__)){
var cached = temp__5455__auto__;
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___40969 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___40969;

} else {
}

return cached;
} else {
var query_id = re_frame.utils.first_in_vector(query);
var handler_fn = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$2(re_frame.subs.kind,query_id);
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___40970 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___40970;

} else {
}

if((handler_fn == null)){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___40971 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___40971;

} else {
}

return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["re-frame: no subscription handler registered for: \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_id),"\". Returning a nil subscription."].join('')], 0));
} else {
return re_frame.subs.cache_and_return(query,cljs.core.PersistentVector.EMPTY,(handler_fn.cljs$core$IFn$_invoke$arity$2 ? handler_fn.cljs$core$IFn$_invoke$arity$2(re_frame.db.app_db,query) : handler_fn.call(null,re_frame.db.app_db,query)));
}
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___40972 = re_frame.interop.now();
var duration__19292__auto___40973 = (end__19291__auto___40972 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__40933_40974 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__40934_40975 = null;
var count__40935_40976 = (0);
var i__40936_40977 = (0);
while(true){
if((i__40936_40977 < count__40935_40976)){
var vec__40937_40978 = chunk__40934_40975.cljs$core$IIndexed$_nth$arity$2(null,i__40936_40977);
var k__19293__auto___40979 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40937_40978,(0),null);
var cb__19294__auto___40980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40937_40978,(1),null);
try{var G__40941_40981 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40973,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40980.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40980.cljs$core$IFn$_invoke$arity$1(G__40941_40981) : cb__19294__auto___40980.call(null,G__40941_40981));
}catch (e40940){if((e40940 instanceof java.lang.Exception)){
var e__19295__auto___40982 = e40940;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40979,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40982], 0));
} else {
throw e40940;

}
}
var G__40983 = seq__40933_40974;
var G__40984 = chunk__40934_40975;
var G__40985 = count__40935_40976;
var G__40986 = (i__40936_40977 + (1));
seq__40933_40974 = G__40983;
chunk__40934_40975 = G__40984;
count__40935_40976 = G__40985;
i__40936_40977 = G__40986;
continue;
} else {
var temp__5457__auto___40987 = cljs.core.seq(seq__40933_40974);
if(temp__5457__auto___40987){
var seq__40933_40988__$1 = temp__5457__auto___40987;
if(cljs.core.chunked_seq_QMARK_(seq__40933_40988__$1)){
var c__9319__auto___40989 = cljs.core.chunk_first(seq__40933_40988__$1);
var G__40990 = cljs.core.chunk_rest(seq__40933_40988__$1);
var G__40991 = c__9319__auto___40989;
var G__40992 = cljs.core.count(c__9319__auto___40989);
var G__40993 = (0);
seq__40933_40974 = G__40990;
chunk__40934_40975 = G__40991;
count__40935_40976 = G__40992;
i__40936_40977 = G__40993;
continue;
} else {
var vec__40942_40994 = cljs.core.first(seq__40933_40988__$1);
var k__19293__auto___40995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40942_40994,(0),null);
var cb__19294__auto___40996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40942_40994,(1),null);
try{var G__40946_40997 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40973,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40996.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40996.cljs$core$IFn$_invoke$arity$1(G__40946_40997) : cb__19294__auto___40996.call(null,G__40946_40997));
}catch (e40945){if((e40945 instanceof java.lang.Exception)){
var e__19295__auto___40998 = e40945;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40995,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40998], 0));
} else {
throw e40945;

}
}
var G__40999 = cljs.core.next(seq__40933_40988__$1);
var G__41000 = null;
var G__41001 = (0);
var G__41002 = (0);
seq__40933_40974 = G__40999;
chunk__40934_40975 = G__41000;
count__40935_40976 = G__41001;
i__40936_40977 = G__41002;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_40932;
}} else {
var temp__5455__auto__ = re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(temp__5455__auto__)){
var cached = temp__5455__auto__;
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41003 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41003;

} else {
}

return cached;
} else {
var query_id = re_frame.utils.first_in_vector(query);
var handler_fn = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$2(re_frame.subs.kind,query_id);
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41004 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41004;

} else {
}

if((handler_fn == null)){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41005 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41005;

} else {
}

return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["re-frame: no subscription handler registered for: \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_id),"\". Returning a nil subscription."].join('')], 0));
} else {
return re_frame.subs.cache_and_return(query,cljs.core.PersistentVector.EMPTY,(handler_fn.cljs$core$IFn$_invoke$arity$2 ? handler_fn.cljs$core$IFn$_invoke$arity$2(re_frame.db.app_db,query) : handler_fn.call(null,re_frame.db.app_db,query)));
}
}
}
});

re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (query,dynv){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_40947 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,re_frame.utils.first_in_vector(query),cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$sub_SLASH_create,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$query_DASH_v,query,cljs.core.cst$kw$dyn_DASH_v,dynv], null)], null));

try{try{var temp__5455__auto__ = re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$2(query,dynv);
if(cljs.core.truth_(temp__5455__auto__)){
var cached = temp__5455__auto__;
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41006 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41006;

} else {
}

return cached;
} else {
var query_id = re_frame.utils.first_in_vector(query);
var handler_fn = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$2(re_frame.subs.kind,query_id);
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41007 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41007;

} else {
}

if(re_frame.interop.debug_enabled_QMARK_){
var temp__5457__auto___41008 = cljs.core.not_empty(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(re_frame.interop.ratom_QMARK_,dynv));
if(cljs.core.truth_(temp__5457__auto___41008)){
var not_reactive_41009 = temp__5457__auto___41008;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: your subscription's dynamic parameters that don't implement IReactiveAtom:",not_reactive_41009], 0));
} else {
}
} else {
}

if((handler_fn == null)){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41010 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41010;

} else {
}

return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["re-frame: no subscription handler registered for: \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_id),"\". Returning a nil subscription."].join('')], 0));
} else {
var dyn_vals = re_frame.interop.make_reaction(((function (query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947){
return (function (){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.deref,dynv);
});})(query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947))
);
var sub = re_frame.interop.make_reaction(((function (dyn_vals,query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947){
return (function (){
var G__40962 = re_frame.db.app_db;
var G__40963 = query;
var G__40964 = cljs.core.deref(dyn_vals);
return (handler_fn.cljs$core$IFn$_invoke$arity$3 ? handler_fn.cljs$core$IFn$_invoke$arity$3(G__40962,G__40963,G__40964) : handler_fn.call(null,G__40962,G__40963,G__40964));
});})(dyn_vals,query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947))
);
return re_frame.subs.cache_and_return(query,dynv,re_frame.interop.make_reaction(((function (dyn_vals,sub,query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947){
return (function (){
return cljs.core.deref(cljs.core.deref(sub));
});})(dyn_vals,sub,query_id,handler_fn,temp__5455__auto__,_STAR_current_trace_STAR_40947))
));
}
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___41011 = re_frame.interop.now();
var duration__19292__auto___41012 = (end__19291__auto___41011 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__40948_41013 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__40949_41014 = null;
var count__40950_41015 = (0);
var i__40951_41016 = (0);
while(true){
if((i__40951_41016 < count__40950_41015)){
var vec__40952_41017 = chunk__40949_41014.cljs$core$IIndexed$_nth$arity$2(null,i__40951_41016);
var k__19293__auto___41018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40952_41017,(0),null);
var cb__19294__auto___41019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40952_41017,(1),null);
try{var G__40956_41020 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41012,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41019.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41019.cljs$core$IFn$_invoke$arity$1(G__40956_41020) : cb__19294__auto___41019.call(null,G__40956_41020));
}catch (e40955){if((e40955 instanceof java.lang.Exception)){
var e__19295__auto___41021 = e40955;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41018,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41021], 0));
} else {
throw e40955;

}
}
var G__41022 = seq__40948_41013;
var G__41023 = chunk__40949_41014;
var G__41024 = count__40950_41015;
var G__41025 = (i__40951_41016 + (1));
seq__40948_41013 = G__41022;
chunk__40949_41014 = G__41023;
count__40950_41015 = G__41024;
i__40951_41016 = G__41025;
continue;
} else {
var temp__5457__auto___41026 = cljs.core.seq(seq__40948_41013);
if(temp__5457__auto___41026){
var seq__40948_41027__$1 = temp__5457__auto___41026;
if(cljs.core.chunked_seq_QMARK_(seq__40948_41027__$1)){
var c__9319__auto___41028 = cljs.core.chunk_first(seq__40948_41027__$1);
var G__41029 = cljs.core.chunk_rest(seq__40948_41027__$1);
var G__41030 = c__9319__auto___41028;
var G__41031 = cljs.core.count(c__9319__auto___41028);
var G__41032 = (0);
seq__40948_41013 = G__41029;
chunk__40949_41014 = G__41030;
count__40950_41015 = G__41031;
i__40951_41016 = G__41032;
continue;
} else {
var vec__40957_41033 = cljs.core.first(seq__40948_41027__$1);
var k__19293__auto___41034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40957_41033,(0),null);
var cb__19294__auto___41035 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40957_41033,(1),null);
try{var G__40961_41036 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41012,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41035.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41035.cljs$core$IFn$_invoke$arity$1(G__40961_41036) : cb__19294__auto___41035.call(null,G__40961_41036));
}catch (e40960){if((e40960 instanceof java.lang.Exception)){
var e__19295__auto___41037 = e40960;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41034,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41037], 0));
} else {
throw e40960;

}
}
var G__41038 = cljs.core.next(seq__40948_41027__$1);
var G__41039 = null;
var G__41040 = (0);
var G__41041 = (0);
seq__40948_41013 = G__41038;
chunk__40949_41014 = G__41039;
count__40950_41015 = G__41040;
i__40951_41016 = G__41041;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_40947;
}} else {
var temp__5455__auto__ = re_frame.subs.cache_lookup.cljs$core$IFn$_invoke$arity$2(query,dynv);
if(cljs.core.truth_(temp__5455__auto__)){
var cached = temp__5455__auto__;
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41042 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cached_QMARK_,true,cljs.core.cst$kw$reaction,re_frame.interop.reagent_id(cached)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41042;

} else {
}

return cached;
} else {
var query_id = re_frame.utils.first_in_vector(query);
var handler_fn = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$2(re_frame.subs.kind,query_id);
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41043 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cached_QMARK_,false], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41043;

} else {
}

if(re_frame.interop.debug_enabled_QMARK_){
var temp__5457__auto___41044 = cljs.core.not_empty(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(re_frame.interop.ratom_QMARK_,dynv));
if(cljs.core.truth_(temp__5457__auto___41044)){
var not_reactive_41045 = temp__5457__auto___41044;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: your subscription's dynamic parameters that don't implement IReactiveAtom:",not_reactive_41045], 0));
} else {
}
} else {
}

if((handler_fn == null)){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41046 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,true], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41046;

} else {
}

return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["re-frame: no subscription handler registered for: \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_id),"\". Returning a nil subscription."].join('')], 0));
} else {
var dyn_vals = re_frame.interop.make_reaction(((function (query_id,handler_fn,temp__5455__auto__){
return (function (){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.deref,dynv);
});})(query_id,handler_fn,temp__5455__auto__))
);
var sub = re_frame.interop.make_reaction(((function (dyn_vals,query_id,handler_fn,temp__5455__auto__){
return (function (){
var G__40965 = re_frame.db.app_db;
var G__40966 = query;
var G__40967 = cljs.core.deref(dyn_vals);
return (handler_fn.cljs$core$IFn$_invoke$arity$3 ? handler_fn.cljs$core$IFn$_invoke$arity$3(G__40965,G__40966,G__40967) : handler_fn.call(null,G__40965,G__40966,G__40967));
});})(dyn_vals,query_id,handler_fn,temp__5455__auto__))
);
return re_frame.subs.cache_and_return(query,dynv,re_frame.interop.make_reaction(((function (dyn_vals,sub,query_id,handler_fn,temp__5455__auto__){
return (function (){
return cljs.core.deref(cljs.core.deref(sub));
});})(dyn_vals,sub,query_id,handler_fn,temp__5455__auto__))
));
}
}
}
});

re_frame.subs.subscribe.cljs$lang$maxFixedArity = 2;

/**
 * Returns a new version of 'm' in which 'f' has been applied to each value.
 *   (map-vals inc {:a 4, :b 2}) => {:a 5, :b 3}
 */
re_frame.subs.map_vals = (function re_frame$subs$map_vals(f,m){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.empty(m),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p__41047){
var vec__41048 = p__41047;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41048,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41048,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v))], null);
})),m);
});
re_frame.subs.deref_input_signals = (function re_frame$subs$deref_input_signals(signals,query_id){
var signals__$1 = ((cljs.core.sequential_QMARK_(signals))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.deref,signals):((cljs.core.map_QMARK_(signals))?re_frame.subs.map_vals(cljs.core.deref,signals):(cljs.core.truth_(re_frame.interop.deref_QMARK_(signals))?cljs.core.deref(signals):re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: in the reg-sub for ",query_id,", the input-signals function returns: ",signals], 0))
)));
if(re_frame.trace.is_trace_enabled_QMARK_()){
var new_trace__19296__auto___41051 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.update.cljs$core$IFn$_invoke$arity$4(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$tags,cljs.core.merge,cljs.core.cst$kw$tags.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$input_DASH_signals,cljs.core.map.cljs$core$IFn$_invoke$arity$2(re_frame.interop.reagent_id,signals__$1)], null)], null))),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$input_DASH_signals,cljs.core.map.cljs$core$IFn$_invoke$arity$2(re_frame.interop.reagent_id,signals__$1)], null)], null),cljs.core.cst$kw$tags)], 0));
re_frame.trace._STAR_current_trace_STAR_ = new_trace__19296__auto___41051;

} else {
}

return signals__$1;
});
/**
 * For a given `query-id`, register a `computation` function and input `signals`.
 * 
 *   At an abstract level, a call to this function allows you to register 'the mechanism'
 *   to later fulfil a call to `(subscribe [query-id ...])`.
 * 
 *   To say that another way, reg-sub allows you to create a template for a node
 *   in the signal graph. But note: reg-sub does not cause a node to be created.
 *   It simply allows you to register the template from which such a
 *   node could be created, if it were needed, sometime later, when the call
 *   to `subscribe` is made.
 * 
 *   reg-sub needs three things:
 *  - a `query-id`
 *  - the required inputs for this node
 *  - a computation function for this node
 * 
 *   The `query-id` is always the 1st argument to reg-sub and it is typically
 *   a namespaced keyword.
 * 
 *   A computation function is always the last argument and it has this general form:
 *  `(input-signals, query-vector) -> a-value`
 * 
 *   What goes in between the 1st and last args can vary, but whatever is there will
 *   define the input signals part of the template, and, as a result, it will control
 *   what values the computation functions gets as a first argument.
 * 
 *   There's 3 ways this function can be called - 3 ways to supply input signals:
 * 
 *   1. No input signals given:
 * 
 *   (reg-sub
 *     :query-id
 *     a-computation-fn)   ;; (fn [db v]  ... a-value)
 * 
 *   The node's input signal defaults to `app-db`, and the value within `app-db` is
 *   is given as the 1st argument to the computation function.
 * 
 *   2. A signal function is supplied:
 * 
 *   (reg-sub
 *     :query-id
 *     signal-fn     ;; <-- here
 *     computation-fn)
 * 
 *   When a node is created from the template, the `signal-fn` will be called and it
 *   is expected to return the input signal(s) as either a singleton, if there is only
 *   one, or a sequence if there are many, or a map with the signals as the values.
 * 
 *   The values from the nominated signals will be supplied as the 1st argument to the
 *   computation function - either a singleton, sequence or map of them, paralleling
 *   the structure returned by the signal function.
 * 
 *   Here, is an example signal-fn, which returns a vector of input signals.
 * 
 *     (fn [query-vec dynamic-vec]
 *       [(subscribe [:a-sub])
 *        (subscribe [:b-sub])])
 * 
 *   For that signal function, the computation function must be written
 *   to expect a vector of values for its first argument.
 *     (fn [[a b] _] ....)
 * 
 *   If the signal function was simpler and returned a singleton, like this:
 *      (fn [query-vec dynamic-vec]
 *        (subscribe [:a-sub]))
 * 
 *   then the computation function must be written to expect a single value
 *   as the 1st argument:
 * 
 *      (fn [a _] ...)
 * 
 *   3. Syntax Sugar
 * 
 *   (reg-sub
 *     :a-b-sub
 *     :<- [:a-sub]
 *     :<- [:b-sub]
 *     (fn [[a b] [_]] {:a a :b b}))
 * 
 *   This 3rd variation is syntactic sugar for the 2nd. Pairs are supplied instead
 *   of an `input signals` functions. Each pair starts with a `:<-` and a subscription
 *   vector follows.
 * 
 *   For further understanding, read `/docs`, and look at the detailed comments in
 *   /examples/todomvc/src/subs.cljs
 *   
 */
re_frame.subs.reg_sub = (function re_frame$subs$reg_sub(var_args){
var args__9674__auto__ = [];
var len__9667__auto___41098 = arguments.length;
var i__9668__auto___41099 = (0);
while(true){
if((i__9668__auto___41099 < len__9667__auto___41098)){
args__9674__auto__.push((arguments[i__9668__auto___41099]));

var G__41100 = (i__9668__auto___41099 + (1));
i__9668__auto___41099 = G__41100;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return re_frame.subs.reg_sub.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

re_frame.subs.reg_sub.cljs$core$IFn$_invoke$arity$variadic = (function (query_id,args){
var computation_fn = cljs.core.last(args);
var input_args = cljs.core.butlast(args);
var err_header = ["re-frame: reg-sub for ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_id),", "].join('');
var inputs_fn = (function (){var G__41054 = cljs.core.count(input_args);
switch (G__41054) {
case (0):
return ((function (G__41054,computation_fn,input_args,err_header){
return (function() {
var G__41102 = null;
var G__41102__1 = (function (_){
return re_frame.db.app_db;
});
var G__41102__2 = (function (_,___$1){
return re_frame.db.app_db;
});
G__41102 = function(_,___$1){
switch(arguments.length){
case 1:
return G__41102__1.call(this,_);
case 2:
return G__41102__2.call(this,_,___$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__41102.cljs$core$IFn$_invoke$arity$1 = G__41102__1;
G__41102.cljs$core$IFn$_invoke$arity$2 = G__41102__2;
return G__41102;
})()
;})(G__41054,computation_fn,input_args,err_header))

break;
case (1):
var f = cljs.core.first(input_args);
if(cljs.core.fn_QMARK_(f)){
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([err_header,"2nd argument expected to be an inputs function, got:",f], 0));
}

return f;

break;
case (2):
var vec__41055 = input_args;
var marker = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41055,(0),null);
var vec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41055,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_LT__DASH_,marker)){
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([err_header,"expected :<-, got:",marker], 0));
}

return ((function (vec__41055,marker,vec,G__41054,computation_fn,input_args,err_header){
return (function() {
var re_frame$subs$inp_fn = null;
var re_frame$subs$inp_fn__1 = (function (_){
return re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$1(vec);
});
var re_frame$subs$inp_fn__2 = (function (_,___$1){
return re_frame.subs.subscribe.cljs$core$IFn$_invoke$arity$1(vec);
});
re_frame$subs$inp_fn = function(_,___$1){
switch(arguments.length){
case 1:
return re_frame$subs$inp_fn__1.call(this,_);
case 2:
return re_frame$subs$inp_fn__2.call(this,_,___$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_frame$subs$inp_fn.cljs$core$IFn$_invoke$arity$1 = re_frame$subs$inp_fn__1;
re_frame$subs$inp_fn.cljs$core$IFn$_invoke$arity$2 = re_frame$subs$inp_fn__2;
return re_frame$subs$inp_fn;
})()
;})(vec__41055,marker,vec,G__41054,computation_fn,input_args,err_header))

break;
default:
var pairs = cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),input_args);
var markers = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,pairs);
var vecs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.last,pairs);
if((cljs.core.every_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_LT__DASH_,null], null), null),markers)) && (cljs.core.every_QMARK_(cljs.core.vector_QMARK_,vecs))){
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([err_header,"expected pairs of :<- and vectors, got:",pairs], 0));
}

return ((function (pairs,markers,vecs,G__41054,computation_fn,input_args,err_header){
return (function() {
var re_frame$subs$inp_fn = null;
var re_frame$subs$inp_fn__1 = (function (_){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(re_frame.subs.subscribe,vecs);
});
var re_frame$subs$inp_fn__2 = (function (_,___$1){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(re_frame.subs.subscribe,vecs);
});
re_frame$subs$inp_fn = function(_,___$1){
switch(arguments.length){
case 1:
return re_frame$subs$inp_fn__1.call(this,_);
case 2:
return re_frame$subs$inp_fn__2.call(this,_,___$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_frame$subs$inp_fn.cljs$core$IFn$_invoke$arity$1 = re_frame$subs$inp_fn__1;
re_frame$subs$inp_fn.cljs$core$IFn$_invoke$arity$2 = re_frame$subs$inp_fn__2;
return re_frame$subs$inp_fn;
})()
;})(pairs,markers,vecs,G__41054,computation_fn,input_args,err_header))

}
})();
return re_frame.registrar.register_handler(re_frame.subs.kind,query_id,((function (computation_fn,input_args,err_header,inputs_fn){
return (function() {
var re_frame$subs$subs_handler_fn = null;
var re_frame$subs$subs_handler_fn__2 = (function (db,query_vec){
var subscriptions = (inputs_fn.cljs$core$IFn$_invoke$arity$1 ? inputs_fn.cljs$core$IFn$_invoke$arity$1(query_vec) : inputs_fn.call(null,query_vec));
var reaction_id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var reaction = re_frame.interop.make_reaction(((function (subscriptions,reaction_id,computation_fn,input_args,err_header,inputs_fn){
return (function (){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_41058 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,re_frame.utils.first_in_vector(query_vec),cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$sub_SLASH_run,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$query_DASH_v,query_vec,cljs.core.cst$kw$reaction,cljs.core.deref(reaction_id)], null)], null));

try{try{var G__41073 = re_frame.subs.deref_input_signals(subscriptions,query_id);
var G__41074 = query_vec;
return (computation_fn.cljs$core$IFn$_invoke$arity$2 ? computation_fn.cljs$core$IFn$_invoke$arity$2(G__41073,G__41074) : computation_fn.call(null,G__41073,G__41074));
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___41103 = re_frame.interop.now();
var duration__19292__auto___41104 = (end__19291__auto___41103 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__41059_41105 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__41060_41106 = null;
var count__41061_41107 = (0);
var i__41062_41108 = (0);
while(true){
if((i__41062_41108 < count__41061_41107)){
var vec__41063_41109 = chunk__41060_41106.cljs$core$IIndexed$_nth$arity$2(null,i__41062_41108);
var k__19293__auto___41110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41063_41109,(0),null);
var cb__19294__auto___41111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41063_41109,(1),null);
try{var G__41067_41112 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41104,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41111.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41111.cljs$core$IFn$_invoke$arity$1(G__41067_41112) : cb__19294__auto___41111.call(null,G__41067_41112));
}catch (e41066){if((e41066 instanceof java.lang.Exception)){
var e__19295__auto___41113 = e41066;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41110,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41113], 0));
} else {
throw e41066;

}
}
var G__41114 = seq__41059_41105;
var G__41115 = chunk__41060_41106;
var G__41116 = count__41061_41107;
var G__41117 = (i__41062_41108 + (1));
seq__41059_41105 = G__41114;
chunk__41060_41106 = G__41115;
count__41061_41107 = G__41116;
i__41062_41108 = G__41117;
continue;
} else {
var temp__5457__auto___41118 = cljs.core.seq(seq__41059_41105);
if(temp__5457__auto___41118){
var seq__41059_41119__$1 = temp__5457__auto___41118;
if(cljs.core.chunked_seq_QMARK_(seq__41059_41119__$1)){
var c__9319__auto___41120 = cljs.core.chunk_first(seq__41059_41119__$1);
var G__41121 = cljs.core.chunk_rest(seq__41059_41119__$1);
var G__41122 = c__9319__auto___41120;
var G__41123 = cljs.core.count(c__9319__auto___41120);
var G__41124 = (0);
seq__41059_41105 = G__41121;
chunk__41060_41106 = G__41122;
count__41061_41107 = G__41123;
i__41062_41108 = G__41124;
continue;
} else {
var vec__41068_41125 = cljs.core.first(seq__41059_41119__$1);
var k__19293__auto___41126 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41068_41125,(0),null);
var cb__19294__auto___41127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41068_41125,(1),null);
try{var G__41072_41128 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41104,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41127.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41127.cljs$core$IFn$_invoke$arity$1(G__41072_41128) : cb__19294__auto___41127.call(null,G__41072_41128));
}catch (e41071){if((e41071 instanceof java.lang.Exception)){
var e__19295__auto___41129 = e41071;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41126,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41129], 0));
} else {
throw e41071;

}
}
var G__41130 = cljs.core.next(seq__41059_41119__$1);
var G__41131 = null;
var G__41132 = (0);
var G__41133 = (0);
seq__41059_41105 = G__41130;
chunk__41060_41106 = G__41131;
count__41061_41107 = G__41132;
i__41062_41108 = G__41133;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_41058;
}} else {
var G__41075 = re_frame.subs.deref_input_signals(subscriptions,query_id);
var G__41076 = query_vec;
return (computation_fn.cljs$core$IFn$_invoke$arity$2 ? computation_fn.cljs$core$IFn$_invoke$arity$2(G__41075,G__41076) : computation_fn.call(null,G__41075,G__41076));
}
});})(subscriptions,reaction_id,computation_fn,input_args,err_header,inputs_fn))
);
cljs.core.reset_BANG_(reaction_id,re_frame.interop.reagent_id(reaction));

return reaction;
});
var re_frame$subs$subs_handler_fn__3 = (function (db,query_vec,dyn_vec){
var subscriptions = (inputs_fn.cljs$core$IFn$_invoke$arity$2 ? inputs_fn.cljs$core$IFn$_invoke$arity$2(query_vec,dyn_vec) : inputs_fn.call(null,query_vec,dyn_vec));
var reaction_id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var reaction = re_frame.interop.make_reaction(((function (subscriptions,reaction_id,computation_fn,input_args,err_header,inputs_fn){
return (function (){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_41077 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,re_frame.utils.first_in_vector(query_vec),cljs.core.cst$kw$op_DASH_type,cljs.core.cst$kw$sub_SLASH_run,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$query_DASH_v,query_vec,cljs.core.cst$kw$dyn_DASH_v,dyn_vec,cljs.core.cst$kw$reaction,cljs.core.deref(reaction_id)], null)], null));

try{try{var G__41092 = re_frame.subs.deref_input_signals(subscriptions,query_id);
var G__41093 = query_vec;
var G__41094 = dyn_vec;
return (computation_fn.cljs$core$IFn$_invoke$arity$3 ? computation_fn.cljs$core$IFn$_invoke$arity$3(G__41092,G__41093,G__41094) : computation_fn.call(null,G__41092,G__41093,G__41094));
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___41134 = re_frame.interop.now();
var duration__19292__auto___41135 = (end__19291__auto___41134 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__41078_41136 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__41079_41137 = null;
var count__41080_41138 = (0);
var i__41081_41139 = (0);
while(true){
if((i__41081_41139 < count__41080_41138)){
var vec__41082_41140 = chunk__41079_41137.cljs$core$IIndexed$_nth$arity$2(null,i__41081_41139);
var k__19293__auto___41141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41082_41140,(0),null);
var cb__19294__auto___41142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41082_41140,(1),null);
try{var G__41086_41143 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41135,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41142.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41142.cljs$core$IFn$_invoke$arity$1(G__41086_41143) : cb__19294__auto___41142.call(null,G__41086_41143));
}catch (e41085){if((e41085 instanceof java.lang.Exception)){
var e__19295__auto___41144 = e41085;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41141,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41144], 0));
} else {
throw e41085;

}
}
var G__41145 = seq__41078_41136;
var G__41146 = chunk__41079_41137;
var G__41147 = count__41080_41138;
var G__41148 = (i__41081_41139 + (1));
seq__41078_41136 = G__41145;
chunk__41079_41137 = G__41146;
count__41080_41138 = G__41147;
i__41081_41139 = G__41148;
continue;
} else {
var temp__5457__auto___41149 = cljs.core.seq(seq__41078_41136);
if(temp__5457__auto___41149){
var seq__41078_41150__$1 = temp__5457__auto___41149;
if(cljs.core.chunked_seq_QMARK_(seq__41078_41150__$1)){
var c__9319__auto___41151 = cljs.core.chunk_first(seq__41078_41150__$1);
var G__41152 = cljs.core.chunk_rest(seq__41078_41150__$1);
var G__41153 = c__9319__auto___41151;
var G__41154 = cljs.core.count(c__9319__auto___41151);
var G__41155 = (0);
seq__41078_41136 = G__41152;
chunk__41079_41137 = G__41153;
count__41080_41138 = G__41154;
i__41081_41139 = G__41155;
continue;
} else {
var vec__41087_41156 = cljs.core.first(seq__41078_41150__$1);
var k__19293__auto___41157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41087_41156,(0),null);
var cb__19294__auto___41158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41087_41156,(1),null);
try{var G__41091_41159 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___41135,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___41158.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___41158.cljs$core$IFn$_invoke$arity$1(G__41091_41159) : cb__19294__auto___41158.call(null,G__41091_41159));
}catch (e41090){if((e41090 instanceof java.lang.Exception)){
var e__19295__auto___41160 = e41090;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___41157,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___41160], 0));
} else {
throw e41090;

}
}
var G__41161 = cljs.core.next(seq__41078_41150__$1);
var G__41162 = null;
var G__41163 = (0);
var G__41164 = (0);
seq__41078_41136 = G__41161;
chunk__41079_41137 = G__41162;
count__41080_41138 = G__41163;
i__41081_41139 = G__41164;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_41077;
}} else {
var G__41095 = re_frame.subs.deref_input_signals(subscriptions,query_id);
var G__41096 = query_vec;
var G__41097 = dyn_vec;
return (computation_fn.cljs$core$IFn$_invoke$arity$3 ? computation_fn.cljs$core$IFn$_invoke$arity$3(G__41095,G__41096,G__41097) : computation_fn.call(null,G__41095,G__41096,G__41097));
}
});})(subscriptions,reaction_id,computation_fn,input_args,err_header,inputs_fn))
);
cljs.core.reset_BANG_(reaction_id,re_frame.interop.reagent_id(reaction));

return reaction;
});
re_frame$subs$subs_handler_fn = function(db,query_vec,dyn_vec){
switch(arguments.length){
case 2:
return re_frame$subs$subs_handler_fn__2.call(this,db,query_vec);
case 3:
return re_frame$subs$subs_handler_fn__3.call(this,db,query_vec,dyn_vec);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
re_frame$subs$subs_handler_fn.cljs$core$IFn$_invoke$arity$2 = re_frame$subs$subs_handler_fn__2;
re_frame$subs$subs_handler_fn.cljs$core$IFn$_invoke$arity$3 = re_frame$subs$subs_handler_fn__3;
return re_frame$subs$subs_handler_fn;
})()
;})(computation_fn,input_args,err_header,inputs_fn))
);
});

re_frame.subs.reg_sub.cljs$lang$maxFixedArity = (1);

re_frame.subs.reg_sub.cljs$lang$applyTo = (function (seq41052){
var G__41053 = cljs.core.first(seq41052);
var seq41052__$1 = cljs.core.next(seq41052);
return re_frame.subs.reg_sub.cljs$core$IFn$_invoke$arity$variadic(G__41053,seq41052__$1);
});

