// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
var seq__40632 = cljs.core.seq(cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context));
var chunk__40633 = null;
var count__40634 = (0);
var i__40635 = (0);
while(true){
if((i__40635 < count__40634)){
var vec__40636 = chunk__40633.cljs$core$IIndexed$_nth$arity$2(null,i__40635);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40636,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40636,(1),null);
var temp__5455__auto___40642 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___40642)){
var effect_fn_40643 = temp__5455__auto___40642;
(effect_fn_40643.cljs$core$IFn$_invoke$arity$1 ? effect_fn_40643.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_40643.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring."], 0));
}

var G__40644 = seq__40632;
var G__40645 = chunk__40633;
var G__40646 = count__40634;
var G__40647 = (i__40635 + (1));
seq__40632 = G__40644;
chunk__40633 = G__40645;
count__40634 = G__40646;
i__40635 = G__40647;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40632);
if(temp__5457__auto__){
var seq__40632__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40632__$1)){
var c__9319__auto__ = cljs.core.chunk_first(seq__40632__$1);
var G__40648 = cljs.core.chunk_rest(seq__40632__$1);
var G__40649 = c__9319__auto__;
var G__40650 = cljs.core.count(c__9319__auto__);
var G__40651 = (0);
seq__40632 = G__40648;
chunk__40633 = G__40649;
count__40634 = G__40650;
i__40635 = G__40651;
continue;
} else {
var vec__40639 = cljs.core.first(seq__40632__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40639,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40639,(1),null);
var temp__5455__auto___40652 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___40652)){
var effect_fn_40653 = temp__5455__auto___40652;
(effect_fn_40653.cljs$core$IFn$_invoke$arity$1 ? effect_fn_40653.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_40653.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring."], 0));
}

var G__40654 = cljs.core.next(seq__40632__$1);
var G__40655 = null;
var G__40656 = (0);
var G__40657 = (0);
seq__40632 = G__40654;
chunk__40633 = G__40655;
count__40634 = G__40656;
i__40635 = G__40657;
continue;
}
} else {
return null;
}
}
break;
}
})], 0));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_later,(function (value){
var seq__40658 = cljs.core.seq(value);
var chunk__40659 = null;
var count__40660 = (0);
var i__40661 = (0);
while(true){
if((i__40661 < count__40660)){
var map__40662 = chunk__40659.cljs$core$IIndexed$_nth$arity$2(null,i__40661);
var map__40662__$1 = ((((!((map__40662 == null)))?((((map__40662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40662.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40662):map__40662);
var effect = map__40662__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40662__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40662__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__40658,chunk__40659,count__40660,i__40661,map__40662,map__40662__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__40658,chunk__40659,count__40660,i__40661,map__40662,map__40662__$1,effect,ms,dispatch))
,ms);
}

var G__40666 = seq__40658;
var G__40667 = chunk__40659;
var G__40668 = count__40660;
var G__40669 = (i__40661 + (1));
seq__40658 = G__40666;
chunk__40659 = G__40667;
count__40660 = G__40668;
i__40661 = G__40669;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40658);
if(temp__5457__auto__){
var seq__40658__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40658__$1)){
var c__9319__auto__ = cljs.core.chunk_first(seq__40658__$1);
var G__40670 = cljs.core.chunk_rest(seq__40658__$1);
var G__40671 = c__9319__auto__;
var G__40672 = cljs.core.count(c__9319__auto__);
var G__40673 = (0);
seq__40658 = G__40670;
chunk__40659 = G__40671;
count__40660 = G__40672;
i__40661 = G__40673;
continue;
} else {
var map__40664 = cljs.core.first(seq__40658__$1);
var map__40664__$1 = ((((!((map__40664 == null)))?((((map__40664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40664.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40664):map__40664);
var effect = map__40664__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40664__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40664__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__40658,chunk__40659,count__40660,i__40661,map__40664,map__40664__$1,effect,ms,dispatch,seq__40658__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__40658,chunk__40659,count__40660,i__40661,map__40664,map__40664__$1,effect,ms,dispatch,seq__40658__$1,temp__5457__auto__))
,ms);
}

var G__40674 = cljs.core.next(seq__40658__$1);
var G__40675 = null;
var G__40676 = (0);
var G__40677 = (0);
seq__40658 = G__40674;
chunk__40659 = G__40675;
count__40660 = G__40676;
i__40661 = G__40677;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch,(function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$dispatch_DASH_n,(function (value){
if(!(cljs.core.sequential_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value], 0));
} else {
var seq__40678 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__40679 = null;
var count__40680 = (0);
var i__40681 = (0);
while(true){
if((i__40681 < count__40680)){
var event = chunk__40679.cljs$core$IIndexed$_nth$arity$2(null,i__40681);
re_frame.router.dispatch(event);

var G__40682 = seq__40678;
var G__40683 = chunk__40679;
var G__40684 = count__40680;
var G__40685 = (i__40681 + (1));
seq__40678 = G__40682;
chunk__40679 = G__40683;
count__40680 = G__40684;
i__40681 = G__40685;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40678);
if(temp__5457__auto__){
var seq__40678__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40678__$1)){
var c__9319__auto__ = cljs.core.chunk_first(seq__40678__$1);
var G__40686 = cljs.core.chunk_rest(seq__40678__$1);
var G__40687 = c__9319__auto__;
var G__40688 = cljs.core.count(c__9319__auto__);
var G__40689 = (0);
seq__40678 = G__40686;
chunk__40679 = G__40687;
count__40680 = G__40688;
i__40681 = G__40689;
continue;
} else {
var event = cljs.core.first(seq__40678__$1);
re_frame.router.dispatch(event);

var G__40690 = cljs.core.next(seq__40678__$1);
var G__40691 = null;
var G__40692 = (0);
var G__40693 = (0);
seq__40678 = G__40690;
chunk__40679 = G__40691;
count__40680 = G__40692;
i__40681 = G__40693;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$deregister_DASH_event_DASH_handler,(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__40694 = cljs.core.seq(value);
var chunk__40695 = null;
var count__40696 = (0);
var i__40697 = (0);
while(true){
if((i__40697 < count__40696)){
var event = chunk__40695.cljs$core$IIndexed$_nth$arity$2(null,i__40697);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__40698 = seq__40694;
var G__40699 = chunk__40695;
var G__40700 = count__40696;
var G__40701 = (i__40697 + (1));
seq__40694 = G__40698;
chunk__40695 = G__40699;
count__40696 = G__40700;
i__40697 = G__40701;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__40694);
if(temp__5457__auto__){
var seq__40694__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__40694__$1)){
var c__9319__auto__ = cljs.core.chunk_first(seq__40694__$1);
var G__40702 = cljs.core.chunk_rest(seq__40694__$1);
var G__40703 = c__9319__auto__;
var G__40704 = cljs.core.count(c__9319__auto__);
var G__40705 = (0);
seq__40694 = G__40702;
chunk__40695 = G__40703;
count__40696 = G__40704;
i__40697 = G__40705;
continue;
} else {
var event = cljs.core.first(seq__40694__$1);
(clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(event) : clear_event.call(null,event));

var G__40706 = cljs.core.next(seq__40694__$1);
var G__40707 = null;
var G__40708 = (0);
var G__40709 = (0);
seq__40694 = G__40706;
chunk__40695 = G__40707;
count__40696 = G__40708;
i__40697 = G__40709;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
}));
re_frame.fx.reg_fx(cljs.core.cst$kw$db,(function (value){
if(!((cljs.core.deref(re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));
