// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = cljs.core.cst$kw$event;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.events.kind) : re_frame.registrar.kinds.call(null,re_frame.events.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__40355_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.flatten(p1__40355_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain(interceptors);
} else {
if(cljs.core.coll_QMARK_(interceptors)){
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors], 0));
}

var chain = make_chain(interceptors);
if(cljs.core.empty_QMARK_(chain)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", given an empty interceptor chain"], 0));
} else {
}

var temp__5457__auto___40356 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___40356)){
var not_i_40357 = temp__5457__auto___40356;
if(cljs.core.fn_QMARK_(not_i_40357)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_40357], 0));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: when registering ",id,", expected interceptors, but got: ",not_i_40357], 0));
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler(re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils(id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector(event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler."], 0));
} else {
var _STAR_handling_STAR_40358 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR_40359 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$operation,event_id,cljs.core.cst$kw$op_DASH_type,re_frame.events.kind,cljs.core.cst$kw$tags,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$event,event_v], null)], null));

try{try{return re_frame.interceptor.execute(event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__19291__auto___40374 = re_frame.interop.now();
var duration__19292__auto___40375 = (end__19291__auto___40374 - cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__40360_40376 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__40361_40377 = null;
var count__40362_40378 = (0);
var i__40363_40379 = (0);
while(true){
if((i__40363_40379 < count__40362_40378)){
var vec__40364_40380 = chunk__40361_40377.cljs$core$IIndexed$_nth$arity$2(null,i__40363_40379);
var k__19293__auto___40381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40364_40380,(0),null);
var cb__19294__auto___40382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40364_40380,(1),null);
try{var G__40368_40383 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40375,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40382.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40382.cljs$core$IFn$_invoke$arity$1(G__40368_40383) : cb__19294__auto___40382.call(null,G__40368_40383));
}catch (e40367){if((e40367 instanceof java.lang.Exception)){
var e__19295__auto___40384 = e40367;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40381,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40384], 0));
} else {
throw e40367;

}
}
var G__40385 = seq__40360_40376;
var G__40386 = chunk__40361_40377;
var G__40387 = count__40362_40378;
var G__40388 = (i__40363_40379 + (1));
seq__40360_40376 = G__40385;
chunk__40361_40377 = G__40386;
count__40362_40378 = G__40387;
i__40363_40379 = G__40388;
continue;
} else {
var temp__5457__auto___40389 = cljs.core.seq(seq__40360_40376);
if(temp__5457__auto___40389){
var seq__40360_40390__$1 = temp__5457__auto___40389;
if(cljs.core.chunked_seq_QMARK_(seq__40360_40390__$1)){
var c__9319__auto___40391 = cljs.core.chunk_first(seq__40360_40390__$1);
var G__40392 = cljs.core.chunk_rest(seq__40360_40390__$1);
var G__40393 = c__9319__auto___40391;
var G__40394 = cljs.core.count(c__9319__auto___40391);
var G__40395 = (0);
seq__40360_40376 = G__40392;
chunk__40361_40377 = G__40393;
count__40362_40378 = G__40394;
i__40363_40379 = G__40395;
continue;
} else {
var vec__40369_40396 = cljs.core.first(seq__40360_40390__$1);
var k__19293__auto___40397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40369_40396,(0),null);
var cb__19294__auto___40398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40369_40396,(1),null);
try{var G__40373_40399 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,cljs.core.cst$kw$duration,duration__19292__auto___40375,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$end,re_frame.interop.now()], 0))], null);
(cb__19294__auto___40398.cljs$core$IFn$_invoke$arity$1 ? cb__19294__auto___40398.cljs$core$IFn$_invoke$arity$1(G__40373_40399) : cb__19294__auto___40398.call(null,G__40373_40399));
}catch (e40372){if((e40372 instanceof java.lang.Exception)){
var e__19295__auto___40400 = e40372;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k__19293__auto___40397,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___40400], 0));
} else {
throw e40372;

}
}
var G__40401 = cljs.core.next(seq__40360_40390__$1);
var G__40402 = null;
var G__40403 = (0);
var G__40404 = (0);
seq__40360_40376 = G__40401;
chunk__40361_40377 = G__40402;
count__40362_40378 = G__40403;
i__40363_40379 = G__40404;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_40359;
}} else {
return re_frame.interceptor.execute(event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_40358;
}}
} else {
return null;
}
});
