// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__40717){
var vec__40718 = p__40717;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40718,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40718,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__40721 = (clojure.data.diff.cljs$core$IFn$_invoke$arity$2 ? clojure.data.diff.cljs$core$IFn$_invoke$arity$2(va,vb) : clojure.data.diff.call(null,va,vb));
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40721,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40721,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40721,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = (in_a) && (in_b) && ((!((ab == null))) || (((va == null)) && ((vb == null))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((in_a) && ((!((a_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),(((in_b) && ((!((b_STAR_ == null))) || (!(same))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__40725 = arguments.length;
switch (G__40725) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__8740__auto__ = cljs.core.count(a);
var y__8741__auto__ = cljs.core.count(b);
return ((x__8740__auto__ > y__8741__auto__) ? x__8740__auto__ : y__8741__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((!((x == null))) && (!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__9121__auto__ = (((x == null))?null:x);
var m__9122__auto__ = (clojure.data.equality_partition[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__9122__auto__.call(null,x));
} else {
var m__9122__auto____$1 = (clojure.data.equality_partition["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__9122__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((!((a == null))) && (!((a.clojure$data$Diff$diff_similar$arity$2 == null)))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__9121__auto__ = (((a == null))?null:a);
var m__9122__auto__ = (clojure.data.diff_similar[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__9122__auto__.call(null,a,b));
} else {
var m__9122__auto____$1 = (clojure.data.diff_similar["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(a,b) : m__9122__auto____$1.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__40727_40751 = clojure.data.equality_partition;
var G__40728_40752 = "null";
var G__40729_40753 = ((function (G__40727_40751,G__40728_40752){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__40727_40751,G__40728_40752))
;
goog.object.set(G__40727_40751,G__40728_40752,G__40729_40753);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__40730_40754 = clojure.data.equality_partition;
var G__40731_40755 = "string";
var G__40732_40756 = ((function (G__40730_40754,G__40731_40755){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__40730_40754,G__40731_40755))
;
goog.object.set(G__40730_40754,G__40731_40755,G__40732_40756);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__40733_40757 = clojure.data.equality_partition;
var G__40734_40758 = "number";
var G__40735_40759 = ((function (G__40733_40757,G__40734_40758){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__40733_40757,G__40734_40758))
;
goog.object.set(G__40733_40757,G__40734_40758,G__40735_40759);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__40736_40760 = clojure.data.equality_partition;
var G__40737_40761 = "array";
var G__40738_40762 = ((function (G__40736_40760,G__40737_40761){
return (function (x){
return cljs.core.cst$kw$sequential;
});})(G__40736_40760,G__40737_40761))
;
goog.object.set(G__40736_40760,G__40737_40761,G__40738_40762);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__40739_40763 = clojure.data.equality_partition;
var G__40740_40764 = "function";
var G__40741_40765 = ((function (G__40739_40763,G__40740_40764){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__40739_40763,G__40740_40764))
;
goog.object.set(G__40739_40763,G__40740_40764,G__40741_40765);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__40742_40766 = clojure.data.equality_partition;
var G__40743_40767 = "boolean";
var G__40744_40768 = ((function (G__40742_40766,G__40743_40767){
return (function (x){
return cljs.core.cst$kw$atom;
});})(G__40742_40766,G__40743_40767))
;
goog.object.set(G__40742_40766,G__40743_40767,G__40744_40768);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__40745_40769 = clojure.data.equality_partition;
var G__40746_40770 = "_";
var G__40747_40771 = ((function (G__40745_40769,G__40746_40770){
return (function (x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return cljs.core.cst$kw$map;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return cljs.core.cst$kw$set;
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return cljs.core.cst$kw$sequential;
} else {
return cljs.core.cst$kw$atom;

}
}
}
});})(G__40745_40769,G__40746_40770))
;
goog.object.set(G__40745_40769,G__40746_40770,G__40747_40771);
goog.object.set(clojure.data.Diff,"null",true);

var G__40772_40796 = clojure.data.diff_similar;
var G__40773_40797 = "null";
var G__40774_40798 = ((function (G__40772_40796,G__40773_40797){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__40772_40796,G__40773_40797))
;
goog.object.set(G__40772_40796,G__40773_40797,G__40774_40798);

goog.object.set(clojure.data.Diff,"string",true);

var G__40775_40799 = clojure.data.diff_similar;
var G__40776_40800 = "string";
var G__40777_40801 = ((function (G__40775_40799,G__40776_40800){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__40775_40799,G__40776_40800))
;
goog.object.set(G__40775_40799,G__40776_40800,G__40777_40801);

goog.object.set(clojure.data.Diff,"number",true);

var G__40778_40802 = clojure.data.diff_similar;
var G__40779_40803 = "number";
var G__40780_40804 = ((function (G__40778_40802,G__40779_40803){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__40778_40802,G__40779_40803))
;
goog.object.set(G__40778_40802,G__40779_40803,G__40780_40804);

goog.object.set(clojure.data.Diff,"array",true);

var G__40781_40805 = clojure.data.diff_similar;
var G__40782_40806 = "array";
var G__40783_40807 = ((function (G__40781_40805,G__40782_40806){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__40781_40805,G__40782_40806))
;
goog.object.set(G__40781_40805,G__40782_40806,G__40783_40807);

goog.object.set(clojure.data.Diff,"function",true);

var G__40784_40808 = clojure.data.diff_similar;
var G__40785_40809 = "function";
var G__40786_40810 = ((function (G__40784_40808,G__40785_40809){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__40784_40808,G__40785_40809))
;
goog.object.set(G__40784_40808,G__40785_40809,G__40786_40810);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__40787_40811 = clojure.data.diff_similar;
var G__40788_40812 = "boolean";
var G__40789_40813 = ((function (G__40787_40811,G__40788_40812){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__40787_40811,G__40788_40812))
;
goog.object.set(G__40787_40811,G__40788_40812,G__40789_40813);

goog.object.set(clojure.data.Diff,"_",true);

var G__40790_40814 = clojure.data.diff_similar;
var G__40791_40815 = "_";
var G__40792_40816 = ((function (G__40790_40814,G__40791_40815){
return (function (a,b){
var fexpr__40794 = (function (){var G__40795 = clojure.data.equality_partition(a);
var G__40795__$1 = (((G__40795 instanceof cljs.core.Keyword))?G__40795.fqn:null);
switch (G__40795__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40795__$1)].join('')));

}
})();
return (fexpr__40794.cljs$core$IFn$_invoke$arity$2 ? fexpr__40794.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__40794.call(null,a,b));
});})(G__40790_40814,G__40791_40815))
;
goog.object.set(G__40790_40814,G__40791_40815,G__40792_40816);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});
