// Compiled by ClojureScript 1.9.946 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__41329 = arguments.length;
switch (G__41329) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async41330 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41330 = (function (f,blockable,meta41331){
this.f = f;
this.blockable = blockable;
this.meta41331 = meta41331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41332,meta41331__$1){
var self__ = this;
var _41332__$1 = this;
return (new cljs.core.async.t_cljs$core$async41330(self__.f,self__.blockable,meta41331__$1));
});

cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41332){
var self__ = this;
var _41332__$1 = this;
return self__.meta41331;
});

cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async41330.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async41330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta41331], null);
});

cljs.core.async.t_cljs$core$async41330.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41330";

cljs.core.async.t_cljs$core$async41330.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async41330");
});

cljs.core.async.__GT_t_cljs$core$async41330 = (function cljs$core$async$__GT_t_cljs$core$async41330(f__$1,blockable__$1,meta41331){
return (new cljs.core.async.t_cljs$core$async41330(f__$1,blockable__$1,meta41331));
});

}

return (new cljs.core.async.t_cljs$core$async41330(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__41336 = arguments.length;
switch (G__41336) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__41339 = arguments.length;
switch (G__41339) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__41342 = arguments.length;
switch (G__41342) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_41344 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41344) : fn1.call(null,val_41344));
} else {
cljs.core.async.impl.dispatch.run(((function (val_41344,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_41344) : fn1.call(null,val_41344));
});})(val_41344,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__41346 = arguments.length;
switch (G__41346) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9433__auto___41348 = n;
var x_41349 = (0);
while(true){
if((x_41349 < n__9433__auto___41348)){
(a[x_41349] = (0));

var G__41350 = (x_41349 + (1));
x_41349 = G__41350;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__41351 = (i + (1));
i = G__41351;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if(typeof cljs.core.async.t_cljs$core$async41352 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41352 = (function (flag,meta41353){
this.flag = flag;
this.meta41353 = meta41353;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_41354,meta41353__$1){
var self__ = this;
var _41354__$1 = this;
return (new cljs.core.async.t_cljs$core$async41352(self__.flag,meta41353__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_41354){
var self__ = this;
var _41354__$1 = this;
return self__.meta41353;
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta41353], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async41352.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41352.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41352";

cljs.core.async.t_cljs$core$async41352.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async41352");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async41352 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async41352(flag__$1,meta41353){
return (new cljs.core.async.t_cljs$core$async41352(flag__$1,meta41353));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async41352(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async41355 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41355 = (function (flag,cb,meta41356){
this.flag = flag;
this.cb = cb;
this.meta41356 = meta41356;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_41357,meta41356__$1){
var self__ = this;
var _41357__$1 = this;
return (new cljs.core.async.t_cljs$core$async41355(self__.flag,self__.cb,meta41356__$1));
});

cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_41357){
var self__ = this;
var _41357__$1 = this;
return self__.meta41356;
});

cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async41355.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async41355.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta41356], null);
});

cljs.core.async.t_cljs$core$async41355.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41355.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41355";

cljs.core.async.t_cljs$core$async41355.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async41355");
});

cljs.core.async.__GT_t_cljs$core$async41355 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async41355(flag__$1,cb__$1,meta41356){
return (new cljs.core.async.t_cljs$core$async41355(flag__$1,cb__$1,meta41356));
});

}

return (new cljs.core.async.t_cljs$core$async41355(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__41358_SHARP_){
var G__41360 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41358_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__41360) : fret.call(null,G__41360));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__41359_SHARP_){
var G__41361 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__41359_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__41361) : fret.call(null,G__41361));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__8388__auto__ = wport;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return port;
}
})()], null));
} else {
var G__41362 = (i + (1));
i = G__41362;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8388__auto__ = ret;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__8376__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___41368 = arguments.length;
var i__9668__auto___41369 = (0);
while(true){
if((i__9668__auto___41369 < len__9667__auto___41368)){
args__9674__auto__.push((arguments[i__9668__auto___41369]));

var G__41370 = (i__9668__auto___41369 + (1));
i__9668__auto___41369 = G__41370;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__41365){
var map__41366 = p__41365;
var map__41366__$1 = ((((!((map__41366 == null)))?((((map__41366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41366.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41366):map__41366);
var opts = map__41366__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq41363){
var G__41364 = cljs.core.first(seq41363);
var seq41363__$1 = cljs.core.next(seq41363);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__41364,seq41363__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__41372 = arguments.length;
switch (G__41372) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16273__auto___41418 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___41418){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___41418){
return (function (state_41396){
var state_val_41397 = (state_41396[(1)]);
if((state_val_41397 === (7))){
var inst_41392 = (state_41396[(2)]);
var state_41396__$1 = state_41396;
var statearr_41398_41419 = state_41396__$1;
(statearr_41398_41419[(2)] = inst_41392);

(statearr_41398_41419[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (1))){
var state_41396__$1 = state_41396;
var statearr_41399_41420 = state_41396__$1;
(statearr_41399_41420[(2)] = null);

(statearr_41399_41420[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (4))){
var inst_41375 = (state_41396[(7)]);
var inst_41375__$1 = (state_41396[(2)]);
var inst_41376 = (inst_41375__$1 == null);
var state_41396__$1 = (function (){var statearr_41400 = state_41396;
(statearr_41400[(7)] = inst_41375__$1);

return statearr_41400;
})();
if(cljs.core.truth_(inst_41376)){
var statearr_41401_41421 = state_41396__$1;
(statearr_41401_41421[(1)] = (5));

} else {
var statearr_41402_41422 = state_41396__$1;
(statearr_41402_41422[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (13))){
var state_41396__$1 = state_41396;
var statearr_41403_41423 = state_41396__$1;
(statearr_41403_41423[(2)] = null);

(statearr_41403_41423[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (6))){
var inst_41375 = (state_41396[(7)]);
var state_41396__$1 = state_41396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41396__$1,(11),to,inst_41375);
} else {
if((state_val_41397 === (3))){
var inst_41394 = (state_41396[(2)]);
var state_41396__$1 = state_41396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41396__$1,inst_41394);
} else {
if((state_val_41397 === (12))){
var state_41396__$1 = state_41396;
var statearr_41404_41424 = state_41396__$1;
(statearr_41404_41424[(2)] = null);

(statearr_41404_41424[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (2))){
var state_41396__$1 = state_41396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41396__$1,(4),from);
} else {
if((state_val_41397 === (11))){
var inst_41385 = (state_41396[(2)]);
var state_41396__$1 = state_41396;
if(cljs.core.truth_(inst_41385)){
var statearr_41405_41425 = state_41396__$1;
(statearr_41405_41425[(1)] = (12));

} else {
var statearr_41406_41426 = state_41396__$1;
(statearr_41406_41426[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (9))){
var state_41396__$1 = state_41396;
var statearr_41407_41427 = state_41396__$1;
(statearr_41407_41427[(2)] = null);

(statearr_41407_41427[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (5))){
var state_41396__$1 = state_41396;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41408_41428 = state_41396__$1;
(statearr_41408_41428[(1)] = (8));

} else {
var statearr_41409_41429 = state_41396__$1;
(statearr_41409_41429[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (14))){
var inst_41390 = (state_41396[(2)]);
var state_41396__$1 = state_41396;
var statearr_41410_41430 = state_41396__$1;
(statearr_41410_41430[(2)] = inst_41390);

(statearr_41410_41430[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (10))){
var inst_41382 = (state_41396[(2)]);
var state_41396__$1 = state_41396;
var statearr_41411_41431 = state_41396__$1;
(statearr_41411_41431[(2)] = inst_41382);

(statearr_41411_41431[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41397 === (8))){
var inst_41379 = cljs.core.async.close_BANG_(to);
var state_41396__$1 = state_41396;
var statearr_41412_41432 = state_41396__$1;
(statearr_41412_41432[(2)] = inst_41379);

(statearr_41412_41432[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___41418))
;
return ((function (switch__16183__auto__,c__16273__auto___41418){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_41413 = [null,null,null,null,null,null,null,null];
(statearr_41413[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_41413[(1)] = (1));

return statearr_41413;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_41396){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41396);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41414){if((e41414 instanceof Object)){
var ex__16187__auto__ = e41414;
var statearr_41415_41433 = state_41396;
(statearr_41415_41433[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41396);

return cljs.core.cst$kw$recur;
} else {
throw e41414;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41434 = state_41396;
state_41396 = G__41434;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_41396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_41396);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___41418))
})();
var state__16275__auto__ = (function (){var statearr_41416 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41416[(6)] = c__16273__auto___41418);

return statearr_41416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___41418))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__41435){
var vec__41436 = p__41435;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41436,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41436,(1),null);
var job = vec__41436;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__16273__auto___41607 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results){
return (function (state_41443){
var state_val_41444 = (state_41443[(1)]);
if((state_val_41444 === (1))){
var state_41443__$1 = state_41443;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41443__$1,(2),res,v);
} else {
if((state_val_41444 === (2))){
var inst_41440 = (state_41443[(2)]);
var inst_41441 = cljs.core.async.close_BANG_(res);
var state_41443__$1 = (function (){var statearr_41445 = state_41443;
(statearr_41445[(7)] = inst_41440);

return statearr_41445;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_41443__$1,inst_41441);
} else {
return null;
}
}
});})(c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results))
;
return ((function (switch__16183__auto__,c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_41446 = [null,null,null,null,null,null,null,null];
(statearr_41446[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_41446[(1)] = (1));

return statearr_41446;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_41443){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41443);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41447){if((e41447 instanceof Object)){
var ex__16187__auto__ = e41447;
var statearr_41448_41608 = state_41443;
(statearr_41448_41608[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41443);

return cljs.core.cst$kw$recur;
} else {
throw e41447;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41609 = state_41443;
state_41443 = G__41609;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_41443){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_41443);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results))
})();
var state__16275__auto__ = (function (){var statearr_41449 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41449[(6)] = c__16273__auto___41607);

return statearr_41449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___41607,res,vec__41436,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__41450){
var vec__41451 = p__41450;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41451,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41451,(1),null);
var job = vec__41451;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__9433__auto___41610 = n;
var __41611 = (0);
while(true){
if((__41611 < n__9433__auto___41610)){
var G__41454_41612 = type;
var G__41454_41613__$1 = (((G__41454_41612 instanceof cljs.core.Keyword))?G__41454_41612.fqn:null);
switch (G__41454_41613__$1) {
case "compute":
var c__16273__auto___41615 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__41611,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__41611,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function (state_41467){
var state_val_41468 = (state_41467[(1)]);
if((state_val_41468 === (1))){
var state_41467__$1 = state_41467;
var statearr_41469_41616 = state_41467__$1;
(statearr_41469_41616[(2)] = null);

(statearr_41469_41616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41468 === (2))){
var state_41467__$1 = state_41467;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41467__$1,(4),jobs);
} else {
if((state_val_41468 === (3))){
var inst_41465 = (state_41467[(2)]);
var state_41467__$1 = state_41467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41467__$1,inst_41465);
} else {
if((state_val_41468 === (4))){
var inst_41457 = (state_41467[(2)]);
var inst_41458 = process(inst_41457);
var state_41467__$1 = state_41467;
if(cljs.core.truth_(inst_41458)){
var statearr_41470_41617 = state_41467__$1;
(statearr_41470_41617[(1)] = (5));

} else {
var statearr_41471_41618 = state_41467__$1;
(statearr_41471_41618[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41468 === (5))){
var state_41467__$1 = state_41467;
var statearr_41472_41619 = state_41467__$1;
(statearr_41472_41619[(2)] = null);

(statearr_41472_41619[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41468 === (6))){
var state_41467__$1 = state_41467;
var statearr_41473_41620 = state_41467__$1;
(statearr_41473_41620[(2)] = null);

(statearr_41473_41620[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41468 === (7))){
var inst_41463 = (state_41467[(2)]);
var state_41467__$1 = state_41467;
var statearr_41474_41621 = state_41467__$1;
(statearr_41474_41621[(2)] = inst_41463);

(statearr_41474_41621[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__41611,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
;
return ((function (__41611,switch__16183__auto__,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_41475 = [null,null,null,null,null,null,null];
(statearr_41475[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_41475[(1)] = (1));

return statearr_41475;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_41467){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41467);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41476){if((e41476 instanceof Object)){
var ex__16187__auto__ = e41476;
var statearr_41477_41622 = state_41467;
(statearr_41477_41622[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41467);

return cljs.core.cst$kw$recur;
} else {
throw e41476;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41623 = state_41467;
state_41467 = G__41623;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_41467){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_41467);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__41611,switch__16183__auto__,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_41478 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41478[(6)] = c__16273__auto___41615);

return statearr_41478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(__41611,c__16273__auto___41615,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
);


break;
case "async":
var c__16273__auto___41624 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__41611,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__41611,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function (state_41491){
var state_val_41492 = (state_41491[(1)]);
if((state_val_41492 === (1))){
var state_41491__$1 = state_41491;
var statearr_41493_41625 = state_41491__$1;
(statearr_41493_41625[(2)] = null);

(statearr_41493_41625[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41492 === (2))){
var state_41491__$1 = state_41491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41491__$1,(4),jobs);
} else {
if((state_val_41492 === (3))){
var inst_41489 = (state_41491[(2)]);
var state_41491__$1 = state_41491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41491__$1,inst_41489);
} else {
if((state_val_41492 === (4))){
var inst_41481 = (state_41491[(2)]);
var inst_41482 = async(inst_41481);
var state_41491__$1 = state_41491;
if(cljs.core.truth_(inst_41482)){
var statearr_41494_41626 = state_41491__$1;
(statearr_41494_41626[(1)] = (5));

} else {
var statearr_41495_41627 = state_41491__$1;
(statearr_41495_41627[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41492 === (5))){
var state_41491__$1 = state_41491;
var statearr_41496_41628 = state_41491__$1;
(statearr_41496_41628[(2)] = null);

(statearr_41496_41628[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41492 === (6))){
var state_41491__$1 = state_41491;
var statearr_41497_41629 = state_41491__$1;
(statearr_41497_41629[(2)] = null);

(statearr_41497_41629[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41492 === (7))){
var inst_41487 = (state_41491[(2)]);
var state_41491__$1 = state_41491;
var statearr_41498_41630 = state_41491__$1;
(statearr_41498_41630[(2)] = inst_41487);

(statearr_41498_41630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__41611,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
;
return ((function (__41611,switch__16183__auto__,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_41499 = [null,null,null,null,null,null,null];
(statearr_41499[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_41499[(1)] = (1));

return statearr_41499;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_41491){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41491);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41500){if((e41500 instanceof Object)){
var ex__16187__auto__ = e41500;
var statearr_41501_41631 = state_41491;
(statearr_41501_41631[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41491);

return cljs.core.cst$kw$recur;
} else {
throw e41500;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41632 = state_41491;
state_41491 = G__41632;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_41491){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_41491);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__41611,switch__16183__auto__,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_41502 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41502[(6)] = c__16273__auto___41624);

return statearr_41502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(__41611,c__16273__auto___41624,G__41454_41612,G__41454_41613__$1,n__9433__auto___41610,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__41454_41613__$1)].join('')));

}

var G__41633 = (__41611 + (1));
__41611 = G__41633;
continue;
} else {
}
break;
}

var c__16273__auto___41634 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___41634,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___41634,jobs,results,process,async){
return (function (state_41524){
var state_val_41525 = (state_41524[(1)]);
if((state_val_41525 === (1))){
var state_41524__$1 = state_41524;
var statearr_41526_41635 = state_41524__$1;
(statearr_41526_41635[(2)] = null);

(statearr_41526_41635[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41525 === (2))){
var state_41524__$1 = state_41524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41524__$1,(4),from);
} else {
if((state_val_41525 === (3))){
var inst_41522 = (state_41524[(2)]);
var state_41524__$1 = state_41524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41524__$1,inst_41522);
} else {
if((state_val_41525 === (4))){
var inst_41505 = (state_41524[(7)]);
var inst_41505__$1 = (state_41524[(2)]);
var inst_41506 = (inst_41505__$1 == null);
var state_41524__$1 = (function (){var statearr_41527 = state_41524;
(statearr_41527[(7)] = inst_41505__$1);

return statearr_41527;
})();
if(cljs.core.truth_(inst_41506)){
var statearr_41528_41636 = state_41524__$1;
(statearr_41528_41636[(1)] = (5));

} else {
var statearr_41529_41637 = state_41524__$1;
(statearr_41529_41637[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41525 === (5))){
var inst_41508 = cljs.core.async.close_BANG_(jobs);
var state_41524__$1 = state_41524;
var statearr_41530_41638 = state_41524__$1;
(statearr_41530_41638[(2)] = inst_41508);

(statearr_41530_41638[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41525 === (6))){
var inst_41505 = (state_41524[(7)]);
var inst_41510 = (state_41524[(8)]);
var inst_41510__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_41511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41512 = [inst_41505,inst_41510__$1];
var inst_41513 = (new cljs.core.PersistentVector(null,2,(5),inst_41511,inst_41512,null));
var state_41524__$1 = (function (){var statearr_41531 = state_41524;
(statearr_41531[(8)] = inst_41510__$1);

return statearr_41531;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41524__$1,(8),jobs,inst_41513);
} else {
if((state_val_41525 === (7))){
var inst_41520 = (state_41524[(2)]);
var state_41524__$1 = state_41524;
var statearr_41532_41639 = state_41524__$1;
(statearr_41532_41639[(2)] = inst_41520);

(statearr_41532_41639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41525 === (8))){
var inst_41510 = (state_41524[(8)]);
var inst_41515 = (state_41524[(2)]);
var state_41524__$1 = (function (){var statearr_41533 = state_41524;
(statearr_41533[(9)] = inst_41515);

return statearr_41533;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41524__$1,(9),results,inst_41510);
} else {
if((state_val_41525 === (9))){
var inst_41517 = (state_41524[(2)]);
var state_41524__$1 = (function (){var statearr_41534 = state_41524;
(statearr_41534[(10)] = inst_41517);

return statearr_41534;
})();
var statearr_41535_41640 = state_41524__$1;
(statearr_41535_41640[(2)] = null);

(statearr_41535_41640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___41634,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto___41634,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_41536 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41536[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_41536[(1)] = (1));

return statearr_41536;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_41524){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41524);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41537){if((e41537 instanceof Object)){
var ex__16187__auto__ = e41537;
var statearr_41538_41641 = state_41524;
(statearr_41538_41641[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41524);

return cljs.core.cst$kw$recur;
} else {
throw e41537;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41642 = state_41524;
state_41524 = G__41642;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_41524){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_41524);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___41634,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_41539 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41539[(6)] = c__16273__auto___41634);

return statearr_41539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___41634,jobs,results,process,async))
);


var c__16273__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto__,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,jobs,results,process,async){
return (function (state_41577){
var state_val_41578 = (state_41577[(1)]);
if((state_val_41578 === (7))){
var inst_41573 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
var statearr_41579_41643 = state_41577__$1;
(statearr_41579_41643[(2)] = inst_41573);

(statearr_41579_41643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (20))){
var state_41577__$1 = state_41577;
var statearr_41580_41644 = state_41577__$1;
(statearr_41580_41644[(2)] = null);

(statearr_41580_41644[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (1))){
var state_41577__$1 = state_41577;
var statearr_41581_41645 = state_41577__$1;
(statearr_41581_41645[(2)] = null);

(statearr_41581_41645[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (4))){
var inst_41542 = (state_41577[(7)]);
var inst_41542__$1 = (state_41577[(2)]);
var inst_41543 = (inst_41542__$1 == null);
var state_41577__$1 = (function (){var statearr_41582 = state_41577;
(statearr_41582[(7)] = inst_41542__$1);

return statearr_41582;
})();
if(cljs.core.truth_(inst_41543)){
var statearr_41583_41646 = state_41577__$1;
(statearr_41583_41646[(1)] = (5));

} else {
var statearr_41584_41647 = state_41577__$1;
(statearr_41584_41647[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (15))){
var inst_41555 = (state_41577[(8)]);
var state_41577__$1 = state_41577;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41577__$1,(18),to,inst_41555);
} else {
if((state_val_41578 === (21))){
var inst_41568 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
var statearr_41585_41648 = state_41577__$1;
(statearr_41585_41648[(2)] = inst_41568);

(statearr_41585_41648[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (13))){
var inst_41570 = (state_41577[(2)]);
var state_41577__$1 = (function (){var statearr_41586 = state_41577;
(statearr_41586[(9)] = inst_41570);

return statearr_41586;
})();
var statearr_41587_41649 = state_41577__$1;
(statearr_41587_41649[(2)] = null);

(statearr_41587_41649[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (6))){
var inst_41542 = (state_41577[(7)]);
var state_41577__$1 = state_41577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41577__$1,(11),inst_41542);
} else {
if((state_val_41578 === (17))){
var inst_41563 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
if(cljs.core.truth_(inst_41563)){
var statearr_41588_41650 = state_41577__$1;
(statearr_41588_41650[(1)] = (19));

} else {
var statearr_41589_41651 = state_41577__$1;
(statearr_41589_41651[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (3))){
var inst_41575 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41577__$1,inst_41575);
} else {
if((state_val_41578 === (12))){
var inst_41552 = (state_41577[(10)]);
var state_41577__$1 = state_41577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41577__$1,(14),inst_41552);
} else {
if((state_val_41578 === (2))){
var state_41577__$1 = state_41577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41577__$1,(4),results);
} else {
if((state_val_41578 === (19))){
var state_41577__$1 = state_41577;
var statearr_41590_41652 = state_41577__$1;
(statearr_41590_41652[(2)] = null);

(statearr_41590_41652[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (11))){
var inst_41552 = (state_41577[(2)]);
var state_41577__$1 = (function (){var statearr_41591 = state_41577;
(statearr_41591[(10)] = inst_41552);

return statearr_41591;
})();
var statearr_41592_41653 = state_41577__$1;
(statearr_41592_41653[(2)] = null);

(statearr_41592_41653[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (9))){
var state_41577__$1 = state_41577;
var statearr_41593_41654 = state_41577__$1;
(statearr_41593_41654[(2)] = null);

(statearr_41593_41654[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (5))){
var state_41577__$1 = state_41577;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41594_41655 = state_41577__$1;
(statearr_41594_41655[(1)] = (8));

} else {
var statearr_41595_41656 = state_41577__$1;
(statearr_41595_41656[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (14))){
var inst_41555 = (state_41577[(8)]);
var inst_41557 = (state_41577[(11)]);
var inst_41555__$1 = (state_41577[(2)]);
var inst_41556 = (inst_41555__$1 == null);
var inst_41557__$1 = cljs.core.not(inst_41556);
var state_41577__$1 = (function (){var statearr_41596 = state_41577;
(statearr_41596[(8)] = inst_41555__$1);

(statearr_41596[(11)] = inst_41557__$1);

return statearr_41596;
})();
if(inst_41557__$1){
var statearr_41597_41657 = state_41577__$1;
(statearr_41597_41657[(1)] = (15));

} else {
var statearr_41598_41658 = state_41577__$1;
(statearr_41598_41658[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (16))){
var inst_41557 = (state_41577[(11)]);
var state_41577__$1 = state_41577;
var statearr_41599_41659 = state_41577__$1;
(statearr_41599_41659[(2)] = inst_41557);

(statearr_41599_41659[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (10))){
var inst_41549 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
var statearr_41600_41660 = state_41577__$1;
(statearr_41600_41660[(2)] = inst_41549);

(statearr_41600_41660[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (18))){
var inst_41560 = (state_41577[(2)]);
var state_41577__$1 = state_41577;
var statearr_41601_41661 = state_41577__$1;
(statearr_41601_41661[(2)] = inst_41560);

(statearr_41601_41661[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41578 === (8))){
var inst_41546 = cljs.core.async.close_BANG_(to);
var state_41577__$1 = state_41577;
var statearr_41602_41662 = state_41577__$1;
(statearr_41602_41662[(2)] = inst_41546);

(statearr_41602_41662[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_41603 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41603[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_41603[(1)] = (1));

return statearr_41603;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_41577){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41577);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41604){if((e41604 instanceof Object)){
var ex__16187__auto__ = e41604;
var statearr_41605_41663 = state_41577;
(statearr_41605_41663[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41577);

return cljs.core.cst$kw$recur;
} else {
throw e41604;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41664 = state_41577;
state_41577 = G__41664;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_41577){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_41577);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_41606 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41606[(6)] = c__16273__auto__);

return statearr_41606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto__,jobs,results,process,async))
);

return c__16273__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__41666 = arguments.length;
switch (G__41666) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__41669 = arguments.length;
switch (G__41669) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__41672 = arguments.length;
switch (G__41672) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__16273__auto___41721 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___41721,tc,fc){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___41721,tc,fc){
return (function (state_41698){
var state_val_41699 = (state_41698[(1)]);
if((state_val_41699 === (7))){
var inst_41694 = (state_41698[(2)]);
var state_41698__$1 = state_41698;
var statearr_41700_41722 = state_41698__$1;
(statearr_41700_41722[(2)] = inst_41694);

(statearr_41700_41722[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (1))){
var state_41698__$1 = state_41698;
var statearr_41701_41723 = state_41698__$1;
(statearr_41701_41723[(2)] = null);

(statearr_41701_41723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (4))){
var inst_41675 = (state_41698[(7)]);
var inst_41675__$1 = (state_41698[(2)]);
var inst_41676 = (inst_41675__$1 == null);
var state_41698__$1 = (function (){var statearr_41702 = state_41698;
(statearr_41702[(7)] = inst_41675__$1);

return statearr_41702;
})();
if(cljs.core.truth_(inst_41676)){
var statearr_41703_41724 = state_41698__$1;
(statearr_41703_41724[(1)] = (5));

} else {
var statearr_41704_41725 = state_41698__$1;
(statearr_41704_41725[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (13))){
var state_41698__$1 = state_41698;
var statearr_41705_41726 = state_41698__$1;
(statearr_41705_41726[(2)] = null);

(statearr_41705_41726[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (6))){
var inst_41675 = (state_41698[(7)]);
var inst_41681 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_41675) : p.call(null,inst_41675));
var state_41698__$1 = state_41698;
if(cljs.core.truth_(inst_41681)){
var statearr_41706_41727 = state_41698__$1;
(statearr_41706_41727[(1)] = (9));

} else {
var statearr_41707_41728 = state_41698__$1;
(statearr_41707_41728[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (3))){
var inst_41696 = (state_41698[(2)]);
var state_41698__$1 = state_41698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41698__$1,inst_41696);
} else {
if((state_val_41699 === (12))){
var state_41698__$1 = state_41698;
var statearr_41708_41729 = state_41698__$1;
(statearr_41708_41729[(2)] = null);

(statearr_41708_41729[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (2))){
var state_41698__$1 = state_41698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41698__$1,(4),ch);
} else {
if((state_val_41699 === (11))){
var inst_41675 = (state_41698[(7)]);
var inst_41685 = (state_41698[(2)]);
var state_41698__$1 = state_41698;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41698__$1,(8),inst_41685,inst_41675);
} else {
if((state_val_41699 === (9))){
var state_41698__$1 = state_41698;
var statearr_41709_41730 = state_41698__$1;
(statearr_41709_41730[(2)] = tc);

(statearr_41709_41730[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (5))){
var inst_41678 = cljs.core.async.close_BANG_(tc);
var inst_41679 = cljs.core.async.close_BANG_(fc);
var state_41698__$1 = (function (){var statearr_41710 = state_41698;
(statearr_41710[(8)] = inst_41678);

return statearr_41710;
})();
var statearr_41711_41731 = state_41698__$1;
(statearr_41711_41731[(2)] = inst_41679);

(statearr_41711_41731[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (14))){
var inst_41692 = (state_41698[(2)]);
var state_41698__$1 = state_41698;
var statearr_41712_41732 = state_41698__$1;
(statearr_41712_41732[(2)] = inst_41692);

(statearr_41712_41732[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (10))){
var state_41698__$1 = state_41698;
var statearr_41713_41733 = state_41698__$1;
(statearr_41713_41733[(2)] = fc);

(statearr_41713_41733[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41699 === (8))){
var inst_41687 = (state_41698[(2)]);
var state_41698__$1 = state_41698;
if(cljs.core.truth_(inst_41687)){
var statearr_41714_41734 = state_41698__$1;
(statearr_41714_41734[(1)] = (12));

} else {
var statearr_41715_41735 = state_41698__$1;
(statearr_41715_41735[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___41721,tc,fc))
;
return ((function (switch__16183__auto__,c__16273__auto___41721,tc,fc){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_41716 = [null,null,null,null,null,null,null,null,null];
(statearr_41716[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_41716[(1)] = (1));

return statearr_41716;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_41698){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41698);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41717){if((e41717 instanceof Object)){
var ex__16187__auto__ = e41717;
var statearr_41718_41736 = state_41698;
(statearr_41718_41736[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41698);

return cljs.core.cst$kw$recur;
} else {
throw e41717;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41737 = state_41698;
state_41698 = G__41737;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_41698){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_41698);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___41721,tc,fc))
})();
var state__16275__auto__ = (function (){var statearr_41719 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41719[(6)] = c__16273__auto___41721);

return statearr_41719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___41721,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16273__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_41758){
var state_val_41759 = (state_41758[(1)]);
if((state_val_41759 === (7))){
var inst_41754 = (state_41758[(2)]);
var state_41758__$1 = state_41758;
var statearr_41760_41778 = state_41758__$1;
(statearr_41760_41778[(2)] = inst_41754);

(statearr_41760_41778[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (1))){
var inst_41738 = init;
var state_41758__$1 = (function (){var statearr_41761 = state_41758;
(statearr_41761[(7)] = inst_41738);

return statearr_41761;
})();
var statearr_41762_41779 = state_41758__$1;
(statearr_41762_41779[(2)] = null);

(statearr_41762_41779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (4))){
var inst_41741 = (state_41758[(8)]);
var inst_41741__$1 = (state_41758[(2)]);
var inst_41742 = (inst_41741__$1 == null);
var state_41758__$1 = (function (){var statearr_41763 = state_41758;
(statearr_41763[(8)] = inst_41741__$1);

return statearr_41763;
})();
if(cljs.core.truth_(inst_41742)){
var statearr_41764_41780 = state_41758__$1;
(statearr_41764_41780[(1)] = (5));

} else {
var statearr_41765_41781 = state_41758__$1;
(statearr_41765_41781[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (6))){
var inst_41741 = (state_41758[(8)]);
var inst_41745 = (state_41758[(9)]);
var inst_41738 = (state_41758[(7)]);
var inst_41745__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_41738,inst_41741) : f.call(null,inst_41738,inst_41741));
var inst_41746 = cljs.core.reduced_QMARK_(inst_41745__$1);
var state_41758__$1 = (function (){var statearr_41766 = state_41758;
(statearr_41766[(9)] = inst_41745__$1);

return statearr_41766;
})();
if(inst_41746){
var statearr_41767_41782 = state_41758__$1;
(statearr_41767_41782[(1)] = (8));

} else {
var statearr_41768_41783 = state_41758__$1;
(statearr_41768_41783[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (3))){
var inst_41756 = (state_41758[(2)]);
var state_41758__$1 = state_41758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41758__$1,inst_41756);
} else {
if((state_val_41759 === (2))){
var state_41758__$1 = state_41758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41758__$1,(4),ch);
} else {
if((state_val_41759 === (9))){
var inst_41745 = (state_41758[(9)]);
var inst_41738 = inst_41745;
var state_41758__$1 = (function (){var statearr_41769 = state_41758;
(statearr_41769[(7)] = inst_41738);

return statearr_41769;
})();
var statearr_41770_41784 = state_41758__$1;
(statearr_41770_41784[(2)] = null);

(statearr_41770_41784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (5))){
var inst_41738 = (state_41758[(7)]);
var state_41758__$1 = state_41758;
var statearr_41771_41785 = state_41758__$1;
(statearr_41771_41785[(2)] = inst_41738);

(statearr_41771_41785[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (10))){
var inst_41752 = (state_41758[(2)]);
var state_41758__$1 = state_41758;
var statearr_41772_41786 = state_41758__$1;
(statearr_41772_41786[(2)] = inst_41752);

(statearr_41772_41786[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41759 === (8))){
var inst_41745 = (state_41758[(9)]);
var inst_41748 = cljs.core.deref(inst_41745);
var state_41758__$1 = state_41758;
var statearr_41773_41787 = state_41758__$1;
(statearr_41773_41787[(2)] = inst_41748);

(statearr_41773_41787[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16184__auto____0 = (function (){
var statearr_41774 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41774[(0)] = cljs$core$async$reduce_$_state_machine__16184__auto__);

(statearr_41774[(1)] = (1));

return statearr_41774;
});
var cljs$core$async$reduce_$_state_machine__16184__auto____1 = (function (state_41758){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41758);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41775){if((e41775 instanceof Object)){
var ex__16187__auto__ = e41775;
var statearr_41776_41788 = state_41758;
(statearr_41776_41788[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41758);

return cljs.core.cst$kw$recur;
} else {
throw e41775;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41789 = state_41758;
state_41758 = G__41789;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16184__auto__ = function(state_41758){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16184__auto____1.call(this,state_41758);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16184__auto____0;
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16184__auto____1;
return cljs$core$async$reduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_41777 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41777[(6)] = c__16273__auto__);

return statearr_41777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__16273__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto__,f__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,f__$1){
return (function (state_41795){
var state_val_41796 = (state_41795[(1)]);
if((state_val_41796 === (1))){
var inst_41790 = cljs.core.async.reduce(f__$1,init,ch);
var state_41795__$1 = state_41795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41795__$1,(2),inst_41790);
} else {
if((state_val_41796 === (2))){
var inst_41792 = (state_41795[(2)]);
var inst_41793 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_41792) : f__$1.call(null,inst_41792));
var state_41795__$1 = state_41795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41795__$1,inst_41793);
} else {
return null;
}
}
});})(c__16273__auto__,f__$1))
;
return ((function (switch__16183__auto__,c__16273__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16184__auto____0 = (function (){
var statearr_41797 = [null,null,null,null,null,null,null];
(statearr_41797[(0)] = cljs$core$async$transduce_$_state_machine__16184__auto__);

(statearr_41797[(1)] = (1));

return statearr_41797;
});
var cljs$core$async$transduce_$_state_machine__16184__auto____1 = (function (state_41795){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41795);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41798){if((e41798 instanceof Object)){
var ex__16187__auto__ = e41798;
var statearr_41799_41801 = state_41795;
(statearr_41799_41801[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41795);

return cljs.core.cst$kw$recur;
} else {
throw e41798;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41802 = state_41795;
state_41795 = G__41802;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16184__auto__ = function(state_41795){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16184__auto____1.call(this,state_41795);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16184__auto____0;
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16184__auto____1;
return cljs$core$async$transduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,f__$1))
})();
var state__16275__auto__ = (function (){var statearr_41800 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41800[(6)] = c__16273__auto__);

return statearr_41800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto__,f__$1))
);

return c__16273__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__41804 = arguments.length;
switch (G__41804) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16273__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_41829){
var state_val_41830 = (state_41829[(1)]);
if((state_val_41830 === (7))){
var inst_41811 = (state_41829[(2)]);
var state_41829__$1 = state_41829;
var statearr_41831_41852 = state_41829__$1;
(statearr_41831_41852[(2)] = inst_41811);

(statearr_41831_41852[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (1))){
var inst_41805 = cljs.core.seq(coll);
var inst_41806 = inst_41805;
var state_41829__$1 = (function (){var statearr_41832 = state_41829;
(statearr_41832[(7)] = inst_41806);

return statearr_41832;
})();
var statearr_41833_41853 = state_41829__$1;
(statearr_41833_41853[(2)] = null);

(statearr_41833_41853[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (4))){
var inst_41806 = (state_41829[(7)]);
var inst_41809 = cljs.core.first(inst_41806);
var state_41829__$1 = state_41829;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_41829__$1,(7),ch,inst_41809);
} else {
if((state_val_41830 === (13))){
var inst_41823 = (state_41829[(2)]);
var state_41829__$1 = state_41829;
var statearr_41834_41854 = state_41829__$1;
(statearr_41834_41854[(2)] = inst_41823);

(statearr_41834_41854[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (6))){
var inst_41814 = (state_41829[(2)]);
var state_41829__$1 = state_41829;
if(cljs.core.truth_(inst_41814)){
var statearr_41835_41855 = state_41829__$1;
(statearr_41835_41855[(1)] = (8));

} else {
var statearr_41836_41856 = state_41829__$1;
(statearr_41836_41856[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (3))){
var inst_41827 = (state_41829[(2)]);
var state_41829__$1 = state_41829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41829__$1,inst_41827);
} else {
if((state_val_41830 === (12))){
var state_41829__$1 = state_41829;
var statearr_41837_41857 = state_41829__$1;
(statearr_41837_41857[(2)] = null);

(statearr_41837_41857[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (2))){
var inst_41806 = (state_41829[(7)]);
var state_41829__$1 = state_41829;
if(cljs.core.truth_(inst_41806)){
var statearr_41838_41858 = state_41829__$1;
(statearr_41838_41858[(1)] = (4));

} else {
var statearr_41839_41859 = state_41829__$1;
(statearr_41839_41859[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (11))){
var inst_41820 = cljs.core.async.close_BANG_(ch);
var state_41829__$1 = state_41829;
var statearr_41840_41860 = state_41829__$1;
(statearr_41840_41860[(2)] = inst_41820);

(statearr_41840_41860[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (9))){
var state_41829__$1 = state_41829;
if(cljs.core.truth_(close_QMARK_)){
var statearr_41841_41861 = state_41829__$1;
(statearr_41841_41861[(1)] = (11));

} else {
var statearr_41842_41862 = state_41829__$1;
(statearr_41842_41862[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (5))){
var inst_41806 = (state_41829[(7)]);
var state_41829__$1 = state_41829;
var statearr_41843_41863 = state_41829__$1;
(statearr_41843_41863[(2)] = inst_41806);

(statearr_41843_41863[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (10))){
var inst_41825 = (state_41829[(2)]);
var state_41829__$1 = state_41829;
var statearr_41844_41864 = state_41829__$1;
(statearr_41844_41864[(2)] = inst_41825);

(statearr_41844_41864[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41830 === (8))){
var inst_41806 = (state_41829[(7)]);
var inst_41816 = cljs.core.next(inst_41806);
var inst_41806__$1 = inst_41816;
var state_41829__$1 = (function (){var statearr_41845 = state_41829;
(statearr_41845[(7)] = inst_41806__$1);

return statearr_41845;
})();
var statearr_41846_41865 = state_41829__$1;
(statearr_41846_41865[(2)] = null);

(statearr_41846_41865[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_41847 = [null,null,null,null,null,null,null,null];
(statearr_41847[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_41847[(1)] = (1));

return statearr_41847;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_41829){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_41829);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e41848){if((e41848 instanceof Object)){
var ex__16187__auto__ = e41848;
var statearr_41849_41866 = state_41829;
(statearr_41849_41866[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_41829);

return cljs.core.cst$kw$recur;
} else {
throw e41848;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__41867 = state_41829;
state_41829 = G__41867;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_41829){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_41829);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_41850 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_41850[(6)] = c__16273__auto__);

return statearr_41850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9121__auto__ = (((_ == null))?null:_);
var m__9122__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__9122__auto__.call(null,_));
} else {
var m__9122__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__9122__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m__$1,ch,close_QMARK_){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m__$1.cljs$core$async$Mult$tap_STAR_$arity$3(m__$1,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$3(m__$1,ch,close_QMARK_) : m__9122__auto__.call(null,m__$1,ch,close_QMARK_));
} else {
var m__9122__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$3(m__$1,ch,close_QMARK_) : m__9122__auto____$1.call(null,m__$1,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m__$1);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto__.call(null,m__$1,ch));
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto____$1.call(null,m__$1,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m__$1);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$1(m__$1) : m__9122__auto__.call(null,m__$1));
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1(m__$1) : m__9122__auto____$1.call(null,m__$1));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m__$1);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async41868 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async41868 = (function (ch,cs,meta41869){
this.ch = ch;
this.cs = cs;
this.meta41869 = meta41869;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_41870,meta41869__$1){
var self__ = this;
var _41870__$1 = this;
return (new cljs.core.async.t_cljs$core$async41868(self__.ch,self__.cs,meta41869__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_41870){
var self__ = this;
var _41870__$1 = this;
return self__.meta41869;
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta41869], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async41868.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async41868.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async41868";

cljs.core.async.t_cljs$core$async41868.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async41868");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async41868 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async41868(ch__$1,cs__$1,meta41869){
return (new cljs.core.async.t_cljs$core$async41868(ch__$1,cs__$1,meta41869));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async41868(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m__$1,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m__$1,dchan,dctr))
;
var c__16273__auto___42090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42090,cs,m__$1,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42090,cs,m__$1,dchan,dctr,done){
return (function (state_42005){
var state_val_42006 = (state_42005[(1)]);
if((state_val_42006 === (7))){
var inst_42001 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42007_42091 = state_42005__$1;
(statearr_42007_42091[(2)] = inst_42001);

(statearr_42007_42091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (20))){
var inst_41904 = (state_42005[(7)]);
var inst_41916 = cljs.core.first(inst_41904);
var inst_41917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41916,(0),null);
var inst_41918 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41916,(1),null);
var state_42005__$1 = (function (){var statearr_42008 = state_42005;
(statearr_42008[(8)] = inst_41917);

return statearr_42008;
})();
if(cljs.core.truth_(inst_41918)){
var statearr_42009_42092 = state_42005__$1;
(statearr_42009_42092[(1)] = (22));

} else {
var statearr_42010_42093 = state_42005__$1;
(statearr_42010_42093[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (27))){
var inst_41873 = (state_42005[(9)]);
var inst_41948 = (state_42005[(10)]);
var inst_41946 = (state_42005[(11)]);
var inst_41953 = (state_42005[(12)]);
var inst_41953__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_41946,inst_41948);
var inst_41954 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_41953__$1,inst_41873,done);
var state_42005__$1 = (function (){var statearr_42011 = state_42005;
(statearr_42011[(12)] = inst_41953__$1);

return statearr_42011;
})();
if(cljs.core.truth_(inst_41954)){
var statearr_42012_42094 = state_42005__$1;
(statearr_42012_42094[(1)] = (30));

} else {
var statearr_42013_42095 = state_42005__$1;
(statearr_42013_42095[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (1))){
var state_42005__$1 = state_42005;
var statearr_42014_42096 = state_42005__$1;
(statearr_42014_42096[(2)] = null);

(statearr_42014_42096[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (24))){
var inst_41904 = (state_42005[(7)]);
var inst_41923 = (state_42005[(2)]);
var inst_41924 = cljs.core.next(inst_41904);
var inst_41882 = inst_41924;
var inst_41883 = null;
var inst_41884 = (0);
var inst_41885 = (0);
var state_42005__$1 = (function (){var statearr_42015 = state_42005;
(statearr_42015[(13)] = inst_41884);

(statearr_42015[(14)] = inst_41882);

(statearr_42015[(15)] = inst_41883);

(statearr_42015[(16)] = inst_41885);

(statearr_42015[(17)] = inst_41923);

return statearr_42015;
})();
var statearr_42016_42097 = state_42005__$1;
(statearr_42016_42097[(2)] = null);

(statearr_42016_42097[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (39))){
var state_42005__$1 = state_42005;
var statearr_42020_42098 = state_42005__$1;
(statearr_42020_42098[(2)] = null);

(statearr_42020_42098[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (4))){
var inst_41873 = (state_42005[(9)]);
var inst_41873__$1 = (state_42005[(2)]);
var inst_41874 = (inst_41873__$1 == null);
var state_42005__$1 = (function (){var statearr_42021 = state_42005;
(statearr_42021[(9)] = inst_41873__$1);

return statearr_42021;
})();
if(cljs.core.truth_(inst_41874)){
var statearr_42022_42099 = state_42005__$1;
(statearr_42022_42099[(1)] = (5));

} else {
var statearr_42023_42100 = state_42005__$1;
(statearr_42023_42100[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (15))){
var inst_41884 = (state_42005[(13)]);
var inst_41882 = (state_42005[(14)]);
var inst_41883 = (state_42005[(15)]);
var inst_41885 = (state_42005[(16)]);
var inst_41900 = (state_42005[(2)]);
var inst_41901 = (inst_41885 + (1));
var tmp42017 = inst_41884;
var tmp42018 = inst_41882;
var tmp42019 = inst_41883;
var inst_41882__$1 = tmp42018;
var inst_41883__$1 = tmp42019;
var inst_41884__$1 = tmp42017;
var inst_41885__$1 = inst_41901;
var state_42005__$1 = (function (){var statearr_42024 = state_42005;
(statearr_42024[(18)] = inst_41900);

(statearr_42024[(13)] = inst_41884__$1);

(statearr_42024[(14)] = inst_41882__$1);

(statearr_42024[(15)] = inst_41883__$1);

(statearr_42024[(16)] = inst_41885__$1);

return statearr_42024;
})();
var statearr_42025_42101 = state_42005__$1;
(statearr_42025_42101[(2)] = null);

(statearr_42025_42101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (21))){
var inst_41927 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42029_42102 = state_42005__$1;
(statearr_42029_42102[(2)] = inst_41927);

(statearr_42029_42102[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (31))){
var inst_41953 = (state_42005[(12)]);
var inst_41957 = done(null);
var inst_41958 = m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_41953);
var state_42005__$1 = (function (){var statearr_42030 = state_42005;
(statearr_42030[(19)] = inst_41957);

return statearr_42030;
})();
var statearr_42031_42103 = state_42005__$1;
(statearr_42031_42103[(2)] = inst_41958);

(statearr_42031_42103[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (32))){
var inst_41945 = (state_42005[(20)]);
var inst_41948 = (state_42005[(10)]);
var inst_41947 = (state_42005[(21)]);
var inst_41946 = (state_42005[(11)]);
var inst_41960 = (state_42005[(2)]);
var inst_41961 = (inst_41948 + (1));
var tmp42026 = inst_41945;
var tmp42027 = inst_41947;
var tmp42028 = inst_41946;
var inst_41945__$1 = tmp42026;
var inst_41946__$1 = tmp42028;
var inst_41947__$1 = tmp42027;
var inst_41948__$1 = inst_41961;
var state_42005__$1 = (function (){var statearr_42032 = state_42005;
(statearr_42032[(20)] = inst_41945__$1);

(statearr_42032[(22)] = inst_41960);

(statearr_42032[(10)] = inst_41948__$1);

(statearr_42032[(21)] = inst_41947__$1);

(statearr_42032[(11)] = inst_41946__$1);

return statearr_42032;
})();
var statearr_42033_42104 = state_42005__$1;
(statearr_42033_42104[(2)] = null);

(statearr_42033_42104[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (40))){
var inst_41973 = (state_42005[(23)]);
var inst_41977 = done(null);
var inst_41978 = m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_41973);
var state_42005__$1 = (function (){var statearr_42034 = state_42005;
(statearr_42034[(24)] = inst_41977);

return statearr_42034;
})();
var statearr_42035_42105 = state_42005__$1;
(statearr_42035_42105[(2)] = inst_41978);

(statearr_42035_42105[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (33))){
var inst_41964 = (state_42005[(25)]);
var inst_41966 = cljs.core.chunked_seq_QMARK_(inst_41964);
var state_42005__$1 = state_42005;
if(inst_41966){
var statearr_42036_42106 = state_42005__$1;
(statearr_42036_42106[(1)] = (36));

} else {
var statearr_42037_42107 = state_42005__$1;
(statearr_42037_42107[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (13))){
var inst_41894 = (state_42005[(26)]);
var inst_41897 = cljs.core.async.close_BANG_(inst_41894);
var state_42005__$1 = state_42005;
var statearr_42038_42108 = state_42005__$1;
(statearr_42038_42108[(2)] = inst_41897);

(statearr_42038_42108[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (22))){
var inst_41917 = (state_42005[(8)]);
var inst_41920 = cljs.core.async.close_BANG_(inst_41917);
var state_42005__$1 = state_42005;
var statearr_42039_42109 = state_42005__$1;
(statearr_42039_42109[(2)] = inst_41920);

(statearr_42039_42109[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (36))){
var inst_41964 = (state_42005[(25)]);
var inst_41968 = cljs.core.chunk_first(inst_41964);
var inst_41969 = cljs.core.chunk_rest(inst_41964);
var inst_41970 = cljs.core.count(inst_41968);
var inst_41945 = inst_41969;
var inst_41946 = inst_41968;
var inst_41947 = inst_41970;
var inst_41948 = (0);
var state_42005__$1 = (function (){var statearr_42040 = state_42005;
(statearr_42040[(20)] = inst_41945);

(statearr_42040[(10)] = inst_41948);

(statearr_42040[(21)] = inst_41947);

(statearr_42040[(11)] = inst_41946);

return statearr_42040;
})();
var statearr_42041_42110 = state_42005__$1;
(statearr_42041_42110[(2)] = null);

(statearr_42041_42110[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (41))){
var inst_41964 = (state_42005[(25)]);
var inst_41980 = (state_42005[(2)]);
var inst_41981 = cljs.core.next(inst_41964);
var inst_41945 = inst_41981;
var inst_41946 = null;
var inst_41947 = (0);
var inst_41948 = (0);
var state_42005__$1 = (function (){var statearr_42042 = state_42005;
(statearr_42042[(27)] = inst_41980);

(statearr_42042[(20)] = inst_41945);

(statearr_42042[(10)] = inst_41948);

(statearr_42042[(21)] = inst_41947);

(statearr_42042[(11)] = inst_41946);

return statearr_42042;
})();
var statearr_42043_42111 = state_42005__$1;
(statearr_42043_42111[(2)] = null);

(statearr_42043_42111[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (43))){
var state_42005__$1 = state_42005;
var statearr_42044_42112 = state_42005__$1;
(statearr_42044_42112[(2)] = null);

(statearr_42044_42112[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (29))){
var inst_41989 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42045_42113 = state_42005__$1;
(statearr_42045_42113[(2)] = inst_41989);

(statearr_42045_42113[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (44))){
var inst_41998 = (state_42005[(2)]);
var state_42005__$1 = (function (){var statearr_42046 = state_42005;
(statearr_42046[(28)] = inst_41998);

return statearr_42046;
})();
var statearr_42047_42114 = state_42005__$1;
(statearr_42047_42114[(2)] = null);

(statearr_42047_42114[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (6))){
var inst_41937 = (state_42005[(29)]);
var inst_41936 = cljs.core.deref(cs);
var inst_41937__$1 = cljs.core.keys(inst_41936);
var inst_41938 = cljs.core.count(inst_41937__$1);
var inst_41939 = cljs.core.reset_BANG_(dctr,inst_41938);
var inst_41944 = cljs.core.seq(inst_41937__$1);
var inst_41945 = inst_41944;
var inst_41946 = null;
var inst_41947 = (0);
var inst_41948 = (0);
var state_42005__$1 = (function (){var statearr_42048 = state_42005;
(statearr_42048[(20)] = inst_41945);

(statearr_42048[(10)] = inst_41948);

(statearr_42048[(29)] = inst_41937__$1);

(statearr_42048[(21)] = inst_41947);

(statearr_42048[(30)] = inst_41939);

(statearr_42048[(11)] = inst_41946);

return statearr_42048;
})();
var statearr_42049_42115 = state_42005__$1;
(statearr_42049_42115[(2)] = null);

(statearr_42049_42115[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (28))){
var inst_41945 = (state_42005[(20)]);
var inst_41964 = (state_42005[(25)]);
var inst_41964__$1 = cljs.core.seq(inst_41945);
var state_42005__$1 = (function (){var statearr_42050 = state_42005;
(statearr_42050[(25)] = inst_41964__$1);

return statearr_42050;
})();
if(inst_41964__$1){
var statearr_42051_42116 = state_42005__$1;
(statearr_42051_42116[(1)] = (33));

} else {
var statearr_42052_42117 = state_42005__$1;
(statearr_42052_42117[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (25))){
var inst_41948 = (state_42005[(10)]);
var inst_41947 = (state_42005[(21)]);
var inst_41950 = (inst_41948 < inst_41947);
var inst_41951 = inst_41950;
var state_42005__$1 = state_42005;
if(cljs.core.truth_(inst_41951)){
var statearr_42053_42118 = state_42005__$1;
(statearr_42053_42118[(1)] = (27));

} else {
var statearr_42054_42119 = state_42005__$1;
(statearr_42054_42119[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (34))){
var state_42005__$1 = state_42005;
var statearr_42055_42120 = state_42005__$1;
(statearr_42055_42120[(2)] = null);

(statearr_42055_42120[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (17))){
var state_42005__$1 = state_42005;
var statearr_42056_42121 = state_42005__$1;
(statearr_42056_42121[(2)] = null);

(statearr_42056_42121[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (3))){
var inst_42003 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42005__$1,inst_42003);
} else {
if((state_val_42006 === (12))){
var inst_41932 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42057_42122 = state_42005__$1;
(statearr_42057_42122[(2)] = inst_41932);

(statearr_42057_42122[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (2))){
var state_42005__$1 = state_42005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42005__$1,(4),ch);
} else {
if((state_val_42006 === (23))){
var state_42005__$1 = state_42005;
var statearr_42058_42123 = state_42005__$1;
(statearr_42058_42123[(2)] = null);

(statearr_42058_42123[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (35))){
var inst_41987 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42059_42124 = state_42005__$1;
(statearr_42059_42124[(2)] = inst_41987);

(statearr_42059_42124[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (19))){
var inst_41904 = (state_42005[(7)]);
var inst_41908 = cljs.core.chunk_first(inst_41904);
var inst_41909 = cljs.core.chunk_rest(inst_41904);
var inst_41910 = cljs.core.count(inst_41908);
var inst_41882 = inst_41909;
var inst_41883 = inst_41908;
var inst_41884 = inst_41910;
var inst_41885 = (0);
var state_42005__$1 = (function (){var statearr_42060 = state_42005;
(statearr_42060[(13)] = inst_41884);

(statearr_42060[(14)] = inst_41882);

(statearr_42060[(15)] = inst_41883);

(statearr_42060[(16)] = inst_41885);

return statearr_42060;
})();
var statearr_42061_42125 = state_42005__$1;
(statearr_42061_42125[(2)] = null);

(statearr_42061_42125[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (11))){
var inst_41882 = (state_42005[(14)]);
var inst_41904 = (state_42005[(7)]);
var inst_41904__$1 = cljs.core.seq(inst_41882);
var state_42005__$1 = (function (){var statearr_42062 = state_42005;
(statearr_42062[(7)] = inst_41904__$1);

return statearr_42062;
})();
if(inst_41904__$1){
var statearr_42063_42126 = state_42005__$1;
(statearr_42063_42126[(1)] = (16));

} else {
var statearr_42064_42127 = state_42005__$1;
(statearr_42064_42127[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (9))){
var inst_41934 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42065_42128 = state_42005__$1;
(statearr_42065_42128[(2)] = inst_41934);

(statearr_42065_42128[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (5))){
var inst_41880 = cljs.core.deref(cs);
var inst_41881 = cljs.core.seq(inst_41880);
var inst_41882 = inst_41881;
var inst_41883 = null;
var inst_41884 = (0);
var inst_41885 = (0);
var state_42005__$1 = (function (){var statearr_42066 = state_42005;
(statearr_42066[(13)] = inst_41884);

(statearr_42066[(14)] = inst_41882);

(statearr_42066[(15)] = inst_41883);

(statearr_42066[(16)] = inst_41885);

return statearr_42066;
})();
var statearr_42067_42129 = state_42005__$1;
(statearr_42067_42129[(2)] = null);

(statearr_42067_42129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (14))){
var state_42005__$1 = state_42005;
var statearr_42068_42130 = state_42005__$1;
(statearr_42068_42130[(2)] = null);

(statearr_42068_42130[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (45))){
var inst_41995 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42069_42131 = state_42005__$1;
(statearr_42069_42131[(2)] = inst_41995);

(statearr_42069_42131[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (26))){
var inst_41937 = (state_42005[(29)]);
var inst_41991 = (state_42005[(2)]);
var inst_41992 = cljs.core.seq(inst_41937);
var state_42005__$1 = (function (){var statearr_42070 = state_42005;
(statearr_42070[(31)] = inst_41991);

return statearr_42070;
})();
if(inst_41992){
var statearr_42071_42132 = state_42005__$1;
(statearr_42071_42132[(1)] = (42));

} else {
var statearr_42072_42133 = state_42005__$1;
(statearr_42072_42133[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (16))){
var inst_41904 = (state_42005[(7)]);
var inst_41906 = cljs.core.chunked_seq_QMARK_(inst_41904);
var state_42005__$1 = state_42005;
if(inst_41906){
var statearr_42073_42134 = state_42005__$1;
(statearr_42073_42134[(1)] = (19));

} else {
var statearr_42074_42135 = state_42005__$1;
(statearr_42074_42135[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (38))){
var inst_41984 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42075_42136 = state_42005__$1;
(statearr_42075_42136[(2)] = inst_41984);

(statearr_42075_42136[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (30))){
var state_42005__$1 = state_42005;
var statearr_42076_42137 = state_42005__$1;
(statearr_42076_42137[(2)] = null);

(statearr_42076_42137[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (10))){
var inst_41883 = (state_42005[(15)]);
var inst_41885 = (state_42005[(16)]);
var inst_41893 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_41883,inst_41885);
var inst_41894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41893,(0),null);
var inst_41895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41893,(1),null);
var state_42005__$1 = (function (){var statearr_42077 = state_42005;
(statearr_42077[(26)] = inst_41894);

return statearr_42077;
})();
if(cljs.core.truth_(inst_41895)){
var statearr_42078_42138 = state_42005__$1;
(statearr_42078_42138[(1)] = (13));

} else {
var statearr_42079_42139 = state_42005__$1;
(statearr_42079_42139[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (18))){
var inst_41930 = (state_42005[(2)]);
var state_42005__$1 = state_42005;
var statearr_42080_42140 = state_42005__$1;
(statearr_42080_42140[(2)] = inst_41930);

(statearr_42080_42140[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (42))){
var state_42005__$1 = state_42005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42005__$1,(45),dchan);
} else {
if((state_val_42006 === (37))){
var inst_41873 = (state_42005[(9)]);
var inst_41964 = (state_42005[(25)]);
var inst_41973 = (state_42005[(23)]);
var inst_41973__$1 = cljs.core.first(inst_41964);
var inst_41974 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_41973__$1,inst_41873,done);
var state_42005__$1 = (function (){var statearr_42081 = state_42005;
(statearr_42081[(23)] = inst_41973__$1);

return statearr_42081;
})();
if(cljs.core.truth_(inst_41974)){
var statearr_42082_42141 = state_42005__$1;
(statearr_42082_42141[(1)] = (39));

} else {
var statearr_42083_42142 = state_42005__$1;
(statearr_42083_42142[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42006 === (8))){
var inst_41884 = (state_42005[(13)]);
var inst_41885 = (state_42005[(16)]);
var inst_41887 = (inst_41885 < inst_41884);
var inst_41888 = inst_41887;
var state_42005__$1 = state_42005;
if(cljs.core.truth_(inst_41888)){
var statearr_42084_42143 = state_42005__$1;
(statearr_42084_42143[(1)] = (10));

} else {
var statearr_42085_42144 = state_42005__$1;
(statearr_42085_42144[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42090,cs,m__$1,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___42090,cs,m__$1,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16184__auto__ = null;
var cljs$core$async$mult_$_state_machine__16184__auto____0 = (function (){
var statearr_42086 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42086[(0)] = cljs$core$async$mult_$_state_machine__16184__auto__);

(statearr_42086[(1)] = (1));

return statearr_42086;
});
var cljs$core$async$mult_$_state_machine__16184__auto____1 = (function (state_42005){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42005);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42087){if((e42087 instanceof Object)){
var ex__16187__auto__ = e42087;
var statearr_42088_42145 = state_42005;
(statearr_42088_42145[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42005);

return cljs.core.cst$kw$recur;
} else {
throw e42087;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42146 = state_42005;
state_42005 = G__42146;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16184__auto__ = function(state_42005){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16184__auto____1.call(this,state_42005);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16184__auto____0;
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16184__auto____1;
return cljs$core$async$mult_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42090,cs,m__$1,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_42089 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42089[(6)] = c__16273__auto___42090);

return statearr_42089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42090,cs,m__$1,dchan,dctr,done))
);


return m__$1;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__42148 = arguments.length;
switch (G__42148) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$admix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto__.call(null,m__$1,ch));
} else {
var m__9122__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto____$1.call(null,m__$1,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m__$1);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto__.call(null,m__$1,ch));
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(m__$1,ch) : m__9122__auto____$1.call(null,m__$1,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m__$1);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$1(m__$1) : m__9122__auto__.call(null,m__$1));
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1(m__$1) : m__9122__auto____$1.call(null,m__$1));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m__$1);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m__$1,state_map){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2(m__$1,state_map);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(m__$1,state_map) : m__9122__auto__.call(null,m__$1,state_map));
} else {
var m__9122__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(m__$1,state_map) : m__9122__auto____$1.call(null,m__$1,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m__$1);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m__$1,mode){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m__$1,mode);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(m__$1,mode) : m__9122__auto__.call(null,m__$1,mode));
} else {
var m__9122__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(m__$1,mode) : m__9122__auto____$1.call(null,m__$1,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m__$1);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___42160 = arguments.length;
var i__9668__auto___42161 = (0);
while(true){
if((i__9668__auto___42161 < len__9667__auto___42160)){
args__9674__auto__.push((arguments[i__9668__auto___42161]));

var G__42162 = (i__9668__auto___42161 + (1));
i__9668__auto___42161 = G__42162;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((3) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9675__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__42154){
var map__42155 = p__42154;
var map__42155__$1 = ((((!((map__42155 == null)))?((((map__42155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42155.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42155):map__42155);
var opts = map__42155__$1;
var statearr_42157_42163 = state;
(statearr_42157_42163[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__42155,map__42155__$1,opts){
return (function (val){
var statearr_42158_42164 = state;
(statearr_42158_42164[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__42155,map__42155__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_42159_42165 = state;
(statearr_42159_42165[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq42150){
var G__42151 = cljs.core.first(seq42150);
var seq42150__$1 = cljs.core.next(seq42150);
var G__42152 = cljs.core.first(seq42150__$1);
var seq42150__$2 = cljs.core.next(seq42150__$1);
var G__42153 = cljs.core.first(seq42150__$2);
var seq42150__$3 = cljs.core.next(seq42150__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__42151,G__42152,G__42153,seq42150__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async42166 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42166 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta42167){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta42167 = meta42167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_42168,meta42167__$1){
var self__ = this;
var _42168__$1 = this;
return (new cljs.core.async.t_cljs$core$async42166(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta42167__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_42168){
var self__ = this;
var _42168__$1 = this;
return self__.meta42167;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta42167], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async42166.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42166";

cljs.core.async.t_cljs$core$async42166.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42166");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async42166 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async42166(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta42167){
return (new cljs.core.async.t_cljs$core$async42166(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta42167));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async42166(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___42330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (state_42270){
var state_val_42271 = (state_42270[(1)]);
if((state_val_42271 === (7))){
var inst_42185 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
var statearr_42272_42331 = state_42270__$1;
(statearr_42272_42331[(2)] = inst_42185);

(statearr_42272_42331[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (20))){
var inst_42197 = (state_42270[(7)]);
var state_42270__$1 = state_42270;
var statearr_42273_42332 = state_42270__$1;
(statearr_42273_42332[(2)] = inst_42197);

(statearr_42273_42332[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (27))){
var state_42270__$1 = state_42270;
var statearr_42274_42333 = state_42270__$1;
(statearr_42274_42333[(2)] = null);

(statearr_42274_42333[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (1))){
var inst_42172 = (state_42270[(8)]);
var inst_42172__$1 = calc_state();
var inst_42174 = (inst_42172__$1 == null);
var inst_42175 = cljs.core.not(inst_42174);
var state_42270__$1 = (function (){var statearr_42275 = state_42270;
(statearr_42275[(8)] = inst_42172__$1);

return statearr_42275;
})();
if(inst_42175){
var statearr_42276_42334 = state_42270__$1;
(statearr_42276_42334[(1)] = (2));

} else {
var statearr_42277_42335 = state_42270__$1;
(statearr_42277_42335[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (24))){
var inst_42244 = (state_42270[(9)]);
var inst_42221 = (state_42270[(10)]);
var inst_42230 = (state_42270[(11)]);
var inst_42244__$1 = (inst_42221.cljs$core$IFn$_invoke$arity$1 ? inst_42221.cljs$core$IFn$_invoke$arity$1(inst_42230) : inst_42221.call(null,inst_42230));
var state_42270__$1 = (function (){var statearr_42278 = state_42270;
(statearr_42278[(9)] = inst_42244__$1);

return statearr_42278;
})();
if(cljs.core.truth_(inst_42244__$1)){
var statearr_42279_42336 = state_42270__$1;
(statearr_42279_42336[(1)] = (29));

} else {
var statearr_42280_42337 = state_42270__$1;
(statearr_42280_42337[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (4))){
var inst_42188 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42188)){
var statearr_42281_42338 = state_42270__$1;
(statearr_42281_42338[(1)] = (8));

} else {
var statearr_42282_42339 = state_42270__$1;
(statearr_42282_42339[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (15))){
var inst_42215 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42215)){
var statearr_42283_42340 = state_42270__$1;
(statearr_42283_42340[(1)] = (19));

} else {
var statearr_42284_42341 = state_42270__$1;
(statearr_42284_42341[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (21))){
var inst_42220 = (state_42270[(12)]);
var inst_42220__$1 = (state_42270[(2)]);
var inst_42221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42220__$1,cljs.core.cst$kw$solos);
var inst_42222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42220__$1,cljs.core.cst$kw$mutes);
var inst_42223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42220__$1,cljs.core.cst$kw$reads);
var state_42270__$1 = (function (){var statearr_42285 = state_42270;
(statearr_42285[(12)] = inst_42220__$1);

(statearr_42285[(10)] = inst_42221);

(statearr_42285[(13)] = inst_42222);

return statearr_42285;
})();
return cljs.core.async.ioc_alts_BANG_(state_42270__$1,(22),inst_42223);
} else {
if((state_val_42271 === (31))){
var inst_42252 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42252)){
var statearr_42286_42342 = state_42270__$1;
(statearr_42286_42342[(1)] = (32));

} else {
var statearr_42287_42343 = state_42270__$1;
(statearr_42287_42343[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (32))){
var inst_42229 = (state_42270[(14)]);
var state_42270__$1 = state_42270;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42270__$1,(35),out,inst_42229);
} else {
if((state_val_42271 === (33))){
var inst_42220 = (state_42270[(12)]);
var inst_42197 = inst_42220;
var state_42270__$1 = (function (){var statearr_42288 = state_42270;
(statearr_42288[(7)] = inst_42197);

return statearr_42288;
})();
var statearr_42289_42344 = state_42270__$1;
(statearr_42289_42344[(2)] = null);

(statearr_42289_42344[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (13))){
var inst_42197 = (state_42270[(7)]);
var inst_42204 = inst_42197.cljs$lang$protocol_mask$partition0$;
var inst_42205 = (inst_42204 & (64));
var inst_42206 = inst_42197.cljs$core$ISeq$;
var inst_42207 = (cljs.core.PROTOCOL_SENTINEL === inst_42206);
var inst_42208 = (inst_42205) || (inst_42207);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42208)){
var statearr_42290_42345 = state_42270__$1;
(statearr_42290_42345[(1)] = (16));

} else {
var statearr_42291_42346 = state_42270__$1;
(statearr_42291_42346[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (22))){
var inst_42229 = (state_42270[(14)]);
var inst_42230 = (state_42270[(11)]);
var inst_42228 = (state_42270[(2)]);
var inst_42229__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42228,(0),null);
var inst_42230__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42228,(1),null);
var inst_42231 = (inst_42229__$1 == null);
var inst_42232 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42230__$1,change);
var inst_42233 = (inst_42231) || (inst_42232);
var state_42270__$1 = (function (){var statearr_42292 = state_42270;
(statearr_42292[(14)] = inst_42229__$1);

(statearr_42292[(11)] = inst_42230__$1);

return statearr_42292;
})();
if(cljs.core.truth_(inst_42233)){
var statearr_42293_42347 = state_42270__$1;
(statearr_42293_42347[(1)] = (23));

} else {
var statearr_42294_42348 = state_42270__$1;
(statearr_42294_42348[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (36))){
var inst_42220 = (state_42270[(12)]);
var inst_42197 = inst_42220;
var state_42270__$1 = (function (){var statearr_42295 = state_42270;
(statearr_42295[(7)] = inst_42197);

return statearr_42295;
})();
var statearr_42296_42349 = state_42270__$1;
(statearr_42296_42349[(2)] = null);

(statearr_42296_42349[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (29))){
var inst_42244 = (state_42270[(9)]);
var state_42270__$1 = state_42270;
var statearr_42297_42350 = state_42270__$1;
(statearr_42297_42350[(2)] = inst_42244);

(statearr_42297_42350[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (6))){
var state_42270__$1 = state_42270;
var statearr_42298_42351 = state_42270__$1;
(statearr_42298_42351[(2)] = false);

(statearr_42298_42351[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (28))){
var inst_42240 = (state_42270[(2)]);
var inst_42241 = calc_state();
var inst_42197 = inst_42241;
var state_42270__$1 = (function (){var statearr_42299 = state_42270;
(statearr_42299[(15)] = inst_42240);

(statearr_42299[(7)] = inst_42197);

return statearr_42299;
})();
var statearr_42300_42352 = state_42270__$1;
(statearr_42300_42352[(2)] = null);

(statearr_42300_42352[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (25))){
var inst_42266 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
var statearr_42301_42353 = state_42270__$1;
(statearr_42301_42353[(2)] = inst_42266);

(statearr_42301_42353[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (34))){
var inst_42264 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
var statearr_42302_42354 = state_42270__$1;
(statearr_42302_42354[(2)] = inst_42264);

(statearr_42302_42354[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (17))){
var state_42270__$1 = state_42270;
var statearr_42303_42355 = state_42270__$1;
(statearr_42303_42355[(2)] = false);

(statearr_42303_42355[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (3))){
var state_42270__$1 = state_42270;
var statearr_42304_42356 = state_42270__$1;
(statearr_42304_42356[(2)] = false);

(statearr_42304_42356[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (12))){
var inst_42268 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42270__$1,inst_42268);
} else {
if((state_val_42271 === (2))){
var inst_42172 = (state_42270[(8)]);
var inst_42177 = inst_42172.cljs$lang$protocol_mask$partition0$;
var inst_42178 = (inst_42177 & (64));
var inst_42179 = inst_42172.cljs$core$ISeq$;
var inst_42180 = (cljs.core.PROTOCOL_SENTINEL === inst_42179);
var inst_42181 = (inst_42178) || (inst_42180);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42181)){
var statearr_42305_42357 = state_42270__$1;
(statearr_42305_42357[(1)] = (5));

} else {
var statearr_42306_42358 = state_42270__$1;
(statearr_42306_42358[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (23))){
var inst_42229 = (state_42270[(14)]);
var inst_42235 = (inst_42229 == null);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42235)){
var statearr_42307_42359 = state_42270__$1;
(statearr_42307_42359[(1)] = (26));

} else {
var statearr_42308_42360 = state_42270__$1;
(statearr_42308_42360[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (35))){
var inst_42255 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
if(cljs.core.truth_(inst_42255)){
var statearr_42309_42361 = state_42270__$1;
(statearr_42309_42361[(1)] = (36));

} else {
var statearr_42310_42362 = state_42270__$1;
(statearr_42310_42362[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (19))){
var inst_42197 = (state_42270[(7)]);
var inst_42217 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42197);
var state_42270__$1 = state_42270;
var statearr_42311_42363 = state_42270__$1;
(statearr_42311_42363[(2)] = inst_42217);

(statearr_42311_42363[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (11))){
var inst_42197 = (state_42270[(7)]);
var inst_42201 = (inst_42197 == null);
var inst_42202 = cljs.core.not(inst_42201);
var state_42270__$1 = state_42270;
if(inst_42202){
var statearr_42312_42364 = state_42270__$1;
(statearr_42312_42364[(1)] = (13));

} else {
var statearr_42313_42365 = state_42270__$1;
(statearr_42313_42365[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (9))){
var inst_42172 = (state_42270[(8)]);
var state_42270__$1 = state_42270;
var statearr_42314_42366 = state_42270__$1;
(statearr_42314_42366[(2)] = inst_42172);

(statearr_42314_42366[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (5))){
var state_42270__$1 = state_42270;
var statearr_42315_42367 = state_42270__$1;
(statearr_42315_42367[(2)] = true);

(statearr_42315_42367[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (14))){
var state_42270__$1 = state_42270;
var statearr_42316_42368 = state_42270__$1;
(statearr_42316_42368[(2)] = false);

(statearr_42316_42368[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (26))){
var inst_42230 = (state_42270[(11)]);
var inst_42237 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_42230);
var state_42270__$1 = state_42270;
var statearr_42317_42369 = state_42270__$1;
(statearr_42317_42369[(2)] = inst_42237);

(statearr_42317_42369[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (16))){
var state_42270__$1 = state_42270;
var statearr_42318_42370 = state_42270__$1;
(statearr_42318_42370[(2)] = true);

(statearr_42318_42370[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (38))){
var inst_42260 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
var statearr_42319_42371 = state_42270__$1;
(statearr_42319_42371[(2)] = inst_42260);

(statearr_42319_42371[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (30))){
var inst_42221 = (state_42270[(10)]);
var inst_42222 = (state_42270[(13)]);
var inst_42230 = (state_42270[(11)]);
var inst_42247 = cljs.core.empty_QMARK_(inst_42221);
var inst_42248 = (inst_42222.cljs$core$IFn$_invoke$arity$1 ? inst_42222.cljs$core$IFn$_invoke$arity$1(inst_42230) : inst_42222.call(null,inst_42230));
var inst_42249 = cljs.core.not(inst_42248);
var inst_42250 = (inst_42247) && (inst_42249);
var state_42270__$1 = state_42270;
var statearr_42320_42372 = state_42270__$1;
(statearr_42320_42372[(2)] = inst_42250);

(statearr_42320_42372[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (10))){
var inst_42172 = (state_42270[(8)]);
var inst_42193 = (state_42270[(2)]);
var inst_42194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42193,cljs.core.cst$kw$solos);
var inst_42195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42193,cljs.core.cst$kw$mutes);
var inst_42196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42193,cljs.core.cst$kw$reads);
var inst_42197 = inst_42172;
var state_42270__$1 = (function (){var statearr_42321 = state_42270;
(statearr_42321[(16)] = inst_42195);

(statearr_42321[(17)] = inst_42194);

(statearr_42321[(18)] = inst_42196);

(statearr_42321[(7)] = inst_42197);

return statearr_42321;
})();
var statearr_42322_42373 = state_42270__$1;
(statearr_42322_42373[(2)] = null);

(statearr_42322_42373[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (18))){
var inst_42212 = (state_42270[(2)]);
var state_42270__$1 = state_42270;
var statearr_42323_42374 = state_42270__$1;
(statearr_42323_42374[(2)] = inst_42212);

(statearr_42323_42374[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (37))){
var state_42270__$1 = state_42270;
var statearr_42324_42375 = state_42270__$1;
(statearr_42324_42375[(2)] = null);

(statearr_42324_42375[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42271 === (8))){
var inst_42172 = (state_42270[(8)]);
var inst_42190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42172);
var state_42270__$1 = state_42270;
var statearr_42325_42376 = state_42270__$1;
(statearr_42325_42376[(2)] = inst_42190);

(statearr_42325_42376[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
;
return ((function (switch__16183__auto__,c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function() {
var cljs$core$async$mix_$_state_machine__16184__auto__ = null;
var cljs$core$async$mix_$_state_machine__16184__auto____0 = (function (){
var statearr_42326 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42326[(0)] = cljs$core$async$mix_$_state_machine__16184__auto__);

(statearr_42326[(1)] = (1));

return statearr_42326;
});
var cljs$core$async$mix_$_state_machine__16184__auto____1 = (function (state_42270){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42270);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42327){if((e42327 instanceof Object)){
var ex__16187__auto__ = e42327;
var statearr_42328_42377 = state_42270;
(statearr_42328_42377[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42270);

return cljs.core.cst$kw$recur;
} else {
throw e42327;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42378 = state_42270;
state_42270 = G__42378;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16184__auto__ = function(state_42270){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16184__auto____1.call(this,state_42270);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16184__auto____0;
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16184__auto____1;
return cljs$core$async$mix_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
})();
var state__16275__auto__ = (function (){var statearr_42329 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42329[(6)] = c__16273__auto___42330);

return statearr_42329;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42330,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
);


return m__$1;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$4 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9122__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__9122__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__9122__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$3 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9122__auto__.call(null,p,v,ch));
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__9122__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__42380 = arguments.length;
switch (G__42380) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__9122__auto__.call(null,p));
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__9122__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return (m__9122__auto__.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__9122__auto__.call(null,p,v));
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return (m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__9122__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__9122__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__42384 = arguments.length;
switch (G__42384) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8388__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__8388__auto__,mults){
return (function (p1__42382_SHARP_){
if(cljs.core.truth_((p1__42382_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__42382_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__42382_SHARP_.call(null,topic)))){
return p1__42382_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42382_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__8388__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async42385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42385 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta42386){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta42386 = meta42386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_42387,meta42386__$1){
var self__ = this;
var _42387__$1 = this;
return (new cljs.core.async.t_cljs$core$async42385(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta42386__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_42387){
var self__ = this;
var _42387__$1 = this;
return self__.meta42386;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m__$1 = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m__$1,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m__$1 = temp__5457__auto__;
return cljs.core.async.untap(m__$1,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta42386], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async42385.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42385";

cljs.core.async.t_cljs$core$async42385.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42385");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async42385 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async42385(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta42386){
return (new cljs.core.async.t_cljs$core$async42385(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta42386));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async42385(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___42505 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42505,mults,ensure_mult,p){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42505,mults,ensure_mult,p){
return (function (state_42459){
var state_val_42460 = (state_42459[(1)]);
if((state_val_42460 === (7))){
var inst_42455 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42461_42506 = state_42459__$1;
(statearr_42461_42506[(2)] = inst_42455);

(statearr_42461_42506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (20))){
var state_42459__$1 = state_42459;
var statearr_42462_42507 = state_42459__$1;
(statearr_42462_42507[(2)] = null);

(statearr_42462_42507[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (1))){
var state_42459__$1 = state_42459;
var statearr_42463_42508 = state_42459__$1;
(statearr_42463_42508[(2)] = null);

(statearr_42463_42508[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (24))){
var inst_42438 = (state_42459[(7)]);
var inst_42447 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_42438);
var state_42459__$1 = state_42459;
var statearr_42464_42509 = state_42459__$1;
(statearr_42464_42509[(2)] = inst_42447);

(statearr_42464_42509[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (4))){
var inst_42390 = (state_42459[(8)]);
var inst_42390__$1 = (state_42459[(2)]);
var inst_42391 = (inst_42390__$1 == null);
var state_42459__$1 = (function (){var statearr_42465 = state_42459;
(statearr_42465[(8)] = inst_42390__$1);

return statearr_42465;
})();
if(cljs.core.truth_(inst_42391)){
var statearr_42466_42510 = state_42459__$1;
(statearr_42466_42510[(1)] = (5));

} else {
var statearr_42467_42511 = state_42459__$1;
(statearr_42467_42511[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (15))){
var inst_42432 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42468_42512 = state_42459__$1;
(statearr_42468_42512[(2)] = inst_42432);

(statearr_42468_42512[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (21))){
var inst_42452 = (state_42459[(2)]);
var state_42459__$1 = (function (){var statearr_42469 = state_42459;
(statearr_42469[(9)] = inst_42452);

return statearr_42469;
})();
var statearr_42470_42513 = state_42459__$1;
(statearr_42470_42513[(2)] = null);

(statearr_42470_42513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (13))){
var inst_42414 = (state_42459[(10)]);
var inst_42416 = cljs.core.chunked_seq_QMARK_(inst_42414);
var state_42459__$1 = state_42459;
if(inst_42416){
var statearr_42471_42514 = state_42459__$1;
(statearr_42471_42514[(1)] = (16));

} else {
var statearr_42472_42515 = state_42459__$1;
(statearr_42472_42515[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (22))){
var inst_42444 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
if(cljs.core.truth_(inst_42444)){
var statearr_42473_42516 = state_42459__$1;
(statearr_42473_42516[(1)] = (23));

} else {
var statearr_42474_42517 = state_42459__$1;
(statearr_42474_42517[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (6))){
var inst_42438 = (state_42459[(7)]);
var inst_42390 = (state_42459[(8)]);
var inst_42440 = (state_42459[(11)]);
var inst_42438__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_42390) : topic_fn.call(null,inst_42390));
var inst_42439 = cljs.core.deref(mults);
var inst_42440__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42439,inst_42438__$1);
var state_42459__$1 = (function (){var statearr_42475 = state_42459;
(statearr_42475[(7)] = inst_42438__$1);

(statearr_42475[(11)] = inst_42440__$1);

return statearr_42475;
})();
if(cljs.core.truth_(inst_42440__$1)){
var statearr_42476_42518 = state_42459__$1;
(statearr_42476_42518[(1)] = (19));

} else {
var statearr_42477_42519 = state_42459__$1;
(statearr_42477_42519[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (25))){
var inst_42449 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42478_42520 = state_42459__$1;
(statearr_42478_42520[(2)] = inst_42449);

(statearr_42478_42520[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (17))){
var inst_42414 = (state_42459[(10)]);
var inst_42423 = cljs.core.first(inst_42414);
var inst_42424 = cljs.core.async.muxch_STAR_(inst_42423);
var inst_42425 = cljs.core.async.close_BANG_(inst_42424);
var inst_42426 = cljs.core.next(inst_42414);
var inst_42400 = inst_42426;
var inst_42401 = null;
var inst_42402 = (0);
var inst_42403 = (0);
var state_42459__$1 = (function (){var statearr_42479 = state_42459;
(statearr_42479[(12)] = inst_42403);

(statearr_42479[(13)] = inst_42402);

(statearr_42479[(14)] = inst_42400);

(statearr_42479[(15)] = inst_42401);

(statearr_42479[(16)] = inst_42425);

return statearr_42479;
})();
var statearr_42480_42521 = state_42459__$1;
(statearr_42480_42521[(2)] = null);

(statearr_42480_42521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (3))){
var inst_42457 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42459__$1,inst_42457);
} else {
if((state_val_42460 === (12))){
var inst_42434 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42481_42522 = state_42459__$1;
(statearr_42481_42522[(2)] = inst_42434);

(statearr_42481_42522[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (2))){
var state_42459__$1 = state_42459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42459__$1,(4),ch);
} else {
if((state_val_42460 === (23))){
var state_42459__$1 = state_42459;
var statearr_42482_42523 = state_42459__$1;
(statearr_42482_42523[(2)] = null);

(statearr_42482_42523[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (19))){
var inst_42390 = (state_42459[(8)]);
var inst_42440 = (state_42459[(11)]);
var inst_42442 = cljs.core.async.muxch_STAR_(inst_42440);
var state_42459__$1 = state_42459;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42459__$1,(22),inst_42442,inst_42390);
} else {
if((state_val_42460 === (11))){
var inst_42400 = (state_42459[(14)]);
var inst_42414 = (state_42459[(10)]);
var inst_42414__$1 = cljs.core.seq(inst_42400);
var state_42459__$1 = (function (){var statearr_42483 = state_42459;
(statearr_42483[(10)] = inst_42414__$1);

return statearr_42483;
})();
if(inst_42414__$1){
var statearr_42484_42524 = state_42459__$1;
(statearr_42484_42524[(1)] = (13));

} else {
var statearr_42485_42525 = state_42459__$1;
(statearr_42485_42525[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (9))){
var inst_42436 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42486_42526 = state_42459__$1;
(statearr_42486_42526[(2)] = inst_42436);

(statearr_42486_42526[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (5))){
var inst_42397 = cljs.core.deref(mults);
var inst_42398 = cljs.core.vals(inst_42397);
var inst_42399 = cljs.core.seq(inst_42398);
var inst_42400 = inst_42399;
var inst_42401 = null;
var inst_42402 = (0);
var inst_42403 = (0);
var state_42459__$1 = (function (){var statearr_42487 = state_42459;
(statearr_42487[(12)] = inst_42403);

(statearr_42487[(13)] = inst_42402);

(statearr_42487[(14)] = inst_42400);

(statearr_42487[(15)] = inst_42401);

return statearr_42487;
})();
var statearr_42488_42527 = state_42459__$1;
(statearr_42488_42527[(2)] = null);

(statearr_42488_42527[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (14))){
var state_42459__$1 = state_42459;
var statearr_42492_42528 = state_42459__$1;
(statearr_42492_42528[(2)] = null);

(statearr_42492_42528[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (16))){
var inst_42414 = (state_42459[(10)]);
var inst_42418 = cljs.core.chunk_first(inst_42414);
var inst_42419 = cljs.core.chunk_rest(inst_42414);
var inst_42420 = cljs.core.count(inst_42418);
var inst_42400 = inst_42419;
var inst_42401 = inst_42418;
var inst_42402 = inst_42420;
var inst_42403 = (0);
var state_42459__$1 = (function (){var statearr_42493 = state_42459;
(statearr_42493[(12)] = inst_42403);

(statearr_42493[(13)] = inst_42402);

(statearr_42493[(14)] = inst_42400);

(statearr_42493[(15)] = inst_42401);

return statearr_42493;
})();
var statearr_42494_42529 = state_42459__$1;
(statearr_42494_42529[(2)] = null);

(statearr_42494_42529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (10))){
var inst_42403 = (state_42459[(12)]);
var inst_42402 = (state_42459[(13)]);
var inst_42400 = (state_42459[(14)]);
var inst_42401 = (state_42459[(15)]);
var inst_42408 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_42401,inst_42403);
var inst_42409 = cljs.core.async.muxch_STAR_(inst_42408);
var inst_42410 = cljs.core.async.close_BANG_(inst_42409);
var inst_42411 = (inst_42403 + (1));
var tmp42489 = inst_42402;
var tmp42490 = inst_42400;
var tmp42491 = inst_42401;
var inst_42400__$1 = tmp42490;
var inst_42401__$1 = tmp42491;
var inst_42402__$1 = tmp42489;
var inst_42403__$1 = inst_42411;
var state_42459__$1 = (function (){var statearr_42495 = state_42459;
(statearr_42495[(17)] = inst_42410);

(statearr_42495[(12)] = inst_42403__$1);

(statearr_42495[(13)] = inst_42402__$1);

(statearr_42495[(14)] = inst_42400__$1);

(statearr_42495[(15)] = inst_42401__$1);

return statearr_42495;
})();
var statearr_42496_42530 = state_42459__$1;
(statearr_42496_42530[(2)] = null);

(statearr_42496_42530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (18))){
var inst_42429 = (state_42459[(2)]);
var state_42459__$1 = state_42459;
var statearr_42497_42531 = state_42459__$1;
(statearr_42497_42531[(2)] = inst_42429);

(statearr_42497_42531[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42460 === (8))){
var inst_42403 = (state_42459[(12)]);
var inst_42402 = (state_42459[(13)]);
var inst_42405 = (inst_42403 < inst_42402);
var inst_42406 = inst_42405;
var state_42459__$1 = state_42459;
if(cljs.core.truth_(inst_42406)){
var statearr_42498_42532 = state_42459__$1;
(statearr_42498_42532[(1)] = (10));

} else {
var statearr_42499_42533 = state_42459__$1;
(statearr_42499_42533[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42505,mults,ensure_mult,p))
;
return ((function (switch__16183__auto__,c__16273__auto___42505,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_42500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42500[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_42500[(1)] = (1));

return statearr_42500;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42459){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42459);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42501){if((e42501 instanceof Object)){
var ex__16187__auto__ = e42501;
var statearr_42502_42534 = state_42459;
(statearr_42502_42534[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42459);

return cljs.core.cst$kw$recur;
} else {
throw e42501;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42535 = state_42459;
state_42459 = G__42535;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42459){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42505,mults,ensure_mult,p))
})();
var state__16275__auto__ = (function (){var statearr_42503 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42503[(6)] = c__16273__auto___42505);

return statearr_42503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42505,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__42537 = arguments.length;
switch (G__42537) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__42540 = arguments.length;
switch (G__42540) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__42543 = arguments.length;
switch (G__42543) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__16273__auto___42610 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_42582){
var state_val_42583 = (state_42582[(1)]);
if((state_val_42583 === (7))){
var state_42582__$1 = state_42582;
var statearr_42584_42611 = state_42582__$1;
(statearr_42584_42611[(2)] = null);

(statearr_42584_42611[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (1))){
var state_42582__$1 = state_42582;
var statearr_42585_42612 = state_42582__$1;
(statearr_42585_42612[(2)] = null);

(statearr_42585_42612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (4))){
var inst_42546 = (state_42582[(7)]);
var inst_42548 = (inst_42546 < cnt);
var state_42582__$1 = state_42582;
if(cljs.core.truth_(inst_42548)){
var statearr_42586_42613 = state_42582__$1;
(statearr_42586_42613[(1)] = (6));

} else {
var statearr_42587_42614 = state_42582__$1;
(statearr_42587_42614[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (15))){
var inst_42578 = (state_42582[(2)]);
var state_42582__$1 = state_42582;
var statearr_42588_42615 = state_42582__$1;
(statearr_42588_42615[(2)] = inst_42578);

(statearr_42588_42615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (13))){
var inst_42571 = cljs.core.async.close_BANG_(out);
var state_42582__$1 = state_42582;
var statearr_42589_42616 = state_42582__$1;
(statearr_42589_42616[(2)] = inst_42571);

(statearr_42589_42616[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (6))){
var state_42582__$1 = state_42582;
var statearr_42590_42617 = state_42582__$1;
(statearr_42590_42617[(2)] = null);

(statearr_42590_42617[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (3))){
var inst_42580 = (state_42582[(2)]);
var state_42582__$1 = state_42582;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42582__$1,inst_42580);
} else {
if((state_val_42583 === (12))){
var inst_42568 = (state_42582[(8)]);
var inst_42568__$1 = (state_42582[(2)]);
var inst_42569 = cljs.core.some(cljs.core.nil_QMARK_,inst_42568__$1);
var state_42582__$1 = (function (){var statearr_42591 = state_42582;
(statearr_42591[(8)] = inst_42568__$1);

return statearr_42591;
})();
if(cljs.core.truth_(inst_42569)){
var statearr_42592_42618 = state_42582__$1;
(statearr_42592_42618[(1)] = (13));

} else {
var statearr_42593_42619 = state_42582__$1;
(statearr_42593_42619[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (2))){
var inst_42545 = cljs.core.reset_BANG_(dctr,cnt);
var inst_42546 = (0);
var state_42582__$1 = (function (){var statearr_42594 = state_42582;
(statearr_42594[(9)] = inst_42545);

(statearr_42594[(7)] = inst_42546);

return statearr_42594;
})();
var statearr_42595_42620 = state_42582__$1;
(statearr_42595_42620[(2)] = null);

(statearr_42595_42620[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (11))){
var inst_42546 = (state_42582[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_42582,(10),Object,null,(9));
var inst_42555 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_42546) : chs__$1.call(null,inst_42546));
var inst_42556 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_42546) : done.call(null,inst_42546));
var inst_42557 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_42555,inst_42556);
var state_42582__$1 = state_42582;
var statearr_42596_42621 = state_42582__$1;
(statearr_42596_42621[(2)] = inst_42557);


cljs.core.async.impl.ioc_helpers.process_exception(state_42582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (9))){
var inst_42546 = (state_42582[(7)]);
var inst_42559 = (state_42582[(2)]);
var inst_42560 = (inst_42546 + (1));
var inst_42546__$1 = inst_42560;
var state_42582__$1 = (function (){var statearr_42597 = state_42582;
(statearr_42597[(10)] = inst_42559);

(statearr_42597[(7)] = inst_42546__$1);

return statearr_42597;
})();
var statearr_42598_42622 = state_42582__$1;
(statearr_42598_42622[(2)] = null);

(statearr_42598_42622[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (5))){
var inst_42566 = (state_42582[(2)]);
var state_42582__$1 = (function (){var statearr_42599 = state_42582;
(statearr_42599[(11)] = inst_42566);

return statearr_42599;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42582__$1,(12),dchan);
} else {
if((state_val_42583 === (14))){
var inst_42568 = (state_42582[(8)]);
var inst_42573 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_42568);
var state_42582__$1 = state_42582;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42582__$1,(16),out,inst_42573);
} else {
if((state_val_42583 === (16))){
var inst_42575 = (state_42582[(2)]);
var state_42582__$1 = (function (){var statearr_42600 = state_42582;
(statearr_42600[(12)] = inst_42575);

return statearr_42600;
})();
var statearr_42601_42623 = state_42582__$1;
(statearr_42601_42623[(2)] = null);

(statearr_42601_42623[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (10))){
var inst_42550 = (state_42582[(2)]);
var inst_42551 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_42582__$1 = (function (){var statearr_42602 = state_42582;
(statearr_42602[(13)] = inst_42550);

return statearr_42602;
})();
var statearr_42603_42624 = state_42582__$1;
(statearr_42603_42624[(2)] = inst_42551);


cljs.core.async.impl.ioc_helpers.process_exception(state_42582__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_42583 === (8))){
var inst_42564 = (state_42582[(2)]);
var state_42582__$1 = state_42582;
var statearr_42604_42625 = state_42582__$1;
(statearr_42604_42625[(2)] = inst_42564);

(statearr_42604_42625[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_42605 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42605[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_42605[(1)] = (1));

return statearr_42605;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42582){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42582);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42606){if((e42606 instanceof Object)){
var ex__16187__auto__ = e42606;
var statearr_42607_42626 = state_42582;
(statearr_42607_42626[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42582);

return cljs.core.cst$kw$recur;
} else {
throw e42606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42627 = state_42582;
state_42582 = G__42627;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42582){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42582);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_42608 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42608[(6)] = c__16273__auto___42610);

return statearr_42608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42610,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__42630 = arguments.length;
switch (G__42630) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___42684 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42684,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42684,out){
return (function (state_42662){
var state_val_42663 = (state_42662[(1)]);
if((state_val_42663 === (7))){
var inst_42641 = (state_42662[(7)]);
var inst_42642 = (state_42662[(8)]);
var inst_42641__$1 = (state_42662[(2)]);
var inst_42642__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42641__$1,(0),null);
var inst_42643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42641__$1,(1),null);
var inst_42644 = (inst_42642__$1 == null);
var state_42662__$1 = (function (){var statearr_42664 = state_42662;
(statearr_42664[(7)] = inst_42641__$1);

(statearr_42664[(9)] = inst_42643);

(statearr_42664[(8)] = inst_42642__$1);

return statearr_42664;
})();
if(cljs.core.truth_(inst_42644)){
var statearr_42665_42685 = state_42662__$1;
(statearr_42665_42685[(1)] = (8));

} else {
var statearr_42666_42686 = state_42662__$1;
(statearr_42666_42686[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (1))){
var inst_42631 = cljs.core.vec(chs);
var inst_42632 = inst_42631;
var state_42662__$1 = (function (){var statearr_42667 = state_42662;
(statearr_42667[(10)] = inst_42632);

return statearr_42667;
})();
var statearr_42668_42687 = state_42662__$1;
(statearr_42668_42687[(2)] = null);

(statearr_42668_42687[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (4))){
var inst_42632 = (state_42662[(10)]);
var state_42662__$1 = state_42662;
return cljs.core.async.ioc_alts_BANG_(state_42662__$1,(7),inst_42632);
} else {
if((state_val_42663 === (6))){
var inst_42658 = (state_42662[(2)]);
var state_42662__$1 = state_42662;
var statearr_42669_42688 = state_42662__$1;
(statearr_42669_42688[(2)] = inst_42658);

(statearr_42669_42688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (3))){
var inst_42660 = (state_42662[(2)]);
var state_42662__$1 = state_42662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42662__$1,inst_42660);
} else {
if((state_val_42663 === (2))){
var inst_42632 = (state_42662[(10)]);
var inst_42634 = cljs.core.count(inst_42632);
var inst_42635 = (inst_42634 > (0));
var state_42662__$1 = state_42662;
if(cljs.core.truth_(inst_42635)){
var statearr_42671_42689 = state_42662__$1;
(statearr_42671_42689[(1)] = (4));

} else {
var statearr_42672_42690 = state_42662__$1;
(statearr_42672_42690[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (11))){
var inst_42632 = (state_42662[(10)]);
var inst_42651 = (state_42662[(2)]);
var tmp42670 = inst_42632;
var inst_42632__$1 = tmp42670;
var state_42662__$1 = (function (){var statearr_42673 = state_42662;
(statearr_42673[(11)] = inst_42651);

(statearr_42673[(10)] = inst_42632__$1);

return statearr_42673;
})();
var statearr_42674_42691 = state_42662__$1;
(statearr_42674_42691[(2)] = null);

(statearr_42674_42691[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (9))){
var inst_42642 = (state_42662[(8)]);
var state_42662__$1 = state_42662;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42662__$1,(11),out,inst_42642);
} else {
if((state_val_42663 === (5))){
var inst_42656 = cljs.core.async.close_BANG_(out);
var state_42662__$1 = state_42662;
var statearr_42675_42692 = state_42662__$1;
(statearr_42675_42692[(2)] = inst_42656);

(statearr_42675_42692[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (10))){
var inst_42654 = (state_42662[(2)]);
var state_42662__$1 = state_42662;
var statearr_42676_42693 = state_42662__$1;
(statearr_42676_42693[(2)] = inst_42654);

(statearr_42676_42693[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42663 === (8))){
var inst_42641 = (state_42662[(7)]);
var inst_42643 = (state_42662[(9)]);
var inst_42642 = (state_42662[(8)]);
var inst_42632 = (state_42662[(10)]);
var inst_42646 = (function (){var cs = inst_42632;
var vec__42637 = inst_42641;
var v = inst_42642;
var c = inst_42643;
return ((function (cs,vec__42637,v,c,inst_42641,inst_42643,inst_42642,inst_42632,state_val_42663,c__16273__auto___42684,out){
return (function (p1__42628_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__42628_SHARP_);
});
;})(cs,vec__42637,v,c,inst_42641,inst_42643,inst_42642,inst_42632,state_val_42663,c__16273__auto___42684,out))
})();
var inst_42647 = cljs.core.filterv(inst_42646,inst_42632);
var inst_42632__$1 = inst_42647;
var state_42662__$1 = (function (){var statearr_42677 = state_42662;
(statearr_42677[(10)] = inst_42632__$1);

return statearr_42677;
})();
var statearr_42678_42694 = state_42662__$1;
(statearr_42678_42694[(2)] = null);

(statearr_42678_42694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42684,out))
;
return ((function (switch__16183__auto__,c__16273__auto___42684,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_42679 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42679[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_42679[(1)] = (1));

return statearr_42679;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42662){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42662);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42680){if((e42680 instanceof Object)){
var ex__16187__auto__ = e42680;
var statearr_42681_42695 = state_42662;
(statearr_42681_42695[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42662);

return cljs.core.cst$kw$recur;
} else {
throw e42680;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42696 = state_42662;
state_42662 = G__42696;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42662){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42662);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42684,out))
})();
var state__16275__auto__ = (function (){var statearr_42682 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42682[(6)] = c__16273__auto___42684);

return statearr_42682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42684,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__42698 = arguments.length;
switch (G__42698) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___42743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42743,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42743,out){
return (function (state_42722){
var state_val_42723 = (state_42722[(1)]);
if((state_val_42723 === (7))){
var inst_42704 = (state_42722[(7)]);
var inst_42704__$1 = (state_42722[(2)]);
var inst_42705 = (inst_42704__$1 == null);
var inst_42706 = cljs.core.not(inst_42705);
var state_42722__$1 = (function (){var statearr_42724 = state_42722;
(statearr_42724[(7)] = inst_42704__$1);

return statearr_42724;
})();
if(inst_42706){
var statearr_42725_42744 = state_42722__$1;
(statearr_42725_42744[(1)] = (8));

} else {
var statearr_42726_42745 = state_42722__$1;
(statearr_42726_42745[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (1))){
var inst_42699 = (0);
var state_42722__$1 = (function (){var statearr_42727 = state_42722;
(statearr_42727[(8)] = inst_42699);

return statearr_42727;
})();
var statearr_42728_42746 = state_42722__$1;
(statearr_42728_42746[(2)] = null);

(statearr_42728_42746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (4))){
var state_42722__$1 = state_42722;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42722__$1,(7),ch);
} else {
if((state_val_42723 === (6))){
var inst_42717 = (state_42722[(2)]);
var state_42722__$1 = state_42722;
var statearr_42729_42747 = state_42722__$1;
(statearr_42729_42747[(2)] = inst_42717);

(statearr_42729_42747[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (3))){
var inst_42719 = (state_42722[(2)]);
var inst_42720 = cljs.core.async.close_BANG_(out);
var state_42722__$1 = (function (){var statearr_42730 = state_42722;
(statearr_42730[(9)] = inst_42719);

return statearr_42730;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42722__$1,inst_42720);
} else {
if((state_val_42723 === (2))){
var inst_42699 = (state_42722[(8)]);
var inst_42701 = (inst_42699 < n);
var state_42722__$1 = state_42722;
if(cljs.core.truth_(inst_42701)){
var statearr_42731_42748 = state_42722__$1;
(statearr_42731_42748[(1)] = (4));

} else {
var statearr_42732_42749 = state_42722__$1;
(statearr_42732_42749[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (11))){
var inst_42699 = (state_42722[(8)]);
var inst_42709 = (state_42722[(2)]);
var inst_42710 = (inst_42699 + (1));
var inst_42699__$1 = inst_42710;
var state_42722__$1 = (function (){var statearr_42733 = state_42722;
(statearr_42733[(10)] = inst_42709);

(statearr_42733[(8)] = inst_42699__$1);

return statearr_42733;
})();
var statearr_42734_42750 = state_42722__$1;
(statearr_42734_42750[(2)] = null);

(statearr_42734_42750[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (9))){
var state_42722__$1 = state_42722;
var statearr_42735_42751 = state_42722__$1;
(statearr_42735_42751[(2)] = null);

(statearr_42735_42751[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (5))){
var state_42722__$1 = state_42722;
var statearr_42736_42752 = state_42722__$1;
(statearr_42736_42752[(2)] = null);

(statearr_42736_42752[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (10))){
var inst_42714 = (state_42722[(2)]);
var state_42722__$1 = state_42722;
var statearr_42737_42753 = state_42722__$1;
(statearr_42737_42753[(2)] = inst_42714);

(statearr_42737_42753[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42723 === (8))){
var inst_42704 = (state_42722[(7)]);
var state_42722__$1 = state_42722;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42722__$1,(11),out,inst_42704);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42743,out))
;
return ((function (switch__16183__auto__,c__16273__auto___42743,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_42738 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_42738[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_42738[(1)] = (1));

return statearr_42738;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42722){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42722);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42739){if((e42739 instanceof Object)){
var ex__16187__auto__ = e42739;
var statearr_42740_42754 = state_42722;
(statearr_42740_42754[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42722);

return cljs.core.cst$kw$recur;
} else {
throw e42739;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42755 = state_42722;
state_42722 = G__42755;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42722){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42722);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42743,out))
})();
var state__16275__auto__ = (function (){var statearr_42741 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42741[(6)] = c__16273__auto___42743);

return statearr_42741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42743,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async42757 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42757 = (function (f,ch,meta42758){
this.f = f;
this.ch = ch;
this.meta42758 = meta42758;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42759,meta42758__$1){
var self__ = this;
var _42759__$1 = this;
return (new cljs.core.async.t_cljs$core$async42757(self__.f,self__.ch,meta42758__$1));
});

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42759){
var self__ = this;
var _42759__$1 = this;
return self__.meta42758;
});

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async42760 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42760 = (function (f,ch,meta42758,_,fn1,meta42761){
this.f = f;
this.ch = ch;
this.meta42758 = meta42758;
this._ = _;
this.fn1 = fn1;
this.meta42761 = meta42761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_42762,meta42761__$1){
var self__ = this;
var _42762__$1 = this;
return (new cljs.core.async.t_cljs$core$async42760(self__.f,self__.ch,self__.meta42758,self__._,self__.fn1,meta42761__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_42762){
var self__ = this;
var _42762__$1 = this;
return self__.meta42761;
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__42756_SHARP_){
var G__42763 = (((p1__42756_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__42756_SHARP_) : self__.f.call(null,p1__42756_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__42763) : f1.call(null,G__42763));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta42758,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async42757], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta42761], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async42760.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42760.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42760";

cljs.core.async.t_cljs$core$async42760.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42760");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async42760 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async42760(f__$1,ch__$1,meta42758__$1,___$2,fn1__$1,meta42761){
return (new cljs.core.async.t_cljs$core$async42760(f__$1,ch__$1,meta42758__$1,___$2,fn1__$1,meta42761));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async42760(self__.f,self__.ch,self__.meta42758,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8376__auto__ = ret;
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.deref(ret) == null));
} else {
return and__8376__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__42764 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__42764) : self__.f.call(null,G__42764));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42757.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async42757.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta42758], null);
});

cljs.core.async.t_cljs$core$async42757.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42757.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42757";

cljs.core.async.t_cljs$core$async42757.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42757");
});

cljs.core.async.__GT_t_cljs$core$async42757 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async42757(f__$1,ch__$1,meta42758){
return (new cljs.core.async.t_cljs$core$async42757(f__$1,ch__$1,meta42758));
});

}

return (new cljs.core.async.t_cljs$core$async42757(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async42765 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42765 = (function (f,ch,meta42766){
this.f = f;
this.ch = ch;
this.meta42766 = meta42766;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42767,meta42766__$1){
var self__ = this;
var _42767__$1 = this;
return (new cljs.core.async.t_cljs$core$async42765(self__.f,self__.ch,meta42766__$1));
});

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42767){
var self__ = this;
var _42767__$1 = this;
return self__.meta42766;
});

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42765.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async42765.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta42766], null);
});

cljs.core.async.t_cljs$core$async42765.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42765.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42765";

cljs.core.async.t_cljs$core$async42765.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42765");
});

cljs.core.async.__GT_t_cljs$core$async42765 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async42765(f__$1,ch__$1,meta42766){
return (new cljs.core.async.t_cljs$core$async42765(f__$1,ch__$1,meta42766));
});

}

return (new cljs.core.async.t_cljs$core$async42765(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async42768 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async42768 = (function (p,ch,meta42769){
this.p = p;
this.ch = ch;
this.meta42769 = meta42769;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_42770,meta42769__$1){
var self__ = this;
var _42770__$1 = this;
return (new cljs.core.async.t_cljs$core$async42768(self__.p,self__.ch,meta42769__$1));
});

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_42770){
var self__ = this;
var _42770__$1 = this;
return self__.meta42769;
});

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async42768.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async42768.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta42769], null);
});

cljs.core.async.t_cljs$core$async42768.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async42768.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async42768";

cljs.core.async.t_cljs$core$async42768.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write(writer__9060__auto__,"cljs.core.async/t_cljs$core$async42768");
});

cljs.core.async.__GT_t_cljs$core$async42768 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async42768(p__$1,ch__$1,meta42769){
return (new cljs.core.async.t_cljs$core$async42768(p__$1,ch__$1,meta42769));
});

}

return (new cljs.core.async.t_cljs$core$async42768(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__42772 = arguments.length;
switch (G__42772) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___42812 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___42812,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___42812,out){
return (function (state_42793){
var state_val_42794 = (state_42793[(1)]);
if((state_val_42794 === (7))){
var inst_42789 = (state_42793[(2)]);
var state_42793__$1 = state_42793;
var statearr_42795_42813 = state_42793__$1;
(statearr_42795_42813[(2)] = inst_42789);

(statearr_42795_42813[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (1))){
var state_42793__$1 = state_42793;
var statearr_42796_42814 = state_42793__$1;
(statearr_42796_42814[(2)] = null);

(statearr_42796_42814[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (4))){
var inst_42775 = (state_42793[(7)]);
var inst_42775__$1 = (state_42793[(2)]);
var inst_42776 = (inst_42775__$1 == null);
var state_42793__$1 = (function (){var statearr_42797 = state_42793;
(statearr_42797[(7)] = inst_42775__$1);

return statearr_42797;
})();
if(cljs.core.truth_(inst_42776)){
var statearr_42798_42815 = state_42793__$1;
(statearr_42798_42815[(1)] = (5));

} else {
var statearr_42799_42816 = state_42793__$1;
(statearr_42799_42816[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (6))){
var inst_42775 = (state_42793[(7)]);
var inst_42780 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_42775) : p.call(null,inst_42775));
var state_42793__$1 = state_42793;
if(cljs.core.truth_(inst_42780)){
var statearr_42800_42817 = state_42793__$1;
(statearr_42800_42817[(1)] = (8));

} else {
var statearr_42801_42818 = state_42793__$1;
(statearr_42801_42818[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (3))){
var inst_42791 = (state_42793[(2)]);
var state_42793__$1 = state_42793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42793__$1,inst_42791);
} else {
if((state_val_42794 === (2))){
var state_42793__$1 = state_42793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42793__$1,(4),ch);
} else {
if((state_val_42794 === (11))){
var inst_42783 = (state_42793[(2)]);
var state_42793__$1 = state_42793;
var statearr_42802_42819 = state_42793__$1;
(statearr_42802_42819[(2)] = inst_42783);

(statearr_42802_42819[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (9))){
var state_42793__$1 = state_42793;
var statearr_42803_42820 = state_42793__$1;
(statearr_42803_42820[(2)] = null);

(statearr_42803_42820[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (5))){
var inst_42778 = cljs.core.async.close_BANG_(out);
var state_42793__$1 = state_42793;
var statearr_42804_42821 = state_42793__$1;
(statearr_42804_42821[(2)] = inst_42778);

(statearr_42804_42821[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (10))){
var inst_42786 = (state_42793[(2)]);
var state_42793__$1 = (function (){var statearr_42805 = state_42793;
(statearr_42805[(8)] = inst_42786);

return statearr_42805;
})();
var statearr_42806_42822 = state_42793__$1;
(statearr_42806_42822[(2)] = null);

(statearr_42806_42822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42794 === (8))){
var inst_42775 = (state_42793[(7)]);
var state_42793__$1 = state_42793;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42793__$1,(11),out,inst_42775);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___42812,out))
;
return ((function (switch__16183__auto__,c__16273__auto___42812,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_42807 = [null,null,null,null,null,null,null,null,null];
(statearr_42807[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_42807[(1)] = (1));

return statearr_42807;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42793){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42793);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42808){if((e42808 instanceof Object)){
var ex__16187__auto__ = e42808;
var statearr_42809_42823 = state_42793;
(statearr_42809_42823[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42793);

return cljs.core.cst$kw$recur;
} else {
throw e42808;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42824 = state_42793;
state_42793 = G__42824;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42793){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42793);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___42812,out))
})();
var state__16275__auto__ = (function (){var statearr_42810 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42810[(6)] = c__16273__auto___42812);

return statearr_42810;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___42812,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__42826 = arguments.length;
switch (G__42826) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16273__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_42889){
var state_val_42890 = (state_42889[(1)]);
if((state_val_42890 === (7))){
var inst_42885 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
var statearr_42891_42929 = state_42889__$1;
(statearr_42891_42929[(2)] = inst_42885);

(statearr_42891_42929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (20))){
var inst_42855 = (state_42889[(7)]);
var inst_42866 = (state_42889[(2)]);
var inst_42867 = cljs.core.next(inst_42855);
var inst_42841 = inst_42867;
var inst_42842 = null;
var inst_42843 = (0);
var inst_42844 = (0);
var state_42889__$1 = (function (){var statearr_42892 = state_42889;
(statearr_42892[(8)] = inst_42866);

(statearr_42892[(9)] = inst_42841);

(statearr_42892[(10)] = inst_42842);

(statearr_42892[(11)] = inst_42844);

(statearr_42892[(12)] = inst_42843);

return statearr_42892;
})();
var statearr_42893_42930 = state_42889__$1;
(statearr_42893_42930[(2)] = null);

(statearr_42893_42930[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (1))){
var state_42889__$1 = state_42889;
var statearr_42894_42931 = state_42889__$1;
(statearr_42894_42931[(2)] = null);

(statearr_42894_42931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (4))){
var inst_42830 = (state_42889[(13)]);
var inst_42830__$1 = (state_42889[(2)]);
var inst_42831 = (inst_42830__$1 == null);
var state_42889__$1 = (function (){var statearr_42895 = state_42889;
(statearr_42895[(13)] = inst_42830__$1);

return statearr_42895;
})();
if(cljs.core.truth_(inst_42831)){
var statearr_42896_42932 = state_42889__$1;
(statearr_42896_42932[(1)] = (5));

} else {
var statearr_42897_42933 = state_42889__$1;
(statearr_42897_42933[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (15))){
var state_42889__$1 = state_42889;
var statearr_42901_42934 = state_42889__$1;
(statearr_42901_42934[(2)] = null);

(statearr_42901_42934[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (21))){
var state_42889__$1 = state_42889;
var statearr_42902_42935 = state_42889__$1;
(statearr_42902_42935[(2)] = null);

(statearr_42902_42935[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (13))){
var inst_42841 = (state_42889[(9)]);
var inst_42842 = (state_42889[(10)]);
var inst_42844 = (state_42889[(11)]);
var inst_42843 = (state_42889[(12)]);
var inst_42851 = (state_42889[(2)]);
var inst_42852 = (inst_42844 + (1));
var tmp42898 = inst_42841;
var tmp42899 = inst_42842;
var tmp42900 = inst_42843;
var inst_42841__$1 = tmp42898;
var inst_42842__$1 = tmp42899;
var inst_42843__$1 = tmp42900;
var inst_42844__$1 = inst_42852;
var state_42889__$1 = (function (){var statearr_42903 = state_42889;
(statearr_42903[(14)] = inst_42851);

(statearr_42903[(9)] = inst_42841__$1);

(statearr_42903[(10)] = inst_42842__$1);

(statearr_42903[(11)] = inst_42844__$1);

(statearr_42903[(12)] = inst_42843__$1);

return statearr_42903;
})();
var statearr_42904_42936 = state_42889__$1;
(statearr_42904_42936[(2)] = null);

(statearr_42904_42936[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (22))){
var state_42889__$1 = state_42889;
var statearr_42905_42937 = state_42889__$1;
(statearr_42905_42937[(2)] = null);

(statearr_42905_42937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (6))){
var inst_42830 = (state_42889[(13)]);
var inst_42839 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_42830) : f.call(null,inst_42830));
var inst_42840 = cljs.core.seq(inst_42839);
var inst_42841 = inst_42840;
var inst_42842 = null;
var inst_42843 = (0);
var inst_42844 = (0);
var state_42889__$1 = (function (){var statearr_42906 = state_42889;
(statearr_42906[(9)] = inst_42841);

(statearr_42906[(10)] = inst_42842);

(statearr_42906[(11)] = inst_42844);

(statearr_42906[(12)] = inst_42843);

return statearr_42906;
})();
var statearr_42907_42938 = state_42889__$1;
(statearr_42907_42938[(2)] = null);

(statearr_42907_42938[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (17))){
var inst_42855 = (state_42889[(7)]);
var inst_42859 = cljs.core.chunk_first(inst_42855);
var inst_42860 = cljs.core.chunk_rest(inst_42855);
var inst_42861 = cljs.core.count(inst_42859);
var inst_42841 = inst_42860;
var inst_42842 = inst_42859;
var inst_42843 = inst_42861;
var inst_42844 = (0);
var state_42889__$1 = (function (){var statearr_42908 = state_42889;
(statearr_42908[(9)] = inst_42841);

(statearr_42908[(10)] = inst_42842);

(statearr_42908[(11)] = inst_42844);

(statearr_42908[(12)] = inst_42843);

return statearr_42908;
})();
var statearr_42909_42939 = state_42889__$1;
(statearr_42909_42939[(2)] = null);

(statearr_42909_42939[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (3))){
var inst_42887 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42889__$1,inst_42887);
} else {
if((state_val_42890 === (12))){
var inst_42875 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
var statearr_42910_42940 = state_42889__$1;
(statearr_42910_42940[(2)] = inst_42875);

(statearr_42910_42940[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (2))){
var state_42889__$1 = state_42889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42889__$1,(4),in$);
} else {
if((state_val_42890 === (23))){
var inst_42883 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
var statearr_42911_42941 = state_42889__$1;
(statearr_42911_42941[(2)] = inst_42883);

(statearr_42911_42941[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (19))){
var inst_42870 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
var statearr_42912_42942 = state_42889__$1;
(statearr_42912_42942[(2)] = inst_42870);

(statearr_42912_42942[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (11))){
var inst_42855 = (state_42889[(7)]);
var inst_42841 = (state_42889[(9)]);
var inst_42855__$1 = cljs.core.seq(inst_42841);
var state_42889__$1 = (function (){var statearr_42913 = state_42889;
(statearr_42913[(7)] = inst_42855__$1);

return statearr_42913;
})();
if(inst_42855__$1){
var statearr_42914_42943 = state_42889__$1;
(statearr_42914_42943[(1)] = (14));

} else {
var statearr_42915_42944 = state_42889__$1;
(statearr_42915_42944[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (9))){
var inst_42877 = (state_42889[(2)]);
var inst_42878 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_42889__$1 = (function (){var statearr_42916 = state_42889;
(statearr_42916[(15)] = inst_42877);

return statearr_42916;
})();
if(cljs.core.truth_(inst_42878)){
var statearr_42917_42945 = state_42889__$1;
(statearr_42917_42945[(1)] = (21));

} else {
var statearr_42918_42946 = state_42889__$1;
(statearr_42918_42946[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (5))){
var inst_42833 = cljs.core.async.close_BANG_(out);
var state_42889__$1 = state_42889;
var statearr_42919_42947 = state_42889__$1;
(statearr_42919_42947[(2)] = inst_42833);

(statearr_42919_42947[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (14))){
var inst_42855 = (state_42889[(7)]);
var inst_42857 = cljs.core.chunked_seq_QMARK_(inst_42855);
var state_42889__$1 = state_42889;
if(inst_42857){
var statearr_42920_42948 = state_42889__$1;
(statearr_42920_42948[(1)] = (17));

} else {
var statearr_42921_42949 = state_42889__$1;
(statearr_42921_42949[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (16))){
var inst_42873 = (state_42889[(2)]);
var state_42889__$1 = state_42889;
var statearr_42922_42950 = state_42889__$1;
(statearr_42922_42950[(2)] = inst_42873);

(statearr_42922_42950[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42890 === (10))){
var inst_42842 = (state_42889[(10)]);
var inst_42844 = (state_42889[(11)]);
var inst_42849 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_42842,inst_42844);
var state_42889__$1 = state_42889;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42889__$1,(13),out,inst_42849);
} else {
if((state_val_42890 === (18))){
var inst_42855 = (state_42889[(7)]);
var inst_42864 = cljs.core.first(inst_42855);
var state_42889__$1 = state_42889;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42889__$1,(20),out,inst_42864);
} else {
if((state_val_42890 === (8))){
var inst_42844 = (state_42889[(11)]);
var inst_42843 = (state_42889[(12)]);
var inst_42846 = (inst_42844 < inst_42843);
var inst_42847 = inst_42846;
var state_42889__$1 = state_42889;
if(cljs.core.truth_(inst_42847)){
var statearr_42923_42951 = state_42889__$1;
(statearr_42923_42951[(1)] = (10));

} else {
var statearr_42924_42952 = state_42889__$1;
(statearr_42924_42952[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_42925 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42925[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__);

(statearr_42925[(1)] = (1));

return statearr_42925;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1 = (function (state_42889){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42889);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e42926){if((e42926 instanceof Object)){
var ex__16187__auto__ = e42926;
var statearr_42927_42953 = state_42889;
(statearr_42927_42953[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42889);

return cljs.core.cst$kw$recur;
} else {
throw e42926;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__42954 = state_42889;
state_42889 = G__42954;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = function(state_42889){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1.call(this,state_42889);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_42928 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_42928[(6)] = c__16273__auto__);

return statearr_42928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__42956 = arguments.length;
switch (G__42956) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__42959 = arguments.length;
switch (G__42959) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__42962 = arguments.length;
switch (G__42962) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___43009 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___43009,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___43009,out){
return (function (state_42986){
var state_val_42987 = (state_42986[(1)]);
if((state_val_42987 === (7))){
var inst_42981 = (state_42986[(2)]);
var state_42986__$1 = state_42986;
var statearr_42988_43010 = state_42986__$1;
(statearr_42988_43010[(2)] = inst_42981);

(statearr_42988_43010[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (1))){
var inst_42963 = null;
var state_42986__$1 = (function (){var statearr_42989 = state_42986;
(statearr_42989[(7)] = inst_42963);

return statearr_42989;
})();
var statearr_42990_43011 = state_42986__$1;
(statearr_42990_43011[(2)] = null);

(statearr_42990_43011[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (4))){
var inst_42966 = (state_42986[(8)]);
var inst_42966__$1 = (state_42986[(2)]);
var inst_42967 = (inst_42966__$1 == null);
var inst_42968 = cljs.core.not(inst_42967);
var state_42986__$1 = (function (){var statearr_42991 = state_42986;
(statearr_42991[(8)] = inst_42966__$1);

return statearr_42991;
})();
if(inst_42968){
var statearr_42992_43012 = state_42986__$1;
(statearr_42992_43012[(1)] = (5));

} else {
var statearr_42993_43013 = state_42986__$1;
(statearr_42993_43013[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (6))){
var state_42986__$1 = state_42986;
var statearr_42994_43014 = state_42986__$1;
(statearr_42994_43014[(2)] = null);

(statearr_42994_43014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (3))){
var inst_42983 = (state_42986[(2)]);
var inst_42984 = cljs.core.async.close_BANG_(out);
var state_42986__$1 = (function (){var statearr_42995 = state_42986;
(statearr_42995[(9)] = inst_42983);

return statearr_42995;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_42986__$1,inst_42984);
} else {
if((state_val_42987 === (2))){
var state_42986__$1 = state_42986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42986__$1,(4),ch);
} else {
if((state_val_42987 === (11))){
var inst_42966 = (state_42986[(8)]);
var inst_42975 = (state_42986[(2)]);
var inst_42963 = inst_42966;
var state_42986__$1 = (function (){var statearr_42996 = state_42986;
(statearr_42996[(10)] = inst_42975);

(statearr_42996[(7)] = inst_42963);

return statearr_42996;
})();
var statearr_42997_43015 = state_42986__$1;
(statearr_42997_43015[(2)] = null);

(statearr_42997_43015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (9))){
var inst_42966 = (state_42986[(8)]);
var state_42986__$1 = state_42986;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_42986__$1,(11),out,inst_42966);
} else {
if((state_val_42987 === (5))){
var inst_42966 = (state_42986[(8)]);
var inst_42963 = (state_42986[(7)]);
var inst_42970 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42966,inst_42963);
var state_42986__$1 = state_42986;
if(inst_42970){
var statearr_42999_43016 = state_42986__$1;
(statearr_42999_43016[(1)] = (8));

} else {
var statearr_43000_43017 = state_42986__$1;
(statearr_43000_43017[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (10))){
var inst_42978 = (state_42986[(2)]);
var state_42986__$1 = state_42986;
var statearr_43001_43018 = state_42986__$1;
(statearr_43001_43018[(2)] = inst_42978);

(statearr_43001_43018[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42987 === (8))){
var inst_42963 = (state_42986[(7)]);
var tmp42998 = inst_42963;
var inst_42963__$1 = tmp42998;
var state_42986__$1 = (function (){var statearr_43002 = state_42986;
(statearr_43002[(7)] = inst_42963__$1);

return statearr_43002;
})();
var statearr_43003_43019 = state_42986__$1;
(statearr_43003_43019[(2)] = null);

(statearr_43003_43019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___43009,out))
;
return ((function (switch__16183__auto__,c__16273__auto___43009,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_43004 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43004[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_43004[(1)] = (1));

return statearr_43004;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_42986){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_42986);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e43005){if((e43005 instanceof Object)){
var ex__16187__auto__ = e43005;
var statearr_43006_43020 = state_42986;
(statearr_43006_43020[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_42986);

return cljs.core.cst$kw$recur;
} else {
throw e43005;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__43021 = state_42986;
state_42986 = G__43021;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_42986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_42986);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___43009,out))
})();
var state__16275__auto__ = (function (){var statearr_43007 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_43007[(6)] = c__16273__auto___43009);

return statearr_43007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___43009,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__43023 = arguments.length;
switch (G__43023) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___43089 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___43089,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___43089,out){
return (function (state_43061){
var state_val_43062 = (state_43061[(1)]);
if((state_val_43062 === (7))){
var inst_43057 = (state_43061[(2)]);
var state_43061__$1 = state_43061;
var statearr_43063_43090 = state_43061__$1;
(statearr_43063_43090[(2)] = inst_43057);

(statearr_43063_43090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (1))){
var inst_43024 = (new Array(n));
var inst_43025 = inst_43024;
var inst_43026 = (0);
var state_43061__$1 = (function (){var statearr_43064 = state_43061;
(statearr_43064[(7)] = inst_43026);

(statearr_43064[(8)] = inst_43025);

return statearr_43064;
})();
var statearr_43065_43091 = state_43061__$1;
(statearr_43065_43091[(2)] = null);

(statearr_43065_43091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (4))){
var inst_43029 = (state_43061[(9)]);
var inst_43029__$1 = (state_43061[(2)]);
var inst_43030 = (inst_43029__$1 == null);
var inst_43031 = cljs.core.not(inst_43030);
var state_43061__$1 = (function (){var statearr_43066 = state_43061;
(statearr_43066[(9)] = inst_43029__$1);

return statearr_43066;
})();
if(inst_43031){
var statearr_43067_43092 = state_43061__$1;
(statearr_43067_43092[(1)] = (5));

} else {
var statearr_43068_43093 = state_43061__$1;
(statearr_43068_43093[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (15))){
var inst_43051 = (state_43061[(2)]);
var state_43061__$1 = state_43061;
var statearr_43069_43094 = state_43061__$1;
(statearr_43069_43094[(2)] = inst_43051);

(statearr_43069_43094[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (13))){
var state_43061__$1 = state_43061;
var statearr_43070_43095 = state_43061__$1;
(statearr_43070_43095[(2)] = null);

(statearr_43070_43095[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (6))){
var inst_43026 = (state_43061[(7)]);
var inst_43047 = (inst_43026 > (0));
var state_43061__$1 = state_43061;
if(cljs.core.truth_(inst_43047)){
var statearr_43071_43096 = state_43061__$1;
(statearr_43071_43096[(1)] = (12));

} else {
var statearr_43072_43097 = state_43061__$1;
(statearr_43072_43097[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (3))){
var inst_43059 = (state_43061[(2)]);
var state_43061__$1 = state_43061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43061__$1,inst_43059);
} else {
if((state_val_43062 === (12))){
var inst_43025 = (state_43061[(8)]);
var inst_43049 = cljs.core.vec(inst_43025);
var state_43061__$1 = state_43061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43061__$1,(15),out,inst_43049);
} else {
if((state_val_43062 === (2))){
var state_43061__$1 = state_43061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43061__$1,(4),ch);
} else {
if((state_val_43062 === (11))){
var inst_43041 = (state_43061[(2)]);
var inst_43042 = (new Array(n));
var inst_43025 = inst_43042;
var inst_43026 = (0);
var state_43061__$1 = (function (){var statearr_43073 = state_43061;
(statearr_43073[(10)] = inst_43041);

(statearr_43073[(7)] = inst_43026);

(statearr_43073[(8)] = inst_43025);

return statearr_43073;
})();
var statearr_43074_43098 = state_43061__$1;
(statearr_43074_43098[(2)] = null);

(statearr_43074_43098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (9))){
var inst_43025 = (state_43061[(8)]);
var inst_43039 = cljs.core.vec(inst_43025);
var state_43061__$1 = state_43061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43061__$1,(11),out,inst_43039);
} else {
if((state_val_43062 === (5))){
var inst_43026 = (state_43061[(7)]);
var inst_43025 = (state_43061[(8)]);
var inst_43034 = (state_43061[(11)]);
var inst_43029 = (state_43061[(9)]);
var inst_43033 = (inst_43025[inst_43026] = inst_43029);
var inst_43034__$1 = (inst_43026 + (1));
var inst_43035 = (inst_43034__$1 < n);
var state_43061__$1 = (function (){var statearr_43075 = state_43061;
(statearr_43075[(11)] = inst_43034__$1);

(statearr_43075[(12)] = inst_43033);

return statearr_43075;
})();
if(cljs.core.truth_(inst_43035)){
var statearr_43076_43099 = state_43061__$1;
(statearr_43076_43099[(1)] = (8));

} else {
var statearr_43077_43100 = state_43061__$1;
(statearr_43077_43100[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (14))){
var inst_43054 = (state_43061[(2)]);
var inst_43055 = cljs.core.async.close_BANG_(out);
var state_43061__$1 = (function (){var statearr_43079 = state_43061;
(statearr_43079[(13)] = inst_43054);

return statearr_43079;
})();
var statearr_43080_43101 = state_43061__$1;
(statearr_43080_43101[(2)] = inst_43055);

(statearr_43080_43101[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (10))){
var inst_43045 = (state_43061[(2)]);
var state_43061__$1 = state_43061;
var statearr_43081_43102 = state_43061__$1;
(statearr_43081_43102[(2)] = inst_43045);

(statearr_43081_43102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43062 === (8))){
var inst_43025 = (state_43061[(8)]);
var inst_43034 = (state_43061[(11)]);
var tmp43078 = inst_43025;
var inst_43025__$1 = tmp43078;
var inst_43026 = inst_43034;
var state_43061__$1 = (function (){var statearr_43082 = state_43061;
(statearr_43082[(7)] = inst_43026);

(statearr_43082[(8)] = inst_43025__$1);

return statearr_43082;
})();
var statearr_43083_43103 = state_43061__$1;
(statearr_43083_43103[(2)] = null);

(statearr_43083_43103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___43089,out))
;
return ((function (switch__16183__auto__,c__16273__auto___43089,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_43084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43084[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_43084[(1)] = (1));

return statearr_43084;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_43061){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_43061);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e43085){if((e43085 instanceof Object)){
var ex__16187__auto__ = e43085;
var statearr_43086_43104 = state_43061;
(statearr_43086_43104[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43061);

return cljs.core.cst$kw$recur;
} else {
throw e43085;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__43105 = state_43061;
state_43061 = G__43105;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_43061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_43061);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___43089,out))
})();
var state__16275__auto__ = (function (){var statearr_43087 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_43087[(6)] = c__16273__auto___43089);

return statearr_43087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___43089,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__43107 = arguments.length;
switch (G__43107) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__16273__auto___43177 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__16273__auto___43177,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___43177,out){
return (function (state_43149){
var state_val_43150 = (state_43149[(1)]);
if((state_val_43150 === (7))){
var inst_43145 = (state_43149[(2)]);
var state_43149__$1 = state_43149;
var statearr_43151_43178 = state_43149__$1;
(statearr_43151_43178[(2)] = inst_43145);

(statearr_43151_43178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (1))){
var inst_43108 = [];
var inst_43109 = inst_43108;
var inst_43110 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_43149__$1 = (function (){var statearr_43152 = state_43149;
(statearr_43152[(7)] = inst_43109);

(statearr_43152[(8)] = inst_43110);

return statearr_43152;
})();
var statearr_43153_43179 = state_43149__$1;
(statearr_43153_43179[(2)] = null);

(statearr_43153_43179[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (4))){
var inst_43113 = (state_43149[(9)]);
var inst_43113__$1 = (state_43149[(2)]);
var inst_43114 = (inst_43113__$1 == null);
var inst_43115 = cljs.core.not(inst_43114);
var state_43149__$1 = (function (){var statearr_43154 = state_43149;
(statearr_43154[(9)] = inst_43113__$1);

return statearr_43154;
})();
if(inst_43115){
var statearr_43155_43180 = state_43149__$1;
(statearr_43155_43180[(1)] = (5));

} else {
var statearr_43156_43181 = state_43149__$1;
(statearr_43156_43181[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (15))){
var inst_43139 = (state_43149[(2)]);
var state_43149__$1 = state_43149;
var statearr_43157_43182 = state_43149__$1;
(statearr_43157_43182[(2)] = inst_43139);

(statearr_43157_43182[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (13))){
var state_43149__$1 = state_43149;
var statearr_43158_43183 = state_43149__$1;
(statearr_43158_43183[(2)] = null);

(statearr_43158_43183[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (6))){
var inst_43109 = (state_43149[(7)]);
var inst_43134 = inst_43109.length;
var inst_43135 = (inst_43134 > (0));
var state_43149__$1 = state_43149;
if(cljs.core.truth_(inst_43135)){
var statearr_43159_43184 = state_43149__$1;
(statearr_43159_43184[(1)] = (12));

} else {
var statearr_43160_43185 = state_43149__$1;
(statearr_43160_43185[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (3))){
var inst_43147 = (state_43149[(2)]);
var state_43149__$1 = state_43149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43149__$1,inst_43147);
} else {
if((state_val_43150 === (12))){
var inst_43109 = (state_43149[(7)]);
var inst_43137 = cljs.core.vec(inst_43109);
var state_43149__$1 = state_43149;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43149__$1,(15),out,inst_43137);
} else {
if((state_val_43150 === (2))){
var state_43149__$1 = state_43149;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43149__$1,(4),ch);
} else {
if((state_val_43150 === (11))){
var inst_43117 = (state_43149[(10)]);
var inst_43113 = (state_43149[(9)]);
var inst_43127 = (state_43149[(2)]);
var inst_43128 = [];
var inst_43129 = inst_43128.push(inst_43113);
var inst_43109 = inst_43128;
var inst_43110 = inst_43117;
var state_43149__$1 = (function (){var statearr_43161 = state_43149;
(statearr_43161[(11)] = inst_43127);

(statearr_43161[(7)] = inst_43109);

(statearr_43161[(8)] = inst_43110);

(statearr_43161[(12)] = inst_43129);

return statearr_43161;
})();
var statearr_43162_43186 = state_43149__$1;
(statearr_43162_43186[(2)] = null);

(statearr_43162_43186[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (9))){
var inst_43109 = (state_43149[(7)]);
var inst_43125 = cljs.core.vec(inst_43109);
var state_43149__$1 = state_43149;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_43149__$1,(11),out,inst_43125);
} else {
if((state_val_43150 === (5))){
var inst_43117 = (state_43149[(10)]);
var inst_43110 = (state_43149[(8)]);
var inst_43113 = (state_43149[(9)]);
var inst_43117__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_43113) : f.call(null,inst_43113));
var inst_43118 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43117__$1,inst_43110);
var inst_43119 = cljs.core.keyword_identical_QMARK_(inst_43110,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_43120 = (inst_43118) || (inst_43119);
var state_43149__$1 = (function (){var statearr_43163 = state_43149;
(statearr_43163[(10)] = inst_43117__$1);

return statearr_43163;
})();
if(cljs.core.truth_(inst_43120)){
var statearr_43164_43187 = state_43149__$1;
(statearr_43164_43187[(1)] = (8));

} else {
var statearr_43165_43188 = state_43149__$1;
(statearr_43165_43188[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (14))){
var inst_43142 = (state_43149[(2)]);
var inst_43143 = cljs.core.async.close_BANG_(out);
var state_43149__$1 = (function (){var statearr_43167 = state_43149;
(statearr_43167[(13)] = inst_43142);

return statearr_43167;
})();
var statearr_43168_43189 = state_43149__$1;
(statearr_43168_43189[(2)] = inst_43143);

(statearr_43168_43189[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (10))){
var inst_43132 = (state_43149[(2)]);
var state_43149__$1 = state_43149;
var statearr_43169_43190 = state_43149__$1;
(statearr_43169_43190[(2)] = inst_43132);

(statearr_43169_43190[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43150 === (8))){
var inst_43117 = (state_43149[(10)]);
var inst_43109 = (state_43149[(7)]);
var inst_43113 = (state_43149[(9)]);
var inst_43122 = inst_43109.push(inst_43113);
var tmp43166 = inst_43109;
var inst_43109__$1 = tmp43166;
var inst_43110 = inst_43117;
var state_43149__$1 = (function (){var statearr_43170 = state_43149;
(statearr_43170[(7)] = inst_43109__$1);

(statearr_43170[(8)] = inst_43110);

(statearr_43170[(14)] = inst_43122);

return statearr_43170;
})();
var statearr_43171_43191 = state_43149__$1;
(statearr_43171_43191[(2)] = null);

(statearr_43171_43191[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___43177,out))
;
return ((function (switch__16183__auto__,c__16273__auto___43177,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_43172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43172[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_43172[(1)] = (1));

return statearr_43172;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_43149){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__(state_43149);
if(cljs.core.keyword_identical_QMARK_(result__16186__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e43173){if((e43173 instanceof Object)){
var ex__16187__auto__ = e43173;
var statearr_43174_43192 = state_43149;
(statearr_43174_43192[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_43149);

return cljs.core.cst$kw$recur;
} else {
throw e43173;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16185__auto__,cljs.core.cst$kw$recur)){
var G__43193 = state_43149;
state_43149 = G__43193;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_43149){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_43149);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___43177,out))
})();
var state__16275__auto__ = (function (){var statearr_43175 = (f__16274__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16274__auto__.cljs$core$IFn$_invoke$arity$0() : f__16274__auto__.call(null));
(statearr_43175[(6)] = c__16273__auto___43177);

return statearr_43175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16275__auto__);
});})(c__16273__auto___43177,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

