// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__32853 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__32854 = null;
var count__32855 = (0);
var i__32856 = (0);
while(true){
if((i__32856 < count__32855)){
var vec__32857 = cljs.core._nth.call(null,chunk__32854,i__32856);
var effect_key = cljs.core.nth.call(null,vec__32857,(0),null);
var effect_value = cljs.core.nth.call(null,vec__32857,(1),null);
var temp__5455__auto___32863 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___32863)){
var effect_fn_32864 = temp__5455__auto___32863;
effect_fn_32864.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__32865 = seq__32853;
var G__32866 = chunk__32854;
var G__32867 = count__32855;
var G__32868 = (i__32856 + (1));
seq__32853 = G__32865;
chunk__32854 = G__32866;
count__32855 = G__32867;
i__32856 = G__32868;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32853);
if(temp__5457__auto__){
var seq__32853__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32853__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__32853__$1);
var G__32869 = cljs.core.chunk_rest.call(null,seq__32853__$1);
var G__32870 = c__9319__auto__;
var G__32871 = cljs.core.count.call(null,c__9319__auto__);
var G__32872 = (0);
seq__32853 = G__32869;
chunk__32854 = G__32870;
count__32855 = G__32871;
i__32856 = G__32872;
continue;
} else {
var vec__32860 = cljs.core.first.call(null,seq__32853__$1);
var effect_key = cljs.core.nth.call(null,vec__32860,(0),null);
var effect_value = cljs.core.nth.call(null,vec__32860,(1),null);
var temp__5455__auto___32873 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___32873)){
var effect_fn_32874 = temp__5455__auto___32873;
effect_fn_32874.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__32875 = cljs.core.next.call(null,seq__32853__$1);
var G__32876 = null;
var G__32877 = (0);
var G__32878 = (0);
seq__32853 = G__32875;
chunk__32854 = G__32876;
count__32855 = G__32877;
i__32856 = G__32878;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__32879 = cljs.core.seq.call(null,value);
var chunk__32880 = null;
var count__32881 = (0);
var i__32882 = (0);
while(true){
if((i__32882 < count__32881)){
var map__32883 = cljs.core._nth.call(null,chunk__32880,i__32882);
var map__32883__$1 = ((((!((map__32883 == null)))?((((map__32883.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32883.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32883):map__32883);
var effect = map__32883__$1;
var ms = cljs.core.get.call(null,map__32883__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__32883__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__32879,chunk__32880,count__32881,i__32882,map__32883,map__32883__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__32879,chunk__32880,count__32881,i__32882,map__32883,map__32883__$1,effect,ms,dispatch))
,ms);
}

var G__32887 = seq__32879;
var G__32888 = chunk__32880;
var G__32889 = count__32881;
var G__32890 = (i__32882 + (1));
seq__32879 = G__32887;
chunk__32880 = G__32888;
count__32881 = G__32889;
i__32882 = G__32890;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32879);
if(temp__5457__auto__){
var seq__32879__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32879__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__32879__$1);
var G__32891 = cljs.core.chunk_rest.call(null,seq__32879__$1);
var G__32892 = c__9319__auto__;
var G__32893 = cljs.core.count.call(null,c__9319__auto__);
var G__32894 = (0);
seq__32879 = G__32891;
chunk__32880 = G__32892;
count__32881 = G__32893;
i__32882 = G__32894;
continue;
} else {
var map__32885 = cljs.core.first.call(null,seq__32879__$1);
var map__32885__$1 = ((((!((map__32885 == null)))?((((map__32885.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32885.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32885):map__32885);
var effect = map__32885__$1;
var ms = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__32885__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__32879,chunk__32880,count__32881,i__32882,map__32885,map__32885__$1,effect,ms,dispatch,seq__32879__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__32879,chunk__32880,count__32881,i__32882,map__32885,map__32885__$1,effect,ms,dispatch,seq__32879__$1,temp__5457__auto__))
,ms);
}

var G__32895 = cljs.core.next.call(null,seq__32879__$1);
var G__32896 = null;
var G__32897 = (0);
var G__32898 = (0);
seq__32879 = G__32895;
chunk__32880 = G__32896;
count__32881 = G__32897;
i__32882 = G__32898;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__32899 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__32900 = null;
var count__32901 = (0);
var i__32902 = (0);
while(true){
if((i__32902 < count__32901)){
var event = cljs.core._nth.call(null,chunk__32900,i__32902);
re_frame.router.dispatch.call(null,event);

var G__32903 = seq__32899;
var G__32904 = chunk__32900;
var G__32905 = count__32901;
var G__32906 = (i__32902 + (1));
seq__32899 = G__32903;
chunk__32900 = G__32904;
count__32901 = G__32905;
i__32902 = G__32906;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32899);
if(temp__5457__auto__){
var seq__32899__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32899__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__32899__$1);
var G__32907 = cljs.core.chunk_rest.call(null,seq__32899__$1);
var G__32908 = c__9319__auto__;
var G__32909 = cljs.core.count.call(null,c__9319__auto__);
var G__32910 = (0);
seq__32899 = G__32907;
chunk__32900 = G__32908;
count__32901 = G__32909;
i__32902 = G__32910;
continue;
} else {
var event = cljs.core.first.call(null,seq__32899__$1);
re_frame.router.dispatch.call(null,event);

var G__32911 = cljs.core.next.call(null,seq__32899__$1);
var G__32912 = null;
var G__32913 = (0);
var G__32914 = (0);
seq__32899 = G__32911;
chunk__32900 = G__32912;
count__32901 = G__32913;
i__32902 = G__32914;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__32915 = cljs.core.seq.call(null,value);
var chunk__32916 = null;
var count__32917 = (0);
var i__32918 = (0);
while(true){
if((i__32918 < count__32917)){
var event = cljs.core._nth.call(null,chunk__32916,i__32918);
clear_event.call(null,event);

var G__32919 = seq__32915;
var G__32920 = chunk__32916;
var G__32921 = count__32917;
var G__32922 = (i__32918 + (1));
seq__32915 = G__32919;
chunk__32916 = G__32920;
count__32917 = G__32921;
i__32918 = G__32922;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32915);
if(temp__5457__auto__){
var seq__32915__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32915__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__32915__$1);
var G__32923 = cljs.core.chunk_rest.call(null,seq__32915__$1);
var G__32924 = c__9319__auto__;
var G__32925 = cljs.core.count.call(null,c__9319__auto__);
var G__32926 = (0);
seq__32915 = G__32923;
chunk__32916 = G__32924;
count__32917 = G__32925;
i__32918 = G__32926;
continue;
} else {
var event = cljs.core.first.call(null,seq__32915__$1);
clear_event.call(null,event);

var G__32927 = cljs.core.next.call(null,seq__32915__$1);
var G__32928 = null;
var G__32929 = (0);
var G__32930 = (0);
seq__32915 = G__32927;
chunk__32916 = G__32928;
count__32917 = G__32929;
i__32918 = G__32930;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));
