// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__33625 = arguments.length;
switch (G__33625) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async33626 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33626 = (function (f,blockable,meta33627){
this.f = f;
this.blockable = blockable;
this.meta33627 = meta33627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33628,meta33627__$1){
var self__ = this;
var _33628__$1 = this;
return (new cljs.core.async.t_cljs$core$async33626(self__.f,self__.blockable,meta33627__$1));
});

cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33628){
var self__ = this;
var _33628__$1 = this;
return self__.meta33627;
});

cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async33626.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async33626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta33627","meta33627",-534857492,null)], null);
});

cljs.core.async.t_cljs$core$async33626.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33626.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33626";

cljs.core.async.t_cljs$core$async33626.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async33626");
});

cljs.core.async.__GT_t_cljs$core$async33626 = (function cljs$core$async$__GT_t_cljs$core$async33626(f__$1,blockable__$1,meta33627){
return (new cljs.core.async.t_cljs$core$async33626(f__$1,blockable__$1,meta33627));
});

}

return (new cljs.core.async.t_cljs$core$async33626(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__33632 = arguments.length;
switch (G__33632) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__33635 = arguments.length;
switch (G__33635) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__33638 = arguments.length;
switch (G__33638) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_33640 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_33640);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_33640,ret){
return (function (){
return fn1.call(null,val_33640);
});})(val_33640,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__33642 = arguments.length;
switch (G__33642) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9433__auto___33644 = n;
var x_33645 = (0);
while(true){
if((x_33645 < n__9433__auto___33644)){
(a[x_33645] = (0));

var G__33646 = (x_33645 + (1));
x_33645 = G__33646;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__33647 = (i + (1));
i = G__33647;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async33648 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33648 = (function (flag,meta33649){
this.flag = flag;
this.meta33649 = meta33649;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_33650,meta33649__$1){
var self__ = this;
var _33650__$1 = this;
return (new cljs.core.async.t_cljs$core$async33648(self__.flag,meta33649__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_33650){
var self__ = this;
var _33650__$1 = this;
return self__.meta33649;
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta33649","meta33649",637761193,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async33648.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33648.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33648";

cljs.core.async.t_cljs$core$async33648.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async33648");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async33648 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async33648(flag__$1,meta33649){
return (new cljs.core.async.t_cljs$core$async33648(flag__$1,meta33649));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async33648(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async33651 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33651 = (function (flag,cb,meta33652){
this.flag = flag;
this.cb = cb;
this.meta33652 = meta33652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33653,meta33652__$1){
var self__ = this;
var _33653__$1 = this;
return (new cljs.core.async.t_cljs$core$async33651(self__.flag,self__.cb,meta33652__$1));
});

cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33653){
var self__ = this;
var _33653__$1 = this;
return self__.meta33652;
});

cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async33651.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async33651.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta33652","meta33652",1543111349,null)], null);
});

cljs.core.async.t_cljs$core$async33651.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33651";

cljs.core.async.t_cljs$core$async33651.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async33651");
});

cljs.core.async.__GT_t_cljs$core$async33651 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async33651(flag__$1,cb__$1,meta33652){
return (new cljs.core.async.t_cljs$core$async33651(flag__$1,cb__$1,meta33652));
});

}

return (new cljs.core.async.t_cljs$core$async33651(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33654_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33654_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__33655_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__33655_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8388__auto__ = wport;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33656 = (i + (1));
i = G__33656;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8388__auto__ = ret;
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__8376__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8376__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8376__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___33662 = arguments.length;
var i__9668__auto___33663 = (0);
while(true){
if((i__9668__auto___33663 < len__9667__auto___33662)){
args__9674__auto__.push((arguments[i__9668__auto___33663]));

var G__33664 = (i__9668__auto___33663 + (1));
i__9668__auto___33663 = G__33664;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((1) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9675__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__33659){
var map__33660 = p__33659;
var map__33660__$1 = ((((!((map__33660 == null)))?((((map__33660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33660.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33660):map__33660);
var opts = map__33660__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq33657){
var G__33658 = cljs.core.first.call(null,seq33657);
var seq33657__$1 = cljs.core.next.call(null,seq33657);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33658,seq33657__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__33666 = arguments.length;
switch (G__33666) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16273__auto___33712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___33712){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___33712){
return (function (state_33690){
var state_val_33691 = (state_33690[(1)]);
if((state_val_33691 === (7))){
var inst_33686 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33692_33713 = state_33690__$1;
(statearr_33692_33713[(2)] = inst_33686);

(statearr_33692_33713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (1))){
var state_33690__$1 = state_33690;
var statearr_33693_33714 = state_33690__$1;
(statearr_33693_33714[(2)] = null);

(statearr_33693_33714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (4))){
var inst_33669 = (state_33690[(7)]);
var inst_33669__$1 = (state_33690[(2)]);
var inst_33670 = (inst_33669__$1 == null);
var state_33690__$1 = (function (){var statearr_33694 = state_33690;
(statearr_33694[(7)] = inst_33669__$1);

return statearr_33694;
})();
if(cljs.core.truth_(inst_33670)){
var statearr_33695_33715 = state_33690__$1;
(statearr_33695_33715[(1)] = (5));

} else {
var statearr_33696_33716 = state_33690__$1;
(statearr_33696_33716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (13))){
var state_33690__$1 = state_33690;
var statearr_33697_33717 = state_33690__$1;
(statearr_33697_33717[(2)] = null);

(statearr_33697_33717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (6))){
var inst_33669 = (state_33690[(7)]);
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33690__$1,(11),to,inst_33669);
} else {
if((state_val_33691 === (3))){
var inst_33688 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33690__$1,inst_33688);
} else {
if((state_val_33691 === (12))){
var state_33690__$1 = state_33690;
var statearr_33698_33718 = state_33690__$1;
(statearr_33698_33718[(2)] = null);

(statearr_33698_33718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (2))){
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33690__$1,(4),from);
} else {
if((state_val_33691 === (11))){
var inst_33679 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
if(cljs.core.truth_(inst_33679)){
var statearr_33699_33719 = state_33690__$1;
(statearr_33699_33719[(1)] = (12));

} else {
var statearr_33700_33720 = state_33690__$1;
(statearr_33700_33720[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (9))){
var state_33690__$1 = state_33690;
var statearr_33701_33721 = state_33690__$1;
(statearr_33701_33721[(2)] = null);

(statearr_33701_33721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (5))){
var state_33690__$1 = state_33690;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33702_33722 = state_33690__$1;
(statearr_33702_33722[(1)] = (8));

} else {
var statearr_33703_33723 = state_33690__$1;
(statearr_33703_33723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (14))){
var inst_33684 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33704_33724 = state_33690__$1;
(statearr_33704_33724[(2)] = inst_33684);

(statearr_33704_33724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (10))){
var inst_33676 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33705_33725 = state_33690__$1;
(statearr_33705_33725[(2)] = inst_33676);

(statearr_33705_33725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33691 === (8))){
var inst_33673 = cljs.core.async.close_BANG_.call(null,to);
var state_33690__$1 = state_33690;
var statearr_33706_33726 = state_33690__$1;
(statearr_33706_33726[(2)] = inst_33673);

(statearr_33706_33726[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___33712))
;
return ((function (switch__16183__auto__,c__16273__auto___33712){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_33707 = [null,null,null,null,null,null,null,null];
(statearr_33707[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_33707[(1)] = (1));

return statearr_33707;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_33690){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33708){if((e33708 instanceof Object)){
var ex__16187__auto__ = e33708;
var statearr_33709_33727 = state_33690;
(statearr_33709_33727[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33690);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33728 = state_33690;
state_33690 = G__33728;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_33690){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_33690);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___33712))
})();
var state__16275__auto__ = (function (){var statearr_33710 = f__16274__auto__.call(null);
(statearr_33710[(6)] = c__16273__auto___33712);

return statearr_33710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___33712))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__33729){
var vec__33730 = p__33729;
var v = cljs.core.nth.call(null,vec__33730,(0),null);
var p = cljs.core.nth.call(null,vec__33730,(1),null);
var job = vec__33730;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16273__auto___33901 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results){
return (function (state_33737){
var state_val_33738 = (state_33737[(1)]);
if((state_val_33738 === (1))){
var state_33737__$1 = state_33737;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33737__$1,(2),res,v);
} else {
if((state_val_33738 === (2))){
var inst_33734 = (state_33737[(2)]);
var inst_33735 = cljs.core.async.close_BANG_.call(null,res);
var state_33737__$1 = (function (){var statearr_33739 = state_33737;
(statearr_33739[(7)] = inst_33734);

return statearr_33739;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33737__$1,inst_33735);
} else {
return null;
}
}
});})(c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results))
;
return ((function (switch__16183__auto__,c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_33740 = [null,null,null,null,null,null,null,null];
(statearr_33740[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_33740[(1)] = (1));

return statearr_33740;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_33737){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33741){if((e33741 instanceof Object)){
var ex__16187__auto__ = e33741;
var statearr_33742_33902 = state_33737;
(statearr_33742_33902[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33737);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33741;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33903 = state_33737;
state_33737 = G__33903;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_33737){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_33737);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results))
})();
var state__16275__auto__ = (function (){var statearr_33743 = f__16274__auto__.call(null);
(statearr_33743[(6)] = c__16273__auto___33901);

return statearr_33743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___33901,res,vec__33730,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__33744){
var vec__33745 = p__33744;
var v = cljs.core.nth.call(null,vec__33745,(0),null);
var p = cljs.core.nth.call(null,vec__33745,(1),null);
var job = vec__33745;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9433__auto___33904 = n;
var __33905 = (0);
while(true){
if((__33905 < n__9433__auto___33904)){
var G__33748_33906 = type;
var G__33748_33907__$1 = (((G__33748_33906 instanceof cljs.core.Keyword))?G__33748_33906.fqn:null);
switch (G__33748_33907__$1) {
case "compute":
var c__16273__auto___33909 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__33905,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__33905,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function (state_33761){
var state_val_33762 = (state_33761[(1)]);
if((state_val_33762 === (1))){
var state_33761__$1 = state_33761;
var statearr_33763_33910 = state_33761__$1;
(statearr_33763_33910[(2)] = null);

(statearr_33763_33910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33762 === (2))){
var state_33761__$1 = state_33761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33761__$1,(4),jobs);
} else {
if((state_val_33762 === (3))){
var inst_33759 = (state_33761[(2)]);
var state_33761__$1 = state_33761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33761__$1,inst_33759);
} else {
if((state_val_33762 === (4))){
var inst_33751 = (state_33761[(2)]);
var inst_33752 = process.call(null,inst_33751);
var state_33761__$1 = state_33761;
if(cljs.core.truth_(inst_33752)){
var statearr_33764_33911 = state_33761__$1;
(statearr_33764_33911[(1)] = (5));

} else {
var statearr_33765_33912 = state_33761__$1;
(statearr_33765_33912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33762 === (5))){
var state_33761__$1 = state_33761;
var statearr_33766_33913 = state_33761__$1;
(statearr_33766_33913[(2)] = null);

(statearr_33766_33913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33762 === (6))){
var state_33761__$1 = state_33761;
var statearr_33767_33914 = state_33761__$1;
(statearr_33767_33914[(2)] = null);

(statearr_33767_33914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33762 === (7))){
var inst_33757 = (state_33761[(2)]);
var state_33761__$1 = state_33761;
var statearr_33768_33915 = state_33761__$1;
(statearr_33768_33915[(2)] = inst_33757);

(statearr_33768_33915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33905,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
;
return ((function (__33905,switch__16183__auto__,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_33769 = [null,null,null,null,null,null,null];
(statearr_33769[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_33769[(1)] = (1));

return statearr_33769;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_33761){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33770){if((e33770 instanceof Object)){
var ex__16187__auto__ = e33770;
var statearr_33771_33916 = state_33761;
(statearr_33771_33916[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33761);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33917 = state_33761;
state_33761 = G__33917;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_33761){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_33761);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__33905,switch__16183__auto__,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_33772 = f__16274__auto__.call(null);
(statearr_33772[(6)] = c__16273__auto___33909);

return statearr_33772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__33905,c__16273__auto___33909,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
);


break;
case "async":
var c__16273__auto___33918 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__33905,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (__33905,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function (state_33785){
var state_val_33786 = (state_33785[(1)]);
if((state_val_33786 === (1))){
var state_33785__$1 = state_33785;
var statearr_33787_33919 = state_33785__$1;
(statearr_33787_33919[(2)] = null);

(statearr_33787_33919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (2))){
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33785__$1,(4),jobs);
} else {
if((state_val_33786 === (3))){
var inst_33783 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33785__$1,inst_33783);
} else {
if((state_val_33786 === (4))){
var inst_33775 = (state_33785[(2)]);
var inst_33776 = async.call(null,inst_33775);
var state_33785__$1 = state_33785;
if(cljs.core.truth_(inst_33776)){
var statearr_33788_33920 = state_33785__$1;
(statearr_33788_33920[(1)] = (5));

} else {
var statearr_33789_33921 = state_33785__$1;
(statearr_33789_33921[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (5))){
var state_33785__$1 = state_33785;
var statearr_33790_33922 = state_33785__$1;
(statearr_33790_33922[(2)] = null);

(statearr_33790_33922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (6))){
var state_33785__$1 = state_33785;
var statearr_33791_33923 = state_33785__$1;
(statearr_33791_33923[(2)] = null);

(statearr_33791_33923[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33786 === (7))){
var inst_33781 = (state_33785[(2)]);
var state_33785__$1 = state_33785;
var statearr_33792_33924 = state_33785__$1;
(statearr_33792_33924[(2)] = inst_33781);

(statearr_33792_33924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33905,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
;
return ((function (__33905,switch__16183__auto__,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_33793 = [null,null,null,null,null,null,null];
(statearr_33793[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_33793[(1)] = (1));

return statearr_33793;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_33785){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33794){if((e33794 instanceof Object)){
var ex__16187__auto__ = e33794;
var statearr_33795_33925 = state_33785;
(statearr_33795_33925[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33785);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33926 = state_33785;
state_33785 = G__33926;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_33785){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_33785);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(__33905,switch__16183__auto__,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_33796 = f__16274__auto__.call(null);
(statearr_33796[(6)] = c__16273__auto___33918);

return statearr_33796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(__33905,c__16273__auto___33918,G__33748_33906,G__33748_33907__$1,n__9433__auto___33904,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33748_33907__$1)].join('')));

}

var G__33927 = (__33905 + (1));
__33905 = G__33927;
continue;
} else {
}
break;
}

var c__16273__auto___33928 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___33928,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___33928,jobs,results,process,async){
return (function (state_33818){
var state_val_33819 = (state_33818[(1)]);
if((state_val_33819 === (1))){
var state_33818__$1 = state_33818;
var statearr_33820_33929 = state_33818__$1;
(statearr_33820_33929[(2)] = null);

(statearr_33820_33929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33819 === (2))){
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33818__$1,(4),from);
} else {
if((state_val_33819 === (3))){
var inst_33816 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33818__$1,inst_33816);
} else {
if((state_val_33819 === (4))){
var inst_33799 = (state_33818[(7)]);
var inst_33799__$1 = (state_33818[(2)]);
var inst_33800 = (inst_33799__$1 == null);
var state_33818__$1 = (function (){var statearr_33821 = state_33818;
(statearr_33821[(7)] = inst_33799__$1);

return statearr_33821;
})();
if(cljs.core.truth_(inst_33800)){
var statearr_33822_33930 = state_33818__$1;
(statearr_33822_33930[(1)] = (5));

} else {
var statearr_33823_33931 = state_33818__$1;
(statearr_33823_33931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33819 === (5))){
var inst_33802 = cljs.core.async.close_BANG_.call(null,jobs);
var state_33818__$1 = state_33818;
var statearr_33824_33932 = state_33818__$1;
(statearr_33824_33932[(2)] = inst_33802);

(statearr_33824_33932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33819 === (6))){
var inst_33799 = (state_33818[(7)]);
var inst_33804 = (state_33818[(8)]);
var inst_33804__$1 = cljs.core.async.chan.call(null,(1));
var inst_33805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33806 = [inst_33799,inst_33804__$1];
var inst_33807 = (new cljs.core.PersistentVector(null,2,(5),inst_33805,inst_33806,null));
var state_33818__$1 = (function (){var statearr_33825 = state_33818;
(statearr_33825[(8)] = inst_33804__$1);

return statearr_33825;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33818__$1,(8),jobs,inst_33807);
} else {
if((state_val_33819 === (7))){
var inst_33814 = (state_33818[(2)]);
var state_33818__$1 = state_33818;
var statearr_33826_33933 = state_33818__$1;
(statearr_33826_33933[(2)] = inst_33814);

(statearr_33826_33933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33819 === (8))){
var inst_33804 = (state_33818[(8)]);
var inst_33809 = (state_33818[(2)]);
var state_33818__$1 = (function (){var statearr_33827 = state_33818;
(statearr_33827[(9)] = inst_33809);

return statearr_33827;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33818__$1,(9),results,inst_33804);
} else {
if((state_val_33819 === (9))){
var inst_33811 = (state_33818[(2)]);
var state_33818__$1 = (function (){var statearr_33828 = state_33818;
(statearr_33828[(10)] = inst_33811);

return statearr_33828;
})();
var statearr_33829_33934 = state_33818__$1;
(statearr_33829_33934[(2)] = null);

(statearr_33829_33934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___33928,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto___33928,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_33830 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33830[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_33830[(1)] = (1));

return statearr_33830;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_33818){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33831){if((e33831 instanceof Object)){
var ex__16187__auto__ = e33831;
var statearr_33832_33935 = state_33818;
(statearr_33832_33935[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33818);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33831;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33936 = state_33818;
state_33818 = G__33936;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_33818){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_33818);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___33928,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_33833 = f__16274__auto__.call(null);
(statearr_33833[(6)] = c__16273__auto___33928);

return statearr_33833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___33928,jobs,results,process,async))
);


var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,jobs,results,process,async){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,jobs,results,process,async){
return (function (state_33871){
var state_val_33872 = (state_33871[(1)]);
if((state_val_33872 === (7))){
var inst_33867 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
var statearr_33873_33937 = state_33871__$1;
(statearr_33873_33937[(2)] = inst_33867);

(statearr_33873_33937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (20))){
var state_33871__$1 = state_33871;
var statearr_33874_33938 = state_33871__$1;
(statearr_33874_33938[(2)] = null);

(statearr_33874_33938[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (1))){
var state_33871__$1 = state_33871;
var statearr_33875_33939 = state_33871__$1;
(statearr_33875_33939[(2)] = null);

(statearr_33875_33939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (4))){
var inst_33836 = (state_33871[(7)]);
var inst_33836__$1 = (state_33871[(2)]);
var inst_33837 = (inst_33836__$1 == null);
var state_33871__$1 = (function (){var statearr_33876 = state_33871;
(statearr_33876[(7)] = inst_33836__$1);

return statearr_33876;
})();
if(cljs.core.truth_(inst_33837)){
var statearr_33877_33940 = state_33871__$1;
(statearr_33877_33940[(1)] = (5));

} else {
var statearr_33878_33941 = state_33871__$1;
(statearr_33878_33941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (15))){
var inst_33849 = (state_33871[(8)]);
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33871__$1,(18),to,inst_33849);
} else {
if((state_val_33872 === (21))){
var inst_33862 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
var statearr_33879_33942 = state_33871__$1;
(statearr_33879_33942[(2)] = inst_33862);

(statearr_33879_33942[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (13))){
var inst_33864 = (state_33871[(2)]);
var state_33871__$1 = (function (){var statearr_33880 = state_33871;
(statearr_33880[(9)] = inst_33864);

return statearr_33880;
})();
var statearr_33881_33943 = state_33871__$1;
(statearr_33881_33943[(2)] = null);

(statearr_33881_33943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (6))){
var inst_33836 = (state_33871[(7)]);
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33871__$1,(11),inst_33836);
} else {
if((state_val_33872 === (17))){
var inst_33857 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
if(cljs.core.truth_(inst_33857)){
var statearr_33882_33944 = state_33871__$1;
(statearr_33882_33944[(1)] = (19));

} else {
var statearr_33883_33945 = state_33871__$1;
(statearr_33883_33945[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (3))){
var inst_33869 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33871__$1,inst_33869);
} else {
if((state_val_33872 === (12))){
var inst_33846 = (state_33871[(10)]);
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33871__$1,(14),inst_33846);
} else {
if((state_val_33872 === (2))){
var state_33871__$1 = state_33871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33871__$1,(4),results);
} else {
if((state_val_33872 === (19))){
var state_33871__$1 = state_33871;
var statearr_33884_33946 = state_33871__$1;
(statearr_33884_33946[(2)] = null);

(statearr_33884_33946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (11))){
var inst_33846 = (state_33871[(2)]);
var state_33871__$1 = (function (){var statearr_33885 = state_33871;
(statearr_33885[(10)] = inst_33846);

return statearr_33885;
})();
var statearr_33886_33947 = state_33871__$1;
(statearr_33886_33947[(2)] = null);

(statearr_33886_33947[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (9))){
var state_33871__$1 = state_33871;
var statearr_33887_33948 = state_33871__$1;
(statearr_33887_33948[(2)] = null);

(statearr_33887_33948[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (5))){
var state_33871__$1 = state_33871;
if(cljs.core.truth_(close_QMARK_)){
var statearr_33888_33949 = state_33871__$1;
(statearr_33888_33949[(1)] = (8));

} else {
var statearr_33889_33950 = state_33871__$1;
(statearr_33889_33950[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (14))){
var inst_33851 = (state_33871[(11)]);
var inst_33849 = (state_33871[(8)]);
var inst_33849__$1 = (state_33871[(2)]);
var inst_33850 = (inst_33849__$1 == null);
var inst_33851__$1 = cljs.core.not.call(null,inst_33850);
var state_33871__$1 = (function (){var statearr_33890 = state_33871;
(statearr_33890[(11)] = inst_33851__$1);

(statearr_33890[(8)] = inst_33849__$1);

return statearr_33890;
})();
if(inst_33851__$1){
var statearr_33891_33951 = state_33871__$1;
(statearr_33891_33951[(1)] = (15));

} else {
var statearr_33892_33952 = state_33871__$1;
(statearr_33892_33952[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (16))){
var inst_33851 = (state_33871[(11)]);
var state_33871__$1 = state_33871;
var statearr_33893_33953 = state_33871__$1;
(statearr_33893_33953[(2)] = inst_33851);

(statearr_33893_33953[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (10))){
var inst_33843 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
var statearr_33894_33954 = state_33871__$1;
(statearr_33894_33954[(2)] = inst_33843);

(statearr_33894_33954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (18))){
var inst_33854 = (state_33871[(2)]);
var state_33871__$1 = state_33871;
var statearr_33895_33955 = state_33871__$1;
(statearr_33895_33955[(2)] = inst_33854);

(statearr_33895_33955[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33872 === (8))){
var inst_33840 = cljs.core.async.close_BANG_.call(null,to);
var state_33871__$1 = state_33871;
var statearr_33896_33956 = state_33871__$1;
(statearr_33896_33956[(2)] = inst_33840);

(statearr_33896_33956[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__,jobs,results,process,async))
;
return ((function (switch__16183__auto__,c__16273__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_33897 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33897[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__);

(statearr_33897[(1)] = (1));

return statearr_33897;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1 = (function (state_33871){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e33898){if((e33898 instanceof Object)){
var ex__16187__auto__ = e33898;
var statearr_33899_33957 = state_33871;
(statearr_33899_33957[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33958 = state_33871;
state_33871 = G__33958;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__ = function(state_33871){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1.call(this,state_33871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,jobs,results,process,async))
})();
var state__16275__auto__ = (function (){var statearr_33900 = f__16274__auto__.call(null);
(statearr_33900[(6)] = c__16273__auto__);

return statearr_33900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,jobs,results,process,async))
);

return c__16273__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__33960 = arguments.length;
switch (G__33960) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__33963 = arguments.length;
switch (G__33963) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__33966 = arguments.length;
switch (G__33966) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16273__auto___34015 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34015,tc,fc){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34015,tc,fc){
return (function (state_33992){
var state_val_33993 = (state_33992[(1)]);
if((state_val_33993 === (7))){
var inst_33988 = (state_33992[(2)]);
var state_33992__$1 = state_33992;
var statearr_33994_34016 = state_33992__$1;
(statearr_33994_34016[(2)] = inst_33988);

(statearr_33994_34016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (1))){
var state_33992__$1 = state_33992;
var statearr_33995_34017 = state_33992__$1;
(statearr_33995_34017[(2)] = null);

(statearr_33995_34017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (4))){
var inst_33969 = (state_33992[(7)]);
var inst_33969__$1 = (state_33992[(2)]);
var inst_33970 = (inst_33969__$1 == null);
var state_33992__$1 = (function (){var statearr_33996 = state_33992;
(statearr_33996[(7)] = inst_33969__$1);

return statearr_33996;
})();
if(cljs.core.truth_(inst_33970)){
var statearr_33997_34018 = state_33992__$1;
(statearr_33997_34018[(1)] = (5));

} else {
var statearr_33998_34019 = state_33992__$1;
(statearr_33998_34019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (13))){
var state_33992__$1 = state_33992;
var statearr_33999_34020 = state_33992__$1;
(statearr_33999_34020[(2)] = null);

(statearr_33999_34020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (6))){
var inst_33969 = (state_33992[(7)]);
var inst_33975 = p.call(null,inst_33969);
var state_33992__$1 = state_33992;
if(cljs.core.truth_(inst_33975)){
var statearr_34000_34021 = state_33992__$1;
(statearr_34000_34021[(1)] = (9));

} else {
var statearr_34001_34022 = state_33992__$1;
(statearr_34001_34022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (3))){
var inst_33990 = (state_33992[(2)]);
var state_33992__$1 = state_33992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33992__$1,inst_33990);
} else {
if((state_val_33993 === (12))){
var state_33992__$1 = state_33992;
var statearr_34002_34023 = state_33992__$1;
(statearr_34002_34023[(2)] = null);

(statearr_34002_34023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (2))){
var state_33992__$1 = state_33992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33992__$1,(4),ch);
} else {
if((state_val_33993 === (11))){
var inst_33969 = (state_33992[(7)]);
var inst_33979 = (state_33992[(2)]);
var state_33992__$1 = state_33992;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33992__$1,(8),inst_33979,inst_33969);
} else {
if((state_val_33993 === (9))){
var state_33992__$1 = state_33992;
var statearr_34003_34024 = state_33992__$1;
(statearr_34003_34024[(2)] = tc);

(statearr_34003_34024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (5))){
var inst_33972 = cljs.core.async.close_BANG_.call(null,tc);
var inst_33973 = cljs.core.async.close_BANG_.call(null,fc);
var state_33992__$1 = (function (){var statearr_34004 = state_33992;
(statearr_34004[(8)] = inst_33972);

return statearr_34004;
})();
var statearr_34005_34025 = state_33992__$1;
(statearr_34005_34025[(2)] = inst_33973);

(statearr_34005_34025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (14))){
var inst_33986 = (state_33992[(2)]);
var state_33992__$1 = state_33992;
var statearr_34006_34026 = state_33992__$1;
(statearr_34006_34026[(2)] = inst_33986);

(statearr_34006_34026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (10))){
var state_33992__$1 = state_33992;
var statearr_34007_34027 = state_33992__$1;
(statearr_34007_34027[(2)] = fc);

(statearr_34007_34027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33993 === (8))){
var inst_33981 = (state_33992[(2)]);
var state_33992__$1 = state_33992;
if(cljs.core.truth_(inst_33981)){
var statearr_34008_34028 = state_33992__$1;
(statearr_34008_34028[(1)] = (12));

} else {
var statearr_34009_34029 = state_33992__$1;
(statearr_34009_34029[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34015,tc,fc))
;
return ((function (switch__16183__auto__,c__16273__auto___34015,tc,fc){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_34010 = [null,null,null,null,null,null,null,null,null];
(statearr_34010[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_34010[(1)] = (1));

return statearr_34010;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_33992){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_33992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34011){if((e34011 instanceof Object)){
var ex__16187__auto__ = e34011;
var statearr_34012_34030 = state_33992;
(statearr_34012_34030[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34011;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34031 = state_33992;
state_33992 = G__34031;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_33992){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_33992);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34015,tc,fc))
})();
var state__16275__auto__ = (function (){var statearr_34013 = f__16274__auto__.call(null);
(statearr_34013[(6)] = c__16273__auto___34015);

return statearr_34013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34015,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_34052){
var state_val_34053 = (state_34052[(1)]);
if((state_val_34053 === (7))){
var inst_34048 = (state_34052[(2)]);
var state_34052__$1 = state_34052;
var statearr_34054_34072 = state_34052__$1;
(statearr_34054_34072[(2)] = inst_34048);

(statearr_34054_34072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (1))){
var inst_34032 = init;
var state_34052__$1 = (function (){var statearr_34055 = state_34052;
(statearr_34055[(7)] = inst_34032);

return statearr_34055;
})();
var statearr_34056_34073 = state_34052__$1;
(statearr_34056_34073[(2)] = null);

(statearr_34056_34073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (4))){
var inst_34035 = (state_34052[(8)]);
var inst_34035__$1 = (state_34052[(2)]);
var inst_34036 = (inst_34035__$1 == null);
var state_34052__$1 = (function (){var statearr_34057 = state_34052;
(statearr_34057[(8)] = inst_34035__$1);

return statearr_34057;
})();
if(cljs.core.truth_(inst_34036)){
var statearr_34058_34074 = state_34052__$1;
(statearr_34058_34074[(1)] = (5));

} else {
var statearr_34059_34075 = state_34052__$1;
(statearr_34059_34075[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (6))){
var inst_34035 = (state_34052[(8)]);
var inst_34032 = (state_34052[(7)]);
var inst_34039 = (state_34052[(9)]);
var inst_34039__$1 = f.call(null,inst_34032,inst_34035);
var inst_34040 = cljs.core.reduced_QMARK_.call(null,inst_34039__$1);
var state_34052__$1 = (function (){var statearr_34060 = state_34052;
(statearr_34060[(9)] = inst_34039__$1);

return statearr_34060;
})();
if(inst_34040){
var statearr_34061_34076 = state_34052__$1;
(statearr_34061_34076[(1)] = (8));

} else {
var statearr_34062_34077 = state_34052__$1;
(statearr_34062_34077[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (3))){
var inst_34050 = (state_34052[(2)]);
var state_34052__$1 = state_34052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34052__$1,inst_34050);
} else {
if((state_val_34053 === (2))){
var state_34052__$1 = state_34052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34052__$1,(4),ch);
} else {
if((state_val_34053 === (9))){
var inst_34039 = (state_34052[(9)]);
var inst_34032 = inst_34039;
var state_34052__$1 = (function (){var statearr_34063 = state_34052;
(statearr_34063[(7)] = inst_34032);

return statearr_34063;
})();
var statearr_34064_34078 = state_34052__$1;
(statearr_34064_34078[(2)] = null);

(statearr_34064_34078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (5))){
var inst_34032 = (state_34052[(7)]);
var state_34052__$1 = state_34052;
var statearr_34065_34079 = state_34052__$1;
(statearr_34065_34079[(2)] = inst_34032);

(statearr_34065_34079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (10))){
var inst_34046 = (state_34052[(2)]);
var state_34052__$1 = state_34052;
var statearr_34066_34080 = state_34052__$1;
(statearr_34066_34080[(2)] = inst_34046);

(statearr_34066_34080[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34053 === (8))){
var inst_34039 = (state_34052[(9)]);
var inst_34042 = cljs.core.deref.call(null,inst_34039);
var state_34052__$1 = state_34052;
var statearr_34067_34081 = state_34052__$1;
(statearr_34067_34081[(2)] = inst_34042);

(statearr_34067_34081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16184__auto____0 = (function (){
var statearr_34068 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34068[(0)] = cljs$core$async$reduce_$_state_machine__16184__auto__);

(statearr_34068[(1)] = (1));

return statearr_34068;
});
var cljs$core$async$reduce_$_state_machine__16184__auto____1 = (function (state_34052){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34069){if((e34069 instanceof Object)){
var ex__16187__auto__ = e34069;
var statearr_34070_34082 = state_34052;
(statearr_34070_34082[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34052);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34069;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34083 = state_34052;
state_34052 = G__34083;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16184__auto__ = function(state_34052){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16184__auto____1.call(this,state_34052);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16184__auto____0;
cljs$core$async$reduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16184__auto____1;
return cljs$core$async$reduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_34071 = f__16274__auto__.call(null);
(statearr_34071[(6)] = c__16273__auto__);

return statearr_34071;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__,f__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__,f__$1){
return (function (state_34089){
var state_val_34090 = (state_34089[(1)]);
if((state_val_34090 === (1))){
var inst_34084 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_34089__$1 = state_34089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34089__$1,(2),inst_34084);
} else {
if((state_val_34090 === (2))){
var inst_34086 = (state_34089[(2)]);
var inst_34087 = f__$1.call(null,inst_34086);
var state_34089__$1 = state_34089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34089__$1,inst_34087);
} else {
return null;
}
}
});})(c__16273__auto__,f__$1))
;
return ((function (switch__16183__auto__,c__16273__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__16184__auto__ = null;
var cljs$core$async$transduce_$_state_machine__16184__auto____0 = (function (){
var statearr_34091 = [null,null,null,null,null,null,null];
(statearr_34091[(0)] = cljs$core$async$transduce_$_state_machine__16184__auto__);

(statearr_34091[(1)] = (1));

return statearr_34091;
});
var cljs$core$async$transduce_$_state_machine__16184__auto____1 = (function (state_34089){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34092){if((e34092 instanceof Object)){
var ex__16187__auto__ = e34092;
var statearr_34093_34095 = state_34089;
(statearr_34093_34095[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34092;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34096 = state_34089;
state_34089 = G__34096;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__16184__auto__ = function(state_34089){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__16184__auto____1.call(this,state_34089);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__16184__auto____0;
cljs$core$async$transduce_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__16184__auto____1;
return cljs$core$async$transduce_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__,f__$1))
})();
var state__16275__auto__ = (function (){var statearr_34094 = f__16274__auto__.call(null);
(statearr_34094[(6)] = c__16273__auto__);

return statearr_34094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__,f__$1))
);

return c__16273__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__34098 = arguments.length;
switch (G__34098) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_34123){
var state_val_34124 = (state_34123[(1)]);
if((state_val_34124 === (7))){
var inst_34105 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
var statearr_34125_34146 = state_34123__$1;
(statearr_34125_34146[(2)] = inst_34105);

(statearr_34125_34146[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (1))){
var inst_34099 = cljs.core.seq.call(null,coll);
var inst_34100 = inst_34099;
var state_34123__$1 = (function (){var statearr_34126 = state_34123;
(statearr_34126[(7)] = inst_34100);

return statearr_34126;
})();
var statearr_34127_34147 = state_34123__$1;
(statearr_34127_34147[(2)] = null);

(statearr_34127_34147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (4))){
var inst_34100 = (state_34123[(7)]);
var inst_34103 = cljs.core.first.call(null,inst_34100);
var state_34123__$1 = state_34123;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34123__$1,(7),ch,inst_34103);
} else {
if((state_val_34124 === (13))){
var inst_34117 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
var statearr_34128_34148 = state_34123__$1;
(statearr_34128_34148[(2)] = inst_34117);

(statearr_34128_34148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (6))){
var inst_34108 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
if(cljs.core.truth_(inst_34108)){
var statearr_34129_34149 = state_34123__$1;
(statearr_34129_34149[(1)] = (8));

} else {
var statearr_34130_34150 = state_34123__$1;
(statearr_34130_34150[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (3))){
var inst_34121 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34123__$1,inst_34121);
} else {
if((state_val_34124 === (12))){
var state_34123__$1 = state_34123;
var statearr_34131_34151 = state_34123__$1;
(statearr_34131_34151[(2)] = null);

(statearr_34131_34151[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (2))){
var inst_34100 = (state_34123[(7)]);
var state_34123__$1 = state_34123;
if(cljs.core.truth_(inst_34100)){
var statearr_34132_34152 = state_34123__$1;
(statearr_34132_34152[(1)] = (4));

} else {
var statearr_34133_34153 = state_34123__$1;
(statearr_34133_34153[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (11))){
var inst_34114 = cljs.core.async.close_BANG_.call(null,ch);
var state_34123__$1 = state_34123;
var statearr_34134_34154 = state_34123__$1;
(statearr_34134_34154[(2)] = inst_34114);

(statearr_34134_34154[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (9))){
var state_34123__$1 = state_34123;
if(cljs.core.truth_(close_QMARK_)){
var statearr_34135_34155 = state_34123__$1;
(statearr_34135_34155[(1)] = (11));

} else {
var statearr_34136_34156 = state_34123__$1;
(statearr_34136_34156[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (5))){
var inst_34100 = (state_34123[(7)]);
var state_34123__$1 = state_34123;
var statearr_34137_34157 = state_34123__$1;
(statearr_34137_34157[(2)] = inst_34100);

(statearr_34137_34157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (10))){
var inst_34119 = (state_34123[(2)]);
var state_34123__$1 = state_34123;
var statearr_34138_34158 = state_34123__$1;
(statearr_34138_34158[(2)] = inst_34119);

(statearr_34138_34158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34124 === (8))){
var inst_34100 = (state_34123[(7)]);
var inst_34110 = cljs.core.next.call(null,inst_34100);
var inst_34100__$1 = inst_34110;
var state_34123__$1 = (function (){var statearr_34139 = state_34123;
(statearr_34139[(7)] = inst_34100__$1);

return statearr_34139;
})();
var statearr_34140_34159 = state_34123__$1;
(statearr_34140_34159[(2)] = null);

(statearr_34140_34159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_34141 = [null,null,null,null,null,null,null,null];
(statearr_34141[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_34141[(1)] = (1));

return statearr_34141;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_34123){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34123);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34142){if((e34142 instanceof Object)){
var ex__16187__auto__ = e34142;
var statearr_34143_34160 = state_34123;
(statearr_34143_34160[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34123);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34142;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34161 = state_34123;
state_34123 = G__34161;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_34123){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_34123);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_34144 = f__16274__auto__.call(null);
(statearr_34144[(6)] = c__16273__auto__);

return statearr_34144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__9121__auto__ = (((_ == null))?null:_);
var m__9122__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,_);
} else {
var m__9122__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m__$1,ch,close_QMARK_){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m__$1.cljs$core$async$Mult$tap_STAR_$arity$3(m__$1,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m__$1);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mult$untap_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m__$1);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mult$untap_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m__$1);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async34162 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34162 = (function (ch,cs,meta34163){
this.ch = ch;
this.cs = cs;
this.meta34163 = meta34163;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_34164,meta34163__$1){
var self__ = this;
var _34164__$1 = this;
return (new cljs.core.async.t_cljs$core$async34162(self__.ch,self__.cs,meta34163__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_34164){
var self__ = this;
var _34164__$1 = this;
return self__.meta34163;
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta34163","meta34163",-1443804621,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async34162.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34162.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34162";

cljs.core.async.t_cljs$core$async34162.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async34162");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async34162 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async34162(ch__$1,cs__$1,meta34163){
return (new cljs.core.async.t_cljs$core$async34162(ch__$1,cs__$1,meta34163));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async34162(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m__$1,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m__$1,dchan,dctr))
;
var c__16273__auto___34384 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34384,cs,m__$1,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34384,cs,m__$1,dchan,dctr,done){
return (function (state_34299){
var state_val_34300 = (state_34299[(1)]);
if((state_val_34300 === (7))){
var inst_34295 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34301_34385 = state_34299__$1;
(statearr_34301_34385[(2)] = inst_34295);

(statearr_34301_34385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (20))){
var inst_34198 = (state_34299[(7)]);
var inst_34210 = cljs.core.first.call(null,inst_34198);
var inst_34211 = cljs.core.nth.call(null,inst_34210,(0),null);
var inst_34212 = cljs.core.nth.call(null,inst_34210,(1),null);
var state_34299__$1 = (function (){var statearr_34302 = state_34299;
(statearr_34302[(8)] = inst_34211);

return statearr_34302;
})();
if(cljs.core.truth_(inst_34212)){
var statearr_34303_34386 = state_34299__$1;
(statearr_34303_34386[(1)] = (22));

} else {
var statearr_34304_34387 = state_34299__$1;
(statearr_34304_34387[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (27))){
var inst_34242 = (state_34299[(9)]);
var inst_34240 = (state_34299[(10)]);
var inst_34167 = (state_34299[(11)]);
var inst_34247 = (state_34299[(12)]);
var inst_34247__$1 = cljs.core._nth.call(null,inst_34240,inst_34242);
var inst_34248 = cljs.core.async.put_BANG_.call(null,inst_34247__$1,inst_34167,done);
var state_34299__$1 = (function (){var statearr_34305 = state_34299;
(statearr_34305[(12)] = inst_34247__$1);

return statearr_34305;
})();
if(cljs.core.truth_(inst_34248)){
var statearr_34306_34388 = state_34299__$1;
(statearr_34306_34388[(1)] = (30));

} else {
var statearr_34307_34389 = state_34299__$1;
(statearr_34307_34389[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (1))){
var state_34299__$1 = state_34299;
var statearr_34308_34390 = state_34299__$1;
(statearr_34308_34390[(2)] = null);

(statearr_34308_34390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (24))){
var inst_34198 = (state_34299[(7)]);
var inst_34217 = (state_34299[(2)]);
var inst_34218 = cljs.core.next.call(null,inst_34198);
var inst_34176 = inst_34218;
var inst_34177 = null;
var inst_34178 = (0);
var inst_34179 = (0);
var state_34299__$1 = (function (){var statearr_34309 = state_34299;
(statearr_34309[(13)] = inst_34178);

(statearr_34309[(14)] = inst_34217);

(statearr_34309[(15)] = inst_34176);

(statearr_34309[(16)] = inst_34179);

(statearr_34309[(17)] = inst_34177);

return statearr_34309;
})();
var statearr_34310_34391 = state_34299__$1;
(statearr_34310_34391[(2)] = null);

(statearr_34310_34391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (39))){
var state_34299__$1 = state_34299;
var statearr_34314_34392 = state_34299__$1;
(statearr_34314_34392[(2)] = null);

(statearr_34314_34392[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (4))){
var inst_34167 = (state_34299[(11)]);
var inst_34167__$1 = (state_34299[(2)]);
var inst_34168 = (inst_34167__$1 == null);
var state_34299__$1 = (function (){var statearr_34315 = state_34299;
(statearr_34315[(11)] = inst_34167__$1);

return statearr_34315;
})();
if(cljs.core.truth_(inst_34168)){
var statearr_34316_34393 = state_34299__$1;
(statearr_34316_34393[(1)] = (5));

} else {
var statearr_34317_34394 = state_34299__$1;
(statearr_34317_34394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (15))){
var inst_34178 = (state_34299[(13)]);
var inst_34176 = (state_34299[(15)]);
var inst_34179 = (state_34299[(16)]);
var inst_34177 = (state_34299[(17)]);
var inst_34194 = (state_34299[(2)]);
var inst_34195 = (inst_34179 + (1));
var tmp34311 = inst_34178;
var tmp34312 = inst_34176;
var tmp34313 = inst_34177;
var inst_34176__$1 = tmp34312;
var inst_34177__$1 = tmp34313;
var inst_34178__$1 = tmp34311;
var inst_34179__$1 = inst_34195;
var state_34299__$1 = (function (){var statearr_34318 = state_34299;
(statearr_34318[(18)] = inst_34194);

(statearr_34318[(13)] = inst_34178__$1);

(statearr_34318[(15)] = inst_34176__$1);

(statearr_34318[(16)] = inst_34179__$1);

(statearr_34318[(17)] = inst_34177__$1);

return statearr_34318;
})();
var statearr_34319_34395 = state_34299__$1;
(statearr_34319_34395[(2)] = null);

(statearr_34319_34395[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (21))){
var inst_34221 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34323_34396 = state_34299__$1;
(statearr_34323_34396[(2)] = inst_34221);

(statearr_34323_34396[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (31))){
var inst_34247 = (state_34299[(12)]);
var inst_34251 = done.call(null,null);
var inst_34252 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_34247);
var state_34299__$1 = (function (){var statearr_34324 = state_34299;
(statearr_34324[(19)] = inst_34251);

return statearr_34324;
})();
var statearr_34325_34397 = state_34299__$1;
(statearr_34325_34397[(2)] = inst_34252);

(statearr_34325_34397[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (32))){
var inst_34241 = (state_34299[(20)]);
var inst_34242 = (state_34299[(9)]);
var inst_34240 = (state_34299[(10)]);
var inst_34239 = (state_34299[(21)]);
var inst_34254 = (state_34299[(2)]);
var inst_34255 = (inst_34242 + (1));
var tmp34320 = inst_34241;
var tmp34321 = inst_34240;
var tmp34322 = inst_34239;
var inst_34239__$1 = tmp34322;
var inst_34240__$1 = tmp34321;
var inst_34241__$1 = tmp34320;
var inst_34242__$1 = inst_34255;
var state_34299__$1 = (function (){var statearr_34326 = state_34299;
(statearr_34326[(20)] = inst_34241__$1);

(statearr_34326[(9)] = inst_34242__$1);

(statearr_34326[(22)] = inst_34254);

(statearr_34326[(10)] = inst_34240__$1);

(statearr_34326[(21)] = inst_34239__$1);

return statearr_34326;
})();
var statearr_34327_34398 = state_34299__$1;
(statearr_34327_34398[(2)] = null);

(statearr_34327_34398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (40))){
var inst_34267 = (state_34299[(23)]);
var inst_34271 = done.call(null,null);
var inst_34272 = cljs.core.async.untap_STAR_.call(null,m__$1,inst_34267);
var state_34299__$1 = (function (){var statearr_34328 = state_34299;
(statearr_34328[(24)] = inst_34271);

return statearr_34328;
})();
var statearr_34329_34399 = state_34299__$1;
(statearr_34329_34399[(2)] = inst_34272);

(statearr_34329_34399[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (33))){
var inst_34258 = (state_34299[(25)]);
var inst_34260 = cljs.core.chunked_seq_QMARK_.call(null,inst_34258);
var state_34299__$1 = state_34299;
if(inst_34260){
var statearr_34330_34400 = state_34299__$1;
(statearr_34330_34400[(1)] = (36));

} else {
var statearr_34331_34401 = state_34299__$1;
(statearr_34331_34401[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (13))){
var inst_34188 = (state_34299[(26)]);
var inst_34191 = cljs.core.async.close_BANG_.call(null,inst_34188);
var state_34299__$1 = state_34299;
var statearr_34332_34402 = state_34299__$1;
(statearr_34332_34402[(2)] = inst_34191);

(statearr_34332_34402[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (22))){
var inst_34211 = (state_34299[(8)]);
var inst_34214 = cljs.core.async.close_BANG_.call(null,inst_34211);
var state_34299__$1 = state_34299;
var statearr_34333_34403 = state_34299__$1;
(statearr_34333_34403[(2)] = inst_34214);

(statearr_34333_34403[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (36))){
var inst_34258 = (state_34299[(25)]);
var inst_34262 = cljs.core.chunk_first.call(null,inst_34258);
var inst_34263 = cljs.core.chunk_rest.call(null,inst_34258);
var inst_34264 = cljs.core.count.call(null,inst_34262);
var inst_34239 = inst_34263;
var inst_34240 = inst_34262;
var inst_34241 = inst_34264;
var inst_34242 = (0);
var state_34299__$1 = (function (){var statearr_34334 = state_34299;
(statearr_34334[(20)] = inst_34241);

(statearr_34334[(9)] = inst_34242);

(statearr_34334[(10)] = inst_34240);

(statearr_34334[(21)] = inst_34239);

return statearr_34334;
})();
var statearr_34335_34404 = state_34299__$1;
(statearr_34335_34404[(2)] = null);

(statearr_34335_34404[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (41))){
var inst_34258 = (state_34299[(25)]);
var inst_34274 = (state_34299[(2)]);
var inst_34275 = cljs.core.next.call(null,inst_34258);
var inst_34239 = inst_34275;
var inst_34240 = null;
var inst_34241 = (0);
var inst_34242 = (0);
var state_34299__$1 = (function (){var statearr_34336 = state_34299;
(statearr_34336[(27)] = inst_34274);

(statearr_34336[(20)] = inst_34241);

(statearr_34336[(9)] = inst_34242);

(statearr_34336[(10)] = inst_34240);

(statearr_34336[(21)] = inst_34239);

return statearr_34336;
})();
var statearr_34337_34405 = state_34299__$1;
(statearr_34337_34405[(2)] = null);

(statearr_34337_34405[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (43))){
var state_34299__$1 = state_34299;
var statearr_34338_34406 = state_34299__$1;
(statearr_34338_34406[(2)] = null);

(statearr_34338_34406[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (29))){
var inst_34283 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34339_34407 = state_34299__$1;
(statearr_34339_34407[(2)] = inst_34283);

(statearr_34339_34407[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (44))){
var inst_34292 = (state_34299[(2)]);
var state_34299__$1 = (function (){var statearr_34340 = state_34299;
(statearr_34340[(28)] = inst_34292);

return statearr_34340;
})();
var statearr_34341_34408 = state_34299__$1;
(statearr_34341_34408[(2)] = null);

(statearr_34341_34408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (6))){
var inst_34231 = (state_34299[(29)]);
var inst_34230 = cljs.core.deref.call(null,cs);
var inst_34231__$1 = cljs.core.keys.call(null,inst_34230);
var inst_34232 = cljs.core.count.call(null,inst_34231__$1);
var inst_34233 = cljs.core.reset_BANG_.call(null,dctr,inst_34232);
var inst_34238 = cljs.core.seq.call(null,inst_34231__$1);
var inst_34239 = inst_34238;
var inst_34240 = null;
var inst_34241 = (0);
var inst_34242 = (0);
var state_34299__$1 = (function (){var statearr_34342 = state_34299;
(statearr_34342[(20)] = inst_34241);

(statearr_34342[(9)] = inst_34242);

(statearr_34342[(10)] = inst_34240);

(statearr_34342[(21)] = inst_34239);

(statearr_34342[(30)] = inst_34233);

(statearr_34342[(29)] = inst_34231__$1);

return statearr_34342;
})();
var statearr_34343_34409 = state_34299__$1;
(statearr_34343_34409[(2)] = null);

(statearr_34343_34409[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (28))){
var inst_34239 = (state_34299[(21)]);
var inst_34258 = (state_34299[(25)]);
var inst_34258__$1 = cljs.core.seq.call(null,inst_34239);
var state_34299__$1 = (function (){var statearr_34344 = state_34299;
(statearr_34344[(25)] = inst_34258__$1);

return statearr_34344;
})();
if(inst_34258__$1){
var statearr_34345_34410 = state_34299__$1;
(statearr_34345_34410[(1)] = (33));

} else {
var statearr_34346_34411 = state_34299__$1;
(statearr_34346_34411[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (25))){
var inst_34241 = (state_34299[(20)]);
var inst_34242 = (state_34299[(9)]);
var inst_34244 = (inst_34242 < inst_34241);
var inst_34245 = inst_34244;
var state_34299__$1 = state_34299;
if(cljs.core.truth_(inst_34245)){
var statearr_34347_34412 = state_34299__$1;
(statearr_34347_34412[(1)] = (27));

} else {
var statearr_34348_34413 = state_34299__$1;
(statearr_34348_34413[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (34))){
var state_34299__$1 = state_34299;
var statearr_34349_34414 = state_34299__$1;
(statearr_34349_34414[(2)] = null);

(statearr_34349_34414[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (17))){
var state_34299__$1 = state_34299;
var statearr_34350_34415 = state_34299__$1;
(statearr_34350_34415[(2)] = null);

(statearr_34350_34415[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (3))){
var inst_34297 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34299__$1,inst_34297);
} else {
if((state_val_34300 === (12))){
var inst_34226 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34351_34416 = state_34299__$1;
(statearr_34351_34416[(2)] = inst_34226);

(statearr_34351_34416[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (2))){
var state_34299__$1 = state_34299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34299__$1,(4),ch);
} else {
if((state_val_34300 === (23))){
var state_34299__$1 = state_34299;
var statearr_34352_34417 = state_34299__$1;
(statearr_34352_34417[(2)] = null);

(statearr_34352_34417[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (35))){
var inst_34281 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34353_34418 = state_34299__$1;
(statearr_34353_34418[(2)] = inst_34281);

(statearr_34353_34418[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (19))){
var inst_34198 = (state_34299[(7)]);
var inst_34202 = cljs.core.chunk_first.call(null,inst_34198);
var inst_34203 = cljs.core.chunk_rest.call(null,inst_34198);
var inst_34204 = cljs.core.count.call(null,inst_34202);
var inst_34176 = inst_34203;
var inst_34177 = inst_34202;
var inst_34178 = inst_34204;
var inst_34179 = (0);
var state_34299__$1 = (function (){var statearr_34354 = state_34299;
(statearr_34354[(13)] = inst_34178);

(statearr_34354[(15)] = inst_34176);

(statearr_34354[(16)] = inst_34179);

(statearr_34354[(17)] = inst_34177);

return statearr_34354;
})();
var statearr_34355_34419 = state_34299__$1;
(statearr_34355_34419[(2)] = null);

(statearr_34355_34419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (11))){
var inst_34198 = (state_34299[(7)]);
var inst_34176 = (state_34299[(15)]);
var inst_34198__$1 = cljs.core.seq.call(null,inst_34176);
var state_34299__$1 = (function (){var statearr_34356 = state_34299;
(statearr_34356[(7)] = inst_34198__$1);

return statearr_34356;
})();
if(inst_34198__$1){
var statearr_34357_34420 = state_34299__$1;
(statearr_34357_34420[(1)] = (16));

} else {
var statearr_34358_34421 = state_34299__$1;
(statearr_34358_34421[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (9))){
var inst_34228 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34359_34422 = state_34299__$1;
(statearr_34359_34422[(2)] = inst_34228);

(statearr_34359_34422[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (5))){
var inst_34174 = cljs.core.deref.call(null,cs);
var inst_34175 = cljs.core.seq.call(null,inst_34174);
var inst_34176 = inst_34175;
var inst_34177 = null;
var inst_34178 = (0);
var inst_34179 = (0);
var state_34299__$1 = (function (){var statearr_34360 = state_34299;
(statearr_34360[(13)] = inst_34178);

(statearr_34360[(15)] = inst_34176);

(statearr_34360[(16)] = inst_34179);

(statearr_34360[(17)] = inst_34177);

return statearr_34360;
})();
var statearr_34361_34423 = state_34299__$1;
(statearr_34361_34423[(2)] = null);

(statearr_34361_34423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (14))){
var state_34299__$1 = state_34299;
var statearr_34362_34424 = state_34299__$1;
(statearr_34362_34424[(2)] = null);

(statearr_34362_34424[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (45))){
var inst_34289 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34363_34425 = state_34299__$1;
(statearr_34363_34425[(2)] = inst_34289);

(statearr_34363_34425[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (26))){
var inst_34231 = (state_34299[(29)]);
var inst_34285 = (state_34299[(2)]);
var inst_34286 = cljs.core.seq.call(null,inst_34231);
var state_34299__$1 = (function (){var statearr_34364 = state_34299;
(statearr_34364[(31)] = inst_34285);

return statearr_34364;
})();
if(inst_34286){
var statearr_34365_34426 = state_34299__$1;
(statearr_34365_34426[(1)] = (42));

} else {
var statearr_34366_34427 = state_34299__$1;
(statearr_34366_34427[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (16))){
var inst_34198 = (state_34299[(7)]);
var inst_34200 = cljs.core.chunked_seq_QMARK_.call(null,inst_34198);
var state_34299__$1 = state_34299;
if(inst_34200){
var statearr_34367_34428 = state_34299__$1;
(statearr_34367_34428[(1)] = (19));

} else {
var statearr_34368_34429 = state_34299__$1;
(statearr_34368_34429[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (38))){
var inst_34278 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34369_34430 = state_34299__$1;
(statearr_34369_34430[(2)] = inst_34278);

(statearr_34369_34430[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (30))){
var state_34299__$1 = state_34299;
var statearr_34370_34431 = state_34299__$1;
(statearr_34370_34431[(2)] = null);

(statearr_34370_34431[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (10))){
var inst_34179 = (state_34299[(16)]);
var inst_34177 = (state_34299[(17)]);
var inst_34187 = cljs.core._nth.call(null,inst_34177,inst_34179);
var inst_34188 = cljs.core.nth.call(null,inst_34187,(0),null);
var inst_34189 = cljs.core.nth.call(null,inst_34187,(1),null);
var state_34299__$1 = (function (){var statearr_34371 = state_34299;
(statearr_34371[(26)] = inst_34188);

return statearr_34371;
})();
if(cljs.core.truth_(inst_34189)){
var statearr_34372_34432 = state_34299__$1;
(statearr_34372_34432[(1)] = (13));

} else {
var statearr_34373_34433 = state_34299__$1;
(statearr_34373_34433[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (18))){
var inst_34224 = (state_34299[(2)]);
var state_34299__$1 = state_34299;
var statearr_34374_34434 = state_34299__$1;
(statearr_34374_34434[(2)] = inst_34224);

(statearr_34374_34434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (42))){
var state_34299__$1 = state_34299;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34299__$1,(45),dchan);
} else {
if((state_val_34300 === (37))){
var inst_34167 = (state_34299[(11)]);
var inst_34267 = (state_34299[(23)]);
var inst_34258 = (state_34299[(25)]);
var inst_34267__$1 = cljs.core.first.call(null,inst_34258);
var inst_34268 = cljs.core.async.put_BANG_.call(null,inst_34267__$1,inst_34167,done);
var state_34299__$1 = (function (){var statearr_34375 = state_34299;
(statearr_34375[(23)] = inst_34267__$1);

return statearr_34375;
})();
if(cljs.core.truth_(inst_34268)){
var statearr_34376_34435 = state_34299__$1;
(statearr_34376_34435[(1)] = (39));

} else {
var statearr_34377_34436 = state_34299__$1;
(statearr_34377_34436[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34300 === (8))){
var inst_34178 = (state_34299[(13)]);
var inst_34179 = (state_34299[(16)]);
var inst_34181 = (inst_34179 < inst_34178);
var inst_34182 = inst_34181;
var state_34299__$1 = state_34299;
if(cljs.core.truth_(inst_34182)){
var statearr_34378_34437 = state_34299__$1;
(statearr_34378_34437[(1)] = (10));

} else {
var statearr_34379_34438 = state_34299__$1;
(statearr_34379_34438[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34384,cs,m__$1,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___34384,cs,m__$1,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16184__auto__ = null;
var cljs$core$async$mult_$_state_machine__16184__auto____0 = (function (){
var statearr_34380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34380[(0)] = cljs$core$async$mult_$_state_machine__16184__auto__);

(statearr_34380[(1)] = (1));

return statearr_34380;
});
var cljs$core$async$mult_$_state_machine__16184__auto____1 = (function (state_34299){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34381){if((e34381 instanceof Object)){
var ex__16187__auto__ = e34381;
var statearr_34382_34439 = state_34299;
(statearr_34382_34439[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34299);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34440 = state_34299;
state_34299 = G__34440;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16184__auto__ = function(state_34299){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16184__auto____1.call(this,state_34299);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16184__auto____0;
cljs$core$async$mult_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16184__auto____1;
return cljs$core$async$mult_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34384,cs,m__$1,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_34383 = f__16274__auto__.call(null);
(statearr_34383[(6)] = c__16273__auto___34384);

return statearr_34383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34384,cs,m__$1,dchan,dctr,done))
);


return m__$1;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__34442 = arguments.length;
switch (G__34442) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$admix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m__$1);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m__$1,ch){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$unmix_STAR_$arity$2(m__$1,ch);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m__$1);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m__$1){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m__$1.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m__$1);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1);
} else {
var m__9122__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m__$1);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m__$1,state_map){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$toggle_STAR_$arity$2(m__$1,state_map);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,state_map);
} else {
var m__9122__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m__$1);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m__$1,mode){
if((!((m__$1 == null))) && (!((m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m__$1.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m__$1,mode);
} else {
var x__9121__auto__ = (((m__$1 == null))?null:m__$1);
var m__9122__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,m__$1,mode);
} else {
var m__9122__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,m__$1,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m__$1);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9674__auto__ = [];
var len__9667__auto___34454 = arguments.length;
var i__9668__auto___34455 = (0);
while(true){
if((i__9668__auto___34455 < len__9667__auto___34454)){
args__9674__auto__.push((arguments[i__9668__auto___34455]));

var G__34456 = (i__9668__auto___34455 + (1));
i__9668__auto___34455 = G__34456;
continue;
} else {
}
break;
}

var argseq__9675__auto__ = ((((3) < args__9674__auto__.length))?(new cljs.core.IndexedSeq(args__9674__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9675__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__34448){
var map__34449 = p__34448;
var map__34449__$1 = ((((!((map__34449 == null)))?((((map__34449.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34449.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34449):map__34449);
var opts = map__34449__$1;
var statearr_34451_34457 = state;
(statearr_34451_34457[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__34449,map__34449__$1,opts){
return (function (val){
var statearr_34452_34458 = state;
(statearr_34452_34458[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__34449,map__34449__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_34453_34459 = state;
(statearr_34453_34459[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq34444){
var G__34445 = cljs.core.first.call(null,seq34444);
var seq34444__$1 = cljs.core.next.call(null,seq34444);
var G__34446 = cljs.core.first.call(null,seq34444__$1);
var seq34444__$2 = cljs.core.next.call(null,seq34444__$1);
var G__34447 = cljs.core.first.call(null,seq34444__$2);
var seq34444__$3 = cljs.core.next.call(null,seq34444__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34445,G__34446,G__34447,seq34444__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m__$1 = (function (){
if(typeof cljs.core.async.t_cljs$core$async34460 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34460 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta34461){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta34461 = meta34461;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34462,meta34461__$1){
var self__ = this;
var _34462__$1 = this;
return (new cljs.core.async.t_cljs$core$async34460(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta34461__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_34462){
var self__ = this;
var _34462__$1 = this;
return self__.meta34461;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta34461","meta34461",1918332022,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async34460.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34460.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34460";

cljs.core.async.t_cljs$core$async34460.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async34460");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async34460 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async34460(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta34461){
return (new cljs.core.async.t_cljs$core$async34460(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta34461));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async34460(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___34624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function (state_34564){
var state_val_34565 = (state_34564[(1)]);
if((state_val_34565 === (7))){
var inst_34479 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34566_34625 = state_34564__$1;
(statearr_34566_34625[(2)] = inst_34479);

(statearr_34566_34625[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (20))){
var inst_34491 = (state_34564[(7)]);
var state_34564__$1 = state_34564;
var statearr_34567_34626 = state_34564__$1;
(statearr_34567_34626[(2)] = inst_34491);

(statearr_34567_34626[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (27))){
var state_34564__$1 = state_34564;
var statearr_34568_34627 = state_34564__$1;
(statearr_34568_34627[(2)] = null);

(statearr_34568_34627[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (1))){
var inst_34466 = (state_34564[(8)]);
var inst_34466__$1 = calc_state.call(null);
var inst_34468 = (inst_34466__$1 == null);
var inst_34469 = cljs.core.not.call(null,inst_34468);
var state_34564__$1 = (function (){var statearr_34569 = state_34564;
(statearr_34569[(8)] = inst_34466__$1);

return statearr_34569;
})();
if(inst_34469){
var statearr_34570_34628 = state_34564__$1;
(statearr_34570_34628[(1)] = (2));

} else {
var statearr_34571_34629 = state_34564__$1;
(statearr_34571_34629[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (24))){
var inst_34515 = (state_34564[(9)]);
var inst_34524 = (state_34564[(10)]);
var inst_34538 = (state_34564[(11)]);
var inst_34538__$1 = inst_34515.call(null,inst_34524);
var state_34564__$1 = (function (){var statearr_34572 = state_34564;
(statearr_34572[(11)] = inst_34538__$1);

return statearr_34572;
})();
if(cljs.core.truth_(inst_34538__$1)){
var statearr_34573_34630 = state_34564__$1;
(statearr_34573_34630[(1)] = (29));

} else {
var statearr_34574_34631 = state_34564__$1;
(statearr_34574_34631[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (4))){
var inst_34482 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34482)){
var statearr_34575_34632 = state_34564__$1;
(statearr_34575_34632[(1)] = (8));

} else {
var statearr_34576_34633 = state_34564__$1;
(statearr_34576_34633[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (15))){
var inst_34509 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34509)){
var statearr_34577_34634 = state_34564__$1;
(statearr_34577_34634[(1)] = (19));

} else {
var statearr_34578_34635 = state_34564__$1;
(statearr_34578_34635[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (21))){
var inst_34514 = (state_34564[(12)]);
var inst_34514__$1 = (state_34564[(2)]);
var inst_34515 = cljs.core.get.call(null,inst_34514__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_34516 = cljs.core.get.call(null,inst_34514__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_34517 = cljs.core.get.call(null,inst_34514__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_34564__$1 = (function (){var statearr_34579 = state_34564;
(statearr_34579[(9)] = inst_34515);

(statearr_34579[(12)] = inst_34514__$1);

(statearr_34579[(13)] = inst_34516);

return statearr_34579;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_34564__$1,(22),inst_34517);
} else {
if((state_val_34565 === (31))){
var inst_34546 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34546)){
var statearr_34580_34636 = state_34564__$1;
(statearr_34580_34636[(1)] = (32));

} else {
var statearr_34581_34637 = state_34564__$1;
(statearr_34581_34637[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (32))){
var inst_34523 = (state_34564[(14)]);
var state_34564__$1 = state_34564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34564__$1,(35),out,inst_34523);
} else {
if((state_val_34565 === (33))){
var inst_34514 = (state_34564[(12)]);
var inst_34491 = inst_34514;
var state_34564__$1 = (function (){var statearr_34582 = state_34564;
(statearr_34582[(7)] = inst_34491);

return statearr_34582;
})();
var statearr_34583_34638 = state_34564__$1;
(statearr_34583_34638[(2)] = null);

(statearr_34583_34638[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (13))){
var inst_34491 = (state_34564[(7)]);
var inst_34498 = inst_34491.cljs$lang$protocol_mask$partition0$;
var inst_34499 = (inst_34498 & (64));
var inst_34500 = inst_34491.cljs$core$ISeq$;
var inst_34501 = (cljs.core.PROTOCOL_SENTINEL === inst_34500);
var inst_34502 = (inst_34499) || (inst_34501);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34502)){
var statearr_34584_34639 = state_34564__$1;
(statearr_34584_34639[(1)] = (16));

} else {
var statearr_34585_34640 = state_34564__$1;
(statearr_34585_34640[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (22))){
var inst_34524 = (state_34564[(10)]);
var inst_34523 = (state_34564[(14)]);
var inst_34522 = (state_34564[(2)]);
var inst_34523__$1 = cljs.core.nth.call(null,inst_34522,(0),null);
var inst_34524__$1 = cljs.core.nth.call(null,inst_34522,(1),null);
var inst_34525 = (inst_34523__$1 == null);
var inst_34526 = cljs.core._EQ_.call(null,inst_34524__$1,change);
var inst_34527 = (inst_34525) || (inst_34526);
var state_34564__$1 = (function (){var statearr_34586 = state_34564;
(statearr_34586[(10)] = inst_34524__$1);

(statearr_34586[(14)] = inst_34523__$1);

return statearr_34586;
})();
if(cljs.core.truth_(inst_34527)){
var statearr_34587_34641 = state_34564__$1;
(statearr_34587_34641[(1)] = (23));

} else {
var statearr_34588_34642 = state_34564__$1;
(statearr_34588_34642[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (36))){
var inst_34514 = (state_34564[(12)]);
var inst_34491 = inst_34514;
var state_34564__$1 = (function (){var statearr_34589 = state_34564;
(statearr_34589[(7)] = inst_34491);

return statearr_34589;
})();
var statearr_34590_34643 = state_34564__$1;
(statearr_34590_34643[(2)] = null);

(statearr_34590_34643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (29))){
var inst_34538 = (state_34564[(11)]);
var state_34564__$1 = state_34564;
var statearr_34591_34644 = state_34564__$1;
(statearr_34591_34644[(2)] = inst_34538);

(statearr_34591_34644[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (6))){
var state_34564__$1 = state_34564;
var statearr_34592_34645 = state_34564__$1;
(statearr_34592_34645[(2)] = false);

(statearr_34592_34645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (28))){
var inst_34534 = (state_34564[(2)]);
var inst_34535 = calc_state.call(null);
var inst_34491 = inst_34535;
var state_34564__$1 = (function (){var statearr_34593 = state_34564;
(statearr_34593[(15)] = inst_34534);

(statearr_34593[(7)] = inst_34491);

return statearr_34593;
})();
var statearr_34594_34646 = state_34564__$1;
(statearr_34594_34646[(2)] = null);

(statearr_34594_34646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (25))){
var inst_34560 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34595_34647 = state_34564__$1;
(statearr_34595_34647[(2)] = inst_34560);

(statearr_34595_34647[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (34))){
var inst_34558 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34596_34648 = state_34564__$1;
(statearr_34596_34648[(2)] = inst_34558);

(statearr_34596_34648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (17))){
var state_34564__$1 = state_34564;
var statearr_34597_34649 = state_34564__$1;
(statearr_34597_34649[(2)] = false);

(statearr_34597_34649[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (3))){
var state_34564__$1 = state_34564;
var statearr_34598_34650 = state_34564__$1;
(statearr_34598_34650[(2)] = false);

(statearr_34598_34650[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (12))){
var inst_34562 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34564__$1,inst_34562);
} else {
if((state_val_34565 === (2))){
var inst_34466 = (state_34564[(8)]);
var inst_34471 = inst_34466.cljs$lang$protocol_mask$partition0$;
var inst_34472 = (inst_34471 & (64));
var inst_34473 = inst_34466.cljs$core$ISeq$;
var inst_34474 = (cljs.core.PROTOCOL_SENTINEL === inst_34473);
var inst_34475 = (inst_34472) || (inst_34474);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34475)){
var statearr_34599_34651 = state_34564__$1;
(statearr_34599_34651[(1)] = (5));

} else {
var statearr_34600_34652 = state_34564__$1;
(statearr_34600_34652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (23))){
var inst_34523 = (state_34564[(14)]);
var inst_34529 = (inst_34523 == null);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34529)){
var statearr_34601_34653 = state_34564__$1;
(statearr_34601_34653[(1)] = (26));

} else {
var statearr_34602_34654 = state_34564__$1;
(statearr_34602_34654[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (35))){
var inst_34549 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
if(cljs.core.truth_(inst_34549)){
var statearr_34603_34655 = state_34564__$1;
(statearr_34603_34655[(1)] = (36));

} else {
var statearr_34604_34656 = state_34564__$1;
(statearr_34604_34656[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (19))){
var inst_34491 = (state_34564[(7)]);
var inst_34511 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34491);
var state_34564__$1 = state_34564;
var statearr_34605_34657 = state_34564__$1;
(statearr_34605_34657[(2)] = inst_34511);

(statearr_34605_34657[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (11))){
var inst_34491 = (state_34564[(7)]);
var inst_34495 = (inst_34491 == null);
var inst_34496 = cljs.core.not.call(null,inst_34495);
var state_34564__$1 = state_34564;
if(inst_34496){
var statearr_34606_34658 = state_34564__$1;
(statearr_34606_34658[(1)] = (13));

} else {
var statearr_34607_34659 = state_34564__$1;
(statearr_34607_34659[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (9))){
var inst_34466 = (state_34564[(8)]);
var state_34564__$1 = state_34564;
var statearr_34608_34660 = state_34564__$1;
(statearr_34608_34660[(2)] = inst_34466);

(statearr_34608_34660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (5))){
var state_34564__$1 = state_34564;
var statearr_34609_34661 = state_34564__$1;
(statearr_34609_34661[(2)] = true);

(statearr_34609_34661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (14))){
var state_34564__$1 = state_34564;
var statearr_34610_34662 = state_34564__$1;
(statearr_34610_34662[(2)] = false);

(statearr_34610_34662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (26))){
var inst_34524 = (state_34564[(10)]);
var inst_34531 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_34524);
var state_34564__$1 = state_34564;
var statearr_34611_34663 = state_34564__$1;
(statearr_34611_34663[(2)] = inst_34531);

(statearr_34611_34663[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (16))){
var state_34564__$1 = state_34564;
var statearr_34612_34664 = state_34564__$1;
(statearr_34612_34664[(2)] = true);

(statearr_34612_34664[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (38))){
var inst_34554 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34613_34665 = state_34564__$1;
(statearr_34613_34665[(2)] = inst_34554);

(statearr_34613_34665[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (30))){
var inst_34515 = (state_34564[(9)]);
var inst_34524 = (state_34564[(10)]);
var inst_34516 = (state_34564[(13)]);
var inst_34541 = cljs.core.empty_QMARK_.call(null,inst_34515);
var inst_34542 = inst_34516.call(null,inst_34524);
var inst_34543 = cljs.core.not.call(null,inst_34542);
var inst_34544 = (inst_34541) && (inst_34543);
var state_34564__$1 = state_34564;
var statearr_34614_34666 = state_34564__$1;
(statearr_34614_34666[(2)] = inst_34544);

(statearr_34614_34666[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (10))){
var inst_34466 = (state_34564[(8)]);
var inst_34487 = (state_34564[(2)]);
var inst_34488 = cljs.core.get.call(null,inst_34487,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_34489 = cljs.core.get.call(null,inst_34487,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_34490 = cljs.core.get.call(null,inst_34487,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_34491 = inst_34466;
var state_34564__$1 = (function (){var statearr_34615 = state_34564;
(statearr_34615[(16)] = inst_34490);

(statearr_34615[(17)] = inst_34488);

(statearr_34615[(7)] = inst_34491);

(statearr_34615[(18)] = inst_34489);

return statearr_34615;
})();
var statearr_34616_34667 = state_34564__$1;
(statearr_34616_34667[(2)] = null);

(statearr_34616_34667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (18))){
var inst_34506 = (state_34564[(2)]);
var state_34564__$1 = state_34564;
var statearr_34617_34668 = state_34564__$1;
(statearr_34617_34668[(2)] = inst_34506);

(statearr_34617_34668[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (37))){
var state_34564__$1 = state_34564;
var statearr_34618_34669 = state_34564__$1;
(statearr_34618_34669[(2)] = null);

(statearr_34618_34669[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34565 === (8))){
var inst_34466 = (state_34564[(8)]);
var inst_34484 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34466);
var state_34564__$1 = state_34564;
var statearr_34619_34670 = state_34564__$1;
(statearr_34619_34670[(2)] = inst_34484);

(statearr_34619_34670[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
;
return ((function (switch__16183__auto__,c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1){
return (function() {
var cljs$core$async$mix_$_state_machine__16184__auto__ = null;
var cljs$core$async$mix_$_state_machine__16184__auto____0 = (function (){
var statearr_34620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34620[(0)] = cljs$core$async$mix_$_state_machine__16184__auto__);

(statearr_34620[(1)] = (1));

return statearr_34620;
});
var cljs$core$async$mix_$_state_machine__16184__auto____1 = (function (state_34564){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34621){if((e34621 instanceof Object)){
var ex__16187__auto__ = e34621;
var statearr_34622_34671 = state_34564;
(statearr_34622_34671[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34621;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34672 = state_34564;
state_34564 = G__34672;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16184__auto__ = function(state_34564){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16184__auto____1.call(this,state_34564);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16184__auto____0;
cljs$core$async$mix_$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16184__auto____1;
return cljs$core$async$mix_$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
})();
var state__16275__auto__ = (function (){var statearr_34623 = f__16274__auto__.call(null);
(statearr_34623[(6)] = c__16273__auto___34624);

return statearr_34623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34624,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m__$1))
);


return m__$1;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__9122__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v,ch);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__34674 = arguments.length;
switch (G__34674) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__9121__auto__ = (((p == null))?null:p);
var m__9122__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__9121__auto__)]);
if(!((m__9122__auto__ == null))){
return m__9122__auto__.call(null,p,v);
} else {
var m__9122__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__9122__auto____$1 == null))){
return m__9122__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__34678 = arguments.length;
switch (G__34678) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8388__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8388__auto__,mults){
return (function (p1__34676_SHARP_){
if(cljs.core.truth_(p1__34676_SHARP_.call(null,topic))){
return p1__34676_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__34676_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8388__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async34679 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34679 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta34680){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta34680 = meta34680;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_34681,meta34680__$1){
var self__ = this;
var _34681__$1 = this;
return (new cljs.core.async.t_cljs$core$async34679(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta34680__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_34681){
var self__ = this;
var _34681__$1 = this;
return self__.meta34680;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m__$1 = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m__$1,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m__$1 = temp__5457__auto__;
return cljs.core.async.untap.call(null,m__$1,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta34680","meta34680",1976537277,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async34679.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34679.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34679";

cljs.core.async.t_cljs$core$async34679.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async34679");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async34679 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async34679(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34680){
return (new cljs.core.async.t_cljs$core$async34679(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta34680));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async34679(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16273__auto___34799 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34799,mults,ensure_mult,p){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34799,mults,ensure_mult,p){
return (function (state_34753){
var state_val_34754 = (state_34753[(1)]);
if((state_val_34754 === (7))){
var inst_34749 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34755_34800 = state_34753__$1;
(statearr_34755_34800[(2)] = inst_34749);

(statearr_34755_34800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (20))){
var state_34753__$1 = state_34753;
var statearr_34756_34801 = state_34753__$1;
(statearr_34756_34801[(2)] = null);

(statearr_34756_34801[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (1))){
var state_34753__$1 = state_34753;
var statearr_34757_34802 = state_34753__$1;
(statearr_34757_34802[(2)] = null);

(statearr_34757_34802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (24))){
var inst_34732 = (state_34753[(7)]);
var inst_34741 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_34732);
var state_34753__$1 = state_34753;
var statearr_34758_34803 = state_34753__$1;
(statearr_34758_34803[(2)] = inst_34741);

(statearr_34758_34803[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (4))){
var inst_34684 = (state_34753[(8)]);
var inst_34684__$1 = (state_34753[(2)]);
var inst_34685 = (inst_34684__$1 == null);
var state_34753__$1 = (function (){var statearr_34759 = state_34753;
(statearr_34759[(8)] = inst_34684__$1);

return statearr_34759;
})();
if(cljs.core.truth_(inst_34685)){
var statearr_34760_34804 = state_34753__$1;
(statearr_34760_34804[(1)] = (5));

} else {
var statearr_34761_34805 = state_34753__$1;
(statearr_34761_34805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (15))){
var inst_34726 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34762_34806 = state_34753__$1;
(statearr_34762_34806[(2)] = inst_34726);

(statearr_34762_34806[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (21))){
var inst_34746 = (state_34753[(2)]);
var state_34753__$1 = (function (){var statearr_34763 = state_34753;
(statearr_34763[(9)] = inst_34746);

return statearr_34763;
})();
var statearr_34764_34807 = state_34753__$1;
(statearr_34764_34807[(2)] = null);

(statearr_34764_34807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (13))){
var inst_34708 = (state_34753[(10)]);
var inst_34710 = cljs.core.chunked_seq_QMARK_.call(null,inst_34708);
var state_34753__$1 = state_34753;
if(inst_34710){
var statearr_34765_34808 = state_34753__$1;
(statearr_34765_34808[(1)] = (16));

} else {
var statearr_34766_34809 = state_34753__$1;
(statearr_34766_34809[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (22))){
var inst_34738 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
if(cljs.core.truth_(inst_34738)){
var statearr_34767_34810 = state_34753__$1;
(statearr_34767_34810[(1)] = (23));

} else {
var statearr_34768_34811 = state_34753__$1;
(statearr_34768_34811[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (6))){
var inst_34684 = (state_34753[(8)]);
var inst_34734 = (state_34753[(11)]);
var inst_34732 = (state_34753[(7)]);
var inst_34732__$1 = topic_fn.call(null,inst_34684);
var inst_34733 = cljs.core.deref.call(null,mults);
var inst_34734__$1 = cljs.core.get.call(null,inst_34733,inst_34732__$1);
var state_34753__$1 = (function (){var statearr_34769 = state_34753;
(statearr_34769[(11)] = inst_34734__$1);

(statearr_34769[(7)] = inst_34732__$1);

return statearr_34769;
})();
if(cljs.core.truth_(inst_34734__$1)){
var statearr_34770_34812 = state_34753__$1;
(statearr_34770_34812[(1)] = (19));

} else {
var statearr_34771_34813 = state_34753__$1;
(statearr_34771_34813[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (25))){
var inst_34743 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34772_34814 = state_34753__$1;
(statearr_34772_34814[(2)] = inst_34743);

(statearr_34772_34814[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (17))){
var inst_34708 = (state_34753[(10)]);
var inst_34717 = cljs.core.first.call(null,inst_34708);
var inst_34718 = cljs.core.async.muxch_STAR_.call(null,inst_34717);
var inst_34719 = cljs.core.async.close_BANG_.call(null,inst_34718);
var inst_34720 = cljs.core.next.call(null,inst_34708);
var inst_34694 = inst_34720;
var inst_34695 = null;
var inst_34696 = (0);
var inst_34697 = (0);
var state_34753__$1 = (function (){var statearr_34773 = state_34753;
(statearr_34773[(12)] = inst_34696);

(statearr_34773[(13)] = inst_34694);

(statearr_34773[(14)] = inst_34695);

(statearr_34773[(15)] = inst_34697);

(statearr_34773[(16)] = inst_34719);

return statearr_34773;
})();
var statearr_34774_34815 = state_34753__$1;
(statearr_34774_34815[(2)] = null);

(statearr_34774_34815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (3))){
var inst_34751 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34753__$1,inst_34751);
} else {
if((state_val_34754 === (12))){
var inst_34728 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34775_34816 = state_34753__$1;
(statearr_34775_34816[(2)] = inst_34728);

(statearr_34775_34816[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (2))){
var state_34753__$1 = state_34753;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34753__$1,(4),ch);
} else {
if((state_val_34754 === (23))){
var state_34753__$1 = state_34753;
var statearr_34776_34817 = state_34753__$1;
(statearr_34776_34817[(2)] = null);

(statearr_34776_34817[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (19))){
var inst_34684 = (state_34753[(8)]);
var inst_34734 = (state_34753[(11)]);
var inst_34736 = cljs.core.async.muxch_STAR_.call(null,inst_34734);
var state_34753__$1 = state_34753;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34753__$1,(22),inst_34736,inst_34684);
} else {
if((state_val_34754 === (11))){
var inst_34694 = (state_34753[(13)]);
var inst_34708 = (state_34753[(10)]);
var inst_34708__$1 = cljs.core.seq.call(null,inst_34694);
var state_34753__$1 = (function (){var statearr_34777 = state_34753;
(statearr_34777[(10)] = inst_34708__$1);

return statearr_34777;
})();
if(inst_34708__$1){
var statearr_34778_34818 = state_34753__$1;
(statearr_34778_34818[(1)] = (13));

} else {
var statearr_34779_34819 = state_34753__$1;
(statearr_34779_34819[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (9))){
var inst_34730 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34780_34820 = state_34753__$1;
(statearr_34780_34820[(2)] = inst_34730);

(statearr_34780_34820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (5))){
var inst_34691 = cljs.core.deref.call(null,mults);
var inst_34692 = cljs.core.vals.call(null,inst_34691);
var inst_34693 = cljs.core.seq.call(null,inst_34692);
var inst_34694 = inst_34693;
var inst_34695 = null;
var inst_34696 = (0);
var inst_34697 = (0);
var state_34753__$1 = (function (){var statearr_34781 = state_34753;
(statearr_34781[(12)] = inst_34696);

(statearr_34781[(13)] = inst_34694);

(statearr_34781[(14)] = inst_34695);

(statearr_34781[(15)] = inst_34697);

return statearr_34781;
})();
var statearr_34782_34821 = state_34753__$1;
(statearr_34782_34821[(2)] = null);

(statearr_34782_34821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (14))){
var state_34753__$1 = state_34753;
var statearr_34786_34822 = state_34753__$1;
(statearr_34786_34822[(2)] = null);

(statearr_34786_34822[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (16))){
var inst_34708 = (state_34753[(10)]);
var inst_34712 = cljs.core.chunk_first.call(null,inst_34708);
var inst_34713 = cljs.core.chunk_rest.call(null,inst_34708);
var inst_34714 = cljs.core.count.call(null,inst_34712);
var inst_34694 = inst_34713;
var inst_34695 = inst_34712;
var inst_34696 = inst_34714;
var inst_34697 = (0);
var state_34753__$1 = (function (){var statearr_34787 = state_34753;
(statearr_34787[(12)] = inst_34696);

(statearr_34787[(13)] = inst_34694);

(statearr_34787[(14)] = inst_34695);

(statearr_34787[(15)] = inst_34697);

return statearr_34787;
})();
var statearr_34788_34823 = state_34753__$1;
(statearr_34788_34823[(2)] = null);

(statearr_34788_34823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (10))){
var inst_34696 = (state_34753[(12)]);
var inst_34694 = (state_34753[(13)]);
var inst_34695 = (state_34753[(14)]);
var inst_34697 = (state_34753[(15)]);
var inst_34702 = cljs.core._nth.call(null,inst_34695,inst_34697);
var inst_34703 = cljs.core.async.muxch_STAR_.call(null,inst_34702);
var inst_34704 = cljs.core.async.close_BANG_.call(null,inst_34703);
var inst_34705 = (inst_34697 + (1));
var tmp34783 = inst_34696;
var tmp34784 = inst_34694;
var tmp34785 = inst_34695;
var inst_34694__$1 = tmp34784;
var inst_34695__$1 = tmp34785;
var inst_34696__$1 = tmp34783;
var inst_34697__$1 = inst_34705;
var state_34753__$1 = (function (){var statearr_34789 = state_34753;
(statearr_34789[(12)] = inst_34696__$1);

(statearr_34789[(17)] = inst_34704);

(statearr_34789[(13)] = inst_34694__$1);

(statearr_34789[(14)] = inst_34695__$1);

(statearr_34789[(15)] = inst_34697__$1);

return statearr_34789;
})();
var statearr_34790_34824 = state_34753__$1;
(statearr_34790_34824[(2)] = null);

(statearr_34790_34824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (18))){
var inst_34723 = (state_34753[(2)]);
var state_34753__$1 = state_34753;
var statearr_34791_34825 = state_34753__$1;
(statearr_34791_34825[(2)] = inst_34723);

(statearr_34791_34825[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34754 === (8))){
var inst_34696 = (state_34753[(12)]);
var inst_34697 = (state_34753[(15)]);
var inst_34699 = (inst_34697 < inst_34696);
var inst_34700 = inst_34699;
var state_34753__$1 = state_34753;
if(cljs.core.truth_(inst_34700)){
var statearr_34792_34826 = state_34753__$1;
(statearr_34792_34826[(1)] = (10));

} else {
var statearr_34793_34827 = state_34753__$1;
(statearr_34793_34827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34799,mults,ensure_mult,p))
;
return ((function (switch__16183__auto__,c__16273__auto___34799,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_34794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34794[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_34794[(1)] = (1));

return statearr_34794;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_34753){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34753);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34795){if((e34795 instanceof Object)){
var ex__16187__auto__ = e34795;
var statearr_34796_34828 = state_34753;
(statearr_34796_34828[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34753);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34829 = state_34753;
state_34753 = G__34829;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_34753){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_34753);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34799,mults,ensure_mult,p))
})();
var state__16275__auto__ = (function (){var statearr_34797 = f__16274__auto__.call(null);
(statearr_34797[(6)] = c__16273__auto___34799);

return statearr_34797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34799,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__34831 = arguments.length;
switch (G__34831) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__34834 = arguments.length;
switch (G__34834) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__34837 = arguments.length;
switch (G__34837) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16273__auto___34904 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_34876){
var state_val_34877 = (state_34876[(1)]);
if((state_val_34877 === (7))){
var state_34876__$1 = state_34876;
var statearr_34878_34905 = state_34876__$1;
(statearr_34878_34905[(2)] = null);

(statearr_34878_34905[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (1))){
var state_34876__$1 = state_34876;
var statearr_34879_34906 = state_34876__$1;
(statearr_34879_34906[(2)] = null);

(statearr_34879_34906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (4))){
var inst_34840 = (state_34876[(7)]);
var inst_34842 = (inst_34840 < cnt);
var state_34876__$1 = state_34876;
if(cljs.core.truth_(inst_34842)){
var statearr_34880_34907 = state_34876__$1;
(statearr_34880_34907[(1)] = (6));

} else {
var statearr_34881_34908 = state_34876__$1;
(statearr_34881_34908[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (15))){
var inst_34872 = (state_34876[(2)]);
var state_34876__$1 = state_34876;
var statearr_34882_34909 = state_34876__$1;
(statearr_34882_34909[(2)] = inst_34872);

(statearr_34882_34909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (13))){
var inst_34865 = cljs.core.async.close_BANG_.call(null,out);
var state_34876__$1 = state_34876;
var statearr_34883_34910 = state_34876__$1;
(statearr_34883_34910[(2)] = inst_34865);

(statearr_34883_34910[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (6))){
var state_34876__$1 = state_34876;
var statearr_34884_34911 = state_34876__$1;
(statearr_34884_34911[(2)] = null);

(statearr_34884_34911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (3))){
var inst_34874 = (state_34876[(2)]);
var state_34876__$1 = state_34876;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34876__$1,inst_34874);
} else {
if((state_val_34877 === (12))){
var inst_34862 = (state_34876[(8)]);
var inst_34862__$1 = (state_34876[(2)]);
var inst_34863 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_34862__$1);
var state_34876__$1 = (function (){var statearr_34885 = state_34876;
(statearr_34885[(8)] = inst_34862__$1);

return statearr_34885;
})();
if(cljs.core.truth_(inst_34863)){
var statearr_34886_34912 = state_34876__$1;
(statearr_34886_34912[(1)] = (13));

} else {
var statearr_34887_34913 = state_34876__$1;
(statearr_34887_34913[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (2))){
var inst_34839 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_34840 = (0);
var state_34876__$1 = (function (){var statearr_34888 = state_34876;
(statearr_34888[(7)] = inst_34840);

(statearr_34888[(9)] = inst_34839);

return statearr_34888;
})();
var statearr_34889_34914 = state_34876__$1;
(statearr_34889_34914[(2)] = null);

(statearr_34889_34914[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (11))){
var inst_34840 = (state_34876[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_34876,(10),Object,null,(9));
var inst_34849 = chs__$1.call(null,inst_34840);
var inst_34850 = done.call(null,inst_34840);
var inst_34851 = cljs.core.async.take_BANG_.call(null,inst_34849,inst_34850);
var state_34876__$1 = state_34876;
var statearr_34890_34915 = state_34876__$1;
(statearr_34890_34915[(2)] = inst_34851);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34876__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (9))){
var inst_34840 = (state_34876[(7)]);
var inst_34853 = (state_34876[(2)]);
var inst_34854 = (inst_34840 + (1));
var inst_34840__$1 = inst_34854;
var state_34876__$1 = (function (){var statearr_34891 = state_34876;
(statearr_34891[(7)] = inst_34840__$1);

(statearr_34891[(10)] = inst_34853);

return statearr_34891;
})();
var statearr_34892_34916 = state_34876__$1;
(statearr_34892_34916[(2)] = null);

(statearr_34892_34916[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (5))){
var inst_34860 = (state_34876[(2)]);
var state_34876__$1 = (function (){var statearr_34893 = state_34876;
(statearr_34893[(11)] = inst_34860);

return statearr_34893;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34876__$1,(12),dchan);
} else {
if((state_val_34877 === (14))){
var inst_34862 = (state_34876[(8)]);
var inst_34867 = cljs.core.apply.call(null,f,inst_34862);
var state_34876__$1 = state_34876;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34876__$1,(16),out,inst_34867);
} else {
if((state_val_34877 === (16))){
var inst_34869 = (state_34876[(2)]);
var state_34876__$1 = (function (){var statearr_34894 = state_34876;
(statearr_34894[(12)] = inst_34869);

return statearr_34894;
})();
var statearr_34895_34917 = state_34876__$1;
(statearr_34895_34917[(2)] = null);

(statearr_34895_34917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (10))){
var inst_34844 = (state_34876[(2)]);
var inst_34845 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_34876__$1 = (function (){var statearr_34896 = state_34876;
(statearr_34896[(13)] = inst_34844);

return statearr_34896;
})();
var statearr_34897_34918 = state_34876__$1;
(statearr_34897_34918[(2)] = inst_34845);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34876__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34877 === (8))){
var inst_34858 = (state_34876[(2)]);
var state_34876__$1 = state_34876;
var statearr_34898_34919 = state_34876__$1;
(statearr_34898_34919[(2)] = inst_34858);

(statearr_34898_34919[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16183__auto__,c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_34899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34899[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_34899[(1)] = (1));

return statearr_34899;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_34876){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34900){if((e34900 instanceof Object)){
var ex__16187__auto__ = e34900;
var statearr_34901_34920 = state_34876;
(statearr_34901_34920[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34900;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34921 = state_34876;
state_34876 = G__34921;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_34876){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_34876);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16275__auto__ = (function (){var statearr_34902 = f__16274__auto__.call(null);
(statearr_34902[(6)] = c__16273__auto___34904);

return statearr_34902;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34904,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__34924 = arguments.length;
switch (G__34924) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___34978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___34978,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___34978,out){
return (function (state_34956){
var state_val_34957 = (state_34956[(1)]);
if((state_val_34957 === (7))){
var inst_34935 = (state_34956[(7)]);
var inst_34936 = (state_34956[(8)]);
var inst_34935__$1 = (state_34956[(2)]);
var inst_34936__$1 = cljs.core.nth.call(null,inst_34935__$1,(0),null);
var inst_34937 = cljs.core.nth.call(null,inst_34935__$1,(1),null);
var inst_34938 = (inst_34936__$1 == null);
var state_34956__$1 = (function (){var statearr_34958 = state_34956;
(statearr_34958[(9)] = inst_34937);

(statearr_34958[(7)] = inst_34935__$1);

(statearr_34958[(8)] = inst_34936__$1);

return statearr_34958;
})();
if(cljs.core.truth_(inst_34938)){
var statearr_34959_34979 = state_34956__$1;
(statearr_34959_34979[(1)] = (8));

} else {
var statearr_34960_34980 = state_34956__$1;
(statearr_34960_34980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (1))){
var inst_34925 = cljs.core.vec.call(null,chs);
var inst_34926 = inst_34925;
var state_34956__$1 = (function (){var statearr_34961 = state_34956;
(statearr_34961[(10)] = inst_34926);

return statearr_34961;
})();
var statearr_34962_34981 = state_34956__$1;
(statearr_34962_34981[(2)] = null);

(statearr_34962_34981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (4))){
var inst_34926 = (state_34956[(10)]);
var state_34956__$1 = state_34956;
return cljs.core.async.ioc_alts_BANG_.call(null,state_34956__$1,(7),inst_34926);
} else {
if((state_val_34957 === (6))){
var inst_34952 = (state_34956[(2)]);
var state_34956__$1 = state_34956;
var statearr_34963_34982 = state_34956__$1;
(statearr_34963_34982[(2)] = inst_34952);

(statearr_34963_34982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (3))){
var inst_34954 = (state_34956[(2)]);
var state_34956__$1 = state_34956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34956__$1,inst_34954);
} else {
if((state_val_34957 === (2))){
var inst_34926 = (state_34956[(10)]);
var inst_34928 = cljs.core.count.call(null,inst_34926);
var inst_34929 = (inst_34928 > (0));
var state_34956__$1 = state_34956;
if(cljs.core.truth_(inst_34929)){
var statearr_34965_34983 = state_34956__$1;
(statearr_34965_34983[(1)] = (4));

} else {
var statearr_34966_34984 = state_34956__$1;
(statearr_34966_34984[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (11))){
var inst_34926 = (state_34956[(10)]);
var inst_34945 = (state_34956[(2)]);
var tmp34964 = inst_34926;
var inst_34926__$1 = tmp34964;
var state_34956__$1 = (function (){var statearr_34967 = state_34956;
(statearr_34967[(10)] = inst_34926__$1);

(statearr_34967[(11)] = inst_34945);

return statearr_34967;
})();
var statearr_34968_34985 = state_34956__$1;
(statearr_34968_34985[(2)] = null);

(statearr_34968_34985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (9))){
var inst_34936 = (state_34956[(8)]);
var state_34956__$1 = state_34956;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34956__$1,(11),out,inst_34936);
} else {
if((state_val_34957 === (5))){
var inst_34950 = cljs.core.async.close_BANG_.call(null,out);
var state_34956__$1 = state_34956;
var statearr_34969_34986 = state_34956__$1;
(statearr_34969_34986[(2)] = inst_34950);

(statearr_34969_34986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (10))){
var inst_34948 = (state_34956[(2)]);
var state_34956__$1 = state_34956;
var statearr_34970_34987 = state_34956__$1;
(statearr_34970_34987[(2)] = inst_34948);

(statearr_34970_34987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34957 === (8))){
var inst_34926 = (state_34956[(10)]);
var inst_34937 = (state_34956[(9)]);
var inst_34935 = (state_34956[(7)]);
var inst_34936 = (state_34956[(8)]);
var inst_34940 = (function (){var cs = inst_34926;
var vec__34931 = inst_34935;
var v = inst_34936;
var c = inst_34937;
return ((function (cs,vec__34931,v,c,inst_34926,inst_34937,inst_34935,inst_34936,state_val_34957,c__16273__auto___34978,out){
return (function (p1__34922_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__34922_SHARP_);
});
;})(cs,vec__34931,v,c,inst_34926,inst_34937,inst_34935,inst_34936,state_val_34957,c__16273__auto___34978,out))
})();
var inst_34941 = cljs.core.filterv.call(null,inst_34940,inst_34926);
var inst_34926__$1 = inst_34941;
var state_34956__$1 = (function (){var statearr_34971 = state_34956;
(statearr_34971[(10)] = inst_34926__$1);

return statearr_34971;
})();
var statearr_34972_34988 = state_34956__$1;
(statearr_34972_34988[(2)] = null);

(statearr_34972_34988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___34978,out))
;
return ((function (switch__16183__auto__,c__16273__auto___34978,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_34973 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34973[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_34973[(1)] = (1));

return statearr_34973;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_34956){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_34956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e34974){if((e34974 instanceof Object)){
var ex__16187__auto__ = e34974;
var statearr_34975_34989 = state_34956;
(statearr_34975_34989[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34974;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34990 = state_34956;
state_34956 = G__34990;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_34956){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_34956);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___34978,out))
})();
var state__16275__auto__ = (function (){var statearr_34976 = f__16274__auto__.call(null);
(statearr_34976[(6)] = c__16273__auto___34978);

return statearr_34976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___34978,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__34992 = arguments.length;
switch (G__34992) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___35037 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___35037,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___35037,out){
return (function (state_35016){
var state_val_35017 = (state_35016[(1)]);
if((state_val_35017 === (7))){
var inst_34998 = (state_35016[(7)]);
var inst_34998__$1 = (state_35016[(2)]);
var inst_34999 = (inst_34998__$1 == null);
var inst_35000 = cljs.core.not.call(null,inst_34999);
var state_35016__$1 = (function (){var statearr_35018 = state_35016;
(statearr_35018[(7)] = inst_34998__$1);

return statearr_35018;
})();
if(inst_35000){
var statearr_35019_35038 = state_35016__$1;
(statearr_35019_35038[(1)] = (8));

} else {
var statearr_35020_35039 = state_35016__$1;
(statearr_35020_35039[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (1))){
var inst_34993 = (0);
var state_35016__$1 = (function (){var statearr_35021 = state_35016;
(statearr_35021[(8)] = inst_34993);

return statearr_35021;
})();
var statearr_35022_35040 = state_35016__$1;
(statearr_35022_35040[(2)] = null);

(statearr_35022_35040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (4))){
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35016__$1,(7),ch);
} else {
if((state_val_35017 === (6))){
var inst_35011 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35023_35041 = state_35016__$1;
(statearr_35023_35041[(2)] = inst_35011);

(statearr_35023_35041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (3))){
var inst_35013 = (state_35016[(2)]);
var inst_35014 = cljs.core.async.close_BANG_.call(null,out);
var state_35016__$1 = (function (){var statearr_35024 = state_35016;
(statearr_35024[(9)] = inst_35013);

return statearr_35024;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35016__$1,inst_35014);
} else {
if((state_val_35017 === (2))){
var inst_34993 = (state_35016[(8)]);
var inst_34995 = (inst_34993 < n);
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34995)){
var statearr_35025_35042 = state_35016__$1;
(statearr_35025_35042[(1)] = (4));

} else {
var statearr_35026_35043 = state_35016__$1;
(statearr_35026_35043[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (11))){
var inst_34993 = (state_35016[(8)]);
var inst_35003 = (state_35016[(2)]);
var inst_35004 = (inst_34993 + (1));
var inst_34993__$1 = inst_35004;
var state_35016__$1 = (function (){var statearr_35027 = state_35016;
(statearr_35027[(10)] = inst_35003);

(statearr_35027[(8)] = inst_34993__$1);

return statearr_35027;
})();
var statearr_35028_35044 = state_35016__$1;
(statearr_35028_35044[(2)] = null);

(statearr_35028_35044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (9))){
var state_35016__$1 = state_35016;
var statearr_35029_35045 = state_35016__$1;
(statearr_35029_35045[(2)] = null);

(statearr_35029_35045[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (5))){
var state_35016__$1 = state_35016;
var statearr_35030_35046 = state_35016__$1;
(statearr_35030_35046[(2)] = null);

(statearr_35030_35046[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (10))){
var inst_35008 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35031_35047 = state_35016__$1;
(statearr_35031_35047[(2)] = inst_35008);

(statearr_35031_35047[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35017 === (8))){
var inst_34998 = (state_35016[(7)]);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35016__$1,(11),out,inst_34998);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___35037,out))
;
return ((function (switch__16183__auto__,c__16273__auto___35037,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_35032 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35032[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_35032[(1)] = (1));

return statearr_35032;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_35016){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35016);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35033){if((e35033 instanceof Object)){
var ex__16187__auto__ = e35033;
var statearr_35034_35048 = state_35016;
(statearr_35034_35048[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35016);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35049 = state_35016;
state_35016 = G__35049;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_35016){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_35016);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___35037,out))
})();
var state__16275__auto__ = (function (){var statearr_35035 = f__16274__auto__.call(null);
(statearr_35035[(6)] = c__16273__auto___35037);

return statearr_35035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___35037,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35051 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35051 = (function (f,ch,meta35052){
this.f = f;
this.ch = ch;
this.meta35052 = meta35052;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35053,meta35052__$1){
var self__ = this;
var _35053__$1 = this;
return (new cljs.core.async.t_cljs$core$async35051(self__.f,self__.ch,meta35052__$1));
});

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35053){
var self__ = this;
var _35053__$1 = this;
return self__.meta35052;
});

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async35054 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35054 = (function (f,ch,meta35052,_,fn1,meta35055){
this.f = f;
this.ch = ch;
this.meta35052 = meta35052;
this._ = _;
this.fn1 = fn1;
this.meta35055 = meta35055;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_35056,meta35055__$1){
var self__ = this;
var _35056__$1 = this;
return (new cljs.core.async.t_cljs$core$async35054(self__.f,self__.ch,self__.meta35052,self__._,self__.fn1,meta35055__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_35056){
var self__ = this;
var _35056__$1 = this;
return self__.meta35055;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__35050_SHARP_){
return f1.call(null,(((p1__35050_SHARP_ == null))?null:self__.f.call(null,p1__35050_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35052","meta35052",722935126,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async35051","cljs.core.async/t_cljs$core$async35051",1965851852,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta35055","meta35055",242717157,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async35054.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35054.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35054";

cljs.core.async.t_cljs$core$async35054.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async35054");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async35054 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35054(f__$1,ch__$1,meta35052__$1,___$2,fn1__$1,meta35055){
return (new cljs.core.async.t_cljs$core$async35054(f__$1,ch__$1,meta35052__$1,___$2,fn1__$1,meta35055));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async35054(self__.f,self__.ch,self__.meta35052,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8376__auto__ = ret;
if(cljs.core.truth_(and__8376__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8376__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35051.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async35051.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35052","meta35052",722935126,null)], null);
});

cljs.core.async.t_cljs$core$async35051.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35051.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35051";

cljs.core.async.t_cljs$core$async35051.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async35051");
});

cljs.core.async.__GT_t_cljs$core$async35051 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async35051(f__$1,ch__$1,meta35052){
return (new cljs.core.async.t_cljs$core$async35051(f__$1,ch__$1,meta35052));
});

}

return (new cljs.core.async.t_cljs$core$async35051(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async35057 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35057 = (function (f,ch,meta35058){
this.f = f;
this.ch = ch;
this.meta35058 = meta35058;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35059,meta35058__$1){
var self__ = this;
var _35059__$1 = this;
return (new cljs.core.async.t_cljs$core$async35057(self__.f,self__.ch,meta35058__$1));
});

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35059){
var self__ = this;
var _35059__$1 = this;
return self__.meta35058;
});

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35057.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async35057.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35058","meta35058",-1289324856,null)], null);
});

cljs.core.async.t_cljs$core$async35057.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35057.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35057";

cljs.core.async.t_cljs$core$async35057.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async35057");
});

cljs.core.async.__GT_t_cljs$core$async35057 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async35057(f__$1,ch__$1,meta35058){
return (new cljs.core.async.t_cljs$core$async35057(f__$1,ch__$1,meta35058));
});

}

return (new cljs.core.async.t_cljs$core$async35057(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async35060 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35060 = (function (p,ch,meta35061){
this.p = p;
this.ch = ch;
this.meta35061 = meta35061;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35062,meta35061__$1){
var self__ = this;
var _35062__$1 = this;
return (new cljs.core.async.t_cljs$core$async35060(self__.p,self__.ch,meta35061__$1));
});

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35062){
var self__ = this;
var _35062__$1 = this;
return self__.meta35061;
});

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async35060.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async35060.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta35061","meta35061",-1881915897,null)], null);
});

cljs.core.async.t_cljs$core$async35060.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async35060.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35060";

cljs.core.async.t_cljs$core$async35060.cljs$lang$ctorPrWriter = (function (this__9059__auto__,writer__9060__auto__,opt__9061__auto__){
return cljs.core._write.call(null,writer__9060__auto__,"cljs.core.async/t_cljs$core$async35060");
});

cljs.core.async.__GT_t_cljs$core$async35060 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async35060(p__$1,ch__$1,meta35061){
return (new cljs.core.async.t_cljs$core$async35060(p__$1,ch__$1,meta35061));
});

}

return (new cljs.core.async.t_cljs$core$async35060(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__35064 = arguments.length;
switch (G__35064) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___35104 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___35104,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___35104,out){
return (function (state_35085){
var state_val_35086 = (state_35085[(1)]);
if((state_val_35086 === (7))){
var inst_35081 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35087_35105 = state_35085__$1;
(statearr_35087_35105[(2)] = inst_35081);

(statearr_35087_35105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (1))){
var state_35085__$1 = state_35085;
var statearr_35088_35106 = state_35085__$1;
(statearr_35088_35106[(2)] = null);

(statearr_35088_35106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (4))){
var inst_35067 = (state_35085[(7)]);
var inst_35067__$1 = (state_35085[(2)]);
var inst_35068 = (inst_35067__$1 == null);
var state_35085__$1 = (function (){var statearr_35089 = state_35085;
(statearr_35089[(7)] = inst_35067__$1);

return statearr_35089;
})();
if(cljs.core.truth_(inst_35068)){
var statearr_35090_35107 = state_35085__$1;
(statearr_35090_35107[(1)] = (5));

} else {
var statearr_35091_35108 = state_35085__$1;
(statearr_35091_35108[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (6))){
var inst_35067 = (state_35085[(7)]);
var inst_35072 = p.call(null,inst_35067);
var state_35085__$1 = state_35085;
if(cljs.core.truth_(inst_35072)){
var statearr_35092_35109 = state_35085__$1;
(statearr_35092_35109[(1)] = (8));

} else {
var statearr_35093_35110 = state_35085__$1;
(statearr_35093_35110[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (3))){
var inst_35083 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35085__$1,inst_35083);
} else {
if((state_val_35086 === (2))){
var state_35085__$1 = state_35085;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35085__$1,(4),ch);
} else {
if((state_val_35086 === (11))){
var inst_35075 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35094_35111 = state_35085__$1;
(statearr_35094_35111[(2)] = inst_35075);

(statearr_35094_35111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (9))){
var state_35085__$1 = state_35085;
var statearr_35095_35112 = state_35085__$1;
(statearr_35095_35112[(2)] = null);

(statearr_35095_35112[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (5))){
var inst_35070 = cljs.core.async.close_BANG_.call(null,out);
var state_35085__$1 = state_35085;
var statearr_35096_35113 = state_35085__$1;
(statearr_35096_35113[(2)] = inst_35070);

(statearr_35096_35113[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (10))){
var inst_35078 = (state_35085[(2)]);
var state_35085__$1 = (function (){var statearr_35097 = state_35085;
(statearr_35097[(8)] = inst_35078);

return statearr_35097;
})();
var statearr_35098_35114 = state_35085__$1;
(statearr_35098_35114[(2)] = null);

(statearr_35098_35114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35086 === (8))){
var inst_35067 = (state_35085[(7)]);
var state_35085__$1 = state_35085;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35085__$1,(11),out,inst_35067);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___35104,out))
;
return ((function (switch__16183__auto__,c__16273__auto___35104,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_35099 = [null,null,null,null,null,null,null,null,null];
(statearr_35099[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_35099[(1)] = (1));

return statearr_35099;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_35085){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35085);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35100){if((e35100 instanceof Object)){
var ex__16187__auto__ = e35100;
var statearr_35101_35115 = state_35085;
(statearr_35101_35115[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35085);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35100;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35116 = state_35085;
state_35085 = G__35116;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_35085){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_35085);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___35104,out))
})();
var state__16275__auto__ = (function (){var statearr_35102 = f__16274__auto__.call(null);
(statearr_35102[(6)] = c__16273__auto___35104);

return statearr_35102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___35104,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__35118 = arguments.length;
switch (G__35118) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16273__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto__){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto__){
return (function (state_35181){
var state_val_35182 = (state_35181[(1)]);
if((state_val_35182 === (7))){
var inst_35177 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35183_35221 = state_35181__$1;
(statearr_35183_35221[(2)] = inst_35177);

(statearr_35183_35221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (20))){
var inst_35147 = (state_35181[(7)]);
var inst_35158 = (state_35181[(2)]);
var inst_35159 = cljs.core.next.call(null,inst_35147);
var inst_35133 = inst_35159;
var inst_35134 = null;
var inst_35135 = (0);
var inst_35136 = (0);
var state_35181__$1 = (function (){var statearr_35184 = state_35181;
(statearr_35184[(8)] = inst_35134);

(statearr_35184[(9)] = inst_35135);

(statearr_35184[(10)] = inst_35133);

(statearr_35184[(11)] = inst_35158);

(statearr_35184[(12)] = inst_35136);

return statearr_35184;
})();
var statearr_35185_35222 = state_35181__$1;
(statearr_35185_35222[(2)] = null);

(statearr_35185_35222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (1))){
var state_35181__$1 = state_35181;
var statearr_35186_35223 = state_35181__$1;
(statearr_35186_35223[(2)] = null);

(statearr_35186_35223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (4))){
var inst_35122 = (state_35181[(13)]);
var inst_35122__$1 = (state_35181[(2)]);
var inst_35123 = (inst_35122__$1 == null);
var state_35181__$1 = (function (){var statearr_35187 = state_35181;
(statearr_35187[(13)] = inst_35122__$1);

return statearr_35187;
})();
if(cljs.core.truth_(inst_35123)){
var statearr_35188_35224 = state_35181__$1;
(statearr_35188_35224[(1)] = (5));

} else {
var statearr_35189_35225 = state_35181__$1;
(statearr_35189_35225[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (15))){
var state_35181__$1 = state_35181;
var statearr_35193_35226 = state_35181__$1;
(statearr_35193_35226[(2)] = null);

(statearr_35193_35226[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (21))){
var state_35181__$1 = state_35181;
var statearr_35194_35227 = state_35181__$1;
(statearr_35194_35227[(2)] = null);

(statearr_35194_35227[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (13))){
var inst_35134 = (state_35181[(8)]);
var inst_35135 = (state_35181[(9)]);
var inst_35133 = (state_35181[(10)]);
var inst_35136 = (state_35181[(12)]);
var inst_35143 = (state_35181[(2)]);
var inst_35144 = (inst_35136 + (1));
var tmp35190 = inst_35134;
var tmp35191 = inst_35135;
var tmp35192 = inst_35133;
var inst_35133__$1 = tmp35192;
var inst_35134__$1 = tmp35190;
var inst_35135__$1 = tmp35191;
var inst_35136__$1 = inst_35144;
var state_35181__$1 = (function (){var statearr_35195 = state_35181;
(statearr_35195[(8)] = inst_35134__$1);

(statearr_35195[(9)] = inst_35135__$1);

(statearr_35195[(10)] = inst_35133__$1);

(statearr_35195[(14)] = inst_35143);

(statearr_35195[(12)] = inst_35136__$1);

return statearr_35195;
})();
var statearr_35196_35228 = state_35181__$1;
(statearr_35196_35228[(2)] = null);

(statearr_35196_35228[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (22))){
var state_35181__$1 = state_35181;
var statearr_35197_35229 = state_35181__$1;
(statearr_35197_35229[(2)] = null);

(statearr_35197_35229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (6))){
var inst_35122 = (state_35181[(13)]);
var inst_35131 = f.call(null,inst_35122);
var inst_35132 = cljs.core.seq.call(null,inst_35131);
var inst_35133 = inst_35132;
var inst_35134 = null;
var inst_35135 = (0);
var inst_35136 = (0);
var state_35181__$1 = (function (){var statearr_35198 = state_35181;
(statearr_35198[(8)] = inst_35134);

(statearr_35198[(9)] = inst_35135);

(statearr_35198[(10)] = inst_35133);

(statearr_35198[(12)] = inst_35136);

return statearr_35198;
})();
var statearr_35199_35230 = state_35181__$1;
(statearr_35199_35230[(2)] = null);

(statearr_35199_35230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (17))){
var inst_35147 = (state_35181[(7)]);
var inst_35151 = cljs.core.chunk_first.call(null,inst_35147);
var inst_35152 = cljs.core.chunk_rest.call(null,inst_35147);
var inst_35153 = cljs.core.count.call(null,inst_35151);
var inst_35133 = inst_35152;
var inst_35134 = inst_35151;
var inst_35135 = inst_35153;
var inst_35136 = (0);
var state_35181__$1 = (function (){var statearr_35200 = state_35181;
(statearr_35200[(8)] = inst_35134);

(statearr_35200[(9)] = inst_35135);

(statearr_35200[(10)] = inst_35133);

(statearr_35200[(12)] = inst_35136);

return statearr_35200;
})();
var statearr_35201_35231 = state_35181__$1;
(statearr_35201_35231[(2)] = null);

(statearr_35201_35231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (3))){
var inst_35179 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35181__$1,inst_35179);
} else {
if((state_val_35182 === (12))){
var inst_35167 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35202_35232 = state_35181__$1;
(statearr_35202_35232[(2)] = inst_35167);

(statearr_35202_35232[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (2))){
var state_35181__$1 = state_35181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35181__$1,(4),in$);
} else {
if((state_val_35182 === (23))){
var inst_35175 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35203_35233 = state_35181__$1;
(statearr_35203_35233[(2)] = inst_35175);

(statearr_35203_35233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (19))){
var inst_35162 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35204_35234 = state_35181__$1;
(statearr_35204_35234[(2)] = inst_35162);

(statearr_35204_35234[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (11))){
var inst_35133 = (state_35181[(10)]);
var inst_35147 = (state_35181[(7)]);
var inst_35147__$1 = cljs.core.seq.call(null,inst_35133);
var state_35181__$1 = (function (){var statearr_35205 = state_35181;
(statearr_35205[(7)] = inst_35147__$1);

return statearr_35205;
})();
if(inst_35147__$1){
var statearr_35206_35235 = state_35181__$1;
(statearr_35206_35235[(1)] = (14));

} else {
var statearr_35207_35236 = state_35181__$1;
(statearr_35207_35236[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (9))){
var inst_35169 = (state_35181[(2)]);
var inst_35170 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_35181__$1 = (function (){var statearr_35208 = state_35181;
(statearr_35208[(15)] = inst_35169);

return statearr_35208;
})();
if(cljs.core.truth_(inst_35170)){
var statearr_35209_35237 = state_35181__$1;
(statearr_35209_35237[(1)] = (21));

} else {
var statearr_35210_35238 = state_35181__$1;
(statearr_35210_35238[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (5))){
var inst_35125 = cljs.core.async.close_BANG_.call(null,out);
var state_35181__$1 = state_35181;
var statearr_35211_35239 = state_35181__$1;
(statearr_35211_35239[(2)] = inst_35125);

(statearr_35211_35239[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (14))){
var inst_35147 = (state_35181[(7)]);
var inst_35149 = cljs.core.chunked_seq_QMARK_.call(null,inst_35147);
var state_35181__$1 = state_35181;
if(inst_35149){
var statearr_35212_35240 = state_35181__$1;
(statearr_35212_35240[(1)] = (17));

} else {
var statearr_35213_35241 = state_35181__$1;
(statearr_35213_35241[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (16))){
var inst_35165 = (state_35181[(2)]);
var state_35181__$1 = state_35181;
var statearr_35214_35242 = state_35181__$1;
(statearr_35214_35242[(2)] = inst_35165);

(statearr_35214_35242[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35182 === (10))){
var inst_35134 = (state_35181[(8)]);
var inst_35136 = (state_35181[(12)]);
var inst_35141 = cljs.core._nth.call(null,inst_35134,inst_35136);
var state_35181__$1 = state_35181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35181__$1,(13),out,inst_35141);
} else {
if((state_val_35182 === (18))){
var inst_35147 = (state_35181[(7)]);
var inst_35156 = cljs.core.first.call(null,inst_35147);
var state_35181__$1 = state_35181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35181__$1,(20),out,inst_35156);
} else {
if((state_val_35182 === (8))){
var inst_35135 = (state_35181[(9)]);
var inst_35136 = (state_35181[(12)]);
var inst_35138 = (inst_35136 < inst_35135);
var inst_35139 = inst_35138;
var state_35181__$1 = state_35181;
if(cljs.core.truth_(inst_35139)){
var statearr_35215_35243 = state_35181__$1;
(statearr_35215_35243[(1)] = (10));

} else {
var statearr_35216_35244 = state_35181__$1;
(statearr_35216_35244[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto__))
;
return ((function (switch__16183__auto__,c__16273__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0 = (function (){
var statearr_35217 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35217[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__);

(statearr_35217[(1)] = (1));

return statearr_35217;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1 = (function (state_35181){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35218){if((e35218 instanceof Object)){
var ex__16187__auto__ = e35218;
var statearr_35219_35245 = state_35181;
(statearr_35219_35245[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35218;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35246 = state_35181;
state_35181 = G__35246;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__ = function(state_35181){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1.call(this,state_35181);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16184__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto__))
})();
var state__16275__auto__ = (function (){var statearr_35220 = f__16274__auto__.call(null);
(statearr_35220[(6)] = c__16273__auto__);

return statearr_35220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto__))
);

return c__16273__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__35248 = arguments.length;
switch (G__35248) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__35251 = arguments.length;
switch (G__35251) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__35254 = arguments.length;
switch (G__35254) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___35301 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___35301,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___35301,out){
return (function (state_35278){
var state_val_35279 = (state_35278[(1)]);
if((state_val_35279 === (7))){
var inst_35273 = (state_35278[(2)]);
var state_35278__$1 = state_35278;
var statearr_35280_35302 = state_35278__$1;
(statearr_35280_35302[(2)] = inst_35273);

(statearr_35280_35302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (1))){
var inst_35255 = null;
var state_35278__$1 = (function (){var statearr_35281 = state_35278;
(statearr_35281[(7)] = inst_35255);

return statearr_35281;
})();
var statearr_35282_35303 = state_35278__$1;
(statearr_35282_35303[(2)] = null);

(statearr_35282_35303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (4))){
var inst_35258 = (state_35278[(8)]);
var inst_35258__$1 = (state_35278[(2)]);
var inst_35259 = (inst_35258__$1 == null);
var inst_35260 = cljs.core.not.call(null,inst_35259);
var state_35278__$1 = (function (){var statearr_35283 = state_35278;
(statearr_35283[(8)] = inst_35258__$1);

return statearr_35283;
})();
if(inst_35260){
var statearr_35284_35304 = state_35278__$1;
(statearr_35284_35304[(1)] = (5));

} else {
var statearr_35285_35305 = state_35278__$1;
(statearr_35285_35305[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (6))){
var state_35278__$1 = state_35278;
var statearr_35286_35306 = state_35278__$1;
(statearr_35286_35306[(2)] = null);

(statearr_35286_35306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (3))){
var inst_35275 = (state_35278[(2)]);
var inst_35276 = cljs.core.async.close_BANG_.call(null,out);
var state_35278__$1 = (function (){var statearr_35287 = state_35278;
(statearr_35287[(9)] = inst_35275);

return statearr_35287;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35278__$1,inst_35276);
} else {
if((state_val_35279 === (2))){
var state_35278__$1 = state_35278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35278__$1,(4),ch);
} else {
if((state_val_35279 === (11))){
var inst_35258 = (state_35278[(8)]);
var inst_35267 = (state_35278[(2)]);
var inst_35255 = inst_35258;
var state_35278__$1 = (function (){var statearr_35288 = state_35278;
(statearr_35288[(7)] = inst_35255);

(statearr_35288[(10)] = inst_35267);

return statearr_35288;
})();
var statearr_35289_35307 = state_35278__$1;
(statearr_35289_35307[(2)] = null);

(statearr_35289_35307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (9))){
var inst_35258 = (state_35278[(8)]);
var state_35278__$1 = state_35278;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35278__$1,(11),out,inst_35258);
} else {
if((state_val_35279 === (5))){
var inst_35255 = (state_35278[(7)]);
var inst_35258 = (state_35278[(8)]);
var inst_35262 = cljs.core._EQ_.call(null,inst_35258,inst_35255);
var state_35278__$1 = state_35278;
if(inst_35262){
var statearr_35291_35308 = state_35278__$1;
(statearr_35291_35308[(1)] = (8));

} else {
var statearr_35292_35309 = state_35278__$1;
(statearr_35292_35309[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (10))){
var inst_35270 = (state_35278[(2)]);
var state_35278__$1 = state_35278;
var statearr_35293_35310 = state_35278__$1;
(statearr_35293_35310[(2)] = inst_35270);

(statearr_35293_35310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35279 === (8))){
var inst_35255 = (state_35278[(7)]);
var tmp35290 = inst_35255;
var inst_35255__$1 = tmp35290;
var state_35278__$1 = (function (){var statearr_35294 = state_35278;
(statearr_35294[(7)] = inst_35255__$1);

return statearr_35294;
})();
var statearr_35295_35311 = state_35278__$1;
(statearr_35295_35311[(2)] = null);

(statearr_35295_35311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___35301,out))
;
return ((function (switch__16183__auto__,c__16273__auto___35301,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_35296 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35296[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_35296[(1)] = (1));

return statearr_35296;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_35278){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35297){if((e35297 instanceof Object)){
var ex__16187__auto__ = e35297;
var statearr_35298_35312 = state_35278;
(statearr_35298_35312[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35278);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35297;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35313 = state_35278;
state_35278 = G__35313;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_35278){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_35278);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___35301,out))
})();
var state__16275__auto__ = (function (){var statearr_35299 = f__16274__auto__.call(null);
(statearr_35299[(6)] = c__16273__auto___35301);

return statearr_35299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___35301,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__35315 = arguments.length;
switch (G__35315) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___35381 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___35381,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___35381,out){
return (function (state_35353){
var state_val_35354 = (state_35353[(1)]);
if((state_val_35354 === (7))){
var inst_35349 = (state_35353[(2)]);
var state_35353__$1 = state_35353;
var statearr_35355_35382 = state_35353__$1;
(statearr_35355_35382[(2)] = inst_35349);

(statearr_35355_35382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (1))){
var inst_35316 = (new Array(n));
var inst_35317 = inst_35316;
var inst_35318 = (0);
var state_35353__$1 = (function (){var statearr_35356 = state_35353;
(statearr_35356[(7)] = inst_35317);

(statearr_35356[(8)] = inst_35318);

return statearr_35356;
})();
var statearr_35357_35383 = state_35353__$1;
(statearr_35357_35383[(2)] = null);

(statearr_35357_35383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (4))){
var inst_35321 = (state_35353[(9)]);
var inst_35321__$1 = (state_35353[(2)]);
var inst_35322 = (inst_35321__$1 == null);
var inst_35323 = cljs.core.not.call(null,inst_35322);
var state_35353__$1 = (function (){var statearr_35358 = state_35353;
(statearr_35358[(9)] = inst_35321__$1);

return statearr_35358;
})();
if(inst_35323){
var statearr_35359_35384 = state_35353__$1;
(statearr_35359_35384[(1)] = (5));

} else {
var statearr_35360_35385 = state_35353__$1;
(statearr_35360_35385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (15))){
var inst_35343 = (state_35353[(2)]);
var state_35353__$1 = state_35353;
var statearr_35361_35386 = state_35353__$1;
(statearr_35361_35386[(2)] = inst_35343);

(statearr_35361_35386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (13))){
var state_35353__$1 = state_35353;
var statearr_35362_35387 = state_35353__$1;
(statearr_35362_35387[(2)] = null);

(statearr_35362_35387[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (6))){
var inst_35318 = (state_35353[(8)]);
var inst_35339 = (inst_35318 > (0));
var state_35353__$1 = state_35353;
if(cljs.core.truth_(inst_35339)){
var statearr_35363_35388 = state_35353__$1;
(statearr_35363_35388[(1)] = (12));

} else {
var statearr_35364_35389 = state_35353__$1;
(statearr_35364_35389[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (3))){
var inst_35351 = (state_35353[(2)]);
var state_35353__$1 = state_35353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35353__$1,inst_35351);
} else {
if((state_val_35354 === (12))){
var inst_35317 = (state_35353[(7)]);
var inst_35341 = cljs.core.vec.call(null,inst_35317);
var state_35353__$1 = state_35353;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35353__$1,(15),out,inst_35341);
} else {
if((state_val_35354 === (2))){
var state_35353__$1 = state_35353;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35353__$1,(4),ch);
} else {
if((state_val_35354 === (11))){
var inst_35333 = (state_35353[(2)]);
var inst_35334 = (new Array(n));
var inst_35317 = inst_35334;
var inst_35318 = (0);
var state_35353__$1 = (function (){var statearr_35365 = state_35353;
(statearr_35365[(7)] = inst_35317);

(statearr_35365[(10)] = inst_35333);

(statearr_35365[(8)] = inst_35318);

return statearr_35365;
})();
var statearr_35366_35390 = state_35353__$1;
(statearr_35366_35390[(2)] = null);

(statearr_35366_35390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (9))){
var inst_35317 = (state_35353[(7)]);
var inst_35331 = cljs.core.vec.call(null,inst_35317);
var state_35353__$1 = state_35353;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35353__$1,(11),out,inst_35331);
} else {
if((state_val_35354 === (5))){
var inst_35317 = (state_35353[(7)]);
var inst_35326 = (state_35353[(11)]);
var inst_35318 = (state_35353[(8)]);
var inst_35321 = (state_35353[(9)]);
var inst_35325 = (inst_35317[inst_35318] = inst_35321);
var inst_35326__$1 = (inst_35318 + (1));
var inst_35327 = (inst_35326__$1 < n);
var state_35353__$1 = (function (){var statearr_35367 = state_35353;
(statearr_35367[(12)] = inst_35325);

(statearr_35367[(11)] = inst_35326__$1);

return statearr_35367;
})();
if(cljs.core.truth_(inst_35327)){
var statearr_35368_35391 = state_35353__$1;
(statearr_35368_35391[(1)] = (8));

} else {
var statearr_35369_35392 = state_35353__$1;
(statearr_35369_35392[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (14))){
var inst_35346 = (state_35353[(2)]);
var inst_35347 = cljs.core.async.close_BANG_.call(null,out);
var state_35353__$1 = (function (){var statearr_35371 = state_35353;
(statearr_35371[(13)] = inst_35346);

return statearr_35371;
})();
var statearr_35372_35393 = state_35353__$1;
(statearr_35372_35393[(2)] = inst_35347);

(statearr_35372_35393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (10))){
var inst_35337 = (state_35353[(2)]);
var state_35353__$1 = state_35353;
var statearr_35373_35394 = state_35353__$1;
(statearr_35373_35394[(2)] = inst_35337);

(statearr_35373_35394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35354 === (8))){
var inst_35317 = (state_35353[(7)]);
var inst_35326 = (state_35353[(11)]);
var tmp35370 = inst_35317;
var inst_35317__$1 = tmp35370;
var inst_35318 = inst_35326;
var state_35353__$1 = (function (){var statearr_35374 = state_35353;
(statearr_35374[(7)] = inst_35317__$1);

(statearr_35374[(8)] = inst_35318);

return statearr_35374;
})();
var statearr_35375_35395 = state_35353__$1;
(statearr_35375_35395[(2)] = null);

(statearr_35375_35395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___35381,out))
;
return ((function (switch__16183__auto__,c__16273__auto___35381,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_35376 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35376[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_35376[(1)] = (1));

return statearr_35376;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_35353){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35377){if((e35377 instanceof Object)){
var ex__16187__auto__ = e35377;
var statearr_35378_35396 = state_35353;
(statearr_35378_35396[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35353);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35377;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35397 = state_35353;
state_35353 = G__35397;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_35353){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_35353);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___35381,out))
})();
var state__16275__auto__ = (function (){var statearr_35379 = f__16274__auto__.call(null);
(statearr_35379[(6)] = c__16273__auto___35381);

return statearr_35379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___35381,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__35399 = arguments.length;
switch (G__35399) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16273__auto___35469 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16273__auto___35469,out){
return (function (){
var f__16274__auto__ = (function (){var switch__16183__auto__ = ((function (c__16273__auto___35469,out){
return (function (state_35441){
var state_val_35442 = (state_35441[(1)]);
if((state_val_35442 === (7))){
var inst_35437 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35443_35470 = state_35441__$1;
(statearr_35443_35470[(2)] = inst_35437);

(statearr_35443_35470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (1))){
var inst_35400 = [];
var inst_35401 = inst_35400;
var inst_35402 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_35441__$1 = (function (){var statearr_35444 = state_35441;
(statearr_35444[(7)] = inst_35401);

(statearr_35444[(8)] = inst_35402);

return statearr_35444;
})();
var statearr_35445_35471 = state_35441__$1;
(statearr_35445_35471[(2)] = null);

(statearr_35445_35471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (4))){
var inst_35405 = (state_35441[(9)]);
var inst_35405__$1 = (state_35441[(2)]);
var inst_35406 = (inst_35405__$1 == null);
var inst_35407 = cljs.core.not.call(null,inst_35406);
var state_35441__$1 = (function (){var statearr_35446 = state_35441;
(statearr_35446[(9)] = inst_35405__$1);

return statearr_35446;
})();
if(inst_35407){
var statearr_35447_35472 = state_35441__$1;
(statearr_35447_35472[(1)] = (5));

} else {
var statearr_35448_35473 = state_35441__$1;
(statearr_35448_35473[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (15))){
var inst_35431 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35449_35474 = state_35441__$1;
(statearr_35449_35474[(2)] = inst_35431);

(statearr_35449_35474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (13))){
var state_35441__$1 = state_35441;
var statearr_35450_35475 = state_35441__$1;
(statearr_35450_35475[(2)] = null);

(statearr_35450_35475[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (6))){
var inst_35401 = (state_35441[(7)]);
var inst_35426 = inst_35401.length;
var inst_35427 = (inst_35426 > (0));
var state_35441__$1 = state_35441;
if(cljs.core.truth_(inst_35427)){
var statearr_35451_35476 = state_35441__$1;
(statearr_35451_35476[(1)] = (12));

} else {
var statearr_35452_35477 = state_35441__$1;
(statearr_35452_35477[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (3))){
var inst_35439 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35441__$1,inst_35439);
} else {
if((state_val_35442 === (12))){
var inst_35401 = (state_35441[(7)]);
var inst_35429 = cljs.core.vec.call(null,inst_35401);
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35441__$1,(15),out,inst_35429);
} else {
if((state_val_35442 === (2))){
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35441__$1,(4),ch);
} else {
if((state_val_35442 === (11))){
var inst_35409 = (state_35441[(10)]);
var inst_35405 = (state_35441[(9)]);
var inst_35419 = (state_35441[(2)]);
var inst_35420 = [];
var inst_35421 = inst_35420.push(inst_35405);
var inst_35401 = inst_35420;
var inst_35402 = inst_35409;
var state_35441__$1 = (function (){var statearr_35453 = state_35441;
(statearr_35453[(11)] = inst_35419);

(statearr_35453[(7)] = inst_35401);

(statearr_35453[(8)] = inst_35402);

(statearr_35453[(12)] = inst_35421);

return statearr_35453;
})();
var statearr_35454_35478 = state_35441__$1;
(statearr_35454_35478[(2)] = null);

(statearr_35454_35478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (9))){
var inst_35401 = (state_35441[(7)]);
var inst_35417 = cljs.core.vec.call(null,inst_35401);
var state_35441__$1 = state_35441;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_35441__$1,(11),out,inst_35417);
} else {
if((state_val_35442 === (5))){
var inst_35402 = (state_35441[(8)]);
var inst_35409 = (state_35441[(10)]);
var inst_35405 = (state_35441[(9)]);
var inst_35409__$1 = f.call(null,inst_35405);
var inst_35410 = cljs.core._EQ_.call(null,inst_35409__$1,inst_35402);
var inst_35411 = cljs.core.keyword_identical_QMARK_.call(null,inst_35402,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_35412 = (inst_35410) || (inst_35411);
var state_35441__$1 = (function (){var statearr_35455 = state_35441;
(statearr_35455[(10)] = inst_35409__$1);

return statearr_35455;
})();
if(cljs.core.truth_(inst_35412)){
var statearr_35456_35479 = state_35441__$1;
(statearr_35456_35479[(1)] = (8));

} else {
var statearr_35457_35480 = state_35441__$1;
(statearr_35457_35480[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (14))){
var inst_35434 = (state_35441[(2)]);
var inst_35435 = cljs.core.async.close_BANG_.call(null,out);
var state_35441__$1 = (function (){var statearr_35459 = state_35441;
(statearr_35459[(13)] = inst_35434);

return statearr_35459;
})();
var statearr_35460_35481 = state_35441__$1;
(statearr_35460_35481[(2)] = inst_35435);

(statearr_35460_35481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (10))){
var inst_35424 = (state_35441[(2)]);
var state_35441__$1 = state_35441;
var statearr_35461_35482 = state_35441__$1;
(statearr_35461_35482[(2)] = inst_35424);

(statearr_35461_35482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35442 === (8))){
var inst_35401 = (state_35441[(7)]);
var inst_35409 = (state_35441[(10)]);
var inst_35405 = (state_35441[(9)]);
var inst_35414 = inst_35401.push(inst_35405);
var tmp35458 = inst_35401;
var inst_35401__$1 = tmp35458;
var inst_35402 = inst_35409;
var state_35441__$1 = (function (){var statearr_35462 = state_35441;
(statearr_35462[(7)] = inst_35401__$1);

(statearr_35462[(8)] = inst_35402);

(statearr_35462[(14)] = inst_35414);

return statearr_35462;
})();
var statearr_35463_35483 = state_35441__$1;
(statearr_35463_35483[(2)] = null);

(statearr_35463_35483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16273__auto___35469,out))
;
return ((function (switch__16183__auto__,c__16273__auto___35469,out){
return (function() {
var cljs$core$async$state_machine__16184__auto__ = null;
var cljs$core$async$state_machine__16184__auto____0 = (function (){
var statearr_35464 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35464[(0)] = cljs$core$async$state_machine__16184__auto__);

(statearr_35464[(1)] = (1));

return statearr_35464;
});
var cljs$core$async$state_machine__16184__auto____1 = (function (state_35441){
while(true){
var ret_value__16185__auto__ = (function (){try{while(true){
var result__16186__auto__ = switch__16183__auto__.call(null,state_35441);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16186__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16186__auto__;
}
break;
}
}catch (e35465){if((e35465 instanceof Object)){
var ex__16187__auto__ = e35465;
var statearr_35466_35484 = state_35441;
(statearr_35466_35484[(5)] = ex__16187__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35441);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16185__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35485 = state_35441;
state_35441 = G__35485;
continue;
} else {
return ret_value__16185__auto__;
}
break;
}
});
cljs$core$async$state_machine__16184__auto__ = function(state_35441){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16184__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16184__auto____1.call(this,state_35441);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16184__auto____0;
cljs$core$async$state_machine__16184__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16184__auto____1;
return cljs$core$async$state_machine__16184__auto__;
})()
;})(switch__16183__auto__,c__16273__auto___35469,out))
})();
var state__16275__auto__ = (function (){var statearr_35467 = f__16274__auto__.call(null);
(statearr_35467[(6)] = c__16273__auto___35469);

return statearr_35467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16275__auto__);
});})(c__16273__auto___35469,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

