// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__19463 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__19464 = null;
var count__19465 = (0);
var i__19466 = (0);
while(true){
if((i__19466 < count__19465)){
var vec__19467 = cljs.core._nth.call(null,chunk__19464,i__19466);
var effect_key = cljs.core.nth.call(null,vec__19467,(0),null);
var effect_value = cljs.core.nth.call(null,vec__19467,(1),null);
var temp__5455__auto___19473 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___19473)){
var effect_fn_19474 = temp__5455__auto___19473;
effect_fn_19474.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__19475 = seq__19463;
var G__19476 = chunk__19464;
var G__19477 = count__19465;
var G__19478 = (i__19466 + (1));
seq__19463 = G__19475;
chunk__19464 = G__19476;
count__19465 = G__19477;
i__19466 = G__19478;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__19463);
if(temp__5457__auto__){
var seq__19463__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19463__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__19463__$1);
var G__19479 = cljs.core.chunk_rest.call(null,seq__19463__$1);
var G__19480 = c__9319__auto__;
var G__19481 = cljs.core.count.call(null,c__9319__auto__);
var G__19482 = (0);
seq__19463 = G__19479;
chunk__19464 = G__19480;
count__19465 = G__19481;
i__19466 = G__19482;
continue;
} else {
var vec__19470 = cljs.core.first.call(null,seq__19463__$1);
var effect_key = cljs.core.nth.call(null,vec__19470,(0),null);
var effect_value = cljs.core.nth.call(null,vec__19470,(1),null);
var temp__5455__auto___19483 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___19483)){
var effect_fn_19484 = temp__5455__auto___19483;
effect_fn_19484.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__19485 = cljs.core.next.call(null,seq__19463__$1);
var G__19486 = null;
var G__19487 = (0);
var G__19488 = (0);
seq__19463 = G__19485;
chunk__19464 = G__19486;
count__19465 = G__19487;
i__19466 = G__19488;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__19489 = cljs.core.seq.call(null,value);
var chunk__19490 = null;
var count__19491 = (0);
var i__19492 = (0);
while(true){
if((i__19492 < count__19491)){
var map__19493 = cljs.core._nth.call(null,chunk__19490,i__19492);
var map__19493__$1 = ((((!((map__19493 == null)))?((((map__19493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19493.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19493):map__19493);
var effect = map__19493__$1;
var ms = cljs.core.get.call(null,map__19493__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__19493__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__19489,chunk__19490,count__19491,i__19492,map__19493,map__19493__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__19489,chunk__19490,count__19491,i__19492,map__19493,map__19493__$1,effect,ms,dispatch))
,ms);
}

var G__19497 = seq__19489;
var G__19498 = chunk__19490;
var G__19499 = count__19491;
var G__19500 = (i__19492 + (1));
seq__19489 = G__19497;
chunk__19490 = G__19498;
count__19491 = G__19499;
i__19492 = G__19500;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__19489);
if(temp__5457__auto__){
var seq__19489__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19489__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__19489__$1);
var G__19501 = cljs.core.chunk_rest.call(null,seq__19489__$1);
var G__19502 = c__9319__auto__;
var G__19503 = cljs.core.count.call(null,c__9319__auto__);
var G__19504 = (0);
seq__19489 = G__19501;
chunk__19490 = G__19502;
count__19491 = G__19503;
i__19492 = G__19504;
continue;
} else {
var map__19495 = cljs.core.first.call(null,seq__19489__$1);
var map__19495__$1 = ((((!((map__19495 == null)))?((((map__19495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19495.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19495):map__19495);
var effect = map__19495__$1;
var ms = cljs.core.get.call(null,map__19495__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__19495__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__19489,chunk__19490,count__19491,i__19492,map__19495,map__19495__$1,effect,ms,dispatch,seq__19489__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__19489,chunk__19490,count__19491,i__19492,map__19495,map__19495__$1,effect,ms,dispatch,seq__19489__$1,temp__5457__auto__))
,ms);
}

var G__19505 = cljs.core.next.call(null,seq__19489__$1);
var G__19506 = null;
var G__19507 = (0);
var G__19508 = (0);
seq__19489 = G__19505;
chunk__19490 = G__19506;
count__19491 = G__19507;
i__19492 = G__19508;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__19509 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__19510 = null;
var count__19511 = (0);
var i__19512 = (0);
while(true){
if((i__19512 < count__19511)){
var event = cljs.core._nth.call(null,chunk__19510,i__19512);
re_frame.router.dispatch.call(null,event);

var G__19513 = seq__19509;
var G__19514 = chunk__19510;
var G__19515 = count__19511;
var G__19516 = (i__19512 + (1));
seq__19509 = G__19513;
chunk__19510 = G__19514;
count__19511 = G__19515;
i__19512 = G__19516;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__19509);
if(temp__5457__auto__){
var seq__19509__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19509__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__19509__$1);
var G__19517 = cljs.core.chunk_rest.call(null,seq__19509__$1);
var G__19518 = c__9319__auto__;
var G__19519 = cljs.core.count.call(null,c__9319__auto__);
var G__19520 = (0);
seq__19509 = G__19517;
chunk__19510 = G__19518;
count__19511 = G__19519;
i__19512 = G__19520;
continue;
} else {
var event = cljs.core.first.call(null,seq__19509__$1);
re_frame.router.dispatch.call(null,event);

var G__19521 = cljs.core.next.call(null,seq__19509__$1);
var G__19522 = null;
var G__19523 = (0);
var G__19524 = (0);
seq__19509 = G__19521;
chunk__19510 = G__19522;
count__19511 = G__19523;
i__19512 = G__19524;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__19525 = cljs.core.seq.call(null,value);
var chunk__19526 = null;
var count__19527 = (0);
var i__19528 = (0);
while(true){
if((i__19528 < count__19527)){
var event = cljs.core._nth.call(null,chunk__19526,i__19528);
clear_event.call(null,event);

var G__19529 = seq__19525;
var G__19530 = chunk__19526;
var G__19531 = count__19527;
var G__19532 = (i__19528 + (1));
seq__19525 = G__19529;
chunk__19526 = G__19530;
count__19527 = G__19531;
i__19528 = G__19532;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__19525);
if(temp__5457__auto__){
var seq__19525__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19525__$1)){
var c__9319__auto__ = cljs.core.chunk_first.call(null,seq__19525__$1);
var G__19533 = cljs.core.chunk_rest.call(null,seq__19525__$1);
var G__19534 = c__9319__auto__;
var G__19535 = cljs.core.count.call(null,c__9319__auto__);
var G__19536 = (0);
seq__19525 = G__19533;
chunk__19526 = G__19534;
count__19527 = G__19535;
i__19528 = G__19536;
continue;
} else {
var event = cljs.core.first.call(null,seq__19525__$1);
clear_event.call(null,event);

var G__19537 = cljs.core.next.call(null,seq__19525__$1);
var G__19538 = null;
var G__19539 = (0);
var G__19540 = (0);
seq__19525 = G__19537;
chunk__19526 = G__19538;
count__19527 = G__19539;
i__19528 = G__19540;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1518919053813
