// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__19343_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__19343_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__5457__auto___19344 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__5457__auto___19344)){
var not_i_19345 = temp__5457__auto___19344;
if(cljs.core.fn_QMARK_.call(null,not_i_19345)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_19345);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_19345);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__5455__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__5455__auto__)){
var interceptors = temp__5455__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_19346 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_19347 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__19291__auto___19360 = re_frame.interop.now.call(null);
var duration__19292__auto___19361 = (end__19291__auto___19360 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__19348_19362 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__19349_19363 = null;
var count__19350_19364 = (0);
var i__19351_19365 = (0);
while(true){
if((i__19351_19365 < count__19350_19364)){
var vec__19352_19366 = cljs.core._nth.call(null,chunk__19349_19363,i__19351_19365);
var k__19293__auto___19367 = cljs.core.nth.call(null,vec__19352_19366,(0),null);
var cb__19294__auto___19368 = cljs.core.nth.call(null,vec__19352_19366,(1),null);
try{cb__19294__auto___19368.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___19361,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e19355){if((e19355 instanceof java.lang.Exception)){
var e__19295__auto___19369 = e19355;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___19367,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___19369);
} else {
throw e19355;

}
}
var G__19370 = seq__19348_19362;
var G__19371 = chunk__19349_19363;
var G__19372 = count__19350_19364;
var G__19373 = (i__19351_19365 + (1));
seq__19348_19362 = G__19370;
chunk__19349_19363 = G__19371;
count__19350_19364 = G__19372;
i__19351_19365 = G__19373;
continue;
} else {
var temp__5457__auto___19374 = cljs.core.seq.call(null,seq__19348_19362);
if(temp__5457__auto___19374){
var seq__19348_19375__$1 = temp__5457__auto___19374;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19348_19375__$1)){
var c__9319__auto___19376 = cljs.core.chunk_first.call(null,seq__19348_19375__$1);
var G__19377 = cljs.core.chunk_rest.call(null,seq__19348_19375__$1);
var G__19378 = c__9319__auto___19376;
var G__19379 = cljs.core.count.call(null,c__9319__auto___19376);
var G__19380 = (0);
seq__19348_19362 = G__19377;
chunk__19349_19363 = G__19378;
count__19350_19364 = G__19379;
i__19351_19365 = G__19380;
continue;
} else {
var vec__19356_19381 = cljs.core.first.call(null,seq__19348_19375__$1);
var k__19293__auto___19382 = cljs.core.nth.call(null,vec__19356_19381,(0),null);
var cb__19294__auto___19383 = cljs.core.nth.call(null,vec__19356_19381,(1),null);
try{cb__19294__auto___19383.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__19292__auto___19361,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e19359){if((e19359 instanceof java.lang.Exception)){
var e__19295__auto___19384 = e19359;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__19293__auto___19382,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__19295__auto___19384);
} else {
throw e19359;

}
}
var G__19385 = cljs.core.next.call(null,seq__19348_19375__$1);
var G__19386 = null;
var G__19387 = (0);
var G__19388 = (0);
seq__19348_19362 = G__19385;
chunk__19349_19363 = G__19386;
count__19350_19364 = G__19387;
i__19351_19365 = G__19388;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_19347;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_19346;
}}
} else {
return null;
}
});

//# sourceMappingURL=events.js.map?rel=1518919053666
