(ns m.xfs
  (:require-macros [cljs.core.async.macros :refer [go go-loop]])
  (:require [cljs.core.async :refer [put! take! close! <! to-chan]]
            [cognitect.transit :as t]
            [cljsjs.buffer]
            [m.core :refer [e m]]
            [m.client :refer [get-buffer get-blob-url]]
            [m.eval :refer [e!]]
            [m.async :refer [*>]]))

(defn serialize [data & [n]]
  (let [data' (->> (t/write (e :m/w) data)
                   (.from js/buffer.Buffer))
        n' (or n (name (e :m/ext)))]
    (set! (.-name data') n')
    data'))

(defn deserialize [b]
  (t/read (e :m/r) b))

(defn prr [a]
  (js/console.log a)
  a)

(defn ism? [f]
  (let [p (re-pattern (name (e :m/ext)))]
    (re-find p (.-name f))))

(defn js? [f]
  (re-find #"\.js$" (.-name f)))

(defn cljs? [f]
  (re-find #"\.cljs$" (.-name f)))

(defn json? [f]
  (re-find #"\.json$" (.-name f)))

(defn ext# []
  (re-pattern (str "(" (name (e :m/ext)) "|[^.]*)+$")))

(def files-to-chan
  (map #(-> % .-files to-chan)))

(defn process-ism [infohash ism & [opts]]
    (as-> (*> (partial get-buffer ism) {:xf (map deserialize)}) from
          (*> m (merge opts {:from from}))))

(defn append-script [url]
  (let [el (.createElement js/document "script")]
    (set! (.-src el) url)
    (set! (.-type el) "application/javascript")
    (.appendChild (.-body js/document) el)))

(defn compfns [a b]
  (if (and (fn? a) (fn? b)) (comp b a) b))

(defn process-js [js & [opts]]
  (*> (partial get-blob-url js) (merge-with compfns opts {:xf (map append-script)})))

(defn maf [infohash f to]
  (cond
    (ism? f) (process-ism infohash f {:to to})
    (js? f) (process-js f {:to to})))
