(ns m.stream
  (:require [clojure.set :refer [union select]]
            [cljs.core.async :refer [put!]]
            [re-frame.core :refer [reg-sub reg-event-db dispatch]]
            [cljsjs.crypto-js]
            [m.core :refer [e m]]
            [m.async :refer [*>]]
            [m.local :refer [gl sl]]
            [m.comps :refer [ee]]
            [m.xfs :refer [compfns]]))

(reg-sub
  :m'
  (fn [db] (:m' db)))

(defn m'
  ([v] (m' :m v))
  ([k v & [{:keys [to]}]]
   (let [v' {:m v :time (js/Date.) :coords (e :m/coords)}
         v'' #{(merge v' {:digest (str (.SHA3 js/CryptoJS (str v')))})}]
     (m {:m' {k v''}} {:f union :to to}))))

(defn eem' []
  (ee [:m']))

(defn glm' [& [opts]]
  (gl :m' opts))

(defn slm' [& [opts]]
  (sl :m' (e :m') opts))

(defn mglm' [& [opts]]
  (let [munion (map #(m {:m' %} {:f union}))]
    (*> glm' (merge-with compfns opts {:xf munion}))))

(defn mem' [& [ks]]
  (let [ks' (if ks (select-keys (e :m') ks) (e :m'))]
    (map (fn [[k v]] {k (map :m v)}) ks')))

(defn m'utate! [pred & ks]
  (let [ks' (or ks (keys (e :m')))
        sel #(m {:m' {% pred}} {:f (fn [a b] (select b a))})]
    (map sel ks')))

(defn latest-where [pred coll]
  (->> (filter pred coll)
       (sort-by :time)
       (reverse)
       (first)))

(defn prune! [& ks]
  (let [ks' (or ks (keys (e :m')))
        pt' (fn [k] (:time (latest-where #(= (:m %) :prune) (e :m' k))))
        sel' (fn [k t] (m'utate! #(>= (:time %) t) k))]
    (map #(->> (pt' %) (sel' %)) ks')))
