(ns m.state
  (:require
    [re-frame.core :refer [reg-event-db reg-sub]]
    [cognitect.transit :as t]
    [cljsjs.webtorrent]))

(def nilable-map? (some-fn map? nil?))

(defn deep-merge-with [f & ms]
  (apply merge-with
         (fn [a b]
           (if (and (nilable-map? a) (nilable-map? b))
             (deep-merge-with f a b)
             (f a b)))
         ms))

(def init-db
  {:m/ext :ism._.json
   :m/client (js/WebTorrent.)
   :m/trackers ["wss://tracker.btorrent.xyz"
                "wss://tracker.fastcast.nz"
                "wss://tracker.openwebtorrent.com"]
   :m/seeds #{}
   :m/r (t/reader :json)
   :m/w (t/writer :json)
   :m/coords {}
   :m/vsn 1})

(reg-sub
  :m/db
  (fn [db] db))

(reg-event-db
  :m/init
  (fn [_ _] init-db))

(reg-event-db
  :m
  []
  (fn [db [_ kvs f]]
    (when (not (contains? kvs :m/coords)) (js/console.log (clj->js kvs)))
    (deep-merge-with (or f (fn [a b] b)) db kvs)))
