// Compiled by ClojureScript 1.9.946 {}
goog.provide('m.peer');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cljsjs.simple_peer');
goog.require('m.core');
goog.require('m.client');
goog.require('m.xfs');
goog.require('m.async');
if(typeof m.peer.stun_config !== 'undefined'){
} else {
m.peer.stun_config = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"iceServers","iceServers",-710699989),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"urls","urls",-190753757),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["stun:stun.l.google.com:19302","stun:stun1.l.google.com:19302","stun:stun2.l.google.com:19302","stun:stun3.l.google.com:19302"], null)], null)], null)], null)], null);
}
m.peer.create_peer = (function m$peer$create_peer(id,config){
console.log("create-peer");

var p = (new simplePeer(cljs.core.clj__GT_js.call(null,config)));
if((m.core.e.call(null,new cljs.core.Keyword("peer","channel","peer/channel",737622858)) == null)){
m.core.m.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("peer","channel","peer/channel",737622858),cljs.core.async.chan.call(null)], null));
} else {
}

p.on("signal",((function (p){
return (function (p1__20087_SHARP_){
return m.client.s.call(null,m.xfs.serialize.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"signal","signal",-1984951589),p1__20087_SHARP_], null)));
});})(p))
);

p.on("connect",((function (p){
return (function (){
return console.log("connected!");
});})(p))
);

p.on("data",((function (p){
return (function (p1__20088_SHARP_){
return cljs.core.async.put_BANG_.call(null,m.core.e.call(null,new cljs.core.Keyword("peer","channel","peer/channel",737622858)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"value","value",305978217),m.xfs.deserialize.call(null,p1__20088_SHARP_)], null));
});})(p))
);

p.on("stream",((function (p){
return (function (p1__20089_SHARP_){
return m.core.m.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("peer","peers","peer/peers",2007995640),cljs.core.PersistentArrayMap.createAsIfByAssoc([id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"stream","stream",1534941648),p1__20089_SHARP_], null)])], null));
});})(p))
);

p.on("error",((function (p){
return (function (){
return console.log("error!");
});})(p))
);

p.on("close",((function (p){
return (function (){
return m.core.m.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("peer","peers","peer/peers",2007995640),cljs.core.PersistentArrayMap.createAsIfByAssoc([id,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"peer","peer",1319662792),null,new cljs.core.Keyword(null,"stream","stream",1534941648),null], null)])], null));
});})(p))
);

m.core.m.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("peer","peers","peer/peers",2007995640),cljs.core.PersistentArrayMap.createAsIfByAssoc([id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"peer","peer",1319662792),p], null)])], null));

return p;
});
m.peer.signal_peer = (function m$peer$signal_peer(config,p__20090){
var map__20091 = p__20090;
var map__20091__$1 = ((((!((map__20091 == null)))?((((map__20091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20091):map__20091);
var id = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var signal = cljs.core.get.call(null,map__20091__$1,new cljs.core.Keyword(null,"signal","signal",-1984951589));
var p = (function (){var or__8388__auto__ = m.core.e.call(null,new cljs.core.Keyword("peer","peers","peer/peers",2007995640),id,new cljs.core.Keyword(null,"peer","peer",1319662792));
if(cljs.core.truth_(or__8388__auto__)){
return or__8388__auto__;
} else {
return m.peer.create_peer.call(null,id,config);
}
})();
return p.signal(cljs.core.clj__GT_js.call(null,signal));
});
m.peer.connect_peer = (function m$peer$connect_peer(infohash,config){
console.log("connect-peer");

var from = m.async._STAR__GT_.call(null,cljs.core.partial.call(null,m.client.a,infohash),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xf","xf",401902988),cljs.core.map.call(null,(function (p1__20093_SHARP_){
return cljs.core.first.call(null,p1__20093_SHARP_.files);
}))], null));
var from__$1 = m.async._STAR__GT_.call(null,m.client.get_buffer,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),from,new cljs.core.Keyword(null,"xf","xf",401902988),cljs.core.map.call(null,m.xfs.deserialize)], null));
return m.async._STAR__GT_.call(null,cljs.core.partial.call(null,m.peer.signal_peer,config),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"from","from",1815293044),from__$1], null));
});
m.peer.send_data = (function m$peer$send_data(id,data){
console.log("sending to ",cljs.core.name.call(null,id),": ",cljs.core.clj__GT_js.call(null,data));

return m.core.e.call(null,new cljs.core.Keyword("peer","peers","peer/peers",2007995640),id,new cljs.core.Keyword(null,"peer","peer",1319662792)).send(m.xfs.serialize.call(null,data));
});
m.peer.destroy_peer = (function m$peer$destroy_peer(id){
console.log("destroying ",cljs.core.name.call(null,id));

return m.core.e.call(null,new cljs.core.Keyword("peer","peers","peer/peers",2007995640),id,new cljs.core.Keyword(null,"peer","peer",1319662792)).destroy();
});

//# sourceMappingURL=peer.js.map?rel=1518919054265
