(ns m.nan
  (:require [m.core :refer [e m]]))

; spec for trade obj {:<some1> neg :<some2> pos}
; exchange interop framework (gdax, etc.)

(defn expand-trade [t]
  (let [[b s] (sort t)]
    {:bought {:currency (b 0) :amount (b 1)}
     :sold {:currency (s 0) :amount (- (s 1))}}))

(defn basis [{:keys [bought sold]}]
  (/ (:amount bought)
     (:amount sold)))

(defn net [{:keys [bought sold basis]} current]
  (let [cur-basis (/ ((:currency bought) current)
                     ((:currency sold) current))]
    (/ basis cur-basis)))

#_(->> trades
     (map expand-trade)
     (map #(assoc % :basis (basis %)))
     (map #(assoc % :net (net % cur)))
     (map #(:net %))
     (reduce +))
