(ns m.music
  (:require-macros [cljs.core.async.macros :refer [go go-loop]])
  (:require [cljs.core.async :refer [put! chan]]
            [reagent.core :as r]
            [re-frame.core :refer [reg-sub subscribe]]
            [m.core :refer [e m]]
            [m.async :refer [*>]]))

(defonce music-div-id "music-div")

(defn route-uri [uri]
  ;;(cond
  ;;  (startsWith uri ":") (play (get-in (e :music) (map keyword (split " " uri))))
  ;;  ;; (spotify-uri? uri) (spotify/play uri) ;; later
  ;;  (other-url uri) (ask, embed)
  ;;  :else (find-matches-in-music and play)
  ;;  )
  )

(defn music-ui []
  (let [v (r/atom [])]
    (fn []
      [:div
       [:div#music-embed]
       [:div
        [:input
         {:placeholder "music"
          :value @v
          :on-change #(reset! v (.. % -target -value))}]
        [:button
         {:on-click #(route-uri %)
          :disabled (empty? @v)}
         "|>"]]])))

(defn music []
  (let [app (.getElementById js/document "app")
        div (.createElement js/document "div")]
    (set! (.-id div) music-div-id)
    (if-let [old (.getElementById js/document music-div-id)]
      (.replaceChild app div old)
      (.appendChild app div))
    (r/render [music-ui] div)))
