(ns m.core
  (:require
    [cljs.core.async :refer [put!]]
    [re-frame.core :refer [subscribe dispatch dispatch-sync]]
    [m.state]))

(defn e [& ks]
  (let [db @(subscribe [:m/db])]
    (if ks (get-in db ks) db)))

(defn m [kvs & [{:keys [f to]}]]
  (dispatch [:m kvs f])
  (when to (put! to kvs))
  kvs)

(defn update-coords []
  (let [clean-coords ; js->clj doesn't work on Coordinates in Chrome
        (fn [coords]
          {:latitude (.-latitude coords)
           :longitude (.-longitude coords)
           :altitude (.-altitude coords)
           :accuracy (.-accuracy coords)
           :altitudeAccuracy (.-altitudeAccuracy coords)
           :heading (.-heading coords)
           :speed (.-speed coords)})]
    (when-let [g (.. js/window -navigator -geolocation)]
      (.getCurrentPosition g #(m {:m/coords (-> % .-coords clean-coords)})))))

(defn ^:export init []
  (dispatch-sync [:m/init])
  (update-coords)
  (js/setInterval update-coords 10000))
