(ns m.async
  (:require [cljs.core.async :refer [chan pipe take!]]))

(defn chan' [& [n xf]]
  (let [n' (if (and ((some-fn nil? zero?) n) (some? xf)) 1 n)]
    (chan (when n' n') (when xf xf))))

(defn *> [f & [{:keys [to from n xf] :as opts}]]
  (let [to' (chan' n xf)
        opts' (merge opts {:to to'})]
    (when to (pipe to' to))
    (if from
      (take! from #(f % opts'))
      (f opts'))
    (or to to')))
