(defproject nu/m "0.2.0-SNAPSHOT"
  :description "._.m /'strēm/"
  :url "https://github.com/Nolan330/m.git"
  :license  {:name "Eclipse Public License - v 1.0"
             :url "http://www.eclipse.org/legal/epl-v10.html"
             :distribution :repo
             :comments "same as Clojure"}
  :dependencies [[org.clojure/clojure "1.9.0"]
                 [org.clojure/clojurescript "1.9.946"]
                 [org.clojure/core.async "0.3.443"]
                 [com.cognitect/transit-cljs "0.8.239"]
                 [cljsjs/webtorrent "0.98.19-1"]
                 [cljsjs/localforage "1.5.3-0"]
                 [cljsjs/simple-peer "8.5.0-0"]
                 [cljsjs/crypto-js "3.1.9-1-0"]
                 [cljsjs/buffer "5.1.0-0"]
                 [cljs-http "0.1.44"]
                 [re-frame "0.10.1"]
                 [reagent "0.7.0"]]

  :plugins [[lein-cljsbuild "1.1.5"]
            [lein-figwheel "0.5.14"]]

  :hooks [leiningen.cljsbuild]

  :min-lein-version "2.5.3"

  :source-paths ["src/clj"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled"
                                    "target"]

  :profiles
  {:dev
   {:dependencies [[binaryage/devtools "0.9.4"]]}}

  :cljsbuild
  {:builds
   [{:id           "dev"
     :source-paths ["src/cljs"]
     :compiler     {:main                 m.core
                    :output-to            "resources/public/js/compiled/dev/app.js"
                    :output-dir           "resources/public/js/compiled/dev/out"
                    :asset-path           "js/compiled/dev/out"
                    :optimizations        :none
                    :preloads             [devtools.preload]
                    :external-config      {:devtools/config {:features-to-install :all}}
                    :source-map-timestamp true}
     :figwheel      {:on-jsload "m.core/init"}}

    {:id           "node"
     :source-paths ["src/cljs"]
     :compiler     {:main            m.core
                    :output-to       "resources/public/js/compiled/node/app.js"
                    :output-dir      "resources/public/js/compiled/node/out"
                    :asset-path      "js/compiled/node/out"
                    :target          :nodejs
                    :optimizations   :simple
                    :closure-defines {goog.DEBUG false}
                    :pretty-print    false}}

    {:id           "lib"
     :source-paths ["src/cljs"]
     :compiler     {:main            m.core
                    :output-to       "resources/public/js/compiled/lib/app.js"
                    :output-dir      "resources/public/js/compiled/lib/out"
                    :asset-path      "js/compiled/lib/out"
                    :optimizations   :simple
                    :closure-defines {goog.DEBUG false}
                    :pretty-print    false}}

    {:id           "min"
     :source-paths ["src/cljs"]
     :compiler     {:main            m.core
                    :output-to       "resources/public/js/compiled/min/app.js"
                    :output-dir      "resources/public/js/compiled/min/out"
                    :asset-path      "js/compiled/min/out"
                    :optimizations   :advanced
                    :closure-defines {goog.DEBUG false}
                    :pretty-print    false}}]})
