(defproject nu/m "0.1.0-SNAPSHOT"
  :description "._.m /'strēm/"
  :url "https://github.com/Nolan330/m.git"
  :license  {:name "Eclipse Public License - v 1.0"
             :url "http://www.eclipse.org/legal/epl-v10.html"
             :distribution :repo
             :comments "same as Clojure"}
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.946"]
                 [com.cognitect/transit-cljs "0.8.239"]
                 [reagent "0.7.0"]
                 [re-frame "0.10.1"]
                 [cljsjs/webtorrent "0.98.19-1"]]

  :plugins [[lein-cljsbuild "1.1.5"]]

  :min-lein-version "2.5.3"

  :source-paths ["src/clj"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled" "target"]

  :profiles
  {:dev
   {:dependencies [[binaryage/devtools "0.9.4"]]}}

  :cljsbuild
  {:builds
   [{:id           "dev"
     :source-paths ["src/cljs"]
     :compiler     {:main                 m.core
                    :output-to            "resources/public/js/compiled/app.js"
                    :output-dir           "resources/public/js/compiled/out"
                    :asset-path           "js/compiled/out"
                    :source-map-timestamp true
                    :preloads             [devtools.preload]
                    :external-config      {:devtools/config {:features-to-install :all}}
                    :npm-deps {:buffer "5.0.8"}
                    :install-deps true}}

    {:id           "lib"
     :source-paths ["src/cljs"]
     :compiler     {:main                 m.core
                    :output-to            "resources/public/js/compiled/app.js"
                    :npm-deps {:buffer "5.0.8"}
                    :install-deps true
                    :optimizations :simple
                    :closure-defines {goog.DEBUG false}
                    :pretty-print false}}

    {:id           "min"
     :source-paths ["src/cljs"]
     :compiler     {:main            m.core
                    :output-to       "resources/public/js/compiled/app.js"
                    :npm-deps {:buffer "5.0.8"}
                    :install-deps true
                    :optimizations   :advanced
                    :closure-defines {goog.DEBUG false}
                    :pretty-print    false}}]})
