(ns parts.components.timbre.spec
  (:require
   [clojure.spec.alpha :as s]))

(s/def ::level
  #{:trace :debug :info :warn :error :fatal :report})

(s/def ::enabled?
  (s/nilable boolean?))

(s/def ::min-level
  (s/nilable ::level))

(s/def ::rate-limit
  (s/nilable (s/coll-of (s/tuple pos-int? pos-int?))))

(s/def ::fn
  (s/nilable ifn?))

(s/def ::async?
  (s/nilable boolean?))

(s/def ::appenders
  (s/map-of keyword? (s/keys :opt-un [::enabled?
                                      ::min-level
                                      ::rate-limit
                                      ::output-fn
                                      ::ns-whitelist
                                      ::ns-blacklist
                                      ::fn
                                      #?@(:clj [::async?
                                                ::timestamp-opts])])))

(s/def ::ns-whitelist
  (s/nilable (s/coll-of string?)))

(s/def ::ns-blacklist
  (s/nilable (s/coll-of string?)))

(s/def ::middleware
  (s/nilable (s/coll-of fn?)))

(s/def ::pattern
  (s/nilable string?))

(s/def ::locale
  (s/nilable keyword?))

(s/def ::timezone
  (s/nilable keyword?))

#?(:clj (s/def ::timestamp-opts
          (s/nilable (s/keys :req-un [::pattern ::locale ::timezone]))))

(s/def ::output-fn
  (s/nilable ifn?))

(s/def ::make-logger-option
  (s/keys :req-un [::level
                   ::appenders]
          :opt-un [::ns-whitelist
                   ::ns-blacklist
                   ::ns-log-level
                   ::middleware
                   ::output-fn
                   #?@(:clj [::timestamp-opts])]))

