(ns parts.components.timbre.impl
  (:require
   [clojure.spec.alpha :as s]
   [parts.components.timbre.proto :as ctp]
   [parts.components.timbre.spec :as cts]
   [taoensso.timbre :as log]))

(defrecord Logger []
  ctp/ILogger
  (log [this level throwable message]
    (log/log* this level throwable message)))

(defn make-logger
  [option]
  (map->Logger (s/assert ::cts/make-logger-option option)))

(defn trace
  [logger message]
  (ctp/log logger :trace nil message))

(defn debug
  [logger message]
  (ctp/log logger :debug nil message))

(defn info
  [logger message]
  (ctp/log logger :info nil message))

(defn warn
  [logger message]
  (ctp/log logger :warn nil message))

(defn error
  ([logger throwable message]
   (ctp/log logger :error throwable message))
  ([logger message]
   (ctp/log logger :error nil message)))

(defn fatal
  ([logger throwable message]
   (ctp/log logger :fatal throwable message))
  ([logger message]
   (ctp/log logger :fatal nil message)))

(defn report
  [logger message]
  (ctp/log logger :report nil message))

