(ns parts.components.datomic-conformer.impl
  (:require
   [clojure.java.io :as io]
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [io.rkn.conformity :refer [ensure-conforms]]
   [parts.components.datomic-conformer.spec :as cdcs]))

(defrecord DatomicNormMap [paths norm-map]
  c/Lifecycle
  (start [this]
    (if (some? norm-map)
      this
      (let [norm-map (into {}
                           (comp
                            (keep io/resource)
                            (map io/file)
                            (filter #(.isFile %))
                            (map slurp)
                            (map read-string))
                           paths)]
        (assoc this :norm-map norm-map))))
  (stop [this]
    (if (nil? norm-map)
      this
      (assoc this :norm-map nil))))

(defn make-datomic-norm-map
  [{:keys [paths] :as option}]
  (s/assert ::cdcs/datomic-norm-map-option option)
  (map->DatomicNormMap {:paths paths}))

(defrecord DatomicConformer [datomic norm-map]
  c/Lifecycle
  (start [this]
    (if (some? norm-map)
      this
      (let [norm-map (into {}
                           (comp
                            (map val)
                            (map :norm-map))
                           this)]
        (when (seq norm-map)
          (s/assert ::cdcs/datomic datomic)
          (ensure-conforms (:conn datomic) norm-map))
        (assoc this :norm-map norm-map))))
  (stop [this]
    (if (nil? norm-map)
      this
      (assoc this :norm-map nil))))

(defn make-datomic-conformer
  []
  (map->DatomicConformer {}))
