(ns parts.components.datomic.conn
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [datomic.api :as d]
   [parts.components.datomic.spec :as cds]))

(defrecord DatomicBlueprint [uri temporary? started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (d/create-database uri)
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (do (when temporary? (d/delete-database uri))
          (assoc this :started? false)))))

(defn make-datomic-blueprint
  [{:keys [uri temporary?] :as option}]
  (s/assert ::cds/datomic-blueprint-option option)
  (map->DatomicBlueprint {:uri        uri
                          :temporary? temporary?
                          :started?   false}))

(defrecord Datomic [datomic-blueprint conn]
  c/Lifecycle
  (start [this]
    (if (some? conn)
      this
      (do (s/assert ::cds/datomic-blueprint datomic-blueprint)
          (assoc this :conn (d/connect (:uri datomic-blueprint))))))
  (stop [this]
    (if (nil? conn)
      this
      (do (d/release conn)
          (assoc this :conn nil)))))

(defn make-datomic
  []
  (map->Datomic {}))
