(ns parts.components.bidi.spec
  (:require
   [clojure.spec.alpha :as s]))

(s/def ::prefix string?)

(s/def ::not-found-handler fn?)

(s/def ::routes-no-prefix (s/map-of
                           (s/or :path      string?
                                 :args-path (s/cat :path
                                                   (s/+ (s/or :a string?
                                                              :b keyword?))))
                           (s/or :handler-key keyword?
                                 :handler     fn?
                                 :routes      ::routes-no-prefix)))

(s/def ::routes (s/tuple ::prefix ::routes-no-prefix))

(s/def ::ring-router-option (s/keys :opt-un [::prefix ::not-found-handler]))
