(ns parts.components.async.channel
  (:require
   [com.stuartsierra.component :as c]
   [parts.components.async.spec :as cas]
   #?@(:clj  [[clojure.core.async :as a]
              [clojure.spec.alpha :as s]]
       :cljs [[cljs.core.async :as a]
              [cljs.spec.alpha :as s]])))

(defrecord FixedChannel [size chan]
  c/Lifecycle
  (start [this]
    (if (some? chan)
      this
      (assoc this :chan (if (some? size)
                          (a/chan size)
                          (a/chan)))))
  (stop [this]
    (if (nil? chan)
      this
      (do (a/close! chan)
          (assoc this :chan nil)))))

(defn make-fixed-channel
  ([{:keys [size] :as option}]
   (s/assert ::cas/fixed-channel-option option)
   (map->FixedChannel {:size size}))
  ([]
   (make-fixed-channel {})))

(defrecord SlidingChannel [size chan]
  c/Lifecycle
  (start [this]
    (if (some? chan)
      this
      (assoc this :chan (if (some? size)
                          (a/chan (a/sliding-buffer size))
                          (a/chan (a/sliding-buffer 1))))))
  (stop [this]
    (if (nil? chan)
      this
      (do (a/close! chan)
          (assoc this :chan nil)))))

(defn make-sliding-channel
  ([{:keys [size] :as option}]
   (s/assert ::cas/sliding-channel-option option)
   (map->SlidingChannel {:size size}))
  ([]
   (make-sliding-channel {})))

(defrecord DroppingChannel [size chan]
  c/Lifecycle
  (start [this]
    (if (some? chan)
      this
      (assoc this :chan (if (some? size)
                          (a/chan (a/dropping-buffer size))
                          (a/chan (a/dropping-buffer 1))))))
  (stop [this]
    (if (nil? chan)
      this
      (do (a/close! chan)
          (assoc this :chan nil)))))

(defn make-dropping-channel
  ([{:keys [size] :as option}]
   (s/assert ::cas/dropping-channel-option option)
   (map->DroppingChannel {:size size}))
  ([]
   (make-dropping-channel {})))
