(ns parts.components.ring.head
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [parts.components.ring.spec :as crs]))

(defrecord RingHead [ring-handler ring-middleware handler]
  c/Lifecycle
  (start [this]
    (if (some? handler)
      this
      (let [wrapper (cond
                      (map? ring-middleware)
                      (:wrapper ring-middleware)

                      (fn? ring-middleware)
                      ring-middleware

                      :else
                      identity)
            handler (cond
                      (map? ring-handler)
                      (:handler ring-handler)

                      (fn? ring-handler)
                      ring-handler

                      :else
                      (constantly {:status 503}))]
        (assoc this :handler (wrapper handler)))))
  (stop [this]
    (if (nil? handler)
      this
      (assoc this :handler nil))))

(defn make-ring-head
  ([{:keys [ring-handler ring-middleware] :as option}]
   (s/assert ::crs/option option)
   (map->RingHead {:ring-handler    ring-handler
                   :ring-middleware ring-middleware}))
  ([]
   (make-ring-head {})))
