(ns parts.components.async.listener
  (:require
   [com.stuartsierra.component :as c]
   [parts.components.async.spec :as cas]
   #?@(:clj  [[clojure.core.async :as a :refer [go-loop]]
              [clojure.spec.alpha :as s]]
       :cljs [[cljs.core.async :as a]
              [cljs.spec.alpha :as s]])
   #?(:cljs
      (:require-macros
       [cljs.core.async.macros :refer [go-loop]]))))

(defn collect-chans
  [m]
  (not-empty (into [] (comp (map val) (keep :chan)) m)))

(defrecord ChannelListener [handler stop-chan]
  c/Lifecycle
  (start [this]
    (if (some? stop-chan)
      this
      (let [source-chans (collect-chans this)]
        (if (nil? source-chans)
          this
          (let [stop-chan (a/chan)]
            (go-loop []
              (let [[item chan]
                    (a/alts! (conj source-chans stop-chan) :priority true)

                    stop?
                    (or (= stop-chan chan) (nil? item))]
                (when-not stop?
                  (handler this item)
                  (recur))))
            (assoc this :stop-chan stop-chan))))))
  (stop [this]
    (if (nil? stop-chan)
      this
      (do (a/close! stop-chan)
          (assoc this :stop-chan nil)))))

(defn make-channel-listener
  [{:keys [handler] :as option}]
  (s/assert ::cas/channel-listener-option option)
  (map->ChannelListener {:handler handler}))
