(ns parts.components.middleware.impl
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [parts.components.middleware.spec :as cmws]))

(defn substitute
  [component entry]
  (if (vector? entry)
    (replace {:component component} entry)
    entry))

(defn coerce
  [entry]
  (if (vector? entry)
    #(apply (first entry) % (rest entry))
    entry))

(defn compose
  [component entries]
  (apply comp (into []
                    (comp
                     (map #(substitute component %))
                     (map coerce))
                    entries)))

(defrecord Middleware [entries wrapper middleware]
  c/Lifecycle
  (start [this]
    (if (some? wrapper)
      this
      (let [wrapper (comp (compose this entries)
                       (if (some? middleware)
                         (:wrapper middleware)
                         identity))]
        (assoc this :wrapper wrapper))))
  (stop [this]
    (if (nil? wrapper)
      this
      (assoc this :wrapper nil))))

(defn make-middleware
  ([{:keys [entries middleware] :as option}]
   (s/assert ::cmws/option option)
   (map->Middleware {:entries entries :middleware middleware}))
  ([]
   (make-middleware {})))
