(ns parts.components.http-kit.server
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [org.httpkit.server :refer [run-server]]
   [parts.components.http-kit.spec :as chks]))

(defrecord WebServer [port handler server]
  c/Lifecycle
  (start [this]
    (if (some? server)
      this
      (let [handler (cond
                      (map? handler)
                      (:handler handler)

                      (fn? handler)
                      handler

                      :else
                      (constantly {:status 503}))
            server (run-server handler {:port port})]
        (assoc this :server server))))
  (stop [this]
    (if (nil? server)
      this
      (do (server :timeout 100)
          (assoc this :server nil)))))

(defn make-web-server
  ([{:keys [port handler] :as option}]
   (s/assert ::chks/option option)
   (map->WebServer {:port port :handler handler}))
  ([]
   (make-web-server {})))
