(ns parts.components.datomic-conformer.impl
  (:require
   [clojure.java.io :as io]
   [com.stuartsierra.component :as c]
   [io.rkn.conformity :refer [ensure-conforms]]))

(defn ensure-conforms!
  [conn path]
  (when-let [norm-map (some-> (io/resource path) slurp read-string)]
    (ensure-conforms conn norm-map)))

(defrecord DatomicConformer [datomic path started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (ensure-conforms! (:conn datomic) path)
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-datomic-conformer
  [{:keys [path datomic] :as option}]
  (map->DatomicConformer {:path path :datomic datomic :started? false}))
