(ns parts.components.bouncer.validator
  (:require
   [bouncer.core :as bnc]
   [clojure.spec.alpha :as s]
   [parts.components.bouncer.spec :as cbncs]
   [parts.components.bouncer.proto :as cbncp]))

(defrecord BouncerValidator [schema]
  cbncp/IValidator
  (validate [_ data]
    (bnc/validate data schema))
  (valid? [_ data]
    (bnc/valid? data schema)))

(defn make-bouncer-validator
  [{:keys [schema] :as option}]
  (s/assert ::cbncs/option option)
  (map->BouncerValidator {:schema schema}))
