(ns parts.components.async.pipeliner
  (:require
   [com.stuartsierra.component :as c]
   [parts.components.async.spec :as cas]
   #?@(:clj  [[clojure.core.async :as a :refer [go-loop]]
              [clojure.spec.alpha :as s]]
       :cljs [[cljs.core.async :as a]
              [cljs.spec.alpha :as s]])))

(defn start-channnel-pipeliner!
  [pipeline-fn {:keys [parallelism to updater-fn from close-both? ex-handler]
                :as   this}]
  (let [to-chan   (:chan to)
        from-chan (:chan from)]
    (when (and (some? to-chan) (some? from-chan))
      (let [parallelism (or parallelism 1)
            updater     (updater-fn this)
            args        (cond-> [parallelism
                                 to-chan
                                 updater
                                 from-chan]
                          (some? close-both?)
                          (conj close-both?)

                          (some? ex-handler)
                          (conj ex-handler))]
        (apply pipeline-fn args)
        ::ok))))

(defrecord ChannelPipeliner [option started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (if (not= ::ok (start-channnel-pipeliner! a/pipeline option))
        this
        (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-channel-pipeliner
  [{:keys [parallelism to xform-fn from close-both? ex-handler] :as option}]
  (s/assert ::cas/channel-pipeliner-option option)
  (map->ChannelPipeliner {:option   {:parallelism parallelism
                                     :to          to
                                     :updater-fn  xform-fn
                                     :from        from
                                     :close-both? close-both?
                                     :ex-handler  ex-handler}
                          :started? false}))

(defrecord ChannelPipelinerAsync [option started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (if (not= ::ok (start-channnel-pipeliner! a/pipeline-async option))
        this
        (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-channel-pipeliner-async
  [{:keys [parallelism to async-fn from close-both?] :as option}]
  (s/assert ::cas/channel-pipeliner-async-option option)
  (map->ChannelPipelinerAsync {:option   {:parallelism parallelism
                                          :to          to
                                          :updater-fn  async-fn
                                          :from        from
                                          :close-both? close-both?}
                               :started? false}))

#?(:clj
   (defrecord ChannelPipelinerBlocking [option started?]
     c/Lifecycle
     (start [this]
       (if started?
         this
         (if (not= ::ok (start-channnel-pipeliner! a/pipeline-blocking option))
           this
           (assoc this :started? true))))
     (stop [this]
       (if-not started?
         this
         (assoc this :started? false)))))

#?(:clj
   (defn make-channel-pipeliner-blocking
     [{:keys [parallelism to xform-fn from close-both? ex-handler] :as option}]
     (s/assert ::cas/channel-pipeliner-blocking-option option)
     (map->ChannelPipelinerBlocking {:option   {:parallelism parallelism
                                                :to          to
                                                :updater-fn  xform-fn
                                                :from        from
                                                :close-both? close-both?
                                                :ex-handler  ex-handler}
                                     :started? false})))
