(ns parts.components.middleware
  (:require
   #?@(:clj  [[clojure.spec.alpha :as s]]
       :cljs [[cljs.spec.alpha :as s]])))

(declare wrapper)

;; -----------------------------------------------------
;; middleware spec
;; -----------------------------------------------------

(s/def ::entries
  (s/coll-of
   (s/or :unary fn?
         :n-ary (s/cat
                 :entry fn?
                 :args  (s/* (s/or
                              :component (partial = :component)
                              :value     any?))))))

;; -----------------------------------------------------
;; protocols
;; -----------------------------------------------------

(defprotocol IMiddleware
  (-wrapper [this]))

(defn wrapper
  [imiddleware]
  (-wrapper imiddleware))

;; -----------------------------------------------------
;; middleware
;; -----------------------------------------------------

(defn- substitute
  [component entry]
  (if (vector? entry)
    (replace {:component component} entry)
    entry))

(defn coerce
  [entry]
  (if (vector? entry)
    #(apply (first entry) % (rest entry))
    entry))

(defn compose
  [component entries]
  (apply comp (into []
                    (comp
                     (map #(substitute component %))
                     (map coerce))
                    entries)))

(defrecord Middleware [entries middleware]
  IMiddleware
  (-wrapper [this]
    (comp (compose this entries)
       (if (some? middleware)
         (wrapper middleware)
         identity))))

(defn make-middleware
  [entries]
  (map->Middleware {:entries (s/assert ::entries entries)}))
