(ns parts.components.ring
  (:require
   [clojure.spec.alpha :as s]
   [parts.components.middleware :as cptmdw]
   [com.stuartsierra.component :as c]))

;; -----------------------------------------------------
;; ring binding spec
;; -----------------------------------------------------

(s/def ::binding-fn
  fn?)

;; -----------------------------------------------------
;; protocols
;; -----------------------------------------------------

(defprotocol IRequestHandler
  (-request-handler [this]))

(defn request-handler
  [irequest-handler]
  (-request-handler irequest-handler))

(defprotocol IRequestBinding
  (-request-binding [this]))

(defn request-binding
  [irequest-binding]
  (-request-binding irequest-binding))

;; -----------------------------------------------------
;; ring head
;; -----------------------------------------------------

(defrecord RingHead [ring-handler ring-middleware]
  IRequestHandler
  (-request-handler [this]
    (let [handler    (request-handler ring-handler)
          middleware (if (some? ring-middleware)
                       (cptmdw/wrapper ring-middleware)
                       identity)]
      (middleware
       (fn [request]
         (let [bindings (into {}
                              (comp
                               (map val)
                               (filter #(satisfies? IRequestBinding %))
                               (map request-binding))
                              this)]
           (handler (assoc request :bindings bindings))))))))

(defn make-ring-head
  []
  (c/using
   (map->RingHead {})
   [:ring-handler]))

;; -----------------------------------------------------
;; ring binding
;; -----------------------------------------------------

(defrecord RingBinding [binding-fn]
  IRequestBinding
  (-request-binding [this]
    (binding-fn this)))

(defn make-ring-binding
  [binding-fn]
  (->RingBinding (s/assert ::binding-fn binding-fn)))
