(ns parts.components.http-kit
  (:require
   [clojure.spec.alpha :as s]
   [com.stuartsierra.component :as c]
   [org.httpkit.server :refer [run-server]]
   [parts.components.ring :as cptrng]))

;; -----------------------------------------------------
;; web server spec
;; -----------------------------------------------------

(s/def ::port
  pos-int?)

(s/def ::config
  (s/keys :req-un [::port]))

;; -----------------------------------------------------
;; web server
;; -----------------------------------------------------

(defrecord WebServer [port ring-handler server]
  c/Lifecycle
  (start [this]
    (if (some? server)
      this
      (let [server (run-server (cptrng/request-handler ring-handler)
                               {:port port})]
        (assoc this :server server))))
  (stop [this]
    (if (nil? server)
      this
      (do (server :timeout 100)
          (assoc this :server nil)))))

(defn make-web-server
  [config]
  (-> (s/assert ::config config)
      (select-keys [:port])
      (map->WebServer)
      (c/using [:ring-handler])))
