(ns parts.components.datomic.conformer
  (:require
   [clojure.spec.alpha :as s]
   [clojure.java.io :as io]
   [com.stuartsierra.component :as c]
   [io.rkn.conformity :refer [ensure-conforms]]))

;; -----------------------------------------------------
;; datomic conformer spec
;; -----------------------------------------------------

(s/def ::path
  string?)

;; -----------------------------------------------------
;; datomic conformer
;; -----------------------------------------------------

(defn- ensure-conforms!
  [conn path]
  (when-let [norm-map (some-> (io/resource path) (slurp) (read-string))]
    (ensure-conforms conn norm-map)))

(defrecord DatomicConformer [datomic-connection path started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (ensure-conforms! (:connection datomic-connection) path)
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-datomic-conformer
  [path]
  (map->DatomicConformer {:path     (s/assert ::path path)
                          :started? false}))
