(ns parts.components.ring
  (:require
   [clojure.spec.alpha :as s]
   [parts.components.middleware :as cptmdw]
   [com.stuartsierra.component :as c]))

(declare request-handler request-binding)

;; -----------------------------------------------------
;; ring binding spec
;; -----------------------------------------------------

(s/def ::binding-fn
  fn?)

;; -----------------------------------------------------
;; protocols
;; -----------------------------------------------------

(defprotocol IRequestHandler
  (-request-handler [this]))

(defprotocol IRequestBinding
  (-request-binding [this]))

;; -----------------------------------------------------
;; ring head
;; -----------------------------------------------------

(defrecord RingHead [ring-handler ring-middleware]
  IRequestHandler
  (-request-handler [this]
    (let [handler    (request-handler ring-handler)
          middleware (if (some? ring-middleware)
                       (cptmdw/wrapper ring-middleware)
                       identity)
          bindings   (into {}
                           (comp
                            (map val)
                            (filter #(satisfies? IRequestBinding %))
                            (map request-binding))
                           this)]
      (middleware
       (fn [request]
         (handler (assoc request :bindings bindings)))))))

(defn make-ring-head
  []
  (c/using
   (map->RingHead {})
   [:ring-handler]))

(defn request-handler
  [irequest-handler]
  (-request-handler irequest-handler))

;; -----------------------------------------------------
;; ring binding
;; -----------------------------------------------------

(defrecord RingBinding [binding-fn]
  IRequestBinding
  (-request-binding [this]
    (binding-fn this)))

(defn make-ring-binding
  [binding-fn]
  (->RingBinding (s/assert ::binding-fn binding-fn)))
