(ns parts.components.middleware
  (:require
   #?@(:clj  [[clojure.spec.alpha :as s]]
       :cljs [[cljs.spec.alpha :as s]])))

(declare wrapper)

;; -----------------------------------------------------
;; middleware spec
;; -----------------------------------------------------

(s/def ::entries
  (s/coll-of
   (s/or :unary fn?
         :n-ary (s/cat
                 :entry fn?
                 :args  (s/* (s/or
                              :component (partial = :component)
                              :value     any?))))))

;; -----------------------------------------------------
;; protocols
;; -----------------------------------------------------

(defprotocol IMiddleware
  (-wrapper [this]))

;; -----------------------------------------------------
;; middleware
;; -----------------------------------------------------

(defn coerce
  [entry]
  (if (vector? entry)
    #(apply (first entry) % (rest entry))
    entry))

(defn compose
  [entries]
  (apply comp (into [] (map coerce) entries)))

(defrecord Middleware [entries middleware]
  IMiddleware
  (-wrapper [this]
    (comp (compose entries)
       (if (some? middleware)
         (wrapper middleware)
         identity))))

(defn make-middleware
  [entries]
  (map->Middleware {:entries (s/assert ::entries entries)}))

(defn wrapper
  [imiddleware]
  (-wrapper imiddleware))
