(ns parts.components.bouncer
  (:require
   [bouncer.core :as bnc]
   #?@(:clj  [[clojure.spec.alpha :as s]]
       :cljs [[cljs.spec.alpha :as s]])))

;; -----------------------------------------------------
;; validator spec
;; -----------------------------------------------------

(s/def ::schema
  (s/map-of keyword?
            (s/or :pred  fn?
                  :preds (s/coll-of (s/or :unary fn?
                                          :n-ary (s/cat :pred fn?
                                                        :args (s/* some?)))))))

;; -----------------------------------------------------
;; protocols
;; -----------------------------------------------------

(defprotocol IValidator
  (-valid? [this data])
  (-validate [this data]))

;; -----------------------------------------------------
;; validator
;; -----------------------------------------------------

(defrecord Validator [schema]
  IValidator
  (-valid? [this data]
    (bnc/valid? data schema))
  (-validate [this data]
    (bnc/validate data schema)))

(defn make-validator
  [schema]
  (->Validator (s/assert ::schema schema)))

(defn valid?
  [ibouncer-validator data]
  (-valid? ibouncer-validator data))

(defn validate
  [ibouncer-validator data]
  (-validate ibouncer-validator data))
