(ns joints.components.timbre.logger
  (:require
   [joints.components.timbre.proto :as ctp]
   [taoensso.timbre :as t]))

(defrecord Logger []
  ctp/ILogger
  (-log [this level throwable message]
    (t/log* this level throwable message)))

(defn make-logger
  [option]
  (map->Logger option))

(defn trace
  [logger message]
  (ctp/log logger :trace nil message))

(defn debug
  [logger message]
  (ctp/log logger :debug nil message))

(defn info
  [logger message]
  (ctp/log logger :info nil message))

(defn warn
  [logger message]
  (ctp/log logger :warn nil message))

(defn error
  ([logger throwable message]
   (ctp/log logger :error throwable message))
  ([logger message]
   (ctp/log logger :error nil message)))

(defn fatal
  ([logger throwable message]
   (ctp/log logger :fatal throwable message))
  ([logger message]
   (ctp/log logger :fatal nil message)))

(defn report
  [logger message]
  (ctp/log logger :report nil message))
