(ns joints.components.ring.head
  (:require
   [joints.components.middleware.core :as cmc]
   [joints.components.ring.proto :as crp]
   [ring.util.http-response :as resp]))

(defn search-wrapper
  [m]
  (->> m
       (map val)
       (filter #(satisfies? cmc/IMiddleware %))
       (map cmc/wrapper)
       (apply comp)))

(defn search-handler
  [{:keys [default-handler] :as m}]
  (or (->> m
           (map val)
           (filter #(satisfies? crp/IRequestHandler %))
           (map crp/request-handler)
           first)
      default-handler
      (constantly
       (resp/service-unavailable "No request handler to be found"))))

(defn search-context
  [m]
  (->> m
       (map val)
       (filter #(satisfies? crp/IRequestContext %))
       (map crp/request-context)
       (reduce merge {})))

(defrecord RingHead [default-handler]
  crp/IRequestHandler
  (-request-handler [this]
    (let [wrapper (search-wrapper this)
          handler (search-handler this)]
      (wrapper
       (fn [request]
         (let [context (search-context this)]
           (handler (assoc request :context context))))))))

(defn make-ring-head
  ([{:keys [default-handler]}]
   (->RingHead default-handler))
  ([]
   (make-ring-head {})))
